/*
 * Decompiled with CFR 0.152.
 */
package org.calrissian.mango.criteria.domain;

import java.util.ArrayList;
import java.util.List;
import org.calrissian.mango.criteria.domain.Node;
import org.calrissian.mango.criteria.visitor.NodeVisitor;

public abstract class ParentNode
implements Node {
    private static final long serialVersionUID = 1L;
    protected List<Node> nodes;
    protected ParentNode parent;

    public ParentNode() {
        this.nodes = new ArrayList<Node>();
    }

    public ParentNode(ParentNode parent, List<Node> nodes) {
        this.parent = parent;
        this.nodes = nodes;
    }

    @Override
    public ParentNode parent() {
        return this.parent;
    }

    @Override
    public List<Node> children() {
        return this.nodes;
    }

    @Override
    public void addChild(Node node) {
        this.nodes.add(node);
    }

    @Override
    public void removeChild(Node node) {
        this.nodes.remove(node);
    }

    public List<Node> getNodes() {
        return this.nodes;
    }

    public void setNodes(List<Node> nodes) {
        this.nodes = nodes;
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.begin(this);
        for (Node node : this.nodes.toArray(new Node[this.nodes.size()])) {
            node.accept(visitor);
        }
        visitor.end(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ParentNode that = (ParentNode)o;
        return !(this.nodes != null ? !this.nodes.equals(that.nodes) : that.nodes != null);
    }

    public int hashCode() {
        int result = this.nodes != null ? this.nodes.hashCode() : 0;
        return result;
    }
}

