/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.arrow.tools.ingest;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import java.util.List;
import org.locationtech.geomesa.arrow.tools.UrlParam;
import org.locationtech.geomesa.arrow.tools.UrlParam$class;
import org.locationtech.geomesa.tools.DistributedRunParam;
import org.locationtech.geomesa.tools.InputFilesParam;
import org.locationtech.geomesa.tools.InputFormatParam;
import org.locationtech.geomesa.tools.OptionalConverterConfigParam;
import org.locationtech.geomesa.tools.OptionalFeatureSpecParam;
import org.locationtech.geomesa.tools.OptionalForceParam;
import org.locationtech.geomesa.tools.OptionalInputFormatParam;
import org.locationtech.geomesa.tools.OptionalTypeNameParam;
import org.locationtech.geomesa.tools.ingest.IngestParams;
import scala.Enumeration;
import scala.reflect.ScalaSignature;
import scala.runtime.TraitSetter;

@Parameters(commandDescription="Ingest/convert various file formats into GeoMesa")
@ScalaSignature(bytes="\u0006\u0001M2A!\u0001\u0002\u0001\u001f\t\t\u0012I\u001d:po&sw-Z:u!\u0006\u0014\u0018-\\:\u000b\u0005\r!\u0011AB5oO\u0016\u001cHO\u0003\u0002\u0006\r\u0005)Ao\\8mg*\u0011q\u0001C\u0001\u0006CJ\u0014xn\u001e\u0006\u0003\u0013)\tqaZ3p[\u0016\u001c\u0018M\u0003\u0002\f\u0019\u0005aAn\\2bi&|g\u000e^3dQ*\tQ\"A\u0002pe\u001e\u001c\u0001a\u0005\u0003\u0001!Ya\u0002CA\t\u0015\u001b\u0005\u0011\"\"A\n\u0002\u000bM\u001c\u0017\r\\1\n\u0005U\u0011\"AB!osJ+g\r\u0005\u0002\u001855\t\u0001D\u0003\u0002\u00043)\u0011Q\u0001C\u0005\u00037a\u0011A\"\u00138hKN$\b+\u0019:b[N\u0004\"!\b\u0010\u000e\u0003\u0011I!a\b\u0003\u0003\u0011U\u0013H\u000eU1sC6DQ!\t\u0001\u0005\u0002\t\na\u0001P5oSRtD#A\u0012\u0011\u0005\u0011\u0002Q\"\u0001\u0002)\t\u00011\u0003'\r\t\u0003O9j\u0011\u0001\u000b\u0006\u0003S)\n!B[2p[6\fg\u000eZ3s\u0015\tYC&A\u0003cKV\u001cHOC\u0001.\u0003\r\u0019w.\\\u0005\u0003_!\u0012!\u0002U1sC6,G/\u001a:t\u0003I\u0019w.\\7b]\u0012$Um]2sSB$\u0018n\u001c8\"\u0003I\n\u0001'\u00138hKN$xfY8om\u0016\u0014H\u000f\t<be&|Wo\u001d\u0011gS2,\u0007EZ8s[\u0006$8\u000fI5oi>\u0004s)Z8NKN\f\u0007")
public class ArrowIngestParams
implements IngestParams,
UrlParam {
    @Parameter(names={"--url", "-u"}, description="URL for an Arrow resource, or path to an arrow file", required=true)
    private String url;
    @Parameter(names={"-t", "--threads"}, description="Number of threads if using local ingest")
    private Integer threads;
    @Parameter(names={"--split-max-size"}, description="Maximum size of a split in bytes (distributed jobs)")
    private Integer maxSplitSize;
    @Parameter(names={"--src-list"}, description="Input files are text files with lists of files, one per line, to ingest.")
    private boolean srcList;
    @Parameter(names={"--no-tracking"}, description="This application closes when ingest job is submitted. Useful for launching jobs with a script.")
    private boolean noWaitForCompletion;
    @Parameter(names={"--run-mode"}, description="Run locally or on a cluster", required=false, converter=DistributedRunParam.ModeConverter.class)
    private Enumeration.Value mode;
    @Parameter(names={"--input-format"}, description="File format of input files (shp, csv, tsv, avro, etc). Optional, autodetection will be attempted.")
    private String format;
    @Parameter(description="<file>...")
    private List<String> files;
    @Parameter(names={"-C", "--converter"}, description="GeoMesa converter specification as a config string, file name, or name of an available converter", required=false)
    private String config;
    @Parameter(names={"--force"}, description="Force execution without prompt")
    private boolean force;
    @Parameter(names={"-s", "--spec"}, description="SimpleFeatureType specification as a GeoTools spec string, SFT config, or file with either")
    private String spec;
    @Parameter(names={"-f", "--feature-name"}, description="Simple Feature Type name on which to operate")
    private String featureName;

    @Override
    public String url() {
        return this.url;
    }

    @Override
    @TraitSetter
    public void url_$eq(String x$1) {
        this.url = x$1;
    }

    public Integer threads() {
        return this.threads;
    }

    public void threads_$eq(Integer x$1) {
        this.threads = x$1;
    }

    public Integer maxSplitSize() {
        return this.maxSplitSize;
    }

    public void maxSplitSize_$eq(Integer x$1) {
        this.maxSplitSize = x$1;
    }

    public boolean srcList() {
        return this.srcList;
    }

    public void srcList_$eq(boolean x$1) {
        this.srcList = x$1;
    }

    public boolean noWaitForCompletion() {
        return this.noWaitForCompletion;
    }

    public void noWaitForCompletion_$eq(boolean x$1) {
        this.noWaitForCompletion = x$1;
    }

    public boolean waitForCompletion() {
        return IngestParams.class.waitForCompletion((IngestParams)this);
    }

    public Enumeration.Value mode() {
        return this.mode;
    }

    public void mode_$eq(Enumeration.Value x$1) {
        this.mode = x$1;
    }

    public String format() {
        return this.format;
    }

    public void format_$eq(String x$1) {
        this.format = x$1;
    }

    public Enumeration.Value fmt() {
        return InputFormatParam.class.fmt((InputFormatParam)this);
    }

    public List<String> files() {
        return this.files;
    }

    public void files_$eq(List<String> x$1) {
        this.files = x$1;
    }

    public String config() {
        return this.config;
    }

    public void config_$eq(String x$1) {
        this.config = x$1;
    }

    public boolean force() {
        return this.force;
    }

    public void force_$eq(boolean x$1) {
        this.force = x$1;
    }

    public String spec() {
        return this.spec;
    }

    public void spec_$eq(String x$1) {
        this.spec = x$1;
    }

    public String featureName() {
        return this.featureName;
    }

    public void featureName_$eq(String x$1) {
        this.featureName = x$1;
    }

    public ArrowIngestParams() {
        OptionalTypeNameParam.class.$init$((OptionalTypeNameParam)this);
        OptionalFeatureSpecParam.class.$init$((OptionalFeatureSpecParam)this);
        OptionalForceParam.class.$init$((OptionalForceParam)this);
        OptionalConverterConfigParam.class.$init$((OptionalConverterConfigParam)this);
        InputFilesParam.class.$init$((InputFilesParam)this);
        InputFormatParam.class.$init$((InputFormatParam)this);
        OptionalInputFormatParam.class.$init$((OptionalInputFormatParam)this);
        DistributedRunParam.class.$init$((DistributedRunParam)this);
        IngestParams.class.$init$((IngestParams)this);
        UrlParam$class.$init$(this);
    }
}

