/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.tools.ingest;

import com.beust.jcommander.ParameterException;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigRenderOptions;
import java.io.File;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.URL;
import org.apache.commons.io.FilenameUtils;
import org.locationtech.geomesa.convert.ConverterConfigLoader$;
import org.locationtech.geomesa.convert.shp.ShapefileConverterFactory$;
import org.locationtech.geomesa.convert2.SimpleFeatureConverter$;
import org.locationtech.geomesa.tools.Command$;
import org.locationtech.geomesa.tools.DistributedRunParam$RunModes$;
import org.locationtech.geomesa.tools.ingest.ConverterIngest;
import org.locationtech.geomesa.tools.ingest.IngestCommand;
import org.locationtech.geomesa.tools.ingest.IngestCommand$;
import org.locationtech.geomesa.tools.ingest.IngestCommand$$anonfun$2$;
import org.locationtech.geomesa.tools.utils.CLArgResolver$;
import org.locationtech.geomesa.tools.utils.DataFormats$;
import org.locationtech.geomesa.tools.utils.Prompt$;
import org.locationtech.geomesa.utils.conversions.ScalaImplicits;
import org.locationtech.geomesa.utils.conversions.ScalaImplicits$;
import org.locationtech.geomesa.utils.geotools.ConfigSftParsing$;
import org.locationtech.geomesa.utils.geotools.SimpleFeatureTypes$;
import org.locationtech.geomesa.utils.io.PathUtils$;
import org.locationtech.geomesa.utils.io.WithClose$;
import org.locationtech.geomesa.utils.io.fs.FileSystemDelegate;
import org.opengis.feature.simple.SimpleFeatureType;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.StringBuilder;
import scala.io.Codec$;
import scala.io.Source$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;
import scala.util.Try$;
import scala.util.control.NonFatal$;

public abstract class IngestCommand$class {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void execute(IngestCommand $this) {
        Buffer ingestFiles = $this.params().srcList() ? (Seq)JavaConversions$.MODULE$.asScalaBuffer($this.params().files()).flatMap((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final List<String> apply(String x$1) {
                return Source$.MODULE$.fromFile(x$1, Codec$.MODULE$.fallbackSystemCodec()).getLines().toList();
            }
        }, Buffer$.MODULE$.canBuildFrom()) : JavaConversions$.MODULE$.asScalaBuffer($this.params().files());
        IngestCommand$class.ensureSameFs($this, (Seq)ingestFiles);
        ObjectRef sft = ObjectRef.create((Object)((SimpleFeatureType)Option$.MODULE$.apply((Object)$this.params().featureName()).flatMap((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ IngestCommand $outer;

            public final Option<SimpleFeatureType> apply(String n) {
                return Try$.MODULE$.apply((Function0)new Serializable(this, n){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ IngestCommand$.anonfun.2 $outer;
                    public final String n$1;

                    public final SimpleFeatureType apply() {
                        return (SimpleFeatureType)this.$outer.org$locationtech$geomesa$tools$ingest$IngestCommand$$anonfun$$$outer().withDataStore(new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ IngestCommand$$anonfun$2$.anonfun.apply.1 $outer;

                            public final SimpleFeatureType apply(DS x$2) {
                                return x$2.getSchema(this.$outer.n$1);
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        });
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.n$1 = n$1;
                    }
                }).filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(SimpleFeatureType x$3) {
                        return x$3 != null;
                    }
                }).toOption();
            }

            public /* synthetic */ IngestCommand org$locationtech$geomesa$tools$ingest$IngestCommand$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }).orElse((Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ IngestCommand $outer;

            public final Option<SimpleFeatureType> apply() {
                return Option$.MODULE$.apply((Object)this.$outer.params().spec()).flatMap((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ IngestCommand$.anonfun.3 $outer;

                    public final Option<SimpleFeatureType> apply(String s) {
                        return Option$.MODULE$.apply((Object)CLArgResolver$.MODULE$.getSft(s, this.$outer.org$locationtech$geomesa$tools$ingest$IngestCommand$$anonfun$$$outer().params().featureName()));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ IngestCommand org$locationtech$geomesa$tools$ingest$IngestCommand$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }).orNull(Predef$.MODULE$.$conforms())));
        Config converter = (Config)Option$.MODULE$.apply((Object)$this.params().config()).map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final Config apply(String configArg) {
                return CLArgResolver$.MODULE$.getConfig(configArg);
            }
        }).orNull(Predef$.MODULE$.$conforms());
        if (converter == null && ingestFiles.nonEmpty()) {
            Tuple2 tuple2;
            Command$.MODULE$.user().info("No converter defined - will attempt to detect schema from input files");
            FileSystemDelegate.FileHandle file = (FileSystemDelegate.FileHandle)ScalaImplicits.RichIterator$.MODULE$.headOption$extension(ScalaImplicits$.MODULE$.RichIterator(ingestFiles.iterator().flatMap((Function1)new Serializable($this){
                public static final long serialVersionUID = 0L;

                public final Seq<FileSystemDelegate.FileHandle> apply(String path) {
                    return PathUtils$.MODULE$.interpretPath(path);
                }
            }))).getOrElse((Function0)new Serializable($this, (Seq)ingestFiles){
                public static final long serialVersionUID = 0L;
                private final Seq ingestFiles$1;

                public final Nothing$ apply() {
                    throw new ParameterException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"<files> '", "' did not evaluate to anything"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.ingestFiles$1.mkString(",")}))).append((Object)"that could be read").toString());
                }
                {
                    this.ingestFiles$1 = ingestFiles$1;
                }
            });
            Enumeration.Value value = $this.params().fmt();
            Enumeration.Value value2 = DataFormats$.MODULE$.Shp();
            Option opt = !(value != null ? !value.equals(value2) : value2 != null) ? ShapefileConverterFactory$.MODULE$.infer(file.path(), Option$.MODULE$.apply((Object)((SimpleFeatureType)sft.elem))) : SimpleFeatureConverter$.MODULE$.infer((Function0)new Serializable($this, file){
                public static final long serialVersionUID = 0L;
                private final FileSystemDelegate.FileHandle file$1;

                public final InputStream apply() {
                    return this.file$1.open();
                }
                {
                    this.file$1 = file$1;
                }
            }, Option$.MODULE$.apply((Object)((SimpleFeatureType)sft.elem)));
            Tuple2 tuple22 = (Tuple2)opt.getOrElse((Function0)new Serializable($this){
                public static final long serialVersionUID = 0L;

                public final Nothing$ apply() {
                    throw new ParameterException("Could not determine converter from inputs - please specify a converter");
                }
            });
            if (tuple22 == null) throw new MatchError((Object)tuple22);
            SimpleFeatureType inferredSft = (SimpleFeatureType)tuple22._1();
            Config inferredConverter = (Config)tuple22._2();
            Tuple2 tuple23 = tuple2 = new Tuple2((Object)inferredSft, (Object)inferredConverter);
            SimpleFeatureType inferredSft2 = (SimpleFeatureType)tuple23._1();
            Config inferredConverter2 = (Config)tuple23._2();
            ConfigRenderOptions renderOptions = ConfigRenderOptions.concise().setFormatted(true);
            ObjectRef inferredSftString = ObjectRef.create((Object)None$.MODULE$);
            if ((SimpleFeatureType)sft.elem == null) {
                String typeName = (String)Option$.MODULE$.apply((Object)$this.params().featureName()).getOrElse((Function0)new Serializable($this, file){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ IngestCommand $outer;
                    private final FileSystemDelegate.FileHandle file$1;

                    public final String apply() {
                        String base;
                        String[] existing = (String[])this.$outer.withDataStore(new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final String[] apply(DS x$5) {
                                return x$5.getTypeNames();
                            }
                        });
                        Option fileName = Option$.MODULE$.apply((Object)FilenameUtils.getBaseName((String)this.file$1.path()));
                        String name = base = (String)fileName.map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final String apply(String x$6) {
                                return x$6.trim().replaceAll("[^A-Za-z0-9]+", "_");
                            }
                        }).filterNot((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final boolean apply(String x$7) {
                                return x$7.isEmpty();
                            }
                        }).getOrElse((Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final String apply() {
                                return "geomesa";
                            }
                        });
                        int i = 0;
                        while (Predef$.MODULE$.refArrayOps((Object[])existing).contains((Object)name)) {
                            name = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "_", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{base, BoxesRunTime.boxToInteger((int)i)}));
                            ++i;
                        }
                        return name;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.file$1 = file$1;
                    }
                });
                sft.elem = SimpleFeatureTypes$.MODULE$.renameSft(inferredSft2, typeName);
                SimpleFeatureType x$10 = (SimpleFeatureType)sft.elem;
                boolean x$11 = false;
                boolean x$12 = SimpleFeatureTypes$.MODULE$.toConfig$default$2();
                inferredSftString.elem = new Some((Object)SimpleFeatureTypes$.MODULE$.toConfig(x$10, x$12, x$11).root().render(renderOptions));
                if (!$this.params().force()) {
                    Command$.MODULE$.user().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Inferred schema: ", " identified ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{typeName, SimpleFeatureTypes$.MODULE$.encodeType((SimpleFeatureType)sft.elem)})));
                }
            }
            converter = inferredConverter2;
            if (!$this.params().force()) {
                String converterString = inferredConverter2.root().render(renderOptions);
                Command$.MODULE$.user().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Inferred converter:\\n", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{converterString})));
                if (Prompt$.MODULE$.confirm("Use inferred converter (y/n)? ", Prompt$.MODULE$.confirm$default$2(), $this.console())) {
                    IngestCommand$class.persist$1($this, sft, inferredSftString, converterString);
                } else {
                    Command$.MODULE$.user().info("Please re-run with a valid converter");
                    IngestCommand$class.persist$1($this, sft, inferredSftString, converterString);
                    return;
                }
            }
        }
        if ((SimpleFeatureType)sft.elem == null) {
            throw new ParameterException("SimpleFeatureType name and/or specification argument is required");
        }
        if (converter == null) {
            throw new ParameterException("Converter config argument is required");
        }
        Enumeration.Value value = $this.params().fmt();
        Enumeration.Value value3 = DataFormats$.MODULE$.Shp();
        if (!(value != null ? !value.equals(value3) : value3 != null)) {
            Enumeration.Value value4 = $this.params().mode();
            Enumeration.Value value5 = DistributedRunParam$RunModes$.MODULE$.Distributed();
            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                Command$.MODULE$.user().warn("Forcing run mode to local for shapefile ingestion");
            }
            $this.params().mode_$eq(DistributedRunParam$RunModes$.MODULE$.Local());
        }
        $this.createConverterIngest((SimpleFeatureType)sft.elem, converter, (Seq<String>)ingestFiles).run();
    }

    public static Runnable createConverterIngest(IngestCommand $this, SimpleFeatureType sft, Config converterConfig, Seq ingestFiles) {
        return new ConverterIngest(sft, $this.connection(), converterConfig, (Seq<String>)ingestFiles, (Option<Enumeration.Value>)Option$.MODULE$.apply((Object)$this.params().mode()), $this.libjarsFile(), $this.libjarsPaths(), Predef$.MODULE$.Integer2int($this.params().threads()), (Option<Integer>)Option$.MODULE$.apply((Object)$this.params().maxSplitSize()), $this.params().waitForCompletion());
    }

    private static void ensureSameFs(IngestCommand $this, Seq ingestFiles) {
        String prefix;
        if (ingestFiles.exists((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String path) {
                return PathUtils$.MODULE$.isRemote(path);
            }
        }) && !ingestFiles.forall((Function1)new Serializable($this, prefix = ((String)ingestFiles.head()).split("/")[0].toLowerCase()){
            public static final long serialVersionUID = 0L;
            private final String prefix$1;

            public final boolean apply(String x$8) {
                return x$8.toLowerCase().startsWith(this.prefix$1);
            }
            {
                this.prefix$1 = prefix$1;
            }
        })) {
            throw new ParameterException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Files must all be on the same file system: (", ") or all be local"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{prefix})));
        }
    }

    private static void writeInferredConverter(IngestCommand $this, String typeName, String converterString, Option schemaString) {
        block9: {
            try {
                Option conf;
                Option option = conf = JavaConversions$.MODULE$.enumerationAsScalaIterator($this.getClass().getClassLoader().getResources("reference.conf")).find((Function1)new Serializable($this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(URL u) {
                        return "file".equalsIgnoreCase(u.getProtocol()) && u.getPath().endsWith("/conf/reference.conf");
                    }
                });
                if (None$.MODULE$.equals(option)) {
                    Command$.MODULE$.user().error("Could not persist converter: could not find 'conf/reference.conf'");
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block9;
                }
                if (option instanceof Some) {
                    Tuple2 tuple2;
                    Some some = (Some)option;
                    URL r = (URL)some.x();
                    File reference = new File(r.toURI());
                    File folder = reference.getParentFile();
                    String baseName = typeName.replaceAll("[^A-Za-z0-9_]+", "_");
                    ObjectRef convert2 = ObjectRef.create((Object)new File(folder, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".conf"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{baseName}))));
                    int i = 1;
                    while (((File)convert2.elem).exists()) {
                        convert2.elem = new File(folder, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "_", ".conf"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{baseName, BoxesRunTime.boxToInteger((int)i)})));
                        ++i;
                    }
                    WithClose$.MODULE$.apply((Object)new PrintWriter(new FileWriter((File)convert2.elem)), (Function1)new Serializable($this, converterString, schemaString, baseName){
                        public static final long serialVersionUID = 0L;
                        private final String converterString$2;
                        private final Option schemaString$1;
                        public final String baseName$1;

                        public final void apply(PrintWriter writer) {
                            writer.println(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".", " : ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ConverterConfigLoader$.MODULE$.path(), this.baseName$1, this.converterString$2})));
                            this.schemaString$1.foreach((Function1)new Serializable(this, writer){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ IngestCommand$.anonfun.writeInferredConverter.1 $outer;
                                private final PrintWriter writer$1;

                                public final void apply(String s) {
                                    this.writer$1.println(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".", " : ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ConfigSftParsing$.MODULE$.path(), this.$outer.baseName$1, s})));
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                    this.writer$1 = writer$1;
                                }
                            });
                        }
                        {
                            void var4_4;
                            void var3_3;
                            this.converterString$2 = converterString$2;
                            this.schemaString$1 = var3_3;
                            this.baseName$1 = var4_4;
                        }
                    });
                    WithClose$.MODULE$.apply((Object)new PrintWriter(new FileWriter(reference, true)), (Function1)new Serializable($this, convert2){
                        public static final long serialVersionUID = 0L;
                        private final ObjectRef convert$1;

                        public final void apply(PrintWriter writer) {
                            writer.println(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"include \"", "\""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((File)this.convert$1.elem).getName()})));
                        }
                        {
                            this.convert$1 = convert$1;
                        }
                    });
                    Tuple2 tuple22 = tuple2 = schemaString.isDefined() ? new Tuple2((Object)"schema and converter", (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"'--spec ", "' and '--converter ", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{baseName, baseName}))) : new Tuple2((Object)"converter", (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"'--converter ", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{baseName})));
                    if (tuple2 != null) {
                        Tuple2 tuple23;
                        String names = (String)tuple2._1();
                        String refs = (String)tuple2._2();
                        Tuple2 tuple24 = tuple23 = new Tuple2((Object)names, (Object)refs);
                        String names2 = (String)tuple24._1();
                        String refs2 = (String)tuple24._2();
                        Command$.MODULE$.user().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Added import in reference.conf and saved inferred ", " to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{names2, ((File)convert2.elem).getAbsolutePath()})));
                        Command$.MODULE$.user().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"In future commands, the ", " may be invoked with ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{names2, refs2})));
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        break block9;
                    }
                    throw new MatchError((Object)tuple2);
                }
                throw new MatchError((Object)option);
            }
            catch (Throwable throwable) {
                BoxedUnit boxedUnit;
                Throwable throwable2 = throwable;
                Option option = NonFatal$.MODULE$.unapply(throwable2);
                if (option.isEmpty()) {
                    throw throwable;
                }
                Throwable e = (Throwable)option.get();
                if ($this.logger().underlying().isErrorEnabled()) {
                    $this.logger().underlying().error("Error trying to persist inferred schema", e);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                Command$.MODULE$.user().error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error trying to persist inferred schema: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{e})));
                BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
            }
        }
    }

    private static final void persist$1(IngestCommand $this, ObjectRef sft$1, ObjectRef inferredSftString$1, String converterString$1) {
        if (Prompt$.MODULE$.confirm("Persist this converter for future use (y/n)? ", Prompt$.MODULE$.confirm$default$2(), $this.console())) {
            IngestCommand$class.writeInferredConverter($this, ((SimpleFeatureType)sft$1.elem).getTypeName(), converterString$1, (Option)inferredSftString$1.elem);
        }
    }

    public static void $init$(IngestCommand $this) {
        $this.org$locationtech$geomesa$tools$ingest$IngestCommand$_setter_$name_$eq("ingest");
    }
}

