/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.security;

import com.google.common.base.Joiner;
import org.opengis.feature.simple.SimpleFeature;

public class SecurityUtils {
    public static final String FEATURE_VISIBILITY = "geomesa.feature.visibility";

    public static SimpleFeature setFeatureVisibility(SimpleFeature feature, String visibility2) {
        feature.getUserData().put(FEATURE_VISIBILITY, visibility2);
        return feature;
    }

    public static SimpleFeature setFeatureVisibilities(SimpleFeature feature, String ... visibilities) {
        String and = Joiner.on((String)"&").join((Object[])visibilities);
        return SecurityUtils.setFeatureVisibility(feature, and);
    }

    public static String getVisibility(SimpleFeature feature) {
        return (String)feature.getUserData().get(FEATURE_VISIBILITY);
    }

    public static void copyVisibility(SimpleFeature source, SimpleFeature dest) {
        SecurityUtils.setFeatureVisibility(dest, SecurityUtils.getVisibility(source));
    }
}

