/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.noding;

import com.vividsolutions.jts.algorithm.LineIntersector;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.noding.SegmentIntersector;
import com.vividsolutions.jts.noding.SegmentString;
import java.util.ArrayList;
import java.util.List;

public class InteriorIntersectionFinder
implements SegmentIntersector {
    private boolean findAllIntersections = false;
    private boolean isCheckEndSegmentsOnly = false;
    private LineIntersector li;
    private Coordinate interiorIntersection = null;
    private Coordinate[] intSegments = null;
    private List intersections = new ArrayList();
    private int intersectionCount = 0;
    private boolean keepIntersections = true;

    public static InteriorIntersectionFinder createAnyIntersectionFinder(LineIntersector li) {
        return new InteriorIntersectionFinder(li);
    }

    public static InteriorIntersectionFinder createAllIntersectionsFinder(LineIntersector li) {
        InteriorIntersectionFinder finder = new InteriorIntersectionFinder(li);
        finder.setFindAllIntersections(true);
        return finder;
    }

    public static InteriorIntersectionFinder createIntersectionCounter(LineIntersector li) {
        InteriorIntersectionFinder finder = new InteriorIntersectionFinder(li);
        finder.setFindAllIntersections(true);
        finder.setKeepIntersections(false);
        return finder;
    }

    public InteriorIntersectionFinder(LineIntersector li) {
        this.li = li;
        this.interiorIntersection = null;
    }

    public void setFindAllIntersections(boolean findAllIntersections) {
        this.findAllIntersections = findAllIntersections;
    }

    public void setKeepIntersections(boolean keepIntersections) {
        this.keepIntersections = keepIntersections;
    }

    public List getIntersections() {
        return this.intersections;
    }

    public int count() {
        return this.intersectionCount;
    }

    public void setCheckEndSegmentsOnly(boolean isCheckEndSegmentsOnly) {
        this.isCheckEndSegmentsOnly = isCheckEndSegmentsOnly;
    }

    public boolean hasIntersection() {
        return this.interiorIntersection != null;
    }

    public Coordinate getInteriorIntersection() {
        return this.interiorIntersection;
    }

    public Coordinate[] getIntersectionSegments() {
        return this.intSegments;
    }

    public void processIntersections(SegmentString e0, int segIndex0, SegmentString e1, int segIndex1) {
        if (!this.findAllIntersections && this.hasIntersection()) {
            return;
        }
        if (e0 == e1 && segIndex0 == segIndex1) {
            return;
        }
        if (this.isCheckEndSegmentsOnly) {
            boolean isEndSegPresent;
            boolean bl = isEndSegPresent = this.isEndSegment(e0, segIndex0) || this.isEndSegment(e1, segIndex1);
            if (!isEndSegPresent) {
                return;
            }
        }
        Coordinate p00 = e0.getCoordinates()[segIndex0];
        Coordinate p01 = e0.getCoordinates()[segIndex0 + 1];
        Coordinate p10 = e1.getCoordinates()[segIndex1];
        Coordinate p11 = e1.getCoordinates()[segIndex1 + 1];
        this.li.computeIntersection(p00, p01, p10, p11);
        if (this.li.hasIntersection() && this.li.isInteriorIntersection()) {
            this.intSegments = new Coordinate[4];
            this.intSegments[0] = p00;
            this.intSegments[1] = p01;
            this.intSegments[2] = p10;
            this.intSegments[3] = p11;
            this.interiorIntersection = this.li.getIntersection(0);
            if (this.keepIntersections) {
                this.intersections.add(this.interiorIntersection);
            }
            ++this.intersectionCount;
        }
    }

    private boolean isEndSegment(SegmentString segStr, int index) {
        if (index == 0) {
            return true;
        }
        return index >= segStr.size() - 2;
    }

    public boolean isDone() {
        if (this.findAllIntersections) {
            return false;
        }
        return this.interiorIntersection != null;
    }
}

