/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.utils.index;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import java.util.concurrent.ConcurrentHashMap;
import org.locationtech.geomesa.utils.geotools.GridSnap;
import org.locationtech.geomesa.utils.index.SizeSeparatedBucketIndex$;
import org.locationtech.geomesa.utils.index.SpatialIndex;
import org.locationtech.geomesa.utils.index.SpatialIndex$class;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.BufferedIterator;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.Traversable;
import scala.collection.TraversableOnce;
import scala.collection.generic.CanBuildFrom;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.immutable.Stream;
import scala.collection.immutable.Vector;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.Nothing$;

@ScalaSignature(bytes="\u0006\u0001\tug\u0001B\u0001\u0003\u00015\u0011\u0001dU5{KN+\u0007/\u0019:bi\u0016$')^2lKRLe\u000eZ3y\u0015\t\u0019A!A\u0003j]\u0012,\u0007P\u0003\u0002\u0006\r\u0005)Q\u000f^5mg*\u0011q\u0001C\u0001\bO\u0016|W.Z:b\u0015\tI!\"\u0001\u0007m_\u000e\fG/[8oi\u0016\u001c\u0007NC\u0001\f\u0003\ry'oZ\u0002\u0001+\tq1d\u0005\u0003\u0001\u001fU!\u0003C\u0001\t\u0014\u001b\u0005\t\"\"\u0001\n\u0002\u000bM\u001c\u0017\r\\1\n\u0005Q\t\"AB!osJ+g\rE\u0002\u0017/ei\u0011AA\u0005\u00031\t\u0011Ab\u00159bi&\fG.\u00138eKb\u0004\"AG\u000e\r\u0001\u0011)A\u0004\u0001b\u0001;\t\tA+\u0005\u0002\u001fCA\u0011\u0001cH\u0005\u0003AE\u0011qAT8uQ&tw\r\u0005\u0002\u0011E%\u00111%\u0005\u0002\u0004\u0003:L\bCA\u0013-\u001b\u00051#BA\u0014)\u00031\u00198-\u00197bY><w-\u001b8h\u0015\tI#&\u0001\u0005usB,7/\u00194f\u0015\u0005Y\u0013aA2p[&\u0011QF\n\u0002\u000e'R\u0014\u0018n\u0019;M_\u001e<\u0017N\\4\t\u0011=\u0002!\u0011!Q\u0001\nA\nQa]5{KN\u00042!M\u001d=\u001d\t\u0011tG\u0004\u00024m5\tAG\u0003\u00026\u0019\u00051AH]8pizJ\u0011AE\u0005\u0003qE\tq\u0001]1dW\u0006<W-\u0003\u0002;w\t\u00191+Z9\u000b\u0005a\n\u0002\u0003\u0002\t>\u007f}J!AP\t\u0003\rQ+\b\u000f\\33!\t\u0001\u0002)\u0003\u0002B#\t1Ai\\;cY\u0016D\u0001b\u0011\u0001\u0003\u0002\u0003\u0006IaP\u0001\u0012q\n+8m[3u\u001bVdG/\u001b9mS\u0016\u0014\b\u0002C#\u0001\u0005\u0003\u0005\u000b\u0011B \u0002#e\u0014UoY6fi6+H\u000e^5qY&,'\u000f\u0003\u0005H\u0001\t\u0005\t\u0015!\u0003I\u0003\u001d)\u0007\u0010^3oiN\u0004\"!\u0013)\u000e\u0003)S!a\u0013'\u0002\t\u001d,w.\u001c\u0006\u0003\u001b:\u000b1A\u001b;t\u0015\ty%&\u0001\bwSZLGm]8mkRLwN\\:\n\u0005ES%\u0001C#om\u0016dw\u000e]3\t\u000bM\u0003A\u0011\u0001+\u0002\rqJg.\u001b;?)\u0015)fk\u0016-Z!\r1\u0002!\u0007\u0005\b_I\u0003\n\u00111\u00011\u0011\u001d\u0019%\u000b%AA\u0002}Bq!\u0012*\u0011\u0002\u0003\u0007q\bC\u0004H%B\u0005\t\u0019\u0001%\t\u000fm\u0003!\u0019!C\u00059\u0006)A/[3sgV\tQ\fE\u0002_C\nl\u0011a\u0018\u0006\u0003AF\t!bY8mY\u0016\u001cG/[8o\u0013\tQt\f\u0005\u0002dI6\t\u0001A\u0002\u0003f\u0001\u00111'\u0001\u0002+jKJ\u001c\"\u0001Z\b\t\u0011!$'Q1A\u0005\u0002%\f\u0001\"\\1y'&TX\rW\u000b\u0002\u007f!A1\u000e\u001aB\u0001B\u0003%q(A\u0005nCb\u001c\u0016N_3YA!AQ\u000e\u001aBC\u0002\u0013\u0005\u0011.\u0001\u0005nCb\u001c\u0016N_3Z\u0011!yGM!A!\u0002\u0013y\u0014!C7bqNK'0Z-!\u0011!\tHM!A!\u0002\u0013\u0011\u0018a\u00022vG.,Go\u001d\t\u0004!M,\u0018B\u0001;\u0012\u0005\u0015\t%O]1z!\r\u00012O\u001e\t\u0006oz\f\t!G\u0007\u0002q*\u0011\u0011P_\u0001\u000bG>t7-\u001e:sK:$(BA>}\u0003\u0011)H/\u001b7\u000b\u0003u\fAA[1wC&\u0011q\u0010\u001f\u0002\u0012\u0007>t7-\u001e:sK:$\b*Y:i\u001b\u0006\u0004\b\u0003BA\u0002\u0003\u0013q1\u0001EA\u0003\u0013\r\t9!E\u0001\u0007!J,G-\u001a4\n\t\u0005-\u0011Q\u0002\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005\u001d\u0011\u0003\u0003\u0006\u0002\u0012\u0011\u0014\t\u0011)A\u0005\u0003'\t\u0001b\u001a:jINs\u0017\r\u001d\t\u0005\u0003+\tY\"\u0004\u0002\u0002\u0018)\u0019\u0011\u0011\u0004\u0003\u0002\u0011\u001d,w\u000e^8pYNLA!!\b\u0002\u0018\tAqI]5e':\f\u0007\u000f\u0003\u0004TI\u0012\u0005\u0011\u0011\u0005\u000b\nE\u0006\r\u0012QEA\u0014\u0003SAa\u0001[A\u0010\u0001\u0004y\u0004BB7\u0002 \u0001\u0007q\b\u0003\u0004r\u0003?\u0001\rA\u001d\u0005\t\u0003#\ty\u00021\u0001\u0002\u0014!I\u0011Q\u00063A\u0002\u0013\u0005\u0011qF\u0001\u0006K6\u0004H/_\u000b\u0003\u0003c\u00012\u0001EA\u001a\u0013\r\t)$\u0005\u0002\b\u0005>|G.Z1o\u0011%\tI\u0004\u001aa\u0001\n\u0003\tY$A\u0005f[B$\u0018p\u0018\u0013fcR!\u0011QHA\"!\r\u0001\u0012qH\u0005\u0004\u0003\u0003\n\"\u0001B+oSRD!\"!\u0012\u00028\u0005\u0005\t\u0019AA\u0019\u0003\rAH%\r\u0005\t\u0003\u0013\"\u0007\u0015)\u0003\u00022\u00051Q-\u001c9us\u0002BC!a\u0012\u0002NA\u0019\u0001#a\u0014\n\u0007\u0005E\u0013C\u0001\u0005w_2\fG/\u001b7f\u0011%\t)\u0006\u001ab\u0001\n\u0013\t9&\u0001\u0003nCbDVCAA-!\r\u0001\u00121L\u0005\u0004\u0003;\n\"aA%oi\"A\u0011\u0011\r3!\u0002\u0013\tI&A\u0003nCbD\u0006\u0005C\u0005\u0002f\u0011\u0014\r\u0011\"\u0003\u0002X\u0005!Q.\u0019=Z\u0011!\tI\u0007\u001aQ\u0001\n\u0005e\u0013!B7bqf\u0003\u0003bBA7I\u0012\u0005\u0011qN\u0001\u0007EV\u001c7.\u001a;\u0015\u000bY\f\t(!\u001e\t\u000f\u0005M\u00141\u000ea\u0001\u007f\u0005\t\u0001\u0010C\u0004\u0002x\u0005-\u0004\u0019A \u0002\u0003eDq!!\u001ce\t\u0003\tY\bF\u0002w\u0003{Bq!a \u0002z\u0001\u0007\u0001*\u0001\u0005f]Z,Gn\u001c9f\u0011\u001d\t\u0019\t\u001aC\u0001\u0003\u000b\u000b\u0001\"\u001b;fe\u0006$xN\u001d\u000b\u000b\u0003\u000f\u000bi)!%\u0002\u0016\u0006e\u0005\u0003B\u0019\u0002\nfI1!a#<\u0005!IE/\u001a:bi>\u0014\bbBAH\u0003\u0003\u0003\raP\u0001\u0005q6Lg\u000eC\u0004\u0002\u0014\u0006\u0005\u0005\u0019A \u0002\tel\u0017N\u001c\u0005\b\u0003/\u000b\t\t1\u0001@\u0003\u0011AX.\u0019=\t\u000f\u0005m\u0015\u0011\u0011a\u0001\u007f\u0005!\u00110\\1y\u0011\u001d\ty\n\u001aC\u0001\u0003C\u000bAa]5{KR\u0011\u0011\u0011\f\u0005\b\u0003K#G\u0011AAT\u0003\u0015\u0019G.Z1s)\t\ti\u0004C\u0004\u0002,\u0012$I!!,\u0002\u000bMt\u0017\r\u001d-\u0015\t\u0005e\u0013q\u0016\u0005\b\u0003g\nI\u000b1\u0001@\u0011\u001d\t\u0019\f\u001aC\u0005\u0003k\u000bQa\u001d8baf#B!!\u0017\u00028\"9\u0011qOAY\u0001\u0004ydABA^I\u0002\tiL\u0001\u0007US\u0016\u0014\u0018\n^3sCR|'oE\u0003\u0002:>\t9\t\u0003\u0006\u0002\u0010\u0006e&\u0011!Q\u0001\n}B!\"a%\u0002:\n\u0005\t\u0015!\u0003@\u0011)\t9*!/\u0003\u0002\u0003\u0006Ia\u0010\u0005\u000b\u00037\u000bIL!A!\u0002\u0013y\u0004bB*\u0002:\u0012\u0005\u0011\u0011\u001a\u000b\u000b\u0003\u0017\fy-!5\u0002T\u0006U\u0007\u0003BAg\u0003sk\u0011\u0001\u001a\u0005\b\u0003\u001f\u000b9\r1\u0001@\u0011\u001d\t\u0019*a2A\u0002}Bq!a&\u0002H\u0002\u0007q\bC\u0004\u0002\u001c\u0006\u001d\u0007\u0019A \t\u0015\u0005e\u0017\u0011\u0018b\u0001\n\u0013\t9&\u0001\u0003nCbL\u0007\"CAo\u0003s\u0003\u000b\u0011BA-\u0003\u0015i\u0017\r_5!\u0011)\t\t/!/C\u0002\u0013%\u0011qK\u0001\u0005[&t'\u000eC\u0005\u0002f\u0006e\u0006\u0015!\u0003\u0002Z\u0005)Q.\u001b8kA!Q\u0011\u0011^A]\u0005\u0004%I!a\u0016\u0002\t5\f\u0007P\u001b\u0005\n\u0003[\fI\f)A\u0005\u00033\nQ!\\1yU\u0002B!\"!=\u0002:\u0002\u0007I\u0011BA,\u0003\u0005I\u0007BCA{\u0003s\u0003\r\u0011\"\u0003\u0002x\u0006)\u0011n\u0018\u0013fcR!\u0011QHA}\u0011)\t)%a=\u0002\u0002\u0003\u0007\u0011\u0011\f\u0005\n\u0003{\fI\f)Q\u0005\u00033\n!!\u001b\u0011\t\u0015\t\u0005\u0011\u0011\u0018a\u0001\n\u0013\t9&A\u0001k\u0011)\u0011)!!/A\u0002\u0013%!qA\u0001\u0006U~#S-\u001d\u000b\u0005\u0003{\u0011I\u0001\u0003\u0006\u0002F\t\r\u0011\u0011!a\u0001\u00033B\u0011B!\u0004\u0002:\u0002\u0006K!!\u0017\u0002\u0005)\u0004\u0003B\u0003B\t\u0003s\u0003\r\u0011\"\u0003\u0003\u0014\u0005!\u0011\u000e^3s+\t\u0011)\u0002E\u0003\u0003\u0018\te\u0011$D\u0001{\u0013\r\tYI\u001f\u0005\u000b\u0005;\tI\f1A\u0005\n\t}\u0011\u0001C5uKJ|F%Z9\u0015\t\u0005u\"\u0011\u0005\u0005\u000b\u0003\u000b\u0012Y\"!AA\u0002\tU\u0001\"\u0003B\u0013\u0003s\u0003\u000b\u0015\u0002B\u000b\u0003\u0015IG/\u001a:!\u0011!\u0011I#!/\u0005F\u0005=\u0012a\u00025bg:+\u0007\u0010\u001e\u0015\u0005\u0005O\u0011i\u0003\u0005\u0003\u00030\tURB\u0001B\u0019\u0015\r\u0011\u0019$E\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002\u0002B\u001c\u0005c\u0011q\u0001^1jYJ,7\r\u0003\u0005\u0003<\u0005eF\u0011\tB\u001f\u0003\u0011qW\r\u001f;\u0015\u0003eAqA!\u0011\u0001A\u0003%Q,\u0001\u0004uS\u0016\u00148\u000f\t\u0005\b\u0005\u000b\u0002A\u0011\tB$\u0003\u0019Ign]3siRA\u0011Q\bB%\u0005#\u0012)\u0006C\u0004L\u0005\u0007\u0002\rAa\u0013\u0011\u0007%\u0013i%C\u0002\u0003P)\u0013\u0001bR3p[\u0016$(/\u001f\u0005\t\u0005'\u0012\u0019\u00051\u0001\u0002\u0002\u0005\u00191.Z=\t\u000f\t]#1\ta\u00013\u0005)a/\u00197vK\"9!1\f\u0001\u0005B\tu\u0013A\u0002:f[>4X\rF\u0003\u001a\u0005?\u0012\t\u0007C\u0004L\u00053\u0002\rAa\u0013\t\u0011\tM#\u0011\fa\u0001\u0003\u0003AqA!\u001a\u0001\t\u0003\u00129'A\u0002hKR$R!\u0007B5\u0005WBqa\u0013B2\u0001\u0004\u0011Y\u0005\u0003\u0005\u0003T\t\r\u0004\u0019AA\u0001\u0011\u001d\u0011y\u0007\u0001C!\u0005c\nQ!];fef$\"\"a\"\u0003t\tU$q\u000fB=\u0011\u001d\tyI!\u001cA\u0002}Bq!a%\u0003n\u0001\u0007q\bC\u0004\u0002\u0018\n5\u0004\u0019A \t\u000f\u0005m%Q\u000ea\u0001\u007f!9!q\u000e\u0001\u0005B\tuDCAAD\u0011\u001d\ty\n\u0001C!\u0003CCq!!*\u0001\t\u0003\n9\u000bC\u0004\u0003\u0006\u0002!IAa\"\u0002\u0015M,G.Z2u)&,'\u000fF\u0002c\u0005\u0013Cq!a \u0003\u0004\u0002\u0007\u0001jB\u0004\u0003\u000e\nA\tAa$\u00021MK'0Z*fa\u0006\u0014\u0018\r^3e\u0005V\u001c7.\u001a;J]\u0012,\u0007\u0010E\u0002\u0017\u0005#3a!\u0001\u0002\t\u0002\tM5c\u0001BI\u001f!91K!%\u0005\u0002\t]EC\u0001BH\u0011)\u0011YJ!%C\u0002\u0013\u0005!QT\u0001\r\t\u00164\u0017-\u001e7u)&,'o]\u000b\u0002a!A!\u0011\u0015BIA\u0003%\u0001'A\u0007EK\u001a\fW\u000f\u001c;US\u0016\u00148\u000f\t\u0005\u000b\u0005K\u0013\t*%A\u0005\u0002\t\u001d\u0016a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$\u0013'\u0006\u0003\u0003*\nmVC\u0001BVU\r\u0001$QV\u0016\u0003\u0005_\u0003BA!-\u000386\u0011!1\u0017\u0006\u0005\u0005k\u0013\t$A\u0005v]\u000eDWmY6fI&!!\u0011\u0018BZ\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u0003\u00079\t\r&\u0019A\u000f\t\u0015\t}&\u0011SI\u0001\n\u0003\u0011\t-A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$HEM\u000b\u0005\u0005\u0007\u00149-\u0006\u0002\u0003F*\u001aqH!,\u0005\rq\u0011iL1\u0001\u001e\u0011)\u0011YM!%\u0012\u0002\u0013\u0005!QZ\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u001a\u0016\t\t\r'q\u001a\u0003\u00079\t%'\u0019A\u000f\t\u0015\tM'\u0011SI\u0001\n\u0003\u0011).A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$H\u0005N\u000b\u0005\u0005/\u0014Y.\u0006\u0002\u0003Z*\u001a\u0001J!,\u0005\rq\u0011\tN1\u0001\u001e\u0001")
public class SizeSeparatedBucketIndex<T>
implements SpatialIndex<T>,
StrictLogging {
    public final Seq<Tuple2<Object, Object>> org$locationtech$geomesa$utils$index$SizeSeparatedBucketIndex$$sizes;
    public final double org$locationtech$geomesa$utils$index$SizeSeparatedBucketIndex$$xBucketMultiplier;
    public final double org$locationtech$geomesa$utils$index$SizeSeparatedBucketIndex$$yBucketMultiplier;
    public final Envelope org$locationtech$geomesa$utils$index$SizeSeparatedBucketIndex$$extents;
    private final Seq<Tier> tiers;
    private final Logger logger;

    public static <T> Envelope $lessinit$greater$default$4() {
        return SizeSeparatedBucketIndex$.MODULE$.$lessinit$greater$default$4();
    }

    public static <T> double $lessinit$greater$default$3() {
        return SizeSeparatedBucketIndex$.MODULE$.$lessinit$greater$default$3();
    }

    public static <T> double $lessinit$greater$default$2() {
        return SizeSeparatedBucketIndex$.MODULE$.$lessinit$greater$default$2();
    }

    public static <T> Seq<Tuple2<Object, Object>> $lessinit$greater$default$1() {
        return SizeSeparatedBucketIndex$.MODULE$.$lessinit$greater$default$1();
    }

    public static Seq<Tuple2<Object, Object>> DefaultTiers() {
        return SizeSeparatedBucketIndex$.MODULE$.DefaultTiers();
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    @Override
    public Iterator<T> query(Envelope bbox) {
        return SpatialIndex$class.query(this, bbox);
    }

    @Override
    public void insert(double x, double y, String key2, T item) {
        SpatialIndex$class.insert(this, x, y, key2, item);
    }

    @Override
    public void insert(Envelope envelope, String key2, T item) {
        SpatialIndex$class.insert(this, envelope, key2, item);
    }

    @Override
    public void insert(Envelope envelope, T item) {
        SpatialIndex$class.insert(this, envelope, item);
    }

    @Override
    public T remove(double x, double y, String key2) {
        return (T)SpatialIndex$class.remove(this, x, y, key2);
    }

    @Override
    public T remove(Envelope envelope, String key2) {
        return (T)SpatialIndex$class.remove((SpatialIndex)this, envelope, key2);
    }

    @Override
    public boolean remove(Envelope envelope, T item) {
        return SpatialIndex$class.remove((SpatialIndex)this, envelope, item);
    }

    @Override
    public T get(double x, double y, String key2) {
        return (T)SpatialIndex$class.get(this, x, y, key2);
    }

    @Override
    public T get(Envelope envelope, String key2) {
        return (T)SpatialIndex$class.get(this, envelope, key2);
    }

    @Override
    public Iterator<T> query(Envelope envelope, Function1<T, Object> filter2) {
        return SpatialIndex$class.query(this, envelope, filter2);
    }

    private Seq<Tier> tiers() {
        return this.tiers;
    }

    @Override
    public void insert(Geometry geom, String key2, T value2) {
        Envelope envelope = geom.getEnvelopeInternal();
        Tier tier = this.selectTier(envelope);
        if (tier.empty()) {
            tier.empty_$eq(false);
        }
        tier.bucket(envelope).put(key2, value2);
    }

    @Override
    public T remove(Geometry geom, String key2) {
        Envelope envelope = geom.getEnvelopeInternal();
        return this.selectTier(envelope).bucket(envelope).remove(key2);
    }

    @Override
    public T get(Geometry geom, String key2) {
        Envelope envelope = geom.getEnvelopeInternal();
        return this.selectTier(envelope).bucket(envelope).get(key2);
    }

    @Override
    public Iterator<T> query(double xmin, double ymin, double xmax, double ymax) {
        return this.tiers().iterator().flatMap((Function1)new Serializable(this, xmin, ymin, xmax, ymax){
            public static final long serialVersionUID = 0L;
            private final double xmin$1;
            private final double ymin$1;
            private final double xmax$1;
            private final double ymax$1;

            public final Iterator<T> apply(Tier x$1) {
                return x$1.iterator(this.xmin$1, this.ymin$1, this.xmax$1, this.ymax$1);
            }
            {
                this.xmin$1 = xmin$1;
                this.ymin$1 = ymin$1;
                this.xmax$1 = xmax$1;
                this.ymax$1 = ymax$1;
            }
        });
    }

    @Override
    public Iterator<T> query() {
        return this.query(this.org$locationtech$geomesa$utils$index$SizeSeparatedBucketIndex$$extents.getMinX(), this.org$locationtech$geomesa$utils$index$SizeSeparatedBucketIndex$$extents.getMinY(), this.org$locationtech$geomesa$utils$index$SizeSeparatedBucketIndex$$extents.getMaxX(), this.org$locationtech$geomesa$utils$index$SizeSeparatedBucketIndex$$extents.getMaxY());
    }

    @Override
    public int size() {
        IntRef size2 = IntRef.create((int)0);
        this.tiers().foreach((Function1)new Serializable(this, size2){
            public static final long serialVersionUID = 0L;
            private final IntRef size$1;

            public final void apply(Tier tier) {
                this.size$1.elem += tier.size();
            }
            {
                this.size$1 = size$1;
            }
        });
        return size2.elem;
    }

    @Override
    public void clear() {
        this.tiers().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(Tier x$2) {
                x$2.clear();
            }
        });
    }

    private Tier selectTier(Envelope envelope) {
        double width = envelope.getWidth();
        double height = envelope.getHeight();
        return (Tier)this.tiers().find((Function1)new Serializable(this, width, height){
            public static final long serialVersionUID = 0L;
            private final double width$1;
            private final double height$1;

            public final boolean apply(Tier t) {
                return t.maxSizeX() >= this.width$1 && t.maxSizeY() >= this.height$1;
            }
            {
                this.width$1 = width$1;
                this.height$1 = height$1;
            }
        }).getOrElse((Function0)new Serializable(this, envelope){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SizeSeparatedBucketIndex $outer;
            private final Envelope envelope$1;

            public final Nothing$ apply() {
                throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Envelope ", " exceeds the max tier size ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.envelope$1, this.$outer.org$locationtech$geomesa$utils$index$SizeSeparatedBucketIndex$$sizes.last()})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.envelope$1 = envelope$1;
            }
        });
    }

    public SizeSeparatedBucketIndex(Seq<Tuple2<Object, Object>> sizes, double xBucketMultiplier, double yBucketMultiplier, Envelope extents) {
        this.org$locationtech$geomesa$utils$index$SizeSeparatedBucketIndex$$sizes = sizes;
        this.org$locationtech$geomesa$utils$index$SizeSeparatedBucketIndex$$xBucketMultiplier = xBucketMultiplier;
        this.org$locationtech$geomesa$utils$index$SizeSeparatedBucketIndex$$yBucketMultiplier = yBucketMultiplier;
        this.org$locationtech$geomesa$utils$index$SizeSeparatedBucketIndex$$extents = extents;
        SpatialIndex$class.$init$(this);
        StrictLogging.class.$init$((StrictLogging)this);
        Predef$.MODULE$.require(sizes.nonEmpty(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "No valid tier sizes specified";
            }
        });
        Predef$.MODULE$.require(sizes.lengthCompare(1) == 0 || sizes.sliding(2).forall((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Seq<Tuple2<Object, Object>> x0$2) {
                Seq<Tuple2<Object, Object>> seq = x0$2;
                Some some = Seq$.MODULE$.unapplySeq(seq);
                if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(2) == 0) {
                    Tuple2 tuple2 = (Tuple2)((SeqLike)some.get()).apply(0);
                    Tuple2 tuple22 = (Tuple2)((SeqLike)some.get()).apply(1);
                    if (tuple2 != null) {
                        double x1 = tuple2._1$mcD$sp();
                        double y1 = tuple2._2$mcD$sp();
                        if (tuple22 != null) {
                            double x2 = tuple22._1$mcD$sp();
                            double y2 = tuple22._2$mcD$sp();
                            boolean bl = x1 <= x2 && y1 <= y2;
                            return bl;
                        }
                    }
                }
                throw new MatchError(seq);
            }
        }), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Tiers must be ordered by increasing size";
            }
        });
        this.tiers = (Seq)sizes.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SizeSeparatedBucketIndex $outer;

            public final Tier apply(Tuple2<Object, Object> x0$1) {
                Tuple2<Object, Object> tuple2 = x0$1;
                if (tuple2 != null) {
                    BoxedUnit boxedUnit;
                    double width = tuple2._1$mcD$sp();
                    double height = tuple2._2$mcD$sp();
                    int xSize = (int)scala.math.package$.MODULE$.ceil(this.$outer.org$locationtech$geomesa$utils$index$SizeSeparatedBucketIndex$$extents.getWidth() * this.$outer.org$locationtech$geomesa$utils$index$SizeSeparatedBucketIndex$$xBucketMultiplier / width);
                    int ySize = (int)scala.math.package$.MODULE$.ceil(this.$outer.org$locationtech$geomesa$utils$index$SizeSeparatedBucketIndex$$extents.getHeight() * this.$outer.org$locationtech$geomesa$utils$index$SizeSeparatedBucketIndex$$yBucketMultiplier / height);
                    ConcurrentHashMap[][] buckets = (ConcurrentHashMap[][])Array$.MODULE$.fill(xSize, ySize, (Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final ConcurrentHashMap<String, T> apply() {
                            return new ConcurrentHashMap<K, V>();
                        }
                    }, ClassTag$.MODULE$.apply(ConcurrentHashMap.class));
                    if (this.$outer.logger().underlying().isDebugEnabled()) {
                        this.$outer.logger().underlying().debug("Creating tier for size ({} {}) with buckets [{}x{}]", new Object[]{BoxesRunTime.boxToDouble((double)width), BoxesRunTime.boxToDouble((double)height), BoxesRunTime.boxToInteger((int)xSize), BoxesRunTime.boxToInteger((int)ySize)});
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    Tier tier = new Tier(this.$outer, width, height, buckets, new GridSnap(this.$outer.org$locationtech$geomesa$utils$index$SizeSeparatedBucketIndex$$extents, xSize, ySize));
                    return tier;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    public class Tier {
        private final double maxSizeX;
        private final double maxSizeY;
        public final ConcurrentHashMap<String, T>[][] org$locationtech$geomesa$utils$index$SizeSeparatedBucketIndex$Tier$$buckets;
        private final GridSnap gridSnap;
        private volatile boolean empty;
        private final int maxX;
        private final int maxY;
        public final /* synthetic */ SizeSeparatedBucketIndex $outer;

        public double maxSizeX() {
            return this.maxSizeX;
        }

        public double maxSizeY() {
            return this.maxSizeY;
        }

        public boolean empty() {
            return this.empty;
        }

        public void empty_$eq(boolean x$1) {
            this.empty = x$1;
        }

        private int maxX() {
            return this.maxX;
        }

        private int maxY() {
            return this.maxY;
        }

        public ConcurrentHashMap<String, T> bucket(double x, double y) {
            return this.org$locationtech$geomesa$utils$index$SizeSeparatedBucketIndex$Tier$$buckets[this.org$locationtech$geomesa$utils$index$SizeSeparatedBucketIndex$Tier$$snapX(x)][this.org$locationtech$geomesa$utils$index$SizeSeparatedBucketIndex$Tier$$snapY(y)];
        }

        public ConcurrentHashMap<String, T> bucket(Envelope envelope) {
            return this.org$locationtech$geomesa$utils$index$SizeSeparatedBucketIndex$Tier$$buckets[this.org$locationtech$geomesa$utils$index$SizeSeparatedBucketIndex$Tier$$snapX((envelope.getMinX() + envelope.getMaxX()) / 2.0)][this.org$locationtech$geomesa$utils$index$SizeSeparatedBucketIndex$Tier$$snapY((envelope.getMinY() + envelope.getMaxY()) / 2.0)];
        }

        public Iterator<T> iterator(double xmin, double ymin, double xmax, double ymax) {
            return this.empty() ? package$.MODULE$.Iterator().empty() : new TierIterator(xmin, ymin, xmax, ymax);
        }

        /*
         * WARNING - void declaration
         */
        public int size() {
            int n;
            if (this.empty()) {
                n = 0;
            } else {
                void var1_1;
                int size2 = 0;
                for (int i = 0; i <= this.maxX(); ++i) {
                    for (int j = 0; j <= this.maxY(); ++j) {
                        size2 += this.org$locationtech$geomesa$utils$index$SizeSeparatedBucketIndex$Tier$$buckets[i][j].size();
                    }
                }
                n = var1_1;
            }
            return n;
        }

        public void clear() {
            for (int i = 0; i <= this.maxX(); ++i) {
                for (int j = 0; j <= this.maxY(); ++j) {
                    this.org$locationtech$geomesa$utils$index$SizeSeparatedBucketIndex$Tier$$buckets[i][j].clear();
                }
            }
        }

        public int org$locationtech$geomesa$utils$index$SizeSeparatedBucketIndex$Tier$$snapX(double x) {
            int i = this.gridSnap.i(x);
            return i != -1 ? i : (x < this.org$locationtech$geomesa$utils$index$SizeSeparatedBucketIndex$Tier$$$outer().org$locationtech$geomesa$utils$index$SizeSeparatedBucketIndex$$extents.getMinX() ? 0 : this.maxX());
        }

        public int org$locationtech$geomesa$utils$index$SizeSeparatedBucketIndex$Tier$$snapY(double y) {
            int j = this.gridSnap.j(y);
            return j != -1 ? j : (y < this.org$locationtech$geomesa$utils$index$SizeSeparatedBucketIndex$Tier$$$outer().org$locationtech$geomesa$utils$index$SizeSeparatedBucketIndex$$extents.getMinY() ? 0 : this.maxY());
        }

        public /* synthetic */ SizeSeparatedBucketIndex org$locationtech$geomesa$utils$index$SizeSeparatedBucketIndex$Tier$$$outer() {
            return this.$outer;
        }

        public Tier(SizeSeparatedBucketIndex<T> $outer, double maxSizeX, double maxSizeY, ConcurrentHashMap<String, T>[][] buckets, GridSnap gridSnap) {
            this.maxSizeX = maxSizeX;
            this.maxSizeY = maxSizeY;
            this.org$locationtech$geomesa$utils$index$SizeSeparatedBucketIndex$Tier$$buckets = buckets;
            this.gridSnap = gridSnap;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            this.empty = true;
            this.maxX = buckets.length - 1;
            this.maxY = buckets[0].length - 1;
        }

        public class TierIterator
        implements Iterator<T> {
            private final int maxi;
            private final int minj;
            private final int maxj;
            private int i;
            private int j;
            private java.util.Iterator<T> iter;

            public Iterator<T> seq() {
                return Iterator.class.seq((Iterator)this);
            }

            public boolean isEmpty() {
                return Iterator.class.isEmpty((Iterator)this);
            }

            public boolean isTraversableAgain() {
                return Iterator.class.isTraversableAgain((Iterator)this);
            }

            public boolean hasDefiniteSize() {
                return Iterator.class.hasDefiniteSize((Iterator)this);
            }

            public Iterator<T> take(int n) {
                return Iterator.class.take((Iterator)this, (int)n);
            }

            public Iterator<T> drop(int n) {
                return Iterator.class.drop((Iterator)this, (int)n);
            }

            public Iterator<T> slice(int from, int until) {
                return Iterator.class.slice((Iterator)this, (int)from, (int)until);
            }

            public <B> Iterator<B> map(Function1<T, B> f) {
                return Iterator.class.map((Iterator)this, f);
            }

            public <B> Iterator<B> $plus$plus(Function0<GenTraversableOnce<B>> that) {
                return Iterator.class.$plus$plus((Iterator)this, that);
            }

            public <B> Iterator<B> flatMap(Function1<T, GenTraversableOnce<B>> f) {
                return Iterator.class.flatMap((Iterator)this, f);
            }

            public Iterator<T> filter(Function1<T, Object> p) {
                return Iterator.class.filter((Iterator)this, p);
            }

            public <B> boolean corresponds(GenTraversableOnce<B> that, Function2<T, B, Object> p) {
                return Iterator.class.corresponds((Iterator)this, that, p);
            }

            public Iterator<T> withFilter(Function1<T, Object> p) {
                return Iterator.class.withFilter((Iterator)this, p);
            }

            public Iterator<T> filterNot(Function1<T, Object> p) {
                return Iterator.class.filterNot((Iterator)this, p);
            }

            public <B> Iterator<B> collect(PartialFunction<T, B> pf) {
                return Iterator.class.collect((Iterator)this, pf);
            }

            public <B> Iterator<B> scanLeft(B z, Function2<B, T, B> op) {
                return Iterator.class.scanLeft((Iterator)this, z, op);
            }

            public <B> Iterator<B> scanRight(B z, Function2<T, B, B> op) {
                return Iterator.class.scanRight((Iterator)this, z, op);
            }

            public Iterator<T> takeWhile(Function1<T, Object> p) {
                return Iterator.class.takeWhile((Iterator)this, p);
            }

            public Tuple2<Iterator<T>, Iterator<T>> partition(Function1<T, Object> p) {
                return Iterator.class.partition((Iterator)this, p);
            }

            public Tuple2<Iterator<T>, Iterator<T>> span(Function1<T, Object> p) {
                return Iterator.class.span((Iterator)this, p);
            }

            public Iterator<T> dropWhile(Function1<T, Object> p) {
                return Iterator.class.dropWhile((Iterator)this, p);
            }

            public <B> Iterator<Tuple2<T, B>> zip(Iterator<B> that) {
                return Iterator.class.zip((Iterator)this, that);
            }

            public <A1> Iterator<A1> padTo(int len, A1 elem) {
                return Iterator.class.padTo((Iterator)this, (int)len, elem);
            }

            public Iterator<Tuple2<T, Object>> zipWithIndex() {
                return Iterator.class.zipWithIndex((Iterator)this);
            }

            public <B, A1, B1> Iterator<Tuple2<A1, B1>> zipAll(Iterator<B> that, A1 thisElem, B1 thatElem) {
                return Iterator.class.zipAll((Iterator)this, that, thisElem, thatElem);
            }

            public <U> void foreach(Function1<T, U> f) {
                Iterator.class.foreach((Iterator)this, f);
            }

            public boolean forall(Function1<T, Object> p) {
                return Iterator.class.forall((Iterator)this, p);
            }

            public boolean exists(Function1<T, Object> p) {
                return Iterator.class.exists((Iterator)this, p);
            }

            public boolean contains(Object elem) {
                return Iterator.class.contains((Iterator)this, (Object)elem);
            }

            public Option<T> find(Function1<T, Object> p) {
                return Iterator.class.find((Iterator)this, p);
            }

            public int indexWhere(Function1<T, Object> p) {
                return Iterator.class.indexWhere((Iterator)this, p);
            }

            public <B> int indexOf(B elem) {
                return Iterator.class.indexOf((Iterator)this, elem);
            }

            public BufferedIterator<T> buffered() {
                return Iterator.class.buffered((Iterator)this);
            }

            public <B> Iterator.GroupedIterator<B> grouped(int size2) {
                return Iterator.class.grouped((Iterator)this, (int)size2);
            }

            public <B> Iterator.GroupedIterator<B> sliding(int size2, int step) {
                return Iterator.class.sliding((Iterator)this, (int)size2, (int)step);
            }

            public int length() {
                return Iterator.class.length((Iterator)this);
            }

            public Tuple2<Iterator<T>, Iterator<T>> duplicate() {
                return Iterator.class.duplicate((Iterator)this);
            }

            public <B> Iterator<B> patch(int from, Iterator<B> patchElems, int replaced) {
                return Iterator.class.patch((Iterator)this, (int)from, patchElems, (int)replaced);
            }

            public <B> void copyToArray(Object xs, int start, int len) {
                Iterator.class.copyToArray((Iterator)this, (Object)xs, (int)start, (int)len);
            }

            public boolean sameElements(Iterator<?> that) {
                return Iterator.class.sameElements((Iterator)this, that);
            }

            public Traversable<T> toTraversable() {
                return Iterator.class.toTraversable((Iterator)this);
            }

            public Iterator<T> toIterator() {
                return Iterator.class.toIterator((Iterator)this);
            }

            public Stream<T> toStream() {
                return Iterator.class.toStream((Iterator)this);
            }

            public String toString() {
                return Iterator.class.toString((Iterator)this);
            }

            public <B> int sliding$default$2() {
                return Iterator.class.sliding$default$2((Iterator)this);
            }

            public List<T> reversed() {
                return TraversableOnce.class.reversed((TraversableOnce)this);
            }

            public int size() {
                return TraversableOnce.class.size((TraversableOnce)this);
            }

            public boolean nonEmpty() {
                return TraversableOnce.class.nonEmpty((TraversableOnce)this);
            }

            public int count(Function1<T, Object> p) {
                return TraversableOnce.class.count((TraversableOnce)this, p);
            }

            public <B> Option<B> collectFirst(PartialFunction<T, B> pf) {
                return TraversableOnce.class.collectFirst((TraversableOnce)this, pf);
            }

            public <B> B $div$colon(B z, Function2<B, T, B> op) {
                return (B)TraversableOnce.class.$div$colon((TraversableOnce)this, z, op);
            }

            public <B> B $colon$bslash(B z, Function2<T, B, B> op) {
                return (B)TraversableOnce.class.$colon$bslash((TraversableOnce)this, z, op);
            }

            public <B> B foldLeft(B z, Function2<B, T, B> op) {
                return (B)TraversableOnce.class.foldLeft((TraversableOnce)this, z, op);
            }

            public <B> B foldRight(B z, Function2<T, B, B> op) {
                return (B)TraversableOnce.class.foldRight((TraversableOnce)this, z, op);
            }

            public <B> B reduceLeft(Function2<B, T, B> op) {
                return (B)TraversableOnce.class.reduceLeft((TraversableOnce)this, op);
            }

            public <B> B reduceRight(Function2<T, B, B> op) {
                return (B)TraversableOnce.class.reduceRight((TraversableOnce)this, op);
            }

            public <B> Option<B> reduceLeftOption(Function2<B, T, B> op) {
                return TraversableOnce.class.reduceLeftOption((TraversableOnce)this, op);
            }

            public <B> Option<B> reduceRightOption(Function2<T, B, B> op) {
                return TraversableOnce.class.reduceRightOption((TraversableOnce)this, op);
            }

            public <A1> A1 reduce(Function2<A1, A1, A1> op) {
                return (A1)TraversableOnce.class.reduce((TraversableOnce)this, op);
            }

            public <A1> Option<A1> reduceOption(Function2<A1, A1, A1> op) {
                return TraversableOnce.class.reduceOption((TraversableOnce)this, op);
            }

            public <A1> A1 fold(A1 z, Function2<A1, A1, A1> op) {
                return (A1)TraversableOnce.class.fold((TraversableOnce)this, z, op);
            }

            public <B> B aggregate(Function0<B> z, Function2<B, T, B> seqop, Function2<B, B, B> combop) {
                return (B)TraversableOnce.class.aggregate((TraversableOnce)this, z, seqop, combop);
            }

            public <B> B sum(Numeric<B> num) {
                return (B)TraversableOnce.class.sum((TraversableOnce)this, num);
            }

            public <B> B product(Numeric<B> num) {
                return (B)TraversableOnce.class.product((TraversableOnce)this, num);
            }

            public <B> T min(Ordering<B> cmp) {
                return TraversableOnce.class.min((TraversableOnce)this, cmp);
            }

            public <B> T max(Ordering<B> cmp) {
                return TraversableOnce.class.max((TraversableOnce)this, cmp);
            }

            public <B> T maxBy(Function1<T, B> f, Ordering<B> cmp) {
                return TraversableOnce.class.maxBy((TraversableOnce)this, f, cmp);
            }

            public <B> T minBy(Function1<T, B> f, Ordering<B> cmp) {
                return TraversableOnce.class.minBy((TraversableOnce)this, f, cmp);
            }

            public <B> void copyToBuffer(Buffer<B> dest) {
                TraversableOnce.class.copyToBuffer((TraversableOnce)this, dest);
            }

            public <B> void copyToArray(Object xs, int start) {
                TraversableOnce.class.copyToArray((TraversableOnce)this, (Object)xs, (int)start);
            }

            public <B> void copyToArray(Object xs) {
                TraversableOnce.class.copyToArray((TraversableOnce)this, (Object)xs);
            }

            public <B> Object toArray(ClassTag<B> evidence$1) {
                return TraversableOnce.class.toArray((TraversableOnce)this, evidence$1);
            }

            public List<T> toList() {
                return TraversableOnce.class.toList((TraversableOnce)this);
            }

            public Iterable<T> toIterable() {
                return TraversableOnce.class.toIterable((TraversableOnce)this);
            }

            public Seq<T> toSeq() {
                return TraversableOnce.class.toSeq((TraversableOnce)this);
            }

            public IndexedSeq<T> toIndexedSeq() {
                return TraversableOnce.class.toIndexedSeq((TraversableOnce)this);
            }

            public <B> Buffer<B> toBuffer() {
                return TraversableOnce.class.toBuffer((TraversableOnce)this);
            }

            public <B> Set<B> toSet() {
                return TraversableOnce.class.toSet((TraversableOnce)this);
            }

            public Vector<T> toVector() {
                return TraversableOnce.class.toVector((TraversableOnce)this);
            }

            public <Col> Col to(CanBuildFrom<Nothing$, T, Col> cbf) {
                return (Col)TraversableOnce.class.to((TraversableOnce)this, cbf);
            }

            public <T, U> Map<T, U> toMap(Predef.$less$colon$less<T, Tuple2<T, U>> ev) {
                return TraversableOnce.class.toMap((TraversableOnce)this, ev);
            }

            public String mkString(String start, String sep, String end) {
                return TraversableOnce.class.mkString((TraversableOnce)this, (String)start, (String)sep, (String)end);
            }

            public String mkString(String sep) {
                return TraversableOnce.class.mkString((TraversableOnce)this, (String)sep);
            }

            public String mkString() {
                return TraversableOnce.class.mkString((TraversableOnce)this);
            }

            public StringBuilder addString(StringBuilder b, String start, String sep, String end) {
                return TraversableOnce.class.addString((TraversableOnce)this, (StringBuilder)b, (String)start, (String)sep, (String)end);
            }

            public StringBuilder addString(StringBuilder b, String sep) {
                return TraversableOnce.class.addString((TraversableOnce)this, (StringBuilder)b, (String)sep);
            }

            public StringBuilder addString(StringBuilder b) {
                return TraversableOnce.class.addString((TraversableOnce)this, (StringBuilder)b);
            }

            private int maxi() {
                return this.maxi;
            }

            private int minj() {
                return this.minj;
            }

            private int maxj() {
                return this.maxj;
            }

            private int i() {
                return this.i;
            }

            private void i_$eq(int x$1) {
                this.i = x$1;
            }

            private int j() {
                return this.j;
            }

            private void j_$eq(int x$1) {
                this.j = x$1;
            }

            private java.util.Iterator<T> iter() {
                return this.iter;
            }

            private void iter_$eq(java.util.Iterator<T> x$1) {
                this.iter = x$1;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean hasNext() {
                while (!this.iter().hasNext()) {
                    if (this.i() == this.maxi() && this.j() == this.maxj()) {
                        if (!false) return false;
                        return true;
                    }
                    if (this.j() < this.maxj()) {
                        this.j_$eq(this.j() + 1);
                    } else {
                        this.j_$eq(this.minj());
                        this.i_$eq(this.i() + 1);
                    }
                    this.iter_$eq(this.org$locationtech$geomesa$utils$index$SizeSeparatedBucketIndex$Tier$TierIterator$$$outer().org$locationtech$geomesa$utils$index$SizeSeparatedBucketIndex$Tier$$buckets[this.i()][this.j()].values().iterator());
                }
                return true;
            }

            public T next() {
                return this.iter().next();
            }

            public /* synthetic */ Tier org$locationtech$geomesa$utils$index$SizeSeparatedBucketIndex$Tier$TierIterator$$$outer() {
                return Tier.this;
            }

            public TierIterator(double xmin, double ymin, double xmax, double ymax) {
                if (Tier.this == null) {
                    throw null;
                }
                TraversableOnce.class.$init$((TraversableOnce)this);
                Iterator.class.$init$((Iterator)this);
                this.maxi = Tier.this.org$locationtech$geomesa$utils$index$SizeSeparatedBucketIndex$Tier$$snapX(xmax + Tier.this.maxSizeX());
                this.minj = Tier.this.org$locationtech$geomesa$utils$index$SizeSeparatedBucketIndex$Tier$$snapY(ymin - Tier.this.maxSizeY());
                this.maxj = Tier.this.org$locationtech$geomesa$utils$index$SizeSeparatedBucketIndex$Tier$$snapY(ymax + Tier.this.maxSizeY());
                this.i = Tier.this.org$locationtech$geomesa$utils$index$SizeSeparatedBucketIndex$Tier$$snapX(xmin - Tier.this.maxSizeX());
                this.j = this.minj();
                this.iter = Tier.this.org$locationtech$geomesa$utils$index$SizeSeparatedBucketIndex$Tier$$buckets[this.i()][this.j()].values().iterator();
            }
        }
    }
}

