/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.serialize;

import java.util.Arrays;
import java.util.HashSet;
import net.sf.saxon.event.ProxyReceiver;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.parser.ExplicitLocation;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.om.FingerprintedQName;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.serialize.HTMLTagHashSet;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.tiny.CharSlice;
import net.sf.saxon.type.SchemaType;

public class HTMLIndenter
extends ProxyReceiver {
    private int level = 0;
    protected char[] indentChars = new char[]{'\n', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' '};
    private boolean sameLine = false;
    private boolean inFormattedTag = false;
    private boolean afterInline = false;
    private boolean afterFormatted = true;
    private int[] propertyStack = new int[20];
    private NameClassifier classifier;
    private static final String[] inlineTags = new String[]{"tt", "i", "b", "u", "s", "strike", "big", "small", "em", "strong", "dfn", "code", "samp", "kbd", "var", "cite", "abbr", "acronym", "a", "img", "applet", "object", "font", "basefont", "br", "script", "map", "q", "sub", "sup", "span", "bdo", "iframe", "input", "select", "textarea", "label", "button", "ins", "del"};
    static final String[] formattedTags = new String[]{"pre", "script", "style", "textarea", "xmp"};

    public HTMLIndenter(Receiver next, String method) {
        super(next);
        this.classifier = "xhtml".equals(method) ? XHTMLNameClassifier.THE_INSTANCE : HTMLNameClassifier.THE_INSTANCE;
    }

    public void startElement(NodeName nameCode, SchemaType typeCode, Location location, int properties) throws XPathException {
        int tagProps = this.classifier.classifyTag(nameCode);
        if (this.level >= this.propertyStack.length) {
            int[] p2 = new int[this.level * 2];
            System.arraycopy(this.propertyStack, 0, p2, 0, this.propertyStack.length);
            this.propertyStack = p2;
        }
        this.propertyStack[this.level] = tagProps;
        boolean inlineTag = (tagProps & 1) != 0;
        boolean bl = this.inFormattedTag = this.inFormattedTag || (tagProps & 2) != 0;
        if (!(inlineTag || this.inFormattedTag || this.afterInline || this.afterFormatted)) {
            this.indent();
        }
        this.nextReceiver.startElement(nameCode, typeCode, location, properties);
        ++this.level;
        this.sameLine = true;
        this.afterInline = false;
        this.afterFormatted = false;
    }

    public void endElement() throws XPathException {
        boolean thisFormatted;
        --this.level;
        boolean thisInline = (this.propertyStack[this.level] & 1) != 0;
        boolean bl = thisFormatted = (this.propertyStack[this.level] & 2) != 0;
        if (!(thisInline || thisFormatted || this.afterInline || this.sameLine || this.afterFormatted || this.inFormattedTag)) {
            this.indent();
            this.afterInline = false;
            this.afterFormatted = false;
        } else {
            this.afterInline = thisInline;
            this.afterFormatted = thisFormatted;
        }
        this.nextReceiver.endElement();
        this.inFormattedTag = this.inFormattedTag && !thisFormatted;
        this.sameLine = false;
    }

    public void characters(CharSequence chars, Location locationId, int properties) throws XPathException {
        if (this.inFormattedTag || (properties & 0x100) != 0 || (properties & 1) != 0) {
            this.nextReceiver.characters(chars, locationId, properties);
        } else {
            int lastNL = 0;
            for (int i = 0; i < chars.length(); ++i) {
                if (chars.charAt(i) != '\n' && (i - lastNL <= this.getLineLength() || chars.charAt(i) != ' ')) continue;
                this.sameLine = false;
                this.nextReceiver.characters(chars.subSequence(lastNL, i), locationId, properties);
                this.indent();
                for (lastNL = i + 1; lastNL < chars.length() && chars.charAt(lastNL) == ' '; ++lastNL) {
                }
            }
            if (lastNL < chars.length()) {
                this.nextReceiver.characters(chars.subSequence(lastNL, chars.length()), locationId, properties);
            }
        }
        this.afterInline = false;
    }

    public void comment(CharSequence chars, Location locationId, int properties) throws XPathException {
        this.indent();
        this.nextReceiver.comment(chars, locationId, properties);
    }

    private void indent() throws XPathException {
        int spaces = this.level * this.getIndentation();
        if (spaces + 1 >= this.indentChars.length) {
            int increment = 5 * this.getIndentation();
            if (spaces + 1 > this.indentChars.length + increment) {
                increment += spaces + 1;
            }
            char[] c2 = new char[this.indentChars.length + increment];
            System.arraycopy(this.indentChars, 0, c2, 0, this.indentChars.length);
            Arrays.fill(c2, this.indentChars.length, c2.length, ' ');
            this.indentChars = c2;
        }
        this.nextReceiver.characters(new CharSlice(this.indentChars, 0, spaces + 1), ExplicitLocation.UNKNOWN_LOCATION, 0);
        this.sameLine = false;
    }

    protected int getIndentation() {
        return 3;
    }

    protected int getLineLength() {
        return 80;
    }

    static class XHTMLNameClassifier
    implements NameClassifier {
        static final XHTMLNameClassifier THE_INSTANCE = new XHTMLNameClassifier();
        private static final HashSet<NodeName> inlineTagSet = new HashSet(50);
        private static final HashSet<NodeName> formattedTagSet = new HashSet(10);

        XHTMLNameClassifier() {
        }

        public int classifyTag(NodeName name) {
            int r = 0;
            if (inlineTagSet.contains(name)) {
                r |= 1;
            }
            if (formattedTagSet.contains(name)) {
                r |= 2;
            }
            return r;
        }

        static {
            for (String inlineTag : inlineTags) {
                inlineTagSet.add(new FingerprintedQName("", "http://www.w3.org/1999/xhtml", inlineTag));
            }
            for (String formattedTag : formattedTags) {
                formattedTagSet.add(new FingerprintedQName("", "http://www.w3.org/1999/xhtml", formattedTag));
            }
        }
    }

    static class HTMLNameClassifier
    implements NameClassifier {
        static final HTMLNameClassifier THE_INSTANCE = new HTMLNameClassifier();
        private static HTMLTagHashSet inlineTable = new HTMLTagHashSet(101);
        private static HTMLTagHashSet formattedTable;

        HTMLNameClassifier() {
        }

        public int classifyTag(NodeName elemName) {
            int r = 0;
            String tag = elemName.getDisplayName();
            if (inlineTable.contains(tag)) {
                r |= 1;
            }
            if (formattedTable.contains(tag)) {
                r |= 2;
            }
            return r;
        }

        static {
            for (String inlineTag : inlineTags) {
                inlineTable.add(inlineTag);
            }
            formattedTable = new HTMLTagHashSet(23);
            for (String formattedTag : formattedTags) {
                formattedTable.add(formattedTag);
            }
        }
    }

    static interface NameClassifier {
        public static final int IS_INLINE = 1;
        public static final int IS_FORMATTED = 2;

        public int classifyTag(NodeName var1);
    }
}

