/*
 * Decompiled with CFR 0.152.
 */
package org.calrissian.mango.uri.transform;

import com.google.common.net.MediaType;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.calrissian.mango.uri.domain.ResolvedItem;
import org.calrissian.mango.uri.exception.ContextTransformException;
import org.calrissian.mango.uri.transform.ContextTransformer;
import org.calrissian.mango.uri.transform.interceptor.ContextTransformInterceptor;

public class ContextTransformService {
    private final Map<String, ContextTransformer> contextTransformMap = new HashMap<String, ContextTransformer>();
    private final Map<Class, ContextTransformInterceptor> transformInterceptorMap = new HashMap<Class, ContextTransformInterceptor>();

    public ContextTransformService(Collection<ContextTransformer> contextTransforms, Collection<ContextTransformInterceptor> contextTransformInterceptors) {
        if (contextTransforms != null) {
            for (ContextTransformer transform : contextTransforms) {
                this.contextTransformMap.put(transform.getContextName(), transform);
            }
        }
        if (contextTransformInterceptors != null) {
            for (ContextTransformInterceptor interceptor : contextTransformInterceptors) {
                this.transformInterceptorMap.put(interceptor.intercepts(), interceptor);
            }
        }
    }

    public ResolvedItem transform(String contextName, Object obj) throws ContextTransformException {
        ContextTransformInterceptor interceptor = this.transformInterceptorMap.get(obj.getClass());
        if (interceptor != null) {
            return interceptor.transform(obj);
        }
        return this.contextTransformMap.get(contextName).transform(obj);
    }

    public MediaType getMediaType(String contextName, Object obj) throws ContextTransformException {
        ContextTransformInterceptor interceptor = this.transformInterceptorMap.get(obj.getClass());
        if (interceptor != null) {
            return interceptor.getMediaType(obj);
        }
        return this.contextTransformMap.get(contextName).getMediaType(obj);
    }
}

