/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext;

import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.HashMap;
import java.util.Map;
import javax.media.jai.ImageLayout;
import javax.media.jai.PlanarImage;

public class BufferedImageAdapter
extends PlanarImage {
    private BufferedImage image;

    private static Map getProperties(BufferedImage bi) {
        String[] propertyNames = bi.getPropertyNames();
        if (propertyNames == null) {
            return null;
        }
        HashMap<String, Object> properties = new HashMap<String, Object>();
        for (String name : bi.getPropertyNames()) {
            properties.put(name, bi.getProperty(name));
        }
        return properties;
    }

    private static ImageLayout getImageLayout(BufferedImage im) {
        ImageLayout il = new ImageLayout((RenderedImage)im);
        il.unsetTileLayout();
        il.setTileGridXOffset(0);
        il.setTileGridYOffset(0);
        il.setTileWidth(im.getWidth());
        il.setTileHeight(im.getHeight());
        return il;
    }

    public BufferedImageAdapter(BufferedImage image) {
        super(BufferedImageAdapter.getImageLayout(image), null, BufferedImageAdapter.getProperties(image));
        this.image = image;
    }

    public Raster getTile(int tileX, int tileY) {
        if (tileX != 0 || tileY != 0) {
            return null;
        }
        return this.image.getTile(tileX, tileY);
    }

    public Raster getData() {
        WritableRaster raster = this.image.getRaster();
        if (raster.getParent() != null) {
            return this.image.getData(new Rectangle(0, 0, raster.getWidth(), raster.getHeight()));
        }
        return raster;
    }

    public Raster getData(Rectangle rect) {
        return this.image.getData(rect);
    }

    public WritableRaster copyData(WritableRaster raster) {
        return this.image.copyData(raster);
    }
}

