_geomesa-arrow(){
  local cur prev;
  COMPREPLY=();
  cur="${COMP_WORDS[COMP_CWORD]}";
  prev="${COMP_WORDS[COMP_CWORD-1]}";

  if [[ "${COMP_WORDS[1]}" == "help" ]]; then
    COMPREPLY=( $(compgen -W "describe-schema env export help ingest get-type-names version get-sft-config gen-avro-schema stats-bounds stats-count stats-top-k stats-histogram convert configure classpath scala-console" ${cur}));
    return 0;
  fi;

  case ${COMP_CWORD} in
    1)
      COMPREPLY=( $(compgen -W "describe-schema env export help ingest get-type-names version get-sft-config gen-avro-schema stats-bounds stats-count stats-top-k stats-histogram convert configure classpath scala-console" ${cur}));
      ;;
    [2-9] | [1-9][0-9])
      if [[ "${cur}" =~ ^-[a-zA-Z-]?+$ ]]; then
        case ${COMP_WORDS[1]} in
                    describe-schema)
              COMPREPLY=( $(compgen -W "--url --show-dictionaries" -- ${cur}));
              return 0;
              ;;
                  env)
              COMPREPLY=( $(compgen -W "--concise --converters --list-sfts --describe-sfts --exclude-user-data --format --sfts --list-converters --describe-converters" -- ${cur}));
              return 0;
              ;;
                  export)
              COMPREPLY=( $(compgen -W "--gzip --cql --url --output-format --no-header --attributes --max-features --hints --output" -- ${cur}));
              return 0;
              ;;
                  help)
              COMPREPLY=( $(compgen -W "" -- ${cur}));
              return 0;
              ;;
                  ingest)
              COMPREPLY=( $(compgen -W "--threads --converter --split-max-size --url --src-list --run-mode --input-format --feature-name --force --spec --no-tracking" -- ${cur}));
              return 0;
              ;;
                  get-type-names)
              COMPREPLY=( $(compgen -W "--url" -- ${cur}));
              return 0;
              ;;
                  version)
              COMPREPLY=( $(compgen -W "" -- ${cur}));
              return 0;
              ;;
                  get-sft-config)
              COMPREPLY=( $(compgen -W "--concise --format --url --exclude-user-data --feature-name" -- ${cur}));
              return 0;
              ;;
                  gen-avro-schema)
              COMPREPLY=( $(compgen -W "--feature-name --spec" -- ${cur}));
              return 0;
              ;;
                  stats-bounds)
              COMPREPLY=( $(compgen -W "--no-cache --cql --attributes --url --feature-name" -- ${cur}));
              return 0;
              ;;
                  stats-count)
              COMPREPLY=( $(compgen -W "--url --no-cache --cql --feature-name" -- ${cur}));
              return 0;
              ;;
                  stats-top-k)
              COMPREPLY=( $(compgen -W "--cql --url --feature-name --attributes --no-cache" -- ${cur}));
              return 0;
              ;;
                  stats-histogram)
              COMPREPLY=( $(compgen -W "--no-cache --attributes --feature-name --cql --url --bins" -- ${cur}));
              return 0;
              ;;
                  convert)
              COMPREPLY=( $(compgen -W "--max-features --cql --output-format --no-header --converter --output --gzip --feature-name --spec --hints" -- ${cur}));
              return 0;
              ;;
                  configure)
              COMPREPLY=( $(compgen -W "" -- ${cur}));
              return 0;
              ;;
                  classpath)
              COMPREPLY=( $(compgen -W "" -- ${cur}));
              return 0;
              ;;
                  scala-console)
              COMPREPLY=( $(compgen -W "" -- ${cur}));
              return 0;
              ;;
              esac;
      else
        compopt -o filenames -o nospace;
        COMPREPLY=( $(compgen -f "$2") );
      fi;
      return 0;
      ;;
    *)
      COMPREPLY=();
      ;;
  esac;
};
complete -F _geomesa-arrow geomesa-arrow;
complete -F _geomesa-arrow bin/geomesa-arrow;


       