/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.crs;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.renderer.crs.OffsetOrdinateFilter;
import org.geotools.renderer.crs.ProjectionHandler;
import org.geotools.renderer.crs.WrappingCoordinateFilter;
import org.locationtech.jts.geom.CoordinateSequenceFilter;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryComponentFilter;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;

public class WrappingProjectionHandler
extends ProjectionHandler {
    private int maxWraps;
    private boolean datelineWrappingCheckEnabled = true;

    public WrappingProjectionHandler(ReferencedEnvelope renderingEnvelope, ReferencedEnvelope validArea, CoordinateReferenceSystem sourceCrs, double centralMeridian, int maxWraps) throws FactoryException {
        super(sourceCrs, validArea, renderingEnvelope);
        this.maxWraps = maxWraps;
        this.queryAcrossDateline = true;
        this.setCentralMeridian(centralMeridian);
    }

    @Override
    public Geometry postProcess(MathTransform mt, Geometry geometry) {
        double highLimit;
        double lowLimit;
        double curr;
        double base;
        double reWidth;
        double width;
        boolean northEast;
        Envelope env = geometry.getEnvelopeInternal();
        boolean bl = northEast = CRS.getAxisOrder(this.targetCRS) == CRS.AxisOrder.NORTH_EAST;
        if (northEast) {
            width = env.getHeight();
            reWidth = this.renderingEnvelope.getHeight();
        } else {
            width = env.getWidth();
            reWidth = this.renderingEnvelope.getWidth();
        }
        if (width < this.radius && this.renderingEnvelope.contains(env) && reWidth <= this.radius * 2.0) {
            return geometry;
        }
        if (this.datelineWrappingCheckEnabled && width > this.radius && width < this.radius * 2.0) {
            Geometry wrapped = geometry.copy();
            wrapped.apply((GeometryComponentFilter)new WrappingCoordinateFilter(this.radius, this.radius * 2.0, mt, northEast));
            wrapped.geometryChanged();
            geometry = wrapped;
            env = geometry.getEnvelopeInternal();
        }
        ArrayList<Geometry> geoms = new ArrayList<Geometry>();
        Class geomType = null;
        if (northEast) {
            base = env.getMinY();
            curr = env.getMinY();
            lowLimit = Math.max(this.renderingEnvelope.getMinY(), this.renderingEnvelope.getMedian(1) - (double)this.maxWraps * this.radius * 2.0);
            highLimit = Math.min(this.renderingEnvelope.getMaxY(), this.renderingEnvelope.getMedian(1) + (double)this.maxWraps * this.radius * 2.0);
        } else {
            base = env.getMinX();
            curr = env.getMinX();
            double geometryWidth = geometry.getEnvelopeInternal().getWidth();
            lowLimit = Math.max(this.renderingEnvelope.getMinX() - geometryWidth, this.renderingEnvelope.getMedian(0) - (double)this.maxWraps * this.radius * 2.0);
            highLimit = Math.min(this.renderingEnvelope.getMaxX() + geometryWidth, this.renderingEnvelope.getMedian(0) + (double)this.maxWraps * this.radius * 2.0);
        }
        while (curr > lowLimit) {
            curr -= this.radius * 2.0;
        }
        geomType = this.accumulate(geoms, geometry, geomType);
        while (curr <= highLimit) {
            double offset = curr - base;
            if (!(Math.abs(offset) < this.radius)) {
                Geometry offseted = geometry.copy();
                offseted.apply((CoordinateSequenceFilter)new OffsetOrdinateFilter(northEast ? 1 : 0, offset));
                offseted.geometryChanged();
                geomType = this.accumulate(geoms, offseted, geomType);
            }
            curr += this.radius * 2.0;
        }
        if (geomType == null) {
            return null;
        }
        if (geoms.size() == 1) {
            return (Geometry)geoms.get(0);
        }
        if (Point.class.equals((Object)geomType)) {
            Point[] points = geoms.toArray(new Point[geoms.size()]);
            return geometry.getFactory().createMultiPoint(points);
        }
        if (LineString.class.isAssignableFrom(geomType)) {
            LineString[] lines = geoms.toArray(new LineString[geoms.size()]);
            return geometry.getFactory().createMultiLineString(lines);
        }
        if (Polygon.class.equals((Object)geomType)) {
            Polygon[] polys = geoms.toArray(new Polygon[geoms.size()]);
            return geometry.getFactory().createMultiPolygon(polys);
        }
        return geometry.getFactory().createGeometryCollection(geoms.toArray(new Geometry[geoms.size()]));
    }

    private boolean isUnwrapped(final Geometry geometry) {
        if (geometry instanceof GeometryCollection) {
            final AtomicBoolean unwrapped = new AtomicBoolean(true);
            geometry.apply(new GeometryComponentFilter(){

                public void filter(Geometry geom) {
                    if (geom != geometry && geom.getEnvelopeInternal().getWidth() > WrappingProjectionHandler.this.radius) {
                        unwrapped.set(false);
                    }
                }
            });
            return unwrapped.get();
        }
        return geometry.getEnvelopeInternal().getWidth() <= this.radius;
    }

    private Class accumulate(List<Geometry> geoms, Geometry geometry, Class geomType) {
        for (int i = 0; i < geometry.getNumGeometries(); ++i) {
            Geometry g = geometry.getGeometryN(i);
            Class<?> gtype = null;
            if (g instanceof GeometryCollection) {
                gtype = this.accumulate(geoms, g, geomType);
            } else if (this.renderingEnvelope.intersects(g.getEnvelopeInternal())) {
                geoms.add(g);
                gtype = g.getClass();
            }
            if (geomType == null) {
                geomType = g.getClass();
                continue;
            }
            if (g.getClass().equals(geomType)) continue;
            geomType = Geometry.class;
        }
        return geomType;
    }

    @Override
    public boolean requiresProcessing(Geometry geometry) {
        return true;
    }

    public boolean isDatelineWrappingCheckEnabled() {
        return this.datelineWrappingCheckEnabled;
    }

    public void setDatelineWrappingCheckEnabled(boolean datelineWrappingCheckEnabled) {
        this.datelineWrappingCheckEnabled = datelineWrappingCheckEnabled;
    }
}

