/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.index.geotools;

import com.github.benmanes.caffeine.cache.AsyncLoadingCache;
import com.github.benmanes.caffeine.cache.CacheLoader;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.util.concurrent.TimeUnit;
import org.locationtech.geomesa.index.api.WrappedFeature;
import org.locationtech.geomesa.index.conf.SchemaProperties$;
import org.locationtech.geomesa.index.geotools.GeoMesaDataStore;
import org.locationtech.geomesa.utils.conf.SemanticVersion;
import org.locationtech.geomesa.utils.conf.SemanticVersion$;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.mutable.StringBuilder;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.Right;

public final class GeoMesaDataStore$
implements LazyLogging {
    public static final GeoMesaDataStore$ MODULE$;
    private final Object loader;
    private final AsyncLoadingCache<GeoMesaDataStore.VersionKey<?, ?, ?>, Either<Exception, Option<SemanticVersion>>> org$locationtech$geomesa$index$geotools$GeoMesaDataStore$$versions;
    private final Logger logger;
    private volatile boolean bitmap$0;

    static {
        new GeoMesaDataStore$();
    }

    private Logger logger$lzycompute() {
        GeoMesaDataStore$ geoMesaDataStore$ = this;
        synchronized (geoMesaDataStore$) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    private Object loader() {
        return this.loader;
    }

    public AsyncLoadingCache<GeoMesaDataStore.VersionKey<?, ?, ?>, Either<Exception, Option<SemanticVersion>>> org$locationtech$geomesa$index$geotools$GeoMesaDataStore$$versions() {
        return this.org$locationtech$geomesa$index$geotools$GeoMesaDataStore$$versions;
    }

    public <DS extends GeoMesaDataStore<DS, F, W>, F extends WrappedFeature, W> void initRemoteVersion(GeoMesaDataStore<DS, F, W> ds) {
        if (ds.getTypeNames().length > 0) {
            this.org$locationtech$geomesa$index$geotools$GeoMesaDataStore$$versions().get(new GeoMesaDataStore.VersionKey<DS, F, W>(ds));
        }
    }

    private GeoMesaDataStore$() {
        MODULE$ = this;
        LazyLogging.class.$init$((LazyLogging)this);
        this.loader = new CacheLoader<GeoMesaDataStore.VersionKey<?, ?, ?>, Either<Exception, Option<SemanticVersion>>>(){

            public Either<Exception, Option<SemanticVersion>> load(GeoMesaDataStore.VersionKey<?, ?, ?> key) {
                Right right;
                if (key.ds().getTypeNames().length == 0) {
                    throw new RuntimeException("Can't load remote versions if there are no feature types");
                }
                if (SchemaProperties$.MODULE$.CheckDistributedVersion().toBoolean().contains((Object)BoxesRunTime.boxToBoolean((boolean)true))) {
                    SemanticVersion clientVersion = key.ds().getClientVersion();
                    Set iterVersions = (Set)key.ds().loadIteratorVersions().map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final SemanticVersion apply(String v) {
                            return SemanticVersion$.MODULE$.apply(v, true);
                        }
                    }, Set$.MODULE$.canBuildFrom());
                    Option version = iterVersions.reduceLeftOption((Function2)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final SemanticVersion apply(SemanticVersion left, SemanticVersion right) {
                            return right.$greater((Object)left) ? right : left;
                        }
                    });
                    if (iterVersions.exists((Function1)new Serializable(this, clientVersion){
                        public static final long serialVersionUID = 0L;
                        private final SemanticVersion clientVersion$1;

                        public final boolean apply(SemanticVersion x$10) {
                            return SemanticVersion.MinorOrdering$.MODULE$.compare(x$10, this.clientVersion$1) != 0;
                        }
                        {
                            this.clientVersion$1 = clientVersion$1;
                        }
                    })) {
                        right = package$.MODULE$.Left().apply((Object)new RuntimeException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ". You may override this check by setting the system property "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.message$1(clientVersion, iterVersions)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"'-D", "=false'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{SchemaProperties$.MODULE$.CheckDistributedVersion().property()}))).toString()));
                    } else {
                        BoxedUnit boxedUnit;
                        if (iterVersions.exists((Function1)new Serializable(this, clientVersion){
                            public static final long serialVersionUID = 0L;
                            private final SemanticVersion clientVersion$1;

                            public final boolean apply(SemanticVersion x$11) {
                                SemanticVersion semanticVersion = x$11;
                                SemanticVersion semanticVersion2 = this.clientVersion$1;
                                return semanticVersion != null ? !semanticVersion.equals(semanticVersion2) : semanticVersion2 != null;
                            }
                            {
                                this.clientVersion$1 = clientVersion$1;
                            }
                        })) {
                            if (GeoMesaDataStore$.MODULE$.logger().underlying().isWarnEnabled()) {
                                GeoMesaDataStore$.MODULE$.logger().underlying().warn(this.message$1(clientVersion, iterVersions));
                                boxedUnit = BoxedUnit.UNIT;
                            } else {
                                boxedUnit = BoxedUnit.UNIT;
                            }
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        right = package$.MODULE$.Right().apply((Object)version);
                    }
                } else {
                    right = package$.MODULE$.Right().apply((Object)None$.MODULE$);
                }
                return right;
            }

            private final String message$1(SemanticVersion clientVersion$1, Set iterVersions$1) {
                return new StringBuilder().append((Object)"Classpath errors detected: configured server-side iterators do not match ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"client version. Client version: ", ", server versions: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{clientVersion$1, iterVersions$1.mkString(", ")}))).toString();
            }
        };
        this.org$locationtech$geomesa$index$geotools$GeoMesaDataStore$$versions = Caffeine.newBuilder().refreshAfterWrite(1L, TimeUnit.DAYS).buildAsync(this.loader());
    }
}

