/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.index.index.z3;

import java.time.ZonedDateTime;
import java.util.Date;
import org.geotools.factory.Hints;
import org.locationtech.geomesa.curve.BinnedTime;
import org.locationtech.geomesa.curve.BinnedTime$;
import org.locationtech.geomesa.curve.XZ3SFC;
import org.locationtech.geomesa.curve.XZ3SFC$;
import org.locationtech.geomesa.filter.Bounds;
import org.locationtech.geomesa.filter.FilterHelper$;
import org.locationtech.geomesa.filter.FilterValues;
import org.locationtech.geomesa.filter.FilterValues$;
import org.locationtech.geomesa.index.conf.QueryProperties$;
import org.locationtech.geomesa.index.index.IndexKeySpace;
import org.locationtech.geomesa.index.index.IndexKeySpace$ByteRange$;
import org.locationtech.geomesa.index.index.z3.XZ3IndexKeySpace;
import org.locationtech.geomesa.index.index.z3.XZ3IndexKeySpace$;
import org.locationtech.geomesa.index.index.z3.XZ3IndexValues;
import org.locationtech.geomesa.index.index.z3.Z3IndexKey;
import org.locationtech.geomesa.index.utils.Explainer;
import org.locationtech.geomesa.utils.geotools.GeometryUtils$;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType$;
import org.locationtech.geomesa.utils.index.ByteArrays$;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.sfcurve.IndexRange;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple4;
import scala.Tuple6;
import scala.collection.GenTraversable;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Builder;
import scala.collection.mutable.Map$;
import scala.math.Numeric;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;
import scala.runtime.VolatileByteRef;
import scala.util.control.NonFatal$;

public abstract class XZ3IndexKeySpace$class {
    public static boolean supports(XZ3IndexKeySpace $this, SimpleFeatureType sft) {
        return RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getDtgField$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft)).isDefined() && RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.nonPoints$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft));
    }

    public static Function1 toIndexKey(XZ3IndexKeySpace $this, SimpleFeatureType sft, boolean lenient) {
        XZ3SFC sfc = XZ3SFC$.MODULE$.apply(RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getXZPrecision$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft)), RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getZ3Interval$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft)));
        int geomIndex = sft.indexOf(sft.getGeometryDescriptor().getLocalName());
        int dtgIndex = BoxesRunTime.unboxToInt((Object)RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getDtgIndex$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft)).getOrElse((Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final Nothing$ apply() {
                throw new IllegalStateException("XZ3 index requires a valid date");
            }
        }));
        Function1 timeToIndex = BinnedTime$.MODULE$.timeToBinnedTime(RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getZ3Interval$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft)));
        return new Serializable($this, sfc, geomIndex, dtgIndex, timeToIndex, lenient){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ XZ3IndexKeySpace $outer;
            private final XZ3SFC sfc$1;
            private final int geomIndex$1;
            private final int dtgIndex$1;
            private final Function1 timeToIndex$1;
            private final boolean lenient$1;

            public final Seq<Z3IndexKey> apply(SimpleFeature feature) {
                return XZ3IndexKeySpace$class.org$locationtech$geomesa$index$index$z3$XZ3IndexKeySpace$$getZValue(this.$outer, this.sfc$1, this.geomIndex$1, this.dtgIndex$1, this.timeToIndex$1, this.lenient$1, feature);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.sfc$1 = sfc$1;
                this.geomIndex$1 = geomIndex$1;
                this.dtgIndex$1 = dtgIndex$1;
                this.timeToIndex$1 = timeToIndex$1;
                this.lenient$1 = lenient$1;
            }
        };
    }

    public static Function3 toIndexKeyBytes(XZ3IndexKeySpace $this, SimpleFeatureType sft, boolean lenient) {
        XZ3SFC sfc = XZ3SFC$.MODULE$.apply(RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getXZPrecision$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft)), RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getZ3Interval$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft)));
        int geomIndex = sft.indexOf(sft.getGeometryDescriptor().getLocalName());
        int dtgIndex = BoxesRunTime.unboxToInt((Object)RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getDtgIndex$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft)).getOrElse((Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final Nothing$ apply() {
                throw new IllegalStateException("XZ3 index requires a valid date");
            }
        }));
        Function1 timeToIndex = BinnedTime$.MODULE$.timeToBinnedTime(RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getZ3Interval$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft)));
        return new Serializable($this, sfc, geomIndex, dtgIndex, timeToIndex, lenient){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ XZ3IndexKeySpace $outer;
            private final XZ3SFC sfc$2;
            private final int geomIndex$2;
            private final int dtgIndex$2;
            private final Function1 timeToIndex$2;
            private final boolean lenient$2;

            public final Seq<byte[]> apply(Seq<byte[]> prefix, SimpleFeature feature, byte[] suffix) {
                return XZ3IndexKeySpace$class.org$locationtech$geomesa$index$index$z3$XZ3IndexKeySpace$$getZValueBytes(this.$outer, this.sfc$2, this.geomIndex$2, this.dtgIndex$2, this.timeToIndex$2, this.lenient$2, prefix, feature, suffix);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.sfc$2 = sfc$2;
                this.geomIndex$2 = geomIndex$2;
                this.dtgIndex$2 = dtgIndex$2;
                this.timeToIndex$2 = timeToIndex$2;
                this.lenient$2 = lenient$2;
            }
        };
    }

    public static XZ3IndexValues getIndexValues(XZ3IndexKeySpace $this, SimpleFeatureType sft, Filter filter2, Explainer explain) {
        String dtgField = (String)RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getDtgField$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft)).getOrElse((Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final Nothing$ apply() {
                throw new RuntimeException("Trying to execute an xz3 query but the schema does not have a date");
            }
        });
        XZ3SFC sfc = XZ3SFC$.MODULE$.apply(RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getXZPrecision$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft)), RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getZ3Interval$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft)));
        FilterValues extracted = FilterHelper$.MODULE$.extractGeometries(filter2, RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getGeomField$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft)), RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.isPoints$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft)));
        FilterValues geometries = extracted.nonEmpty() ? extracted : new FilterValues((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Polygon[]{org.locationtech.geomesa.utils.geotools.package$.MODULE$.WholeWorldPolygon()})), FilterValues$.MODULE$.apply$default$2(), FilterValues$.MODULE$.apply$default$3());
        Filter x$9 = filter2;
        String x$10 = dtgField;
        boolean x$11 = true;
        boolean x$12 = FilterHelper$.MODULE$.extractIntervals$default$3();
        FilterValues intervals = FilterHelper$.MODULE$.extractIntervals(x$9, x$10, x$12, x$11);
        explain.apply((Function0<String>)new Serializable($this, geometries){
            public static final long serialVersionUID = 0L;
            private final FilterValues geometries$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Geometries: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.geometries$1}));
            }
            {
                this.geometries$1 = geometries$1;
            }
        });
        explain.apply((Function0<String>)new Serializable($this, intervals){
            public static final long serialVersionUID = 0L;
            private final FilterValues intervals$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Intervals: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.intervals$1}));
            }
            {
                this.intervals$1 = intervals$1;
            }
        });
        if (intervals.disjoint()) {
            explain.apply((Function0<String>)new Serializable($this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Disjoint dates extracted, short-circuiting to empty query";
                }
            });
            return new XZ3IndexValues(sfc, (FilterValues<Geometry>)FilterValues$.MODULE$.empty(), (Seq<Tuple4<Object, Object, Object, Object>>)((Seq)Seq$.MODULE$.empty()), (FilterValues<Bounds<ZonedDateTime>>)FilterValues$.MODULE$.empty(), (Map<Object, Tuple2<Object, Object>>)Predef$.MODULE$.Map().empty(), (Seq<Tuple2<Object, Object>>)((Seq)Seq$.MODULE$.empty()));
        }
        int multiplier = BoxesRunTime.unboxToInt((Object)QueryProperties$.MODULE$.PolygonDecompMultiplier().toInt().get());
        int bits = BoxesRunTime.unboxToInt((Object)QueryProperties$.MODULE$.PolygonDecompBits().toInt().get());
        Seq xy = (Seq)geometries.values().flatMap((Function1)new Serializable($this, multiplier, bits){
            public static final long serialVersionUID = 0L;
            private final int multiplier$1;
            private final int bits$1;

            public final Seq<Tuple4<Object, Object, Object, Object>> apply(Geometry x$1) {
                return GeometryUtils$.MODULE$.bounds(x$1, this.multiplier$1, this.bits$1);
            }
            {
                this.multiplier$1 = multiplier$1;
                this.bits$1 = bits$1;
            }
        }, Seq$.MODULE$.canBuildFrom());
        scala.collection.mutable.Map timesByBin = Map$.MODULE$.empty();
        Builder unboundedBins = Seq$.MODULE$.newBuilder();
        Function1 dateToIndex = BinnedTime$.MODULE$.dateToBinnedTime(RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getZ3Interval$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft)));
        Function1 boundsToDates = BinnedTime$.MODULE$.boundsToIndexableDates(RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getZ3Interval$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft)));
        intervals.foreach((Function1)new Serializable($this, sfc, timesByBin, unboundedBins, dateToIndex, boundsToDates){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ XZ3IndexKeySpace $outer;
            public final XZ3SFC sfc$3;
            public final scala.collection.mutable.Map timesByBin$1;
            private final Builder unboundedBins$1;
            private final Function1 dateToIndex$1;
            private final Function1 boundsToDates$1;

            public final Object apply(Bounds<ZonedDateTime> interval) {
                Tuple2 tuple2 = (Tuple2)this.boundsToDates$1.apply((Object)interval.bounds());
                if (tuple2 != null) {
                    Tuple2 tuple22;
                    ZonedDateTime lower = (ZonedDateTime)tuple2._1();
                    ZonedDateTime upper = (ZonedDateTime)tuple2._2();
                    Tuple2 tuple23 = tuple22 = new Tuple2((Object)lower, (Object)upper);
                    ZonedDateTime lower2 = (ZonedDateTime)tuple23._1();
                    ZonedDateTime upper2 = (ZonedDateTime)tuple23._2();
                    BinnedTime binnedTime = (BinnedTime)this.dateToIndex$1.apply((Object)lower2);
                    if (binnedTime != null) {
                        Tuple2 tuple24;
                        short lb = binnedTime.bin();
                        long lt = binnedTime.offset();
                        Tuple2 tuple25 = tuple24 = new Tuple2((Object)BoxesRunTime.boxToShort((short)lb), (Object)BoxesRunTime.boxToLong((long)lt));
                        short lb2 = BoxesRunTime.unboxToShort((Object)tuple25._1());
                        long lt2 = tuple25._2$mcJ$sp();
                        BinnedTime binnedTime2 = (BinnedTime)this.dateToIndex$1.apply((Object)upper2);
                        if (binnedTime2 != null) {
                            BoxedUnit boxedUnit;
                            Tuple2 tuple26;
                            short ub = binnedTime2.bin();
                            long ut = binnedTime2.offset();
                            Tuple2 tuple27 = tuple26 = new Tuple2((Object)BoxesRunTime.boxToShort((short)ub), (Object)BoxesRunTime.boxToLong((long)ut));
                            short ub2 = BoxesRunTime.unboxToShort((Object)tuple27._1());
                            long ut2 = tuple27._2$mcJ$sp();
                            if (interval.isBoundedBothSides()) {
                                if (lb2 == ub2) {
                                    XZ3IndexKeySpace$class.updateTime$1(this.$outer, lb2, lt2, ut2, this.timesByBin$1);
                                    boxedUnit = BoxedUnit.UNIT;
                                } else {
                                    XZ3IndexKeySpace$class.updateTime$1(this.$outer, lb2, lt2, this.sfc$3.zBounds()._2$mcD$sp(), this.timesByBin$1);
                                    XZ3IndexKeySpace$class.updateTime$1(this.$outer, ub2, this.sfc$3.zBounds()._1$mcD$sp(), ut2, this.timesByBin$1);
                                    package$.MODULE$.Range().inclusive(lb2 + 1, ub2 - 1).foreach$mVc$sp((Function1)new Serializable(this){
                                        public static final long serialVersionUID = 0L;
                                        private final /* synthetic */ XZ3IndexKeySpace$.anonfun.getIndexValues.4 $outer;

                                        public final void apply(int b) {
                                            this.apply$mcVI$sp(b);
                                        }

                                        public void apply$mcVI$sp(int b) {
                                            this.$outer.timesByBin$1.update((Object)BoxesRunTime.boxToShort((short)((short)b)), (Object)this.$outer.sfc$3.zBounds());
                                        }
                                        {
                                            if ($outer == null) {
                                                throw null;
                                            }
                                            this.$outer = $outer;
                                        }
                                    });
                                    boxedUnit = BoxedUnit.UNIT;
                                }
                            } else if (interval.lower().value().isDefined()) {
                                XZ3IndexKeySpace$class.updateTime$1(this.$outer, lb2, lt2, this.sfc$3.zBounds()._2$mcD$sp(), this.timesByBin$1);
                                boxedUnit = this.unboundedBins$1.$plus$eq((Object)new Tuple2((Object)BoxesRunTime.boxToShort((short)((short)(lb2 + 1))), (Object)BoxesRunTime.boxToShort((short)Short.MAX_VALUE)));
                            } else if (interval.upper().value().isDefined()) {
                                XZ3IndexKeySpace$class.updateTime$1(this.$outer, ub2, this.sfc$3.zBounds()._1$mcD$sp(), ut2, this.timesByBin$1);
                                boxedUnit = this.unboundedBins$1.$plus$eq((Object)new Tuple2((Object)BoxesRunTime.boxToShort((short)0), (Object)BoxesRunTime.boxToShort((short)((short)(ub2 - 1)))));
                            } else {
                                boxedUnit = BoxedUnit.UNIT;
                            }
                            return boxedUnit;
                        }
                        throw new MatchError((Object)binnedTime2);
                    }
                    throw new MatchError((Object)binnedTime);
                }
                throw new MatchError((Object)tuple2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.sfc$3 = sfc$3;
                this.timesByBin$1 = timesByBin$1;
                this.unboundedBins$1 = unboundedBins$1;
                this.dateToIndex$1 = dateToIndex$1;
                this.boundsToDates$1 = boundsToDates$1;
            }
        });
        return new XZ3IndexValues(sfc, (FilterValues<Geometry>)geometries, (Seq<Tuple4<Object, Object, Object, Object>>)xy, (FilterValues<Bounds<ZonedDateTime>>)intervals, (Map<Object, Tuple2<Object, Object>>)timesByBin.toMap(Predef$.MODULE$.$conforms()), (Seq<Tuple2<Object, Object>>)((Seq)unboundedBins.result()));
    }

    public static Iterator getRanges(XZ3IndexKeySpace $this, XZ3IndexValues values, int multiplier) {
        ObjectRef wholePeriodRanges$lzy = ObjectRef.zero();
        VolatileByteRef bitmap$0 = VolatileByteRef.create((byte)0);
        XZ3IndexValues xZ3IndexValues = values;
        if (xZ3IndexValues != null) {
            Tuple4 tuple4;
            XZ3SFC sfc = xZ3IndexValues.sfc();
            Seq<Tuple4<Object, Object, Object, Object>> xy = xZ3IndexValues.spatialBounds();
            Map<Object, Tuple2<Object, Object>> timesByBin = xZ3IndexValues.temporalBounds();
            Seq<Tuple2<Object, Object>> unboundedBins = xZ3IndexValues.temporalUnbounded();
            Tuple4 tuple42 = tuple4 = new Tuple4((Object)sfc, xy, timesByBin, unboundedBins);
            XZ3SFC sfc2 = (XZ3SFC)tuple42._1();
            Seq xy2 = (Seq)tuple42._2();
            Map timesByBin2 = (Map)tuple42._3();
            Seq unboundedBins2 = (Seq)tuple42._4();
            Option target = QueryProperties$.MODULE$.ScanRangesTarget().option().map((Function1)new Serializable($this, timesByBin2, multiplier){
                public static final long serialVersionUID = 0L;
                private final Map timesByBin$2;
                private final int multiplier$2;

                public final int apply(String t) {
                    return scala.math.package$.MODULE$.max(1, this.timesByBin$2.isEmpty() ? new StringOps(Predef$.MODULE$.augmentString(t)).toInt() : new StringOps(Predef$.MODULE$.augmentString(t)).toInt() / this.timesByBin$2.size() / this.multiplier$2);
                }
                {
                    this.timesByBin$2 = timesByBin$2;
                    this.multiplier$2 = multiplier$2;
                }
            });
            Iterator bounded = timesByBin2.iterator().flatMap((Function1)new Serializable($this, sfc2, xy2, target, wholePeriodRanges$lzy, bitmap$0){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ XZ3IndexKeySpace $outer;
                private final XZ3SFC sfc$4;
                private final Seq xy$1;
                private final Option target$1;
                private final ObjectRef wholePeriodRanges$lzy$1;
                private final VolatileByteRef bitmap$0$1;

                public final Seq<IndexKeySpace.BoundedRange<Z3IndexKey>> apply(Tuple2<Object, Tuple2<Object, Object>> x0$2) {
                    Tuple2<Object, Tuple2<Object, Object>> tuple2 = x0$2;
                    if (tuple2 != null) {
                        short bin = BoxesRunTime.unboxToShort((Object)tuple2._1());
                        Tuple2 times = (Tuple2)tuple2._2();
                        Seq zs = times == this.sfc$4.zBounds() ? XZ3IndexKeySpace$class.wholePeriodRanges$1(this.$outer, this.sfc$4, this.xy$1, this.target$1, this.wholePeriodRanges$lzy$1, this.bitmap$0$1) : XZ3IndexKeySpace$class.toZRanges$1(this.$outer, times, this.sfc$4, this.xy$1, this.target$1);
                        Seq seq = (Seq)zs.map((Function1)new Serializable(this, bin){
                            public static final long serialVersionUID = 0L;
                            private final short bin$1;

                            public final IndexKeySpace.BoundedRange<Z3IndexKey> apply(IndexRange r) {
                                return new IndexKeySpace.BoundedRange<Z3IndexKey>(new Z3IndexKey(this.bin$1, r.lower()), new Z3IndexKey(this.bin$1, r.upper()));
                            }
                            {
                                this.bin$1 = bin$1;
                            }
                        }, Seq$.MODULE$.canBuildFrom());
                        return seq;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.sfc$4 = sfc$4;
                    this.xy$1 = xy$1;
                    this.target$1 = target$1;
                    this.wholePeriodRanges$lzy$1 = wholePeriodRanges$lzy$1;
                    this.bitmap$0$1 = bitmap$0$1;
                }
            });
            Iterator unbounded = unboundedBins2.iterator().map((Function1)new Serializable($this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ XZ3IndexKeySpace $outer;

                public final Product apply(Tuple2<Object, Object> x0$3) {
                    Tuple2<Object, Object> tuple2;
                    block8: {
                        IndexKeySpace.ScanRange<Z3IndexKey> scanRange;
                        block6: {
                            BoxedUnit boxedUnit;
                            block7: {
                                block5: {
                                    tuple2 = x0$3;
                                    if (tuple2 == null) break block5;
                                    short lower = BoxesRunTime.unboxToShort((Object)tuple2._1());
                                    short s = BoxesRunTime.unboxToShort((Object)tuple2._2());
                                    if (Short.MAX_VALUE != s) break block5;
                                    scanRange = new IndexKeySpace.LowerBoundedRange<Z3IndexKey>(new Z3IndexKey(lower, 0L));
                                    break block6;
                                }
                                if (tuple2 == null) break block7;
                                short s = BoxesRunTime.unboxToShort((Object)tuple2._1());
                                short upper = BoxesRunTime.unboxToShort((Object)tuple2._2());
                                if (0 != s) break block7;
                                scanRange = new IndexKeySpace.UpperBoundedRange<Z3IndexKey>(new Z3IndexKey(upper, Long.MAX_VALUE));
                                break block6;
                            }
                            if (tuple2 == null) break block8;
                            short lower = BoxesRunTime.unboxToShort((Object)tuple2._1());
                            short upper = BoxesRunTime.unboxToShort((Object)tuple2._2());
                            if (this.$outer.logger().underlying().isErrorEnabled()) {
                                this.$outer.logger().underlying().error("Unexpected unbounded bin endpoints: {}:{}", new Object[]{BoxesRunTime.boxToShort((short)lower), BoxesRunTime.boxToShort((short)upper)});
                                boxedUnit = BoxedUnit.UNIT;
                            } else {
                                boxedUnit = BoxedUnit.UNIT;
                            }
                            scanRange = new IndexKeySpace.UnboundedRange<Z3IndexKey>(new Z3IndexKey(0, 0L));
                        }
                        return scanRange;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
            return bounded.$plus$plus((Function0)new Serializable($this, unbounded){
                public static final long serialVersionUID = 0L;
                private final Iterator unbounded$1;

                public final Iterator<Product> apply() {
                    return this.unbounded$1;
                }
                {
                    this.unbounded$1 = unbounded$1;
                }
            });
        }
        throw new MatchError((Object)xZ3IndexValues);
    }

    public static Iterator getRangeBytes(XZ3IndexKeySpace $this, Iterator ranges, Seq prefixes, boolean tier) {
        return prefixes.isEmpty() ? ranges.map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final IndexKeySpace.ByteRange apply(IndexKeySpace.ScanRange<Z3IndexKey> x0$4) {
                IndexKeySpace.ScanRange<Z3IndexKey> scanRange;
                block6: {
                    IndexKeySpace.BoundedByteRange boundedByteRange;
                    block3: {
                        block5: {
                            block4: {
                                block2: {
                                    scanRange = x0$4;
                                    if (!(scanRange instanceof IndexKeySpace.BoundedRange)) break block2;
                                    IndexKeySpace.BoundedRange boundedRange = (IndexKeySpace.BoundedRange)scanRange;
                                    Z3IndexKey lo = (Z3IndexKey)boundedRange.lower();
                                    Z3IndexKey hi = (Z3IndexKey)boundedRange.upper();
                                    boundedByteRange = new IndexKeySpace.BoundedByteRange(ByteArrays$.MODULE$.toBytes(lo.bin(), lo.z()), ByteArrays$.MODULE$.toBytesFollowingPrefix(hi.bin(), hi.z()));
                                    break block3;
                                }
                                if (!(scanRange instanceof IndexKeySpace.LowerBoundedRange)) break block4;
                                IndexKeySpace.LowerBoundedRange lowerBoundedRange = (IndexKeySpace.LowerBoundedRange)scanRange;
                                Z3IndexKey lo = (Z3IndexKey)lowerBoundedRange.lower();
                                boundedByteRange = new IndexKeySpace.BoundedByteRange(ByteArrays$.MODULE$.toBytes(lo.bin(), lo.z()), IndexKeySpace$ByteRange$.MODULE$.UnboundedUpperRange());
                                break block3;
                            }
                            if (!(scanRange instanceof IndexKeySpace.UpperBoundedRange)) break block5;
                            IndexKeySpace.UpperBoundedRange upperBoundedRange = (IndexKeySpace.UpperBoundedRange)scanRange;
                            Z3IndexKey hi = (Z3IndexKey)upperBoundedRange.upper();
                            boundedByteRange = new IndexKeySpace.BoundedByteRange(IndexKeySpace$ByteRange$.MODULE$.UnboundedLowerRange(), ByteArrays$.MODULE$.toBytesFollowingPrefix(hi.bin(), hi.z()));
                            break block3;
                        }
                        if (!(scanRange instanceof IndexKeySpace.UnboundedRange)) break block6;
                        boundedByteRange = new IndexKeySpace.BoundedByteRange(IndexKeySpace$ByteRange$.MODULE$.UnboundedLowerRange(), IndexKeySpace$ByteRange$.MODULE$.UnboundedUpperRange());
                    }
                    return boundedByteRange;
                }
                throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unexpected range type ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{scanRange})));
            }
        }) : ranges.flatMap((Function1)new Serializable($this, prefixes){
            public static final long serialVersionUID = 0L;
            private final Seq prefixes$1;

            public final GenTraversableOnce<IndexKeySpace.ByteRange> apply(IndexKeySpace.ScanRange<Z3IndexKey> x0$5) {
                IndexKeySpace.ScanRange<Z3IndexKey> scanRange;
                block6: {
                    GenTraversable genTraversable;
                    block3: {
                        block5: {
                            block4: {
                                block2: {
                                    scanRange = x0$5;
                                    if (!(scanRange instanceof IndexKeySpace.BoundedRange)) break block2;
                                    IndexKeySpace.BoundedRange boundedRange = (IndexKeySpace.BoundedRange)scanRange;
                                    Z3IndexKey lo = (Z3IndexKey)boundedRange.lower();
                                    Z3IndexKey hi = (Z3IndexKey)boundedRange.upper();
                                    byte[] lower = ByteArrays$.MODULE$.toBytes(lo.bin(), lo.z());
                                    byte[] upper = ByteArrays$.MODULE$.toBytesFollowingPrefix(hi.bin(), hi.z());
                                    genTraversable = (GenTraversableOnce)this.prefixes$1.map((Function1)new Serializable(this, lower, upper){
                                        public static final long serialVersionUID = 0L;
                                        private final byte[] lower$1;
                                        private final byte[] upper$1;

                                        public final IndexKeySpace.BoundedByteRange apply(byte[] p) {
                                            return new IndexKeySpace.BoundedByteRange(ByteArrays$.MODULE$.concat(p, this.lower$1), ByteArrays$.MODULE$.concat(p, this.upper$1));
                                        }
                                        {
                                            this.lower$1 = lower$1;
                                            this.upper$1 = upper$1;
                                        }
                                    }, Seq$.MODULE$.canBuildFrom());
                                    break block3;
                                }
                                if (!(scanRange instanceof IndexKeySpace.LowerBoundedRange)) break block4;
                                IndexKeySpace.LowerBoundedRange lowerBoundedRange = (IndexKeySpace.LowerBoundedRange)scanRange;
                                Z3IndexKey lo = (Z3IndexKey)lowerBoundedRange.lower();
                                byte[] lower = ByteArrays$.MODULE$.toBytes(lo.bin(), lo.z());
                                byte[] upper = IndexKeySpace$ByteRange$.MODULE$.UnboundedUpperRange();
                                genTraversable = (GenTraversableOnce)this.prefixes$1.map((Function1)new Serializable(this, lower, upper){
                                    public static final long serialVersionUID = 0L;
                                    private final byte[] lower$2;
                                    private final byte[] upper$2;

                                    public final IndexKeySpace.BoundedByteRange apply(byte[] p) {
                                        return new IndexKeySpace.BoundedByteRange(ByteArrays$.MODULE$.concat(p, this.lower$2), ByteArrays$.MODULE$.concat(p, this.upper$2));
                                    }
                                    {
                                        this.lower$2 = lower$2;
                                        this.upper$2 = upper$2;
                                    }
                                }, Seq$.MODULE$.canBuildFrom());
                                break block3;
                            }
                            if (!(scanRange instanceof IndexKeySpace.UpperBoundedRange)) break block5;
                            IndexKeySpace.UpperBoundedRange upperBoundedRange = (IndexKeySpace.UpperBoundedRange)scanRange;
                            Z3IndexKey hi = (Z3IndexKey)upperBoundedRange.upper();
                            byte[] lower = IndexKeySpace$ByteRange$.MODULE$.UnboundedLowerRange();
                            byte[] upper = ByteArrays$.MODULE$.toBytesFollowingPrefix(hi.bin(), hi.z());
                            genTraversable = (GenTraversableOnce)this.prefixes$1.map((Function1)new Serializable(this, lower, upper){
                                public static final long serialVersionUID = 0L;
                                private final byte[] lower$3;
                                private final byte[] upper$3;

                                public final IndexKeySpace.BoundedByteRange apply(byte[] p) {
                                    return new IndexKeySpace.BoundedByteRange(ByteArrays$.MODULE$.concat(p, this.lower$3), ByteArrays$.MODULE$.concat(p, this.upper$3));
                                }
                                {
                                    this.lower$3 = lower$3;
                                    this.upper$3 = upper$3;
                                }
                            }, Seq$.MODULE$.canBuildFrom());
                            break block3;
                        }
                        if (!(scanRange instanceof IndexKeySpace.UnboundedRange)) break block6;
                        genTraversable = Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new IndexKeySpace.BoundedByteRange[]{new IndexKeySpace.BoundedByteRange(IndexKeySpace$ByteRange$.MODULE$.UnboundedLowerRange(), IndexKeySpace$ByteRange$.MODULE$.UnboundedUpperRange())}));
                    }
                    return genTraversable;
                }
                throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unexpected range type ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{scanRange})));
            }
            {
                this.prefixes$1 = prefixes$1;
            }
        });
    }

    public static boolean useFullFilter(XZ3IndexKeySpace $this, Option values, Option config, Hints hints) {
        return true;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Seq org$locationtech$geomesa$index$index$z3$XZ3IndexKeySpace$$getZValue(XZ3IndexKeySpace $this, XZ3SFC sfc, int geomIndex, int dtgIndex, Function1 timeToIndex, boolean lenient, SimpleFeature feature) {
        long xz;
        Tuple2 tuple2;
        Geometry geom = (Geometry)feature.getDefaultGeometry();
        if (geom == null) {
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Null geometry in feature ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{feature.getID()})));
        }
        Envelope envelope = geom.getEnvelopeInternal();
        Date dtg = (Date)feature.getAttribute(dtgIndex);
        long time = dtg == null ? 0L : dtg.getTime();
        BinnedTime binnedTime = (BinnedTime)timeToIndex.apply((Object)BoxesRunTime.boxToLong((long)time));
        if (binnedTime == null) throw new MatchError((Object)binnedTime);
        short b = binnedTime.bin();
        long t = binnedTime.offset();
        Tuple2 tuple22 = tuple2 = new Tuple2((Object)BoxesRunTime.boxToShort((short)b), (Object)BoxesRunTime.boxToLong((long)t));
        short b2 = BoxesRunTime.unboxToShort((Object)tuple22._1());
        long t2 = tuple22._2$mcJ$sp();
        try {
            xz = sfc.index(envelope.getMinX(), envelope.getMinY(), (double)t2, envelope.getMaxX(), envelope.getMaxY(), (double)t2, lenient);
        }
        catch (Throwable throwable) {
            void var9_9;
            void var7_7;
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            Throwable e = (Throwable)option.get();
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid xz value from geometry/time: ", ",", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{var7_7, var9_9})), e);
        }
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Z3IndexKey[]{new Z3IndexKey(b2, xz)}));
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Seq org$locationtech$geomesa$index$index$z3$XZ3IndexKeySpace$$getZValueBytes(XZ3IndexKeySpace $this, XZ3SFC sfc, int geomIndex, int dtgIndex, Function1 timeToIndex, boolean lenient, Seq prefix, SimpleFeature feature, byte[] suffix) {
        long xz;
        Tuple2 tuple2;
        Geometry geom = (Geometry)feature.getDefaultGeometry();
        if (geom == null) {
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Null geometry in feature ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{feature.getID()})));
        }
        Envelope envelope = geom.getEnvelopeInternal();
        Date dtg = (Date)feature.getAttribute(dtgIndex);
        long time = dtg == null ? 0L : dtg.getTime();
        BinnedTime binnedTime = (BinnedTime)timeToIndex.apply((Object)BoxesRunTime.boxToLong((long)time));
        if (binnedTime == null) throw new MatchError((Object)binnedTime);
        short b = binnedTime.bin();
        long t = binnedTime.offset();
        Tuple2 tuple22 = tuple2 = new Tuple2((Object)BoxesRunTime.boxToShort((short)b), (Object)BoxesRunTime.boxToLong((long)t));
        short b2 = BoxesRunTime.unboxToShort((Object)tuple22._1());
        long t2 = tuple22._2$mcJ$sp();
        try {
            xz = sfc.index(envelope.getMinX(), envelope.getMinY(), (double)t2, envelope.getMaxX(), envelope.getMaxY(), (double)t2, lenient);
        }
        catch (Throwable throwable) {
            void var11_11;
            void var9_9;
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            Throwable e = (Throwable)option.get();
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid xz value from geometry/time: ", ",", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{var9_9, var11_11})), e);
        }
        byte[] bytes = (byte[])Array$.MODULE$.ofDim(BoxesRunTime.unboxToInt((Object)((TraversableOnce)prefix.map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final int apply(byte[] x$8) {
                return x$8.length;
            }
        }, Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)) + 10 + suffix.length, ClassTag$.MODULE$.Byte());
        IntRef i = IntRef.create((int)0);
        prefix.foreach((Function1)new Serializable($this, bytes, i){
            public static final long serialVersionUID = 0L;
            private final byte[] bytes$1;
            private final IntRef i$1;

            public final void apply(byte[] p) {
                System.arraycopy(p, 0, this.bytes$1, this.i$1.elem, p.length);
                this.i$1.elem += p.length;
            }
            {
                this.bytes$1 = bytes$1;
                this.i$1 = i$1;
            }
        });
        ByteArrays$.MODULE$.writeShort(b2, bytes, i.elem);
        ByteArrays$.MODULE$.writeLong(xz, bytes, i.elem + 2);
        System.arraycopy(suffix, 0, bytes, i.elem + 10, suffix.length);
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new byte[][]{bytes}));
    }

    public static final void updateTime$1(XZ3IndexKeySpace $this, short bin, double lt, double ut, scala.collection.mutable.Map timesByBin$1) {
        Option option;
        block4: {
            Tuple2.mcDD.sp sp2;
            block3: {
                Some some;
                Tuple2 tuple2;
                block2: {
                    option = timesByBin$1.get((Object)BoxesRunTime.boxToShort((short)bin));
                    if (!None$.MODULE$.equals(option)) break block2;
                    sp2 = new Tuple2.mcDD.sp(lt, ut);
                    break block3;
                }
                if (!(option instanceof Some) || (tuple2 = (Tuple2)(some = (Some)option).x()) == null) break block4;
                double min2 = tuple2._1$mcD$sp();
                double max2 = tuple2._2$mcD$sp();
                sp2 = new Tuple2.mcDD.sp(scala.math.package$.MODULE$.min(min2, lt), scala.math.package$.MODULE$.max(max2, ut));
            }
            Tuple2.mcDD.sp times = sp2;
            timesByBin$1.update((Object)BoxesRunTime.boxToShort((short)bin), (Object)times);
            return;
        }
        throw new MatchError((Object)option);
    }

    public static final Seq toZRanges$1(XZ3IndexKeySpace $this, Tuple2 t, XZ3SFC sfc$4, Seq xy$1, Option target$1) {
        return sfc$4.ranges((Seq)xy$1.map((Function1)new Serializable($this, t){
            public static final long serialVersionUID = 0L;
            private final Tuple2 t$1;

            public final Tuple6<Object, Object, Object, Object, Object, Object> apply(Tuple4<Object, Object, Object, Object> x0$1) {
                Tuple4<Object, Object, Object, Object> tuple4 = x0$1;
                if (tuple4 != null) {
                    double xmin = BoxesRunTime.unboxToDouble((Object)tuple4._1());
                    double ymin = BoxesRunTime.unboxToDouble((Object)tuple4._2());
                    double xmax = BoxesRunTime.unboxToDouble((Object)tuple4._3());
                    double ymax = BoxesRunTime.unboxToDouble((Object)tuple4._4());
                    Tuple6 tuple6 = new Tuple6((Object)BoxesRunTime.boxToDouble((double)xmin), (Object)BoxesRunTime.boxToDouble((double)ymin), (Object)BoxesRunTime.boxToDouble((double)this.t$1._1$mcD$sp()), (Object)BoxesRunTime.boxToDouble((double)xmax), (Object)BoxesRunTime.boxToDouble((double)ymax), (Object)BoxesRunTime.boxToDouble((double)this.t$1._2$mcD$sp()));
                    return tuple6;
                }
                throw new MatchError(tuple4);
            }
            {
                this.t$1 = t$1;
            }
        }, Seq$.MODULE$.canBuildFrom()), target$1);
    }

    private static final Seq wholePeriodRanges$lzycompute$1(XZ3IndexKeySpace $this, XZ3SFC sfc$4, Seq xy$1, Option target$1, ObjectRef wholePeriodRanges$lzy$1, VolatileByteRef bitmap$0$1) {
        XZ3IndexKeySpace xZ3IndexKeySpace = $this;
        synchronized (xZ3IndexKeySpace) {
            if ((byte)(bitmap$0$1.elem & 1) == 0) {
                wholePeriodRanges$lzy$1.elem = XZ3IndexKeySpace$class.toZRanges$1($this, sfc$4.zBounds(), sfc$4, xy$1, target$1);
                bitmap$0$1.elem = (byte)(bitmap$0$1.elem | 1);
            }
            return (Seq)wholePeriodRanges$lzy$1.elem;
        }
    }

    public static final Seq wholePeriodRanges$1(XZ3IndexKeySpace $this, XZ3SFC sfc$4, Seq xy$1, Option target$1, ObjectRef wholePeriodRanges$lzy$1, VolatileByteRef bitmap$0$1) {
        return (byte)(bitmap$0$1.elem & 1) == 0 ? XZ3IndexKeySpace$class.wholePeriodRanges$lzycompute$1($this, sfc$4, xy$1, target$1, wholePeriodRanges$lzy$1, bitmap$0$1) : (Seq)wholePeriodRanges$lzy$1.elem;
    }

    public static void $init$(XZ3IndexKeySpace $this) {
        $this.org$locationtech$geomesa$index$index$z3$XZ3IndexKeySpace$_setter_$indexKeyByteLength_$eq(10);
    }
}

