/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.filter.function;

import java.time.Duration;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.concurrent.ConcurrentHashMap;
import org.geotools.filter.FunctionExpressionImpl;
import org.geotools.filter.capability.FunctionNameImpl;
import org.locationtech.geomesa.filter.function.CurrentDateFunction$;
import org.opengis.filter.capability.FunctionName;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001M3A!\u0001\u0002\u0001\u001b\t\u00192)\u001e:sK:$H)\u0019;f\rVt7\r^5p]*\u00111\u0001B\u0001\tMVt7\r^5p]*\u0011QAB\u0001\u0007M&dG/\u001a:\u000b\u0005\u001dA\u0011aB4f_6,7/\u0019\u0006\u0003\u0013)\tA\u0002\\8dCRLwN\u001c;fG\"T\u0011aC\u0001\u0004_J<7\u0001A\n\u0003\u00019\u0001\"aD\n\u000e\u0003AQ!!B\t\u000b\u0005IQ\u0011\u0001C4f_R|w\u000e\\:\n\u0005Q\u0001\"A\u0006$v]\u000e$\u0018n\u001c8FqB\u0014Xm]:j_:LU\u000e\u001d7\t\u000bY\u0001A\u0011A\f\u0002\rqJg.\u001b;?)\u0005A\u0002CA\r\u0001\u001b\u0005\u0011\u0001bB\u000e\u0001\u0005\u0004%I\u0001H\u0001\b_\u001a47/\u001a;t+\u0005i\u0002\u0003\u0002\u0010&OEj\u0011a\b\u0006\u0003A\u0005\n!bY8oGV\u0014(/\u001a8u\u0015\t\u00113%\u0001\u0003vi&d'\"\u0001\u0013\u0002\t)\fg/Y\u0005\u0003M}\u0011\u0011cQ8oGV\u0014(/\u001a8u\u0011\u0006\u001c\b.T1q!\tAcF\u0004\u0002*Y5\t!FC\u0001,\u0003\u0015\u00198-\u00197b\u0013\ti#&\u0001\u0004Qe\u0016$WMZ\u0005\u0003_A\u0012aa\u0015;sS:<'BA\u0017+!\t\u0011T'D\u00014\u0015\t!4%\u0001\u0003uS6,\u0017B\u0001\u001c4\u0005!!UO]1uS>t\u0007B\u0002\u001d\u0001A\u0003%Q$\u0001\u0005pM\u001a\u001cX\r^:!\u0011\u0015Q\u0004\u0001\"\u0011<\u0003!)g/\u00197vCR,GC\u0001\u001f@!\tIS(\u0003\u0002?U\t1\u0011I\\=SK\u001aDQ\u0001Q\u001dA\u0002q\n\u0011a\\\u0004\u0006\u0005\nA\taQ\u0001\u0014\u0007V\u0014(/\u001a8u\t\u0006$XMR;oGRLwN\u001c\t\u00033\u00113Q!\u0001\u0002\t\u0002\u0015\u001b\"\u0001\u0012\u001f\t\u000bY!E\u0011A$\u0015\u0003\rCq!\u0013#C\u0002\u0013\u0005!*\u0001\u0003OC6,W#A&\u0011\u00051{U\"A'\u000b\u00059\u0003\u0012AC2ba\u0006\u0014\u0017\u000e\\5us&\u0011\u0001+\u0014\u0002\u0011\rVt7\r^5p]:\u000bW.Z%na2DaA\u0015#!\u0002\u0013Y\u0015!\u0002(b[\u0016\u0004\u0003")
public class CurrentDateFunction
extends FunctionExpressionImpl {
    private final ConcurrentHashMap<String, Duration> offsets = new ConcurrentHashMap();

    public static FunctionNameImpl Name() {
        return CurrentDateFunction$.MODULE$.Name();
    }

    private ConcurrentHashMap<String, Duration> offsets() {
        return this.offsets;
    }

    public Object evaluate(Object o) {
        Date date;
        Instant now = ZonedDateTime.now(ZoneOffset.UTC).toInstant();
        if (this.getParameters().isEmpty()) {
            date = Date.from(now);
        } else {
            Object object;
            String offset = (String)this.getExpression(0).evaluate(null);
            Duration duration = this.offsets().get(offset);
            if (duration == null) {
                duration = Duration.parse(offset);
                object = this.offsets().put(offset, duration);
            } else {
                object = BoxedUnit.UNIT;
            }
            date = Date.from(now.plus(duration));
        }
        return date;
    }

    public CurrentDateFunction() {
        super((FunctionName)CurrentDateFunction$.MODULE$.Name());
    }
}

