/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.tools.ingest;

import com.beust.jcommander.ParameterException;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Closeable;
import java.io.File;
import java.io.Flushable;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.geotools.data.DataStore;
import org.geotools.data.DataStoreFinder;
import org.geotools.data.DataUtilities;
import org.geotools.data.FeatureWriter;
import org.geotools.data.Transaction;
import org.geotools.factory.Hints;
import org.geotools.filter.identity.FeatureIdImpl;
import org.locationtech.geomesa.tools.Command$;
import org.locationtech.geomesa.tools.DistributedRunParam$RunModes$;
import org.locationtech.geomesa.tools.ingest.AbstractIngest;
import org.locationtech.geomesa.tools.ingest.AbstractIngest$;
import org.locationtech.geomesa.tools.ingest.AbstractIngest$LocalIngestWorker$1$;
import org.locationtech.geomesa.tools.ingest.IngestCommand$;
import org.locationtech.geomesa.utils.io.CloseWithLogging$;
import org.locationtech.geomesa.utils.io.CloseablePool;
import org.locationtech.geomesa.utils.io.CloseablePool$;
import org.locationtech.geomesa.utils.io.PathUtils$;
import org.locationtech.geomesa.utils.io.fs.FileSystemDelegate;
import org.locationtech.geomesa.utils.io.fs.LocalDelegate;
import org.locationtech.geomesa.utils.stats.CountingInputStream;
import org.locationtech.geomesa.utils.text.TextTools$;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\tmf!B\u0001\u0003\u0003\u0003i!AD!cgR\u0014\u0018m\u0019;J]\u001e,7\u000f\u001e\u0006\u0003\u0007\u0011\ta!\u001b8hKN$(BA\u0003\u0007\u0003\u0015!xn\u001c7t\u0015\t9\u0001\"A\u0004hK>lWm]1\u000b\u0005%Q\u0011\u0001\u00047pG\u0006$\u0018n\u001c8uK\u000eD'\"A\u0006\u0002\u0007=\u0014xm\u0001\u0001\u0014\t\u0001qa#\u0007\t\u0003\u001fQi\u0011\u0001\u0005\u0006\u0003#I\tA\u0001\\1oO*\t1#\u0001\u0003kCZ\f\u0017BA\u000b\u0011\u0005\u0019y%M[3diB\u0011qbF\u0005\u00031A\u0011\u0001BU;o]\u0006\u0014G.\u001a\t\u00035\u0005j\u0011a\u0007\u0006\u00039u\tAb]2bY\u0006dwnZ4j]\u001eT!AH\u0010\u0002\u0011QL\b/Z:bM\u0016T\u0011\u0001I\u0001\u0004G>l\u0017B\u0001\u0012\u001c\u0005-a\u0015M_=M_\u001e<\u0017N\\4\t\u0011\u0011\u0002!Q1A\u0005\u0002\u0015\n\u0001\u0002Z:QCJ\fWn]\u000b\u0002MA!q%\f\u00191\u001d\tA3&D\u0001*\u0015\u0005Q\u0013!B:dC2\f\u0017B\u0001\u0017*\u0003\u0019\u0001&/\u001a3fM&\u0011af\f\u0002\u0004\u001b\u0006\u0004(B\u0001\u0017*!\t9\u0013'\u0003\u00023_\t11\u000b\u001e:j]\u001eD\u0001\u0002\u000e\u0001\u0003\u0002\u0003\u0006IAJ\u0001\nIN\u0004\u0016M]1ng\u0002B\u0001B\u000e\u0001\u0003\u0006\u0004%\taN\u0001\tif\u0004XMT1nKV\t\u0001\u0007\u0003\u0005:\u0001\t\u0005\t\u0015!\u00031\u0003%!\u0018\u0010]3OC6,\u0007\u0005\u0003\u0005<\u0001\t\u0015\r\u0011\"\u0001=\u0003\u0019Ig\u000e];ugV\tQ\bE\u0002?\rBr!a\u0010#\u000f\u0005\u0001\u001bU\"A!\u000b\u0005\tc\u0011A\u0002\u001fs_>$h(C\u0001+\u0013\t)\u0015&A\u0004qC\u000e\\\u0017mZ3\n\u0005\u001dC%aA*fc*\u0011Q)\u000b\u0005\t\u0015\u0002\u0011\t\u0011)A\u0005{\u00059\u0011N\u001c9viN\u0004\u0003\u0002\u0003'\u0001\u0005\u0003\u0005\u000b\u0011B'\u0002\t5|G-\u001a\t\u0004Q9\u0003\u0016BA(*\u0005\u0019y\u0005\u000f^5p]B\u0011\u0011\u000b\u0019\b\u0003%vs!aU.\u000f\u0005QSfBA+Z\u001d\t1\u0006L\u0004\u0002A/&\t1\"\u0003\u0002\n\u0015%\u0011q\u0001C\u0005\u0003\u000b\u0019I!\u0001\u0018\u0003\u0002'\u0011K7\u000f\u001e:jEV$X\r\u001a*v]B\u000b'/Y7\n\u0005y{\u0016\u0001\u0003*v]6{G-Z:\u000b\u0005q#\u0011BA1c\u0005\u001d\u0011VO\\'pI\u0016T!AX0\t\u0011\u0011\u0004!\u0011!Q\u0001\nA\n1\u0002\\5cU\u0006\u00148OR5mK\"Aa\r\u0001B\u0001B\u0003%q-\u0001\u0007mS\nT\u0017M]:QCRD7\u000fE\u0002?Q*L!!\u001b%\u0003\u0011%#XM]1u_J\u00042\u0001K6n\u0013\ta\u0017FA\u0005Gk:\u001cG/[8oaA\u0019aH\u00128\u0011\u0005=\u0014X\"\u00019\u000b\u0005E\u0014\u0012AA5p\u0013\t\u0019\bO\u0001\u0003GS2,\u0007\u0002C;\u0001\u0005\u0003\u0005\u000b\u0011\u0002<\u0002\u001f9,X\u000eT8dC2$\u0006N]3bIN\u0004\"\u0001K<\n\u0005aL#aA%oi\")!\u0010\u0001C\u0001w\u00061A(\u001b8jiz\"R\u0002 @\u0000\u0003\u0003\t\u0019!!\u0002\u0002\b\u0005%\u0001CA?\u0001\u001b\u0005\u0011\u0001\"\u0002\u0013z\u0001\u00041\u0003\"\u0002\u001cz\u0001\u0004\u0001\u0004\"B\u001ez\u0001\u0004i\u0004\"\u0002'z\u0001\u0004i\u0005\"\u00023z\u0001\u0004\u0001\u0004\"\u00024z\u0001\u00049\u0007\"B;z\u0001\u00041\bbBA\u0007\u0001\u0019\u0005\u0011qB\u0001\u000fE\u00164wN]3Sk:$\u0016m]6t)\t\t\t\u0002E\u0002)\u0003'I1!!\u0006*\u0005\u0011)f.\u001b;\t\u000f\u0005e\u0001A\"\u0001\u0002\u001c\u0005!2M]3bi\u0016dunY1m\u0007>tg/\u001a:uKJ$b!!\b\u0003R\tU\u0003\u0003BA\u0010\u0005\u0003q1!`A\u0011\u000f\u001d\t\u0019C\u0001E\u0001\u0003K\ta\"\u00112tiJ\f7\r^%oO\u0016\u001cH\u000fE\u0002~\u0003O1a!\u0001\u0002\t\u0002\u0005%2\u0003BA\u0014\u0003W\u00012\u0001KA\u0017\u0013\r\ty#\u000b\u0002\u0007\u0003:L(+\u001a4\t\u000fi\f9\u0003\"\u0001\u00024Q\u0011\u0011Q\u0005\u0005\f\u0003o\t9\u0003#b\u0001\n\u0013\tI$A\u0007uKJl\u0017N\\1m/&$G\u000f[\u000b\u0003\u0003w\u0001B\u0001K6\u0002>A\u0019\u0001&a\u0010\n\u0007\u0005\u0005\u0013FA\u0003GY>\fG\u000fC\u0006\u0002F\u0005\u001d\u0002\u0012!Q!\n\u0005m\u0012A\u0004;fe6Lg.\u00197XS\u0012$\b\u000e\t\u0005\t\u0003\u0013\n9\u0003\"\u0001\u0002L\u0005Yq-\u001a;Ti\u0006$\u0018J\u001c4p)%\u0001\u0014QJA,\u00037\ny\u0006\u0003\u0005\u0002P\u0005\u001d\u0003\u0019AA)\u0003%\u0019XoY2fgN,7\u000fE\u0002)\u0003'J1!!\u0016*\u0005\u0011auN\\4\t\u0011\u0005e\u0013q\ta\u0001\u0003#\n\u0001BZ1jYV\u0014Xm\u001d\u0005\n\u0003;\n9\u0005%AA\u0002A\na!Y2uS>t\u0007\"CA1\u0003\u000f\u0002\n\u00111\u00011\u0003\u0015Ig\u000e];u\r)\t)'a\n\u0011\u0002G\u0005\u0012q\r\u0002\u000f'R\fG/^:DC2d'-Y2l'\u0011\t\u0019'a\u000b\t\u0011\u0005-\u00141\rD\u0001\u0003\u001f\tQA]3tKRD\u0001\"a\u001c\u0002d\u0019\u0005\u0011\u0011O\u0001\u0006CB\u0004H.\u001f\u000b\u000b\u0003#\t\u0019(a\u001e\u0002|\u0005\u001d\u0005bBA;\u0003[\u0002\r\u0001M\u0001\u0007aJ,g-\u001b=\t\u0011\u0005e\u0014Q\u000ea\u0001\u0003{\t\u0001\u0002\u001d:pOJ,7o\u001d\u0005\t\u0003{\ni\u00071\u0001\u0002\u0000\u0005A1m\\;oi\u0016\u00148\u000f\u0005\u0003?\r\u0006\u0005\u0005C\u0002\u0015\u0002\u0004B\n\t&C\u0002\u0002\u0006&\u0012a\u0001V;qY\u0016\u0014\u0004\u0002CAE\u0003[\u0002\r!a#\u0002\t\u0011|g.\u001a\t\u0004Q\u00055\u0015bAAHS\t9!i\\8mK\u0006t\u0017\u0006BA2\u0003'3q!!&\u0002(\u0001\t9JA\u0007Qe&tG\u000f\u0015:pOJ,7o]\n\u0007\u0003'\u000bY#!'\u0011\t\u0005m\u00151M\u0007\u0003\u0003OA1\"a(\u0002\u0014\n\u0005\t\u0015!\u0003\u0002\"\u0006\u0019q.\u001e;\u0011\u0007=\f\u0019+C\u0002\u0002&B\u00141\u0002\u0015:j]R\u001cFO]3b[\"Q\u0011\u0011VAJ\u0005\u0003\u0005\u000b\u0011\u0002\u0019\u0002\u0011\u0015l\u0007\u000f^=CCJD1\"!,\u0002\u0014\n\u0005\t\u0015!\u0003\u00020\u0006Y!/\u001a9mC\u000e,W.\u001a8u!\rA\u0013\u0011W\u0005\u0004\u0003gK#\u0001B\"iCJD1\"a.\u0002\u0014\n\u0005\t\u0015!\u0003\u00020\u0006I\u0011N\u001c3jG\u0006$xN\u001d\u0005\f\u0003w\u000b\u0019J!A!\u0002\u0013\ty+\u0001\u0004u_\u001e<G.\u001a\u0005\bu\u0006ME\u0011AA`)1\t\t-a1\u0002F\u0006\u001d\u0017\u0011ZAf!\u0011\tY*a%\t\u0011\u0005}\u0015Q\u0018a\u0001\u0003CCq!!+\u0002>\u0002\u0007\u0001\u0007\u0003\u0005\u0002.\u0006u\u0006\u0019AAX\u0011!\t9,!0A\u0002\u0005=\u0006\u0002CA^\u0003{\u0003\r!a,\t\u0015\u0005=\u00171\u0013a\u0001\n\u0013\t\t.A\u0004u_\u001e<G.\u001a3\u0016\u0005\u0005-\u0005BCAk\u0003'\u0003\r\u0011\"\u0003\u0002X\u0006YAo\\4hY\u0016$w\fJ3r)\u0011\t\t\"!7\t\u0015\u0005m\u00171[A\u0001\u0002\u0004\tY)A\u0002yIEB\u0011\"a8\u0002\u0014\u0002\u0006K!a#\u0002\u0011Q|wm\u001a7fI\u0002B!\"a9\u0002\u0014\u0002\u0007I\u0011BAs\u0003\u0015\u0019H/\u0019:u+\t\t\t\u0006\u0003\u0006\u0002j\u0006M\u0005\u0019!C\u0005\u0003W\f\u0011b\u001d;beR|F%Z9\u0015\t\u0005E\u0011Q\u001e\u0005\u000b\u00037\f9/!AA\u0002\u0005E\u0003\"CAy\u0003'\u0003\u000b\u0015BA)\u0003\u0019\u0019H/\u0019:uA!A\u00111NAJ\t\u0003\ny\u0001\u0003\u0005\u0002p\u0005ME\u0011IA|))\t\t\"!?\u0002|\u0006u\u0018q \u0005\b\u0003k\n)\u00101\u00011\u0011!\tI(!>A\u0002\u0005u\u0002\u0002CA?\u0003k\u0004\r!a \t\u0011\u0005%\u0015Q\u001fa\u0001\u0003\u00173!Ba\u0001\u0002(A\u0005\u0019\u0013\u0001B\u0003\u0005QaunY1m\u0013:<Wm\u001d;D_:4XM\u001d;feN)!\u0011\u0001\b\u0003\bA\u0019qN!\u0003\n\u0007\t-\u0001OA\u0005DY>\u001cX-\u00192mK\"A!q\u0002B\u0001\r\u0003\u0011\t\"A\u0004d_:4XM\u001d;\u0015\t\tM!\u0011\u0006\t\u0005}!\u0014)\u0002\u0005\u0003\u0003\u0018\t\u0015RB\u0001B\r\u0015\u0011\u0011YB!\b\u0002\rMLW\u000e\u001d7f\u0015\u0011\u0011yB!\t\u0002\u000f\u0019,\u0017\r^;sK*\u0019!1\u0005\u0006\u0002\u000f=\u0004XM\\4jg&!!q\u0005B\r\u00055\u0019\u0016.\u001c9mK\u001a+\u0017\r^;sK\"A!1\u0006B\u0007\u0001\u0004\u0011i#\u0001\u0002jgB\u0019qNa\f\n\u0007\tE\u0002OA\u0006J]B,Ho\u0015;sK\u0006l\u0007B\u0003B\u001b\u0003O\t\n\u0011\"\u0001\u00038\u0005)r-\u001a;Ti\u0006$\u0018J\u001c4pI\u0011,g-Y;mi\u0012\u001aTC\u0001B\u001dU\r\u0001$1H\u0016\u0003\u0005{\u0001BAa\u0010\u0003J5\u0011!\u0011\t\u0006\u0005\u0005\u0007\u0012)%A\u0005v]\u000eDWmY6fI*\u0019!qI\u0015\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0003L\t\u0005#!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\"Q!qJA\u0014#\u0003%\tAa\u000e\u0002+\u001d,Go\u0015;bi&sgm\u001c\u0013eK\u001a\fW\u000f\u001c;%i!9!1KA\f\u0001\u0004\u0001\u0014\u0001\u00029bi\"D\u0001\"!\u0017\u0002\u0018\u0001\u0007!q\u000b\t\u0005\u00053\u00129'\u0004\u0002\u0003\\)!!Q\fB0\u0003\u0019\tGo\\7jG*!!\u0011\rB2\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0004\u0005K\u0012\u0012\u0001B;uS2LAA!\u001b\u0003\\\tQ\u0011\t^8nS\u000eduN\\4\t\u000f\t5\u0004A\"\u0001\u0003p\u0005\t\"/\u001e8ESN$(/\u001b2vi\u0016$'j\u001c2\u0015\r\tE$Q\u000fB>!\u0011AcJa\u001d\u0011\u000f!\n\u0019)!\u0015\u0002R!A!q\u000fB6\u0001\u0004\u0011I(\u0001\bti\u0006$Xo]\"bY2\u0014\u0017mY6\u0011\t\u0005}\u00111\r\u0005\u000b\u0005{\u0012Y\u0007%AA\u0002\u0005-\u0015!E<bSR4uN]\"p[BdW\r^5p]\"I!\u0011\u0011\u0001C\u0002\u0013E!1Q\u0001\u0003IN,\"A!\"\u0011\t\t\u001d%\u0011S\u0007\u0003\u0005\u0013SAAa#\u0003\u000e\u0006!A-\u0019;b\u0015\r\u0011yIC\u0001\tO\u0016|Go\\8mg&!!1\u0013BE\u0005%!\u0015\r^1Ti>\u0014X\r\u0003\u0005\u0003\u0018\u0002\u0001\u000b\u0011\u0002BC\u0003\r!7\u000f\t\u0005\b\u00057\u0003A\u0011IA\b\u0003\r\u0011XO\u001c\u0005\b\u0005?\u0003A\u0011CA\b\u0003!\u0011XO\u001c'pG\u0006d\u0007b\u0002BR\u0001\u0011E!QU\u0001\u000feVtG)[:ue&\u0014W\u000f^3e)\u0011\t\tBa*\t\u0015\tu$\u0011\u0015I\u0001\u0002\u0004\tY\tC\u0004\u0003,\u0002!IA!,\u0002\u001d\r\u0014X-\u0019;f\u0007\u0006dGNY1dWR\u0011!\u0011\u0010\u0005\n\u0005c\u0003\u0011\u0013!C\u0001\u0005g\u000b1D];o\t&\u001cHO]5ckR,GMS8cI\u0011,g-Y;mi\u0012\u0012TC\u0001B[U\u0011\tYIa\u000f\t\u0013\te\u0006!%A\u0005\u0012\tM\u0016\u0001\u0007:v]\u0012K7\u000f\u001e:jEV$X\r\u001a\u0013eK\u001a\fW\u000f\u001c;%c\u0001")
public abstract class AbstractIngest
implements Runnable,
LazyLogging {
    private final scala.collection.immutable.Map<String, String> dsParams;
    private final String typeName;
    private final Seq<String> inputs;
    private final Option<Enumeration.Value> mode;
    private final int numLocalThreads;
    private final DataStore ds;
    private final Logger logger;
    private volatile boolean bitmap$0;

    public static String getStatInfo$default$4() {
        return AbstractIngest$.MODULE$.getStatInfo$default$4();
    }

    public static String getStatInfo$default$3() {
        return AbstractIngest$.MODULE$.getStatInfo$default$3();
    }

    public static String getStatInfo(long l, long l2, String string, String string2) {
        return AbstractIngest$.MODULE$.getStatInfo(l, l2, string, string2);
    }

    private Logger logger$lzycompute() {
        AbstractIngest abstractIngest = this;
        synchronized (abstractIngest) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public scala.collection.immutable.Map<String, String> dsParams() {
        return this.dsParams;
    }

    public String typeName() {
        return this.typeName;
    }

    public Seq<String> inputs() {
        return this.inputs;
    }

    public abstract void beforeRunTasks();

    public abstract LocalIngestConverter createLocalConverter(String var1, AtomicLong var2);

    public abstract Option<Tuple2<Object, Object>> runDistributedJob(StatusCallback var1, boolean var2);

    public DataStore ds() {
        return this.ds;
    }

    @Override
    public void run() {
        block8: {
            block7: {
                block6: {
                    if (this.inputs().isEmpty() && !LocalDelegate.StdInHandle$.MODULE$.isAvailable()) {
                        throw new ParameterException("Missing option: <files>... is required");
                    }
                    if (!this.inputs().headOption().exists((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final boolean apply(String path) {
                            return PathUtils$.MODULE$.isRemote(path);
                        }
                    })) break block6;
                    if (this.mode.contains((Object)DistributedRunParam$RunModes$.MODULE$.Local())) {
                        this.runLocal();
                    } else {
                        this.runDistributed(this.runDistributed$default$1());
                    }
                    break block7;
                }
                if (!this.mode.forall((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Enumeration.Value x$1) {
                        Enumeration.Value value = x$1;
                        Enumeration.Value value2 = DistributedRunParam$RunModes$.MODULE$.Local();
                        return !(value != null ? !value.equals(value2) : value2 != null);
                    }
                })) break block8;
                this.runLocal();
            }
            this.ds().dispose();
            return;
        }
        throw new ParameterException("To run in distributed mode, please copy input files to a distributed file system");
    }

    /*
     * WARNING - void declaration
     */
    public void runLocal() {
        int n;
        Seq files;
        this.beforeRunTasks();
        Command$.MODULE$.user().info("Running ingestion in local mode");
        long start2 = System.currentTimeMillis();
        boolean stdin = this.inputs().isEmpty();
        Seq seq = files = stdin ? Option$.MODULE$.option2Iterable(LocalDelegate.StdInHandle$.MODULE$.available()).toSeq() : (Seq)this.inputs().flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Seq<FileSystemDelegate.FileHandle> apply(String path) {
                return PathUtils$.MODULE$.interpretPath(path);
            }
        }, Seq$.MODULE$.canBuildFrom());
        if (this.numLocalThreads <= files.length()) {
            n = this.numLocalThreads;
        } else {
            Command$.MODULE$.user().warn("Can't use more threads than there are input files - reducing thread count");
            n = files.length();
        }
        int threads = n;
        AtomicLong written = new AtomicLong(0L);
        AtomicLong failed2 = new AtomicLong(0L);
        AtomicInteger errors = new AtomicInteger(0);
        AtomicLong bytesRead = new AtomicLong(0L);
        int batch = BoxesRunTime.unboxToInt((Object)IngestCommand$.MODULE$.LocalBatchSize().toInt().getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Nothing$ apply() {
                throw new IllegalArgumentException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid batch size for property ", ": "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{IngestCommand$.MODULE$.LocalBatchSize().property()}))).append((Object)IngestCommand$.MODULE$.LocalBatchSize().get()).toString());
            }
        }));
        CloseablePool writers = CloseablePool$.MODULE$.apply((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AbstractIngest $outer;

            public final FeatureWriter<SimpleFeatureType, SimpleFeature> apply() {
                return this.$outer.ds().getFeatureWriterAppend(this.$outer.typeName(), Transaction.AUTO_COMMIT);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, threads);
        ConcurrentHashMap batches = new ConcurrentHashMap();
        try {
            Object object;
            Command$.MODULE$.user().info(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Ingesting ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{stdin ? "from stdin" : TextTools$.MODULE$.getPlural((long)files.length(), "file")}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"with ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{TextTools$.MODULE$.getPlural((long)threads, "thread")}))).toString());
            if (stdin) {
                object = new Serializable(this, files, bytesRead){
                    public static final long serialVersionUID = 0L;
                    private final Seq files$1;
                    private final AtomicLong bytesRead$1;

                    public final float apply() {
                        return this.apply$mcF$sp();
                    }

                    public float apply$mcF$sp() {
                        return this.bytesRead$1.get() + BoxesRunTime.unboxToLong((Object)((TraversableOnce)this.files$1.map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final long apply(FileSystemDelegate.FileHandle x$2) {
                                return x$2.length();
                            }
                        }, Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
                    }
                    {
                        this.files$1 = files$1;
                        this.bytesRead$1 = bytesRead$1;
                    }
                };
            } else {
                float length = BoxesRunTime.unboxToLong((Object)((TraversableOnce)files.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final long apply(FileSystemDelegate.FileHandle x$3) {
                        return x$3.length();
                    }
                }, Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
                object = new Serializable(this, length){
                    public static final long serialVersionUID = 0L;
                    private final float length$1;

                    public final float apply() {
                        return this.apply$mcF$sp();
                    }

                    public float apply$mcF$sp() {
                        return this.length$1;
                    }
                    {
                        this.length$1 = length$1;
                    }
                };
            }
            Serializable totalLength = object;
            StatusCallback statusCallback = this.createCallback();
            ExecutorService es = Executors.newFixedThreadPool(threads);
            List futures = ((TraversableOnce)files.map((Function1)new Serializable(this, written, failed2, errors, bytesRead, batch, writers, batches, es){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ AbstractIngest $outer;
                private final AtomicLong written$1;
                private final AtomicLong failed$1;
                private final AtomicInteger errors$1;
                private final AtomicLong bytesRead$1;
                private final int batch$1;
                private final CloseablePool writers$1;
                private final ConcurrentHashMap batches$1;
                private final ExecutorService es$1;

                public final Future<?> apply(FileSystemDelegate.FileHandle f) {
                    public class Org_locationtech_geomesa_tools_ingest_AbstractIngest$LocalIngestWorker$1
                    implements Runnable {
                        private final FileSystemDelegate.FileHandle file;
                        public final /* synthetic */ AbstractIngest $outer;
                        public final AtomicLong written$1;
                        public final AtomicLong failed$1;
                        private final AtomicInteger errors$1;
                        public final AtomicLong bytesRead$1;
                        public final int batch$1;
                        private final CloseablePool writers$1;
                        public final ConcurrentHashMap batches$1;

                        /*
                         * WARNING - void declaration
                         */
                        public void run() {
                            try {
                                LocalIngestConverter converter = this.org$locationtech$geomesa$tools$ingest$AbstractIngest$LocalIngestWorker$$$outer().createLocalConverter(this.file.path(), this.failed$1);
                                CountingInputStream countingStream = new CountingInputStream(this.file.open());
                                InputStream is = PathUtils$.MODULE$.handleCompression((InputStream)countingStream, this.file.path());
                                try {
                                    Iterator<SimpleFeature> features = converter.convert(is);
                                    this.writers$1.borrow((Function1)new Serializable(this, countingStream, features){
                                        public static final long serialVersionUID = 0L;
                                        private final /* synthetic */ Org_locationtech_geomesa_tools_ingest_AbstractIngest$LocalIngestWorker$1 $outer;
                                        public final CountingInputStream countingStream$1;
                                        private final Iterator features$1;

                                        public final void apply(FeatureWriter<SimpleFeatureType, SimpleFeature> writer) {
                                            Object object;
                                            ObjectRef count = ObjectRef.create((Object)((AtomicInteger)this.$outer.batches$1.get(writer)));
                                            if ((AtomicInteger)count.elem == null) {
                                                count.elem = new AtomicInteger();
                                                object = this.$outer.batches$1.put(writer, (AtomicInteger)count.elem);
                                            } else {
                                                object = BoxedUnit.UNIT;
                                            }
                                            this.features$1.foreach((Function1)new Serializable(this, count, writer){
                                                public static final long serialVersionUID = 0L;
                                                private final /* synthetic */ LocalIngestWorker$1$$anonfun$run$3 $outer;
                                                private final ObjectRef count$1;
                                                private final FeatureWriter writer$1;

                                                public final void apply(SimpleFeature sf) {
                                                    long l;
                                                    SimpleFeature toWrite = (SimpleFeature)this.writer$1.next();
                                                    toWrite.setAttributes(sf.getAttributes());
                                                    ((FeatureIdImpl)toWrite.getIdentifier()).setID(sf.getID());
                                                    toWrite.getUserData().putAll(sf.getUserData());
                                                    toWrite.getUserData().put(Hints.USE_PROVIDED_FID, Boolean.TRUE);
                                                    try {
                                                        this.writer$1.write();
                                                        this.$outer.org$locationtech$geomesa$tools$ingest$AbstractIngest$LocalIngestWorker$$anonfun$$$outer().written$1.incrementAndGet();
                                                        l = ((AtomicInteger)this.count$1.elem).incrementAndGet();
                                                    }
                                                    catch (Throwable throwable) {
                                                        long l2;
                                                        BoxedUnit boxedUnit;
                                                        Throwable throwable2 = throwable;
                                                        Option option = NonFatal$.MODULE$.unapply(throwable2);
                                                        if (option.isEmpty()) {
                                                            throw throwable;
                                                        }
                                                        Throwable e = (Throwable)option.get();
                                                        if (this.$outer.org$locationtech$geomesa$tools$ingest$AbstractIngest$LocalIngestWorker$$anonfun$$$outer().org$locationtech$geomesa$tools$ingest$AbstractIngest$LocalIngestWorker$$$outer().logger().underlying().isErrorEnabled()) {
                                                            this.$outer.org$locationtech$geomesa$tools$ingest$AbstractIngest$LocalIngestWorker$$anonfun$$$outer().org$locationtech$geomesa$tools$ingest$AbstractIngest$LocalIngestWorker$$$outer().logger().underlying().error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to write '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{DataUtilities.encodeFeature((SimpleFeature)toWrite)})), e);
                                                            boxedUnit = BoxedUnit.UNIT;
                                                        } else {
                                                            boxedUnit = BoxedUnit.UNIT;
                                                        }
                                                        l = l2 = this.$outer.org$locationtech$geomesa$tools$ingest$AbstractIngest$LocalIngestWorker$$anonfun$$$outer().failed$1.incrementAndGet();
                                                    }
                                                    if (((AtomicInteger)this.count$1.elem).get() % this.$outer.org$locationtech$geomesa$tools$ingest$AbstractIngest$LocalIngestWorker$$anonfun$$$outer().batch$1 == 0) {
                                                        ((AtomicInteger)this.count$1.elem).set(0);
                                                        FeatureWriter featureWriter = this.writer$1;
                                                        if (featureWriter instanceof Flushable) {
                                                            FeatureWriter featureWriter2 = featureWriter;
                                                            ((Flushable)featureWriter2).flush();
                                                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                        } else {
                                                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                        }
                                                    }
                                                    this.$outer.org$locationtech$geomesa$tools$ingest$AbstractIngest$LocalIngestWorker$$anonfun$$$outer().bytesRead$1.addAndGet(this.$outer.countingStream$1.getCount());
                                                    this.$outer.countingStream$1.resetCount();
                                                }
                                                {
                                                    if ($outer == null) {
                                                        throw null;
                                                    }
                                                    this.$outer = $outer;
                                                    this.count$1 = count$1;
                                                    this.writer$1 = writer$1;
                                                }
                                            });
                                        }

                                        public /* synthetic */ Org_locationtech_geomesa_tools_ingest_AbstractIngest$LocalIngestWorker$1 org$locationtech$geomesa$tools$ingest$AbstractIngest$LocalIngestWorker$$anonfun$$$outer() {
                                            return this.$outer;
                                        }
                                        {
                                            if ($outer == null) {
                                                throw null;
                                            }
                                            this.$outer = $outer;
                                            this.countingStream$1 = countingStream$1;
                                            this.features$1 = features$1;
                                        }
                                    });
                                }
                                catch (Throwable throwable) {
                                    void var10_3;
                                    void var8_1;
                                    CloseWithLogging$.MODULE$.apply((Object)var8_1);
                                    CloseWithLogging$.MODULE$.apply((Object)var10_3);
                                    throw throwable;
                                }
                                CloseWithLogging$.MODULE$.apply((Object)converter);
                                CloseWithLogging$.MODULE$.apply((Object)is);
                            }
                            catch (Throwable throwable) {
                                BoxedUnit boxedUnit;
                                Throwable throwable2 = throwable;
                                boolean bl = throwable2 instanceof ClassNotFoundException ? true : throwable2 instanceof NoClassDefFoundError;
                                if (bl) {
                                    throw throwable2;
                                }
                                Option option = NonFatal$.MODULE$.unapply(throwable2);
                                if (option.isEmpty()) {
                                    throw throwable;
                                }
                                Throwable e = (Throwable)option.get();
                                String msg = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Fatal error running local ingest worker on ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.file.path()}));
                                Command$.MODULE$.user().error(msg);
                                if (this.org$locationtech$geomesa$tools$ingest$AbstractIngest$LocalIngestWorker$$$outer().logger().underlying().isErrorEnabled()) {
                                    this.org$locationtech$geomesa$tools$ingest$AbstractIngest$LocalIngestWorker$$$outer().logger().underlying().error(msg, e);
                                    boxedUnit = BoxedUnit.UNIT;
                                } else {
                                    boxedUnit = BoxedUnit.UNIT;
                                }
                                this.errors$1.incrementAndGet();
                                BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
                            }
                        }

                        public /* synthetic */ AbstractIngest org$locationtech$geomesa$tools$ingest$AbstractIngest$LocalIngestWorker$$$outer() {
                            return this.$outer;
                        }

                        public Org_locationtech_geomesa_tools_ingest_AbstractIngest$LocalIngestWorker$1(AbstractIngest $outer, FileSystemDelegate.FileHandle file, AtomicLong written$1, AtomicLong failed$1, AtomicInteger errors$1, AtomicLong bytesRead$1, int batch$1, CloseablePool writers$1, ConcurrentHashMap batches$1) {
                            this.file = file;
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.written$1 = written$1;
                            this.failed$1 = failed$1;
                            this.errors$1 = errors$1;
                            this.bytesRead$1 = bytesRead$1;
                            this.batch$1 = batch$1;
                            this.writers$1 = writers$1;
                            this.batches$1 = batches$1;
                        }
                    }
                    return this.es$1.submit(new Org_locationtech_geomesa_tools_ingest_AbstractIngest$LocalIngestWorker$1(this.$outer, f, this.written$1, this.failed$1, this.errors$1, this.bytesRead$1, this.batch$1, this.writers$1, this.batches$1));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.written$1 = written$1;
                    this.failed$1 = failed$1;
                    this.errors$1 = errors$1;
                    this.bytesRead$1 = bytesRead$1;
                    this.batch$1 = batch$1;
                    this.writers$1 = writers$1;
                    this.batches$1 = batches$1;
                    this.es$1 = es$1;
                }
            }, Seq$.MODULE$.canBuildFrom())).toList();
            es.shutdown();
            while (true) {
                if (!es.isTerminated()) break block11;
                statusCallback.apply("", this.progress$1(bytesRead, (Function0)totalLength), (Seq<Tuple2<String, Object>>)this.counters$1(written, failed2), true);
                futures.foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Object apply(Future<?> x$4) {
                        return x$4.get();
                    }
                });
                break;
            }
        }
        catch (Throwable throwable) {
            CloseWithLogging$.MODULE$.apply((Object)writers).foreach((Function1)new Serializable(this, errors){
                public static final long serialVersionUID = 0L;
                private final AtomicInteger errors$1;

                public final int apply(Throwable x$5) {
                    return this.errors$1.incrementAndGet();
                }
                {
                    this.errors$1 = errors$1;
                }
            });
            throw throwable;
        }
        {
            void var14_13;
            void var16_14;
            block11: {
                CloseWithLogging$.MODULE$.apply((Object)writers).foreach((Function1)new /* invalid duplicate definition of identical inner class */);
                Command$.MODULE$.user().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Local ingestion complete in ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{TextTools$.MODULE$.getTime(start2)})));
                if (files.lengthCompare(1) == 0) {
                    long x$8 = written.get();
                    long x$9 = failed2.get();
                    String x$10 = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" for file: ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((FileSystemDelegate.FileHandle)files.head()).path()}));
                    String x$11 = AbstractIngest$.MODULE$.getStatInfo$default$3();
                    Command$.MODULE$.user().info(AbstractIngest$.MODULE$.getStatInfo(x$8, x$9, x$11, x$10));
                } else {
                    Command$.MODULE$.user().info(AbstractIngest$.MODULE$.getStatInfo(written.get(), failed2.get(), AbstractIngest$.MODULE$.getStatInfo$default$3(), AbstractIngest$.MODULE$.getStatInfo$default$4()));
                }
                if (errors.get() > 0) {
                    Command$.MODULE$.user().warn("Some files caused errors, ingest counts may not be accurate");
                }
                return;
            }
            Thread.sleep(500L);
            var16_14.apply("", this.progress$1(bytesRead, (Function0)var14_13), (Seq<Tuple2<String, Object>>)this.counters$1(written, failed2), false);
            continue;
        }
    }

    public void runDistributed(boolean waitForCompletion) {
        this.beforeRunTasks();
        Command$.MODULE$.user().info("Running ingestion in distributed mode");
        long start2 = System.currentTimeMillis();
        StatusCallback statusCallback = this.createCallback();
        this.runDistributedJob(statusCallback, waitForCompletion).foreach((Function1)new Serializable(this, start2){
            public static final long serialVersionUID = 0L;
            private final long start$1;

            public final void apply(Tuple2<Object, Object> x0$1) {
                Tuple2<Object, Object> tuple2 = x0$1;
                if (tuple2 != null) {
                    long success = tuple2._1$mcJ$sp();
                    long failed2 = tuple2._2$mcJ$sp();
                    Command$.MODULE$.user().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Distributed ingestion complete in ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{TextTools$.MODULE$.getTime(this.start$1)})));
                    Command$.MODULE$.user().info(AbstractIngest$.MODULE$.getStatInfo(success, failed2, AbstractIngest$.MODULE$.getStatInfo$default$3(), AbstractIngest$.MODULE$.getStatInfo$default$4()));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                this.start$1 = start$1;
            }
        });
    }

    public boolean runDistributedJob$default$2() {
        return true;
    }

    public boolean runDistributed$default$1() {
        return true;
    }

    private StatusCallback createCallback() {
        return ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"accumulo.mock", "useMock"}))).exists((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AbstractIngest $outer;

            public final boolean apply(String x$6) {
                return this.$outer.dsParams().get((Object)x$6).exists((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(String x$7) {
                        return new StringOps(Predef$.MODULE$.augmentString(x$7)).toBoolean();
                    }
                });
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }) ? new PrintProgress(System.err, TextTools$.MODULE$.buildString('\u26ac', 60), ' ', '\u15e7', '\u2b58') : new PrintProgress(System.err, TextTools$.MODULE$.buildString(' ', 60), '=', '>', '>');
    }

    private final float progress$1(AtomicLong bytesRead$1, Function0 totalLength$1) {
        return (float)((double)bytesRead$1.get() / (double)totalLength$1.apply$mcF$sp());
    }

    private final Seq counters$1(AtomicLong written$1, AtomicLong failed$1) {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"ingested", (Object)BoxesRunTime.boxToLong((long)written$1.get())), new Tuple2((Object)"failed", (Object)BoxesRunTime.boxToLong((long)failed$1.get()))}));
    }

    public AbstractIngest(scala.collection.immutable.Map<String, String> dsParams, String typeName, Seq<String> inputs, Option<Enumeration.Value> mode, String libjarsFile, Iterator<Function0<Seq<File>>> libjarsPaths, int numLocalThreads) {
        this.dsParams = dsParams;
        this.typeName = typeName;
        this.inputs = inputs;
        this.mode = mode;
        this.numLocalThreads = numLocalThreads;
        LazyLogging.class.$init$((LazyLogging)this);
        this.ds = DataStoreFinder.getDataStore((Map)JavaConversions$.MODULE$.mapAsJavaMap(dsParams));
    }

    public static class PrintProgress
    implements StatusCallback {
        private final PrintStream out;
        private final String emptyBar;
        private final char replacement;
        private final char indicator;
        private final char toggle;
        private boolean toggled;
        private long start;

        private boolean toggled() {
            return this.toggled;
        }

        private void toggled_$eq(boolean x$1) {
            this.toggled = x$1;
        }

        private long start() {
            return this.start;
        }

        private void start_$eq(long x$1) {
            this.start = x$1;
        }

        @Override
        public void reset() {
            this.start_$eq(System.currentTimeMillis());
        }

        @Override
        public void apply(String prefix, float progress, Seq<Tuple2<String, Object>> counters, boolean done) {
            String string;
            int arg$macro$1 = (int)(progress * (float)100);
            String percent = new StringOps("%3d").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)arg$macro$1)}));
            String counterString = counters.isEmpty() ? "" : ((TraversableOnce)counters.map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply(Tuple2<String, Object> x0$2) {
                    Tuple2<String, Object> tuple2 = x0$2;
                    if (tuple2 != null) {
                        String label = (String)tuple2._1();
                        long count = tuple2._2$mcJ$sp();
                        String string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)count), label}));
                        return string;
                    }
                    throw new MatchError(tuple2);
                }
            }, Seq$.MODULE$.canBuildFrom())).mkString(" ", " ", "");
            String info = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" ", "% complete", " in ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{percent, counterString, TextTools$.MODULE$.getTime(this.start())}));
            float tWidth = AbstractIngest$.MODULE$.org$locationtech$geomesa$tools$ingest$AbstractIngest$$terminalWidth().apply$mcF$sp();
            float scaleFactor = tWidth > (float)(info.length() + 3) && tWidth < (float)(this.emptyBar.length() + info.length() + 2 + prefix.length()) ? (tWidth - (float)info.length() - (float)2 - (float)prefix.length()) / (float)this.emptyBar.length() : 1.0f;
            int scaledLen = (int)((float)this.emptyBar.length() * scaleFactor);
            int numDone = (int)((float)scaledLen * progress);
            if (numDone < 1) {
                string = this.emptyBar.substring(this.emptyBar.length() - scaledLen);
            } else if (numDone >= scaledLen) {
                string = TextTools$.MODULE$.buildString(this.replacement, scaledLen);
            } else {
                String doneStr = TextTools$.MODULE$.buildString(this.replacement, numDone - 1);
                String doStr = this.emptyBar.substring(this.emptyBar.length() - (scaledLen - numDone));
                char i = this.toggled() ? this.toggle : this.indicator;
                this.toggled_$eq(!this.toggled());
                string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "", "", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{doneStr, BoxesRunTime.boxToCharacter((char)i), doStr}));
            }
            String bar = string;
            this.out.print(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\\r", "[", "]", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{prefix, bar, info})));
            if (done) {
                this.out.println();
            }
        }

        public PrintProgress(PrintStream out, String emptyBar, char replacement, char indicator, char toggle) {
            this.out = out;
            this.emptyBar = emptyBar;
            this.replacement = replacement;
            this.indicator = indicator;
            this.toggle = toggle;
            this.toggled = false;
            this.start = System.currentTimeMillis();
        }
    }

    public static interface StatusCallback {
        public void reset();

        public void apply(String var1, float var2, Seq<Tuple2<String, Object>> var3, boolean var4);
    }

    public static interface LocalIngestConverter
    extends Closeable {
        public Iterator<SimpleFeature> convert(InputStream var1);
    }
}

