/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.utils.uuid;

import com.google.common.primitives.Bytes;
import com.google.common.primitives.Longs;
import com.google.common.primitives.Shorts;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.security.SecureRandom;
import java.util.Date;
import java.util.UUID;
import org.locationtech.geomesa.curve.BinnedTime;
import org.locationtech.geomesa.curve.BinnedTime$;
import org.locationtech.geomesa.curve.Z3SFC;
import org.locationtech.geomesa.curve.Z3SFC$;
import org.locationtech.geomesa.utils.cache.SoftThreadLocal;
import org.locationtech.geomesa.utils.geotools.Conversions$;
import org.locationtech.geomesa.utils.geotools.Conversions$RichGeometry$;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType$;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType$RichSimpleFeatureType$;
import org.locationtech.geomesa.utils.uuid.RandomLsbUuidGenerator;
import org.locationtech.geomesa.utils.uuid.RandomLsbUuidGenerator$class;
import org.locationtech.geomesa.utils.uuid.Version4UuidGenerator$class;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Point;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Serializable;
import scala.Tuple2;
import scala.math.package$;
import scala.runtime.BoxesRunTime;
import scala.util.hashing.MurmurHash3$;

public final class Z3UuidGenerator$
implements RandomLsbUuidGenerator,
LazyLogging {
    public static final Z3UuidGenerator$ MODULE$;
    private final String NullGeom;
    private final Logger logger;
    private final SecureRandom org$locationtech$geomesa$utils$uuid$RandomLsbUuidGenerator$$r;
    private final SoftThreadLocal<byte[]> org$locationtech$geomesa$utils$uuid$Version4UuidGenerator$$byteCache;
    private volatile boolean bitmap$0;

    static {
        new Z3UuidGenerator$();
    }

    private Logger logger$lzycompute() {
        Z3UuidGenerator$ z3UuidGenerator$ = this;
        synchronized (z3UuidGenerator$) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public SecureRandom org$locationtech$geomesa$utils$uuid$RandomLsbUuidGenerator$$r() {
        return this.org$locationtech$geomesa$utils$uuid$RandomLsbUuidGenerator$$r;
    }

    @Override
    public void org$locationtech$geomesa$utils$uuid$RandomLsbUuidGenerator$_setter_$org$locationtech$geomesa$utils$uuid$RandomLsbUuidGenerator$$r_$eq(SecureRandom x$1) {
        this.org$locationtech$geomesa$utils$uuid$RandomLsbUuidGenerator$$r = x$1;
    }

    @Override
    public long createRandomLsb() {
        return RandomLsbUuidGenerator$class.createRandomLsb(this);
    }

    @Override
    public SoftThreadLocal<byte[]> org$locationtech$geomesa$utils$uuid$Version4UuidGenerator$$byteCache() {
        return this.org$locationtech$geomesa$utils$uuid$Version4UuidGenerator$$byteCache;
    }

    @Override
    public void org$locationtech$geomesa$utils$uuid$Version4UuidGenerator$_setter_$org$locationtech$geomesa$utils$uuid$Version4UuidGenerator$$byteCache_$eq(SoftThreadLocal x$1) {
        this.org$locationtech$geomesa$utils$uuid$Version4UuidGenerator$$byteCache = x$1;
    }

    @Override
    public byte[] getTempByteArray() {
        return Version4UuidGenerator$class.getTempByteArray(this);
    }

    @Override
    public void setVariant(byte[] bytes) {
        Version4UuidGenerator$class.setVariant(this, bytes);
    }

    @Override
    public void setVersion(byte[] bytes) {
        Version4UuidGenerator$class.setVersion(this, bytes);
    }

    private String NullGeom() {
        return this.NullGeom;
    }

    public UUID createUuid(SimpleFeatureType sft, SimpleFeature sf) {
        long time2 = BoxesRunTime.unboxToLong((Object)RichSimpleFeatureType$RichSimpleFeatureType$.MODULE$.getDtgIndex$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft)).flatMap((Function1)new Serializable(sf){
            public static final long serialVersionUID = 0L;
            private final SimpleFeature sf$1;

            public final Option<Object> apply(int i) {
                return Option$.MODULE$.apply(this.sf$1.getAttribute(i)).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final long apply(Object x$1) {
                        return ((Date)x$1).getTime();
                    }
                });
            }
            {
                this.sf$1 = sf$1;
            }
        }).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return System.currentTimeMillis();
            }
        }));
        Object pt = sf.getAttribute(RichSimpleFeatureType$RichSimpleFeatureType$.MODULE$.getGeomIndex$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft)));
        if (pt == null) {
            throw new IllegalArgumentException(this.NullGeom());
        }
        return RichSimpleFeatureType$RichSimpleFeatureType$.MODULE$.isPoints$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft)) ? this.createUuid((Point)pt, time2, RichSimpleFeatureType$RichSimpleFeatureType$.MODULE$.getZ3Interval$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft))) : this.createUuid(Conversions$RichGeometry$.MODULE$.safeCentroid$extension(Conversions$.MODULE$.RichGeometry((Geometry)pt)), time2, RichSimpleFeatureType$RichSimpleFeatureType$.MODULE$.getZ3Interval$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft)));
    }

    public UUID createUuid(Geometry geom, long time2, Enumeration.Value period) {
        if (geom == null) {
            throw new IllegalArgumentException(this.NullGeom());
        }
        return this.createUuid(Conversions$RichGeometry$.MODULE$.safeCentroid$extension(Conversions$.MODULE$.RichGeometry(geom)), time2, period);
    }

    public UUID createUuid(Point pt, long time2, Enumeration.Value period) {
        if (pt == null) {
            throw new IllegalArgumentException(this.NullGeom());
        }
        long leastSigBits = this.createRandomLsb();
        BinnedTime binnedTime = (BinnedTime)BinnedTime$.MODULE$.timeToBinnedTime(period).apply((Object)BoxesRunTime.boxToLong((long)time2));
        if (binnedTime != null) {
            Tuple2 tuple2;
            short b = binnedTime.bin();
            long t = binnedTime.offset();
            Tuple2 tuple22 = tuple2 = new Tuple2((Object)BoxesRunTime.boxToShort((short)b), (Object)BoxesRunTime.boxToLong((long)t));
            short b2 = BoxesRunTime.unboxToShort((Object)tuple22._1());
            long t2 = tuple22._2$mcJ$sp();
            Z3SFC qual$1 = Z3SFC$.MODULE$.apply(period);
            double x$3 = pt.getX();
            double x$4 = pt.getY();
            long x$5 = t2;
            boolean x$6 = qual$1.index$default$4();
            long z = qual$1.index(x$3, x$4, x$5, x$6);
            byte[] z3 = Bytes.concat((byte[][])new byte[][]{Shorts.toByteArray((short)b2), Longs.toByteArray((long)z)});
            byte shard = (byte)package$.MODULE$.abs(MurmurHash3$.MODULE$.bytesHash(z3) % 16);
            byte[] msb = this.getTempByteArray();
            msb[0] = this.lohi(shard, z3[0]);
            msb[1] = this.lohi(z3[0], z3[1]);
            msb[2] = this.lohi(z3[1], z3[2]);
            msb[3] = this.lohi(z3[2], z3[3]);
            msb[4] = this.lohi(z3[3], z3[4]);
            msb[5] = this.lohi(z3[4], z3[5]);
            msb[6] = this.lohi((byte)0, (byte)(z3[5] << 4));
            msb[7] = z3[6];
            this.setVersion(msb);
            long mostSigBits = Longs.fromByteArray((byte[])msb);
            return new UUID(mostSigBits, leastSigBits);
        }
        throw new MatchError((Object)binnedTime);
    }

    public short timeBin(byte[] uuid, int offset) {
        return this.timeBin(uuid[offset], uuid[offset + 1], uuid[offset + 2]);
    }

    public short timeBin(byte b0, byte b1, byte b2) {
        return Shorts.fromBytes((byte)this.lohi(b0, b1), (byte)this.lohi(b1, b2));
    }

    public int timeBin$default$2() {
        return 0;
    }

    private byte lohi(byte b1, byte b2) {
        return (byte)(Byte.toUnsignedInt(b1) << 4 | Byte.toUnsignedInt(b2) >>> 4);
    }

    private Z3UuidGenerator$() {
        MODULE$ = this;
        Version4UuidGenerator$class.$init$(this);
        RandomLsbUuidGenerator$class.$init$(this);
        LazyLogging.class.$init$((LazyLogging)this);
        this.NullGeom = "Cannot meaningfully index a feature with a NULL geometry";
    }
}

