/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.convert.json;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.Map;
import org.locationtech.geomesa.convert.json.GeoJsonParsing;
import org.locationtech.geomesa.convert.json.GeoJsonParsing$;
import org.locationtech.geomesa.utils.text.WKTUtils$;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.impl.CoordinateArraySequence;
import scala.Function1;
import scala.NotImplementedError;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.mutable.Builder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public abstract class GeoJsonParsing$class {
    public static boolean isFeatureCollection(GeoJsonParsing $this, JsonElement el) {
        return GeoJsonParsing$class.isType($this, el, GeoJsonParsing$.MODULE$.org$locationtech$geomesa$convert$json$GeoJsonParsing$$FeatureCollectionType());
    }

    public static boolean isFeature(GeoJsonParsing $this, JsonElement el) {
        return GeoJsonParsing$class.isType($this, el, GeoJsonParsing$.MODULE$.org$locationtech$geomesa$convert$json$GeoJsonParsing$$FeatureType());
    }

    public static Seq parseFeatureCollection(GeoJsonParsing $this, JsonElement el) {
        JsonArray features = el.getAsJsonObject().get(GeoJsonParsing$.MODULE$.org$locationtech$geomesa$convert$json$GeoJsonParsing$$FeaturesKey()).getAsJsonArray();
        return (Seq)Seq$.MODULE$.tabulate(features.size(), (Function1)new Serializable($this, features){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ GeoJsonParsing $outer;
            private final JsonArray features$1;

            public final GeoJsonParsing.GeoJsonFeature apply(int i) {
                return this.$outer.parseFeature(this.features$1.get(i));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.features$1 = features$1;
            }
        });
    }

    public static GeoJsonParsing.GeoJsonFeature parseFeature(GeoJsonParsing $this, JsonElement el) {
        Map map;
        JsonObject obj = el.getAsJsonObject();
        Geometry geometry = $this.parseGeometry(obj.get(GeoJsonParsing$.MODULE$.org$locationtech$geomesa$convert$json$GeoJsonParsing$$GeometryKey()));
        JsonElement jsonElement = obj.get(GeoJsonParsing$.MODULE$.org$locationtech$geomesa$convert$json$GeoJsonParsing$$PropertiesKey());
        if (jsonElement instanceof JsonObject) {
            JsonObject jsonObject = (JsonObject)jsonElement;
            map = GeoJsonParsing$class.org$locationtech$geomesa$convert$json$GeoJsonParsing$$parseProperties($this, jsonObject, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"$['", "']"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{GeoJsonParsing$.MODULE$.org$locationtech$geomesa$convert$json$GeoJsonParsing$$PropertiesKey()})));
        } else {
            map = Predef$.MODULE$.Map().empty();
        }
        Map props = map;
        return new GeoJsonParsing.GeoJsonFeature(geometry, (Map<String, String>)props);
    }

    public static Geometry parseGeometry(GeoJsonParsing $this, JsonElement el) {
        block5: {
            Geometry geometry;
            block3: {
                JsonElement jsonElement;
                block4: {
                    block2: {
                        jsonElement = el;
                        if (!(jsonElement instanceof JsonObject)) break block2;
                        JsonObject jsonObject = (JsonObject)jsonElement;
                        geometry = GeoJsonParsing$class.parseGeometryObject($this, jsonObject);
                        break block3;
                    }
                    if (!(jsonElement instanceof JsonPrimitive)) break block4;
                    JsonPrimitive jsonPrimitive = (JsonPrimitive)jsonElement;
                    geometry = WKTUtils$.MODULE$.read(jsonPrimitive.getAsString());
                    break block3;
                }
                if (!(jsonElement instanceof JsonNull)) break block5;
                geometry = null;
            }
            return geometry;
        }
        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unknown geometry type: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{el})));
    }

    private static Geometry parseGeometryObject(GeoJsonParsing $this, JsonObject obj) {
        String string;
        block9: {
            Point point;
            block3: {
                block8: {
                    block7: {
                        block6: {
                            block5: {
                                block4: {
                                    block2: {
                                        string = obj.get(GeoJsonParsing$.MODULE$.org$locationtech$geomesa$convert$json$GeoJsonParsing$$TypeKey()).getAsString().toLowerCase();
                                        if (!"point".equals(string)) break block2;
                                        point = $this.org$locationtech$geomesa$convert$json$GeoJsonParsing$$factory().createPoint(GeoJsonParsing$class.org$locationtech$geomesa$convert$json$GeoJsonParsing$$toPointCoords($this, obj.get(GeoJsonParsing$.MODULE$.org$locationtech$geomesa$convert$json$GeoJsonParsing$$CoordinatesKey())));
                                        break block3;
                                    }
                                    if (!"linestring".equals(string)) break block4;
                                    point = $this.org$locationtech$geomesa$convert$json$GeoJsonParsing$$factory().createLineString(GeoJsonParsing$class.org$locationtech$geomesa$convert$json$GeoJsonParsing$$toCoordSeq($this, obj.get(GeoJsonParsing$.MODULE$.org$locationtech$geomesa$convert$json$GeoJsonParsing$$CoordinatesKey())));
                                    break block3;
                                }
                                if (!"polygon".equals(string)) break block5;
                                point = GeoJsonParsing$class.org$locationtech$geomesa$convert$json$GeoJsonParsing$$toPolygon($this, obj.get(GeoJsonParsing$.MODULE$.org$locationtech$geomesa$convert$json$GeoJsonParsing$$CoordinatesKey()));
                                break block3;
                            }
                            if (!"multipoint".equals(string)) break block6;
                            point = $this.org$locationtech$geomesa$convert$json$GeoJsonParsing$$factory().createMultiPoint(GeoJsonParsing$class.org$locationtech$geomesa$convert$json$GeoJsonParsing$$toCoordSeq($this, obj.get(GeoJsonParsing$.MODULE$.org$locationtech$geomesa$convert$json$GeoJsonParsing$$CoordinatesKey())));
                            break block3;
                        }
                        if (!"multilinestring".equals(string)) break block7;
                        LineString[] coords = (LineString[])((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((Iterable)obj.get(GeoJsonParsing$.MODULE$.org$locationtech$geomesa$convert$json$GeoJsonParsing$$CoordinatesKey()).getAsJsonArray()).asScala()).map((Function1)new Serializable($this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ GeoJsonParsing $outer;

                            public final LineString apply(JsonElement c) {
                                return this.$outer.org$locationtech$geomesa$convert$json$GeoJsonParsing$$factory().createLineString(GeoJsonParsing$class.org$locationtech$geomesa$convert$json$GeoJsonParsing$$toCoordSeq(this.$outer, c));
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        }, Iterable$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(LineString.class));
                        point = $this.org$locationtech$geomesa$convert$json$GeoJsonParsing$$factory().createMultiLineString(coords);
                        break block3;
                    }
                    if (!"multipolygon".equals(string)) break block8;
                    point = $this.org$locationtech$geomesa$convert$json$GeoJsonParsing$$factory().createMultiPolygon((Polygon[])((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((Iterable)obj.get(GeoJsonParsing$.MODULE$.org$locationtech$geomesa$convert$json$GeoJsonParsing$$CoordinatesKey()).getAsJsonArray()).asScala()).map((Function1)new Serializable($this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ GeoJsonParsing $outer;

                        public final Polygon apply(JsonElement el) {
                            return GeoJsonParsing$class.org$locationtech$geomesa$convert$json$GeoJsonParsing$$toPolygon(this.$outer, el);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    }, Iterable$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Polygon.class)));
                    break block3;
                }
                if (!"geometrycollection".equals(string)) break block9;
                point = $this.org$locationtech$geomesa$convert$json$GeoJsonParsing$$factory().createGeometryCollection((Geometry[])((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((Iterable)obj.get(GeoJsonParsing$.MODULE$.org$locationtech$geomesa$convert$json$GeoJsonParsing$$GeometriesKey()).getAsJsonArray()).asScala()).map((Function1)new Serializable($this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ GeoJsonParsing $outer;

                    public final Geometry apply(JsonElement el) {
                        return this.$outer.parseGeometry(el);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, Iterable$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Geometry.class)));
            }
            return point;
        }
        throw new NotImplementedError(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Can't parse geometry type of ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{string})));
    }

    public static Coordinate org$locationtech$geomesa$convert$json$GeoJsonParsing$$toPointCoords(GeoJsonParsing $this, JsonElement el) {
        Seq seq;
        block4: {
            Coordinate coordinate;
            block3: {
                block2: {
                    seq = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((Iterable)el.getAsJsonArray()).asScala()).map((Function1)new Serializable($this){
                        public static final long serialVersionUID = 0L;

                        public final double apply(JsonElement x$1) {
                            return x$1.getAsDouble();
                        }
                    }, Iterable$.MODULE$.canBuildFrom())).toSeq();
                    Some some = Seq$.MODULE$.unapplySeq(seq);
                    if (some.isEmpty() || some.get() == null || ((SeqLike)some.get()).lengthCompare(2) != 0) break block2;
                    double x = BoxesRunTime.unboxToDouble((Object)((SeqLike)some.get()).apply(0));
                    double y = BoxesRunTime.unboxToDouble((Object)((SeqLike)some.get()).apply(1));
                    coordinate = new Coordinate(x, y);
                    break block3;
                }
                Some some = Seq$.MODULE$.unapplySeq(seq);
                if (some.isEmpty() || some.get() == null || ((SeqLike)some.get()).lengthCompare(3) != 0) break block4;
                double x = BoxesRunTime.unboxToDouble((Object)((SeqLike)some.get()).apply(0));
                double y = BoxesRunTime.unboxToDouble((Object)((SeqLike)some.get()).apply(1));
                double z = BoxesRunTime.unboxToDouble((Object)((SeqLike)some.get()).apply(2));
                coordinate = new Coordinate(x, y, z);
            }
            return coordinate;
        }
        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid point - expected 2 or 3 values, got ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{seq.mkString(", ")})));
    }

    public static CoordinateSequence org$locationtech$geomesa$convert$json$GeoJsonParsing$$toCoordSeq(GeoJsonParsing $this, JsonElement el) {
        return new CoordinateArraySequence((Coordinate[])((TraversableOnce)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((Iterable)el.getAsJsonArray()).asScala()).map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final JsonArray apply(JsonElement x$2) {
                return x$2.getAsJsonArray();
            }
        }, Iterable$.MODULE$.canBuildFrom())).map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ GeoJsonParsing $outer;

            public final Coordinate apply(JsonElement el) {
                return GeoJsonParsing$class.org$locationtech$geomesa$convert$json$GeoJsonParsing$$toPointCoords(this.$outer, el);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Iterable$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Coordinate.class)));
    }

    public static Polygon org$locationtech$geomesa$convert$json$GeoJsonParsing$$toPolygon(GeoJsonParsing $this, JsonElement el) {
        Iterator rings = ((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(el.getAsJsonArray().iterator()).asScala()).map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ GeoJsonParsing $outer;

            public final LinearRing apply(JsonElement c) {
                return this.$outer.org$locationtech$geomesa$convert$json$GeoJsonParsing$$factory().createLinearRing(GeoJsonParsing$class.org$locationtech$geomesa$convert$json$GeoJsonParsing$$toCoordSeq(this.$outer, c));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        LinearRing shell = (LinearRing)rings.next();
        return rings.hasNext() ? $this.org$locationtech$geomesa$convert$json$GeoJsonParsing$$factory().createPolygon(shell, (LinearRing[])rings.toArray(ClassTag$.MODULE$.apply(LinearRing.class))) : $this.org$locationtech$geomesa$convert$json$GeoJsonParsing$$factory().createPolygon(shell);
    }

    public static Map org$locationtech$geomesa$convert$json$GeoJsonParsing$$parseProperties(GeoJsonParsing $this, JsonObject o, String path) {
        Builder builder = Predef$.MODULE$.Map().newBuilder();
        ((IterableLike)JavaConverters$.MODULE$.asScalaSetConverter(o.entrySet()).asScala()).foreach((Function1)new Serializable($this, path, builder){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ GeoJsonParsing $outer;
            private final String path$1;
            private final Builder builder$1;

            public final Object apply(Map.Entry<String, JsonElement> entry) {
                BoxedUnit boxedUnit;
                String p = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "['", "']"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.path$1, entry.getKey()}));
                JsonElement jsonElement = entry.getValue();
                if (jsonElement instanceof JsonPrimitive) {
                    JsonPrimitive jsonPrimitive = (JsonPrimitive)jsonElement;
                    boxedUnit = this.builder$1.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)p), (Object)jsonPrimitive.getAsString()));
                } else if (jsonElement instanceof JsonObject) {
                    JsonObject jsonObject = (JsonObject)jsonElement;
                    boxedUnit = this.builder$1.$plus$plus$eq((TraversableOnce)GeoJsonParsing$class.org$locationtech$geomesa$convert$json$GeoJsonParsing$$parseProperties(this.$outer, jsonObject, p));
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                return boxedUnit;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.path$1 = path$1;
                this.builder$1 = builder$1;
            }
        });
        return (Map)builder.result();
    }

    private static boolean isType(GeoJsonParsing $this, JsonElement el, String t) {
        boolean bl;
        JsonElement jsonElement = el;
        if (jsonElement instanceof JsonObject) {
            JsonObject jsonObject = (JsonObject)jsonElement;
            bl = Option$.MODULE$.apply((Object)jsonObject.get(GeoJsonParsing$.MODULE$.org$locationtech$geomesa$convert$json$GeoJsonParsing$$TypeKey())).exists((Function1)new Serializable($this, t){
                public static final long serialVersionUID = 0L;
                private final String t$1;

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final boolean apply(JsonElement e) {
                    if (!e.isJsonPrimitive()) return false;
                    String string = e.getAsString();
                    String string2 = this.t$1;
                    if (string != null) {
                        if (!string.equals(string2)) return false;
                        return true;
                    }
                    if (string2 == null) return true;
                    return false;
                }
                {
                    this.t$1 = t$1;
                }
            });
        } else {
            bl = false;
        }
        return bl;
    }

    public static void $init$(GeoJsonParsing $this) {
        $this.org$locationtech$geomesa$convert$json$GeoJsonParsing$_setter_$org$locationtech$geomesa$convert$json$GeoJsonParsing$$factory_$eq(new GeometryFactory());
    }
}

