/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.process.function;

import java.lang.reflect.Array;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.geotools.data.Parameter;
import org.geotools.filter.capability.FunctionNameImpl;
import org.geotools.process.Process;
import org.geotools.process.ProcessException;
import org.geotools.process.Processors;
import org.geotools.process.function.ExceptionProgressListener;
import org.geotools.util.Converters;
import org.opengis.feature.type.Name;
import org.opengis.filter.capability.FunctionName;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.ExpressionVisitor;
import org.opengis.filter.expression.Function;
import org.opengis.filter.expression.Literal;

public class ProcessFunction
implements Function {
    String name;
    Literal fallbackValue;
    List<Expression> inputExpressions;
    Map<String, Parameter<?>> parameters;
    Process process;
    Name processName;
    FunctionNameImpl functionName;

    public ProcessFunction(Name processName, List<Expression> inputExpressions, Map<String, Parameter<?>> parameters, Process process, Literal fallbackValue) {
        String nsuri = processName.getNamespaceURI();
        this.name = nsuri == null ? processName.getLocalPart() : nsuri + ":" + processName.getLocalPart();
        this.processName = processName;
        this.inputExpressions = inputExpressions;
        this.parameters = parameters;
        this.process = process;
        this.fallbackValue = fallbackValue;
        ArrayList<org.opengis.parameter.Parameter> inputParams = new ArrayList<org.opengis.parameter.Parameter>();
        Map<String, Parameter<?>> parameterInfo = Processors.getParameterInfo(processName);
        if (parameterInfo instanceof LinkedHashMap) {
            for (Parameter<?> parameter : parameterInfo.values()) {
                inputParams.add(parameter);
            }
        } else {
            Set<String> paramNames = parameterInfo.keySet();
            for (String pn : paramNames) {
                org.opengis.parameter.Parameter param = FunctionNameImpl.parameter((String)pn, Object.class, (int)0, (int)1);
                inputParams.add(param);
            }
        }
        Map<String, Parameter<?>> resultParams = Processors.getResultInfo(processName, null);
        org.opengis.parameter.Parameter parameter = resultParams.values().iterator().next();
        this.functionName = new FunctionNameImpl(this.name, parameter, inputParams);
    }

    public Literal getFallbackValue() {
        return this.fallbackValue;
    }

    public String getName() {
        return this.name;
    }

    public Name getProcessName() {
        return this.processName;
    }

    public FunctionName getFunctionName() {
        return this.functionName;
    }

    public List<Expression> getParameters() {
        return this.inputExpressions;
    }

    public Object accept(ExpressionVisitor visitor, Object extraData) {
        return visitor.visit((Function)this, extraData);
    }

    public <T> T evaluate(Object object, Class<T> context) {
        Object o = this.evaluate(object);
        return Converters.convert(o, context);
    }

    public Object evaluate(Object object) {
        Map<String, Object> processInputs = this.evaluateInputs(object);
        try {
            ExceptionProgressListener listener = new ExceptionProgressListener();
            Map<String, Object> results = this.process.execute(processInputs, listener);
            if (listener.getExceptions().size() > 0) {
                Throwable t = listener.getExceptions().get(0);
                throw new RuntimeException("Failed to evaluate process function, error is: " + t.getMessage(), t);
            }
            return this.getResult(results, processInputs);
        }
        catch (ProcessException e) {
            throw new RuntimeException("Failed to evaluate the process function, error is: " + e.getMessage(), e);
        }
    }

    protected Map<String, Object> evaluateInputs(Object object) {
        HashMap<String, Object> processInputs = new HashMap<String, Object>();
        for (Expression input : this.inputExpressions) {
            Object converted;
            Collection<Object> collection;
            Object result = input.evaluate(object, Map.class);
            if (result == null) continue;
            Map map = (Map)result;
            if (map.size() > 1) {
                throw new InvalidParameterException("The parameters to a ProcessFunction must all be maps with a single entry, the key is the process argument name, the value is the argument value");
            }
            Iterator it = map.entrySet().iterator();
            Map.Entry entry = it.next();
            String paramName = (String)entry.getKey();
            Object paramValue = entry.getValue();
            Parameter<?> param = this.parameters.get(paramName);
            if (param == null) {
                throw new InvalidParameterException("Parameter " + paramName + " is not among the process parameters: " + this.parameters.keySet());
            }
            if (paramValue == null) continue;
            if (param.maxOccurs > 1) {
                if (!(paramValue instanceof Collection) && !paramValue.getClass().isArray()) {
                    collection = Collections.singletonList(paramValue);
                    converted = Converters.convert(collection, Array.newInstance(param.type, 0).getClass());
                } else {
                    converted = Converters.convert(paramValue, Array.newInstance(param.type, 0).getClass());
                }
            } else {
                converted = Converters.convert(paramValue, param.type);
            }
            if (converted == null) {
                if (param.maxOccurs > 1 && Collection.class.isAssignableFrom(paramValue.getClass())) {
                    collection = (Collection)paramValue;
                    ArrayList convertedCollection = new ArrayList(collection.size());
                    for (Object original : collection) {
                        Object convertedItem = Converters.convert(original, param.type);
                        if (original != null && convertedItem == null) {
                            throw new InvalidParameterException("Could not convert the value " + original + " into the expected type " + param.type + " for parameter " + paramName);
                        }
                        convertedCollection.add(convertedItem);
                    }
                    Object array = Array.newInstance(param.type, convertedCollection.size());
                    int i = 0;
                    for (Object item : convertedCollection) {
                        Array.set(array, i, item);
                        ++i;
                    }
                    converted = array;
                } else {
                    throw new InvalidParameterException("Could not convert the value " + paramValue + " into the expected type " + param.type + " for parameter " + paramName);
                }
            }
            processInputs.put(paramName, converted);
        }
        return processInputs;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.fallbackValue == null ? 0 : this.fallbackValue.hashCode());
        result = 31 * result + (this.functionName == null ? 0 : this.functionName.hashCode());
        result = 31 * result + (this.inputExpressions == null ? 0 : this.inputExpressions.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.parameters == null ? 0 : this.parameters.hashCode());
        result = 31 * result + (this.processName == null ? 0 : this.processName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ProcessFunction other = (ProcessFunction)obj;
        if (this.fallbackValue == null ? other.fallbackValue != null : !this.fallbackValue.equals(other.fallbackValue)) {
            return false;
        }
        if (this.functionName == null ? other.functionName != null : !this.functionName.equals((Object)other.functionName)) {
            return false;
        }
        if (this.inputExpressions == null ? other.inputExpressions != null : !this.inputExpressions.equals(other.inputExpressions)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.parameters == null ? other.parameters != null : !this.parameters.equals(other.parameters)) {
            return false;
        }
        return !(this.processName == null ? other.processName != null : !this.processName.equals((Object)other.processName));
    }

    private Object getResult(Map<String, Object> results, Map<String, Object> processInputs) {
        if (results.size() == 1) {
            return results.values().iterator().next();
        }
        Map<String, Parameter<?>> resultInfo = Processors.getResultInfo(this.processName, processInputs);
        String primary = this.getPrimary(resultInfo);
        return results.get(primary);
    }

    private String getPrimary(Map<String, Parameter<?>> resultInfo) {
        if (resultInfo.size() == 1) {
            return resultInfo.get(0).getName();
        }
        for (Parameter<?> param : resultInfo.values()) {
            if (!param.isRequired().booleanValue()) continue;
            return param.getName();
        }
        return null;
    }
}

