/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.process.function;

import java.util.List;
import java.util.Map;
import org.geotools.data.Parameter;
import org.geotools.data.Query;
import org.geotools.filter.function.RenderingTransformation;
import org.geotools.process.ProcessException;
import org.geotools.process.RenderingProcess;
import org.geotools.process.function.ProcessFunction;
import org.opengis.coverage.grid.GridCoverageReader;
import org.opengis.coverage.grid.GridGeometry;
import org.opengis.feature.type.Name;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Literal;
import org.opengis.parameter.GeneralParameterValue;

class RenderingProcessFunction
extends ProcessFunction
implements RenderingTransformation {
    public RenderingProcessFunction(Name processName, List<Expression> inputExpressions, Map<String, Parameter<?>> parameters, RenderingProcess process, Literal fallbackValue) {
        super(processName, inputExpressions, parameters, process, fallbackValue);
    }

    public Query invertQuery(Query targetQuery, GridGeometry gridGeometry) {
        RenderingProcess process = (RenderingProcess)this.process;
        Map<String, Object> inputs = this.evaluateInputs(null);
        try {
            return process.invertQuery(inputs, targetQuery, gridGeometry);
        }
        catch (ProcessException e) {
            throw new RuntimeException("Failed to invert the query, error is: " + e.getMessage(), e);
        }
    }

    public GridGeometry invertGridGeometry(Query targetQuery, GridGeometry targetGridGeometry) {
        RenderingProcess process = (RenderingProcess)this.process;
        Map<String, Object> inputs = this.evaluateInputs(null);
        try {
            return process.invertGridGeometry(inputs, targetQuery, targetGridGeometry);
        }
        catch (ProcessException e) {
            throw new RuntimeException("Failed to invert the grid geometry, error is: " + e.getMessage(), e);
        }
    }

    public GeneralParameterValue[] customizeReadParams(GridCoverageReader reader, GeneralParameterValue[] params) {
        RenderingProcess process = (RenderingProcess)this.process;
        Map<String, Object> inputs = this.evaluateInputs(null);
        try {
            return process.customizeReadParams(inputs, reader, params);
        }
        catch (ProcessException e) {
            throw new RuntimeException("Failed to customize the reader parameters, error is: " + e.getMessage(), e);
        }
    }
}

