/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.hadoop;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.compress.CodecPool;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionInputStream;
import org.apache.hadoop.io.compress.CompressionOutputStream;
import org.apache.hadoop.io.compress.Compressor;
import org.apache.hadoop.io.compress.Decompressor;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.parquet.bytes.ByteBufferAllocator;
import org.apache.parquet.bytes.BytesInput;
import org.apache.parquet.hadoop.BadConfigurationException;
import org.apache.parquet.hadoop.DirectCodecFactory;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;

public class CodecFactory {
    protected static final Map<String, CompressionCodec> CODEC_BY_NAME = Collections.synchronizedMap(new HashMap());
    private final Map<CompressionCodecName, BytesCompressor> compressors = new HashMap<CompressionCodecName, BytesCompressor>();
    private final Map<CompressionCodecName, BytesDecompressor> decompressors = new HashMap<CompressionCodecName, BytesDecompressor>();
    protected final Configuration configuration;
    protected final int pageSize;

    public CodecFactory(Configuration configuration, int pageSize) {
        this.configuration = configuration;
        this.pageSize = pageSize;
    }

    public static CodecFactory createDirectCodecFactory(Configuration config, ByteBufferAllocator allocator, int pageSize) {
        return new DirectCodecFactory(config, allocator, pageSize);
    }

    public BytesCompressor getCompressor(CompressionCodecName codecName) {
        BytesCompressor comp = this.compressors.get((Object)codecName);
        if (comp == null) {
            comp = this.createCompressor(codecName);
            this.compressors.put(codecName, comp);
        }
        return comp;
    }

    public BytesDecompressor getDecompressor(CompressionCodecName codecName) {
        BytesDecompressor decomp = this.decompressors.get((Object)codecName);
        if (decomp == null) {
            decomp = this.createDecompressor(codecName);
            this.decompressors.put(codecName, decomp);
        }
        return decomp;
    }

    protected BytesCompressor createCompressor(CompressionCodecName codecName) {
        return new HeapBytesCompressor(codecName);
    }

    protected BytesDecompressor createDecompressor(CompressionCodecName codecName) {
        return new HeapBytesDecompressor(codecName);
    }

    protected CompressionCodec getCodec(CompressionCodecName codecName) {
        String codecClassName = codecName.getHadoopCompressionCodecClassName();
        if (codecClassName == null) {
            return null;
        }
        CompressionCodec codec = CODEC_BY_NAME.get(codecClassName);
        if (codec != null) {
            return codec;
        }
        try {
            Class<?> codecClass = Class.forName(codecClassName);
            codec = (CompressionCodec)ReflectionUtils.newInstance(codecClass, (Configuration)this.configuration);
            CODEC_BY_NAME.put(codecClassName, codec);
            return codec;
        }
        catch (ClassNotFoundException e) {
            throw new BadConfigurationException("Class " + codecClassName + " was not found", e);
        }
    }

    public void release() {
        for (BytesCompressor compressor : this.compressors.values()) {
            compressor.release();
        }
        this.compressors.clear();
        for (BytesDecompressor decompressor : this.decompressors.values()) {
            decompressor.release();
        }
        this.decompressors.clear();
    }

    public static abstract class BytesDecompressor {
        public abstract BytesInput decompress(BytesInput var1, int var2) throws IOException;

        public abstract void decompress(ByteBuffer var1, int var2, ByteBuffer var3, int var4) throws IOException;

        protected abstract void release();
    }

    public static abstract class BytesCompressor {
        public abstract BytesInput compress(BytesInput var1) throws IOException;

        public abstract CompressionCodecName getCodecName();

        protected abstract void release();
    }

    class HeapBytesCompressor
    extends BytesCompressor {
        private final CompressionCodec codec;
        private final Compressor compressor;
        private final ByteArrayOutputStream compressedOutBuffer;
        private final CompressionCodecName codecName;

        HeapBytesCompressor(CompressionCodecName codecName) {
            this.codecName = codecName;
            this.codec = CodecFactory.this.getCodec(codecName);
            if (this.codec != null) {
                this.compressor = CodecPool.getCompressor((CompressionCodec)this.codec);
                this.compressedOutBuffer = new ByteArrayOutputStream(CodecFactory.this.pageSize);
            } else {
                this.compressor = null;
                this.compressedOutBuffer = null;
            }
        }

        @Override
        public BytesInput compress(BytesInput bytes) throws IOException {
            BytesInput compressedBytes;
            if (this.codec == null) {
                compressedBytes = bytes;
            } else {
                this.compressedOutBuffer.reset();
                if (this.compressor != null) {
                    this.compressor.reset();
                }
                CompressionOutputStream cos = this.codec.createOutputStream((OutputStream)this.compressedOutBuffer, this.compressor);
                bytes.writeAllTo((OutputStream)cos);
                cos.finish();
                cos.close();
                compressedBytes = BytesInput.from((ByteArrayOutputStream)this.compressedOutBuffer);
            }
            return compressedBytes;
        }

        @Override
        protected void release() {
            if (this.compressor != null) {
                CodecPool.returnCompressor((Compressor)this.compressor);
            }
        }

        @Override
        public CompressionCodecName getCodecName() {
            return this.codecName;
        }
    }

    class HeapBytesDecompressor
    extends BytesDecompressor {
        private final CompressionCodec codec;
        private final Decompressor decompressor;

        HeapBytesDecompressor(CompressionCodecName codecName) {
            this.codec = CodecFactory.this.getCodec(codecName);
            this.decompressor = this.codec != null ? CodecPool.getDecompressor((CompressionCodec)this.codec) : null;
        }

        @Override
        public BytesInput decompress(BytesInput bytes, int uncompressedSize) throws IOException {
            BytesInput decompressed;
            if (this.codec != null) {
                this.decompressor.reset();
                CompressionInputStream is = this.codec.createInputStream(bytes.toInputStream(), this.decompressor);
                decompressed = BytesInput.from((InputStream)is, (int)uncompressedSize);
            } else {
                decompressed = bytes;
            }
            return decompressed;
        }

        @Override
        public void decompress(ByteBuffer input, int compressedSize, ByteBuffer output, int uncompressedSize) throws IOException {
            ByteBuffer decompressed = this.decompress(BytesInput.from((ByteBuffer)input, (int)0, (int)input.remaining()), uncompressedSize).toByteBuffer();
            output.put(decompressed);
        }

        @Override
        protected void release() {
            if (this.decompressor != null) {
                CodecPool.returnDecompressor((Decompressor)this.decompressor);
            }
        }
    }
}

