/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.tools.export;

import com.beust.jcommander.ParameterException;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPOutputStream;
import org.geotools.data.Query;
import org.geotools.factory.Hints;
import org.geotools.filter.text.ecql.ECQL;
import org.locationtech.geomesa.index.conf.QueryHints$;
import org.locationtech.geomesa.index.geoserver.ViewParams$;
import org.locationtech.geomesa.index.iterators.BinAggregatingScan$;
import org.locationtech.geomesa.index.planning.QueryRunner$;
import org.locationtech.geomesa.tools.OptionalIndexParam;
import org.locationtech.geomesa.tools.TypeNameParam;
import org.locationtech.geomesa.tools.export.ExportCommand;
import org.locationtech.geomesa.tools.export.ExportCommand$;
import org.locationtech.geomesa.tools.export.formats.ExportFormats$;
import org.locationtech.geomesa.tools.export.formats.ShapefileExporter$;
import org.locationtech.geomesa.utils.io.PathUtils$;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.IncludeFilter;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.mutable.Buffer;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.VolatileByteRef;

public final class ExportCommand$
implements LazyLogging {
    public static final ExportCommand$ MODULE$;
    private final Logger logger;
    private volatile boolean bitmap$0;

    static {
        new ExportCommand$();
    }

    private Logger logger$lzycompute() {
        ExportCommand$ exportCommand$ = this;
        synchronized (exportCommand$) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public Query createQuery(Function0<SimpleFeatureType> toSft, Enumeration.Value fmt, ExportCommand.ExportParams params) {
        Option option;
        block14: {
            Tuple2 tuple2;
            block15: {
                BoxedUnit boxedUnit;
                BoxedUnit boxedUnit2;
                String[] stringArray;
                Query query;
                Filter filter2;
                VolatileByteRef bitmap$0;
                ObjectRef sft$lzy;
                block10: {
                    String[] stringArray2;
                    block13: {
                        Tuple2 tuple22;
                        block12: {
                            Option provided;
                            block11: {
                                block9: {
                                    Object object;
                                    sft$lzy = ObjectRef.zero();
                                    bitmap$0 = VolatileByteRef.create((byte)0);
                                    String typeName = (String)Option$.MODULE$.apply((Object)params).collect((PartialFunction)new Serializable(){
                                        public static final long serialVersionUID = 0L;

                                        public final <A1 extends ExportCommand.ExportParams, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                                            Object object;
                                            A1 A1 = x1;
                                            if (A1 instanceof TypeNameParam) {
                                                A1 A12 = A1;
                                                object = ((TypeNameParam)((Object)A12)).featureName();
                                            } else {
                                                object = function1.apply(x1);
                                            }
                                            return (B1)object;
                                        }

                                        public final boolean isDefinedAt(ExportCommand.ExportParams x1) {
                                            ExportCommand.ExportParams exportParams = x1;
                                            boolean bl = exportParams instanceof TypeNameParam;
                                            return bl;
                                        }
                                    }).orNull(Predef$.MODULE$.$conforms());
                                    filter2 = (Filter)Option$.MODULE$.apply((Object)params.cqlFilter()).getOrElse((Function0)new Serializable(){
                                        public static final long serialVersionUID = 0L;

                                        public final IncludeFilter apply() {
                                            return Filter.INCLUDE;
                                        }
                                    });
                                    query = new Query(typeName, filter2);
                                    Option$.MODULE$.apply((Object)params.maxFeatures()).map((Function1)new Serializable(){
                                        public static final long serialVersionUID = 0L;

                                        public final int apply(Object x) {
                                            return BoxesRunTime.unboxToInt((Object)x);
                                        }
                                    }).foreach((Function1)new Serializable(query){
                                        public static final long serialVersionUID = 0L;
                                        private final Query query$2;

                                        public final void apply(int x$1) {
                                            this.apply$mcVI$sp(x$1);
                                        }

                                        public void apply$mcVI$sp(int x$1) {
                                            this.query$2.setMaxFeatures(x$1);
                                        }
                                        {
                                            this.query$2 = query$2;
                                        }
                                    });
                                    Option$.MODULE$.apply((Object)params).collect((PartialFunction)new Serializable(){
                                        public static final long serialVersionUID = 0L;

                                        public final <A1 extends ExportCommand.ExportParams, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                                            A1 A1;
                                            A1 A12 = x2;
                                            Object object = A12 instanceof OptionalIndexParam ? (A1 = A12) : function1.apply(x2);
                                            return (B1)object;
                                        }

                                        public final boolean isDefinedAt(ExportCommand.ExportParams x2) {
                                            ExportCommand.ExportParams exportParams = x2;
                                            boolean bl = exportParams instanceof OptionalIndexParam;
                                            return bl;
                                        }
                                    }).foreach((Function1)new Serializable(query){
                                        public static final long serialVersionUID = 0L;
                                        public final Query query$2;

                                        public final void apply(ExportCommand.ExportParams p) {
                                            Option$.MODULE$.apply((Object)((OptionalIndexParam)((Object)p)).index()).foreach((Function1)new Serializable(this){
                                                public static final long serialVersionUID = 0L;
                                                private final /* synthetic */ anonfun.createQuery.4 $outer;

                                                public final Object apply(String index) {
                                                    BoxedUnit boxedUnit;
                                                    if (ExportCommand$.MODULE$.logger().underlying().isDebugEnabled()) {
                                                        ExportCommand$.MODULE$.logger().underlying().debug("Using index {}", new Object[]{index});
                                                        boxedUnit = BoxedUnit.UNIT;
                                                    } else {
                                                        boxedUnit = BoxedUnit.UNIT;
                                                    }
                                                    return this.$outer.query$2.getHints().put((Object)QueryHints$.MODULE$.QUERY_INDEX(), (Object)index);
                                                }
                                                {
                                                    if ($outer == null) {
                                                        throw null;
                                                    }
                                                    this.$outer = $outer;
                                                }
                                            });
                                        }
                                        {
                                            this.query$2 = query$2;
                                        }
                                    });
                                    Option$.MODULE$.apply(params.hints()).foreach((Function1)new Serializable(query){
                                        public static final long serialVersionUID = 0L;
                                        private final Query query$2;

                                        public final void apply(Map<String, String> hints) {
                                            this.query$2.getHints().put((Object)Hints.VIRTUAL_TABLE_PARAMETERS, hints);
                                            ViewParams$.MODULE$.setHints(this.query$2);
                                        }
                                        {
                                            this.query$2 = query$2;
                                        }
                                    });
                                    Enumeration.Value value = fmt;
                                    Enumeration.Value value2 = ExportFormats$.MODULE$.Arrow();
                                    if (!(value != null ? !value.equals(value2) : value2 != null)) {
                                        object = query.getHints().put((Object)QueryHints$.MODULE$.ARROW_ENCODE(), (Object)Boolean.TRUE);
                                    } else {
                                        Enumeration.Value value3 = fmt;
                                        Enumeration.Value value4 = ExportFormats$.MODULE$.Bin();
                                        object = !(value3 != null ? !value3.equals(value4) : value4 != null) ? (query.getHints().containsKey((Object)QueryHints$.MODULE$.BIN_TRACK()) ? BoxedUnit.UNIT : query.getHints().put((Object)QueryHints$.MODULE$.BIN_TRACK(), (Object)"id")) : BoxedUnit.UNIT;
                                    }
                                    provided = Option$.MODULE$.apply(params.attributes()).collect((PartialFunction)new Serializable(){
                                        public static final long serialVersionUID = 0L;

                                        public final <A1 extends List<String>, B1> B1 applyOrElse(A1 x3, Function1<A1, B1> function1) {
                                            A1 A1 = x3;
                                            Object object = A1.isEmpty() ? function1.apply(x3) : JavaConverters$.MODULE$.asScalaBufferConverter(A1).asScala();
                                            return (B1)object;
                                        }

                                        public final boolean isDefinedAt(List<String> x3) {
                                            List<String> list = x3;
                                            boolean bl = !list.isEmpty();
                                            return bl;
                                        }
                                    });
                                    Enumeration.Value value5 = fmt;
                                    Enumeration.Value value6 = ExportFormats$.MODULE$.Bin();
                                    if (value5 != null ? !value5.equals(value6) : value6 != null) break block9;
                                    stringArray = (String[])((TraversableOnce)provided.getOrElse((Function0)new Serializable(toSft, sft$lzy, query, bitmap$0){
                                        public static final long serialVersionUID = 0L;
                                        private final Function0 toSft$1;
                                        private final ObjectRef sft$lzy$1;
                                        private final Query query$2;
                                        private final VolatileByteRef bitmap$0$1;

                                        public final Seq<String> apply() {
                                            return BinAggregatingScan$.MODULE$.propertyNames(this.query$2.getHints(), ExportCommand$.MODULE$.org$locationtech$geomesa$tools$export$ExportCommand$$sft$1(this.toSft$1, this.sft$lzy$1, this.bitmap$0$1));
                                        }
                                        {
                                            this.toSft$1 = toSft$1;
                                            this.sft$lzy$1 = sft$lzy$1;
                                            this.query$2 = query$2;
                                            this.bitmap$0$1 = bitmap$0$1;
                                        }
                                    })).toArray(ClassTag$.MODULE$.apply(String.class));
                                    break block10;
                                }
                                Enumeration.Value value = fmt;
                                Enumeration.Value value7 = ExportFormats$.MODULE$.Shp();
                                if (value != null ? !value.equals(value7) : value7 != null) break block11;
                                stringArray = (String[])((TraversableOnce)provided.map((Function1)new Serializable(toSft, sft$lzy, bitmap$0){
                                    public static final long serialVersionUID = 0L;
                                    private final Function0 toSft$1;
                                    private final ObjectRef sft$lzy$1;
                                    private final VolatileByteRef bitmap$0$1;

                                    public final Seq<String> apply(Buffer<String> x$2) {
                                        return ShapefileExporter$.MODULE$.replaceGeom(ExportCommand$.MODULE$.org$locationtech$geomesa$tools$export$ExportCommand$$sft$1(this.toSft$1, this.sft$lzy$1, this.bitmap$0$1), (Seq<String>)x$2);
                                    }
                                    {
                                        this.toSft$1 = toSft$1;
                                        this.sft$lzy$1 = sft$lzy$1;
                                        this.bitmap$0$1 = bitmap$0$1;
                                    }
                                }).getOrElse((Function0)new Serializable(toSft, sft$lzy, bitmap$0){
                                    public static final long serialVersionUID = 0L;
                                    private final Function0 toSft$1;
                                    private final ObjectRef sft$lzy$1;
                                    private final VolatileByteRef bitmap$0$1;

                                    public final Seq<String> apply() {
                                        return ShapefileExporter$.MODULE$.modifySchema(ExportCommand$.MODULE$.org$locationtech$geomesa$tools$export$ExportCommand$$sft$1(this.toSft$1, this.sft$lzy$1, this.bitmap$0$1));
                                    }
                                    {
                                        this.toSft$1 = toSft$1;
                                        this.sft$lzy$1 = sft$lzy$1;
                                        this.bitmap$0$1 = bitmap$0$1;
                                    }
                                })).toArray(ClassTag$.MODULE$.apply(String.class));
                                break block10;
                            }
                            option = provided;
                            if (!None$.MODULE$.equals(option)) break block12;
                            stringArray2 = null;
                            break block13;
                        }
                        if (!(option instanceof Some)) break block14;
                        Some some = (Some)option;
                        Buffer p = (Buffer)some.x();
                        tuple2 = p.partition((Function1)new Serializable(){
                            public static final long serialVersionUID = 0L;

                            public final boolean apply(String x$3) {
                                return x$3.equalsIgnoreCase("id");
                            }
                        });
                        if (tuple2 == null) break block15;
                        Buffer id = (Buffer)tuple2._1();
                        Buffer attributes = (Buffer)tuple2._2();
                        Tuple2 tuple23 = tuple22 = new Tuple2((Object)id, (Object)attributes);
                        Buffer id2 = (Buffer)tuple23._1();
                        Buffer attributes2 = (Buffer)tuple23._2();
                        Object object = id2.isEmpty() && !query.getHints().containsKey((Object)QueryHints$.MODULE$.ARROW_INCLUDE_FID()) ? query.getHints().put((Object)QueryHints$.MODULE$.ARROW_INCLUDE_FID(), (Object)Boolean.FALSE) : BoxedUnit.UNIT;
                        stringArray2 = (String[])attributes2.toArray(ClassTag$.MODULE$.apply(String.class));
                    }
                    stringArray = stringArray2;
                }
                String[] attributes = stringArray;
                query.setPropertyNames(attributes);
                if (this.logger().underlying().isDebugEnabled()) {
                    this.logger().underlying().debug("Applying CQL filter {}", new Object[]{ECQL.toCQL((Filter)filter2)});
                    boxedUnit2 = BoxedUnit.UNIT;
                } else {
                    boxedUnit2 = BoxedUnit.UNIT;
                }
                if (this.logger().underlying().isDebugEnabled()) {
                    this.logger().underlying().debug("Applying transform {}", new Object[]{Option$.MODULE$.apply((Object)attributes).map((Function1)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final String apply(String[] x$5) {
                            return Predef$.MODULE$.refArrayOps((Object[])x$5).mkString(",");
                        }
                    }).orNull(Predef$.MODULE$.$conforms())});
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                return QueryRunner$.MODULE$.configureDefaultQuery(this.org$locationtech$geomesa$tools$export$ExportCommand$$sft$1(toSft, sft$lzy, bitmap$0), query);
            }
            throw new MatchError((Object)tuple2);
        }
        throw new MatchError((Object)option);
    }

    public OutputStream createOutputStream(ExportCommand.ExportParams params) {
        PrintStream out = params.file() == null ? System.out : (PathUtils$.MODULE$.isRemote(params.file()) ? PathUtils$.MODULE$.getUrl(params.file()).openConnection().getOutputStream() : new FileOutputStream(new File(params.file())));
        FilterOutputStream compressed = params.gzip() == null ? out : new GZIPOutputStream(params, out){
            {
                this.def.setLevel(Predef$.MODULE$.Integer2int(params$2.gzip()));
            }
        };
        return new BufferedOutputStream(compressed);
    }

    public Writer createWriter(ExportCommand.ExportParams params) {
        return new OutputStreamWriter(this.createOutputStream(params));
    }

    public String ensureOutputFile(ExportCommand.ExportParams params, Enumeration.Value format) {
        if (params.file() == null) {
            throw new ParameterException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error: Output format '", "' requires file-based output, please use --output"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{format})));
        }
        return params.file();
    }

    public Enumeration.Value getOutputFormat(ExportCommand.ExportParams params) {
        return (Enumeration.Value)this.direct$1(params).orElse((Function0)new Serializable(params){
            public static final long serialVersionUID = 0L;
            private final ExportCommand.ExportParams params$1;

            public final Option<Enumeration.Value> apply() {
                return ExportCommand$.MODULE$.org$locationtech$geomesa$tools$export$ExportCommand$$file$1(this.params$1);
            }
            {
                this.params$1 = params$1;
            }
        }).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Enumeration.Value apply() {
                return ExportFormats$.MODULE$.Csv();
            }
        });
    }

    private final SimpleFeatureType sft$lzycompute$1(Function0 toSft$1, ObjectRef sft$lzy$1, VolatileByteRef bitmap$0$1) {
        ExportCommand$ exportCommand$ = this;
        synchronized (exportCommand$) {
            if ((byte)(bitmap$0$1.elem & 1) == 0) {
                sft$lzy$1.elem = (SimpleFeatureType)toSft$1.apply();
                bitmap$0$1.elem = (byte)(bitmap$0$1.elem | 1);
            }
            return (SimpleFeatureType)sft$lzy$1.elem;
        }
    }

    public final SimpleFeatureType org$locationtech$geomesa$tools$export$ExportCommand$$sft$1(Function0 toSft$1, ObjectRef sft$lzy$1, VolatileByteRef bitmap$0$1) {
        return (byte)(bitmap$0$1.elem & 1) == 0 ? this.sft$lzycompute$1(toSft$1, sft$lzy$1, bitmap$0$1) : (SimpleFeatureType)sft$lzy$1.elem;
    }

    private final Option direct$1(ExportCommand.ExportParams params$1) {
        return Option$.MODULE$.apply((Object)params$1.outputFormat());
    }

    public final Option org$locationtech$geomesa$tools$export$ExportCommand$$file$1(ExportCommand.ExportParams params$1) {
        return Option$.MODULE$.apply((Object)params$1.file()).flatMap((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Option<Enumeration.Value> apply(String f) {
                String ext = PathUtils$.MODULE$.getUncompressedExtension(f);
                return ExportFormats$.MODULE$.values().find((Function1)new Serializable(this, ext){
                    public static final long serialVersionUID = 0L;
                    private final String ext$1;

                    public final boolean apply(Enumeration.Value x$6) {
                        return x$6.toString().equalsIgnoreCase(this.ext$1);
                    }
                    {
                        this.ext$1 = ext$1;
                    }
                });
            }
        });
    }

    private ExportCommand$() {
        MODULE$ = this;
        LazyLogging.class.$init$((LazyLogging)this);
    }
}

