/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.fs.storage.common.metadata;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.sql.Connection;
import java.util.Properties;
import org.apache.commons.dbcp2.ConnectionFactory;
import org.apache.commons.dbcp2.DriverManagerConnectionFactory;
import org.apache.commons.dbcp2.PoolableConnection;
import org.apache.commons.dbcp2.PoolableConnectionFactory;
import org.apache.commons.dbcp2.PoolingDataSource;
import org.apache.commons.pool2.ObjectPool;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.locationtech.geomesa.fs.storage.common.metadata.JdbcMetadata$Config$;
import org.locationtech.geomesa.utils.io.WithClose$;
import org.locationtech.geomesa.utils.stats.MethodProfiling;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxedUnit;
import scala.runtime.Nothing$;
import scala.util.control.NonFatal$;

public final class JdbcMetadataFactory$
implements MethodProfiling {
    public static final JdbcMetadataFactory$ MODULE$;
    private final Logger logger;
    private volatile boolean bitmap$0;

    static {
        new JdbcMetadataFactory$();
    }

    public <R> R profile(Function1<Object, BoxedUnit> onComplete, Function0<R> code) {
        return (R)MethodProfiling.class.profile((MethodProfiling)this, onComplete, code);
    }

    public <R> R profile(Function2<R, Object, BoxedUnit> onComplete, Function0<R> code) {
        return (R)MethodProfiling.class.profile((MethodProfiling)this, onComplete, code);
    }

    public <R> R profile(String message, Function0<R> code) {
        return (R)MethodProfiling.class.profile((MethodProfiling)this, (String)message, code);
    }

    private Logger logger$lzycompute() {
        JdbcMetadataFactory$ jdbcMetadataFactory$ = this;
        synchronized (jdbcMetadataFactory$) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public PoolingDataSource<PoolableConnection> org$locationtech$geomesa$fs$storage$common$metadata$JdbcMetadataFactory$$createDataSource(Map<String, String> config) {
        String url = (String)config.getOrElse((Object)JdbcMetadata$Config$.MODULE$.UrlKey(), (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Nothing$ apply() {
                throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"JdbcMetadata requires '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{JdbcMetadata$Config$.MODULE$.UrlKey()})));
            }
        });
        config.get((Object)JdbcMetadata$Config$.MODULE$.DriverKey()).foreach((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Class<?> apply(String x$1) {
                return Class.forName(x$1);
            }
        });
        Properties props = new Properties();
        config.get((Object)JdbcMetadata$Config$.MODULE$.UserKey()).foreach((Function1)new Serializable(props){
            public static final long serialVersionUID = 0L;
            private final Properties props$1;

            public final Object apply(String x$1) {
                return this.props$1.put("user", x$1);
            }
            {
                this.props$1 = props$1;
            }
        });
        config.get((Object)JdbcMetadata$Config$.MODULE$.PasswordKey()).foreach((Function1)new Serializable(props){
            public static final long serialVersionUID = 0L;
            private final Properties props$1;

            public final Object apply(String x$2) {
                return this.props$1.put("password", x$2);
            }
            {
                this.props$1 = props$1;
            }
        });
        DriverManagerConnectionFactory driver = new DriverManagerConnectionFactory(url, props);
        WithClose$.MODULE$.apply((Object)driver.createConnection(), (Function1)new Serializable(config){
            public static final long serialVersionUID = 0L;
            private final Map config$1;

            public final void apply(Connection connection) {
                if (connection.isValid(10)) {
                    return;
                }
                throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not create valid connection using configuration ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.config$1.mkString(", ")})));
            }
            {
                this.config$1 = config$1;
            }
        });
        GenericObjectPoolConfig poolConfig = new GenericObjectPoolConfig();
        this.setPoolConfig$1(JdbcMetadata$Config$.MODULE$.MaxIdleKey(), (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(String x$3) {
                return new StringOps(Predef$.MODULE$.augmentString(x$3)).toInt();
            }
        }, (Function1)new Serializable(poolConfig){
            public static final long serialVersionUID = 0L;
            private final GenericObjectPoolConfig poolConfig$1;

            public final void apply(int x$1) {
                this.apply$mcVI$sp(x$1);
            }

            public void apply$mcVI$sp(int x$1) {
                this.poolConfig$1.setMaxIdle(x$1);
            }
            {
                this.poolConfig$1 = poolConfig$1;
            }
        }, config);
        this.setPoolConfig$1(JdbcMetadata$Config$.MODULE$.MinIdleKey(), (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(String x$4) {
                return new StringOps(Predef$.MODULE$.augmentString(x$4)).toInt();
            }
        }, (Function1)new Serializable(poolConfig){
            public static final long serialVersionUID = 0L;
            private final GenericObjectPoolConfig poolConfig$1;

            public final void apply(int x$1) {
                this.apply$mcVI$sp(x$1);
            }

            public void apply$mcVI$sp(int x$1) {
                this.poolConfig$1.setMinIdle(x$1);
            }
            {
                this.poolConfig$1 = poolConfig$1;
            }
        }, config);
        this.setPoolConfig$1(JdbcMetadata$Config$.MODULE$.MaxSizeKey(), (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(String x$5) {
                return new StringOps(Predef$.MODULE$.augmentString(x$5)).toInt();
            }
        }, (Function1)new Serializable(poolConfig){
            public static final long serialVersionUID = 0L;
            private final GenericObjectPoolConfig poolConfig$1;

            public final void apply(int x$1) {
                this.apply$mcVI$sp(x$1);
            }

            public void apply$mcVI$sp(int x$1) {
                this.poolConfig$1.setMaxTotal(x$1);
            }
            {
                this.poolConfig$1 = poolConfig$1;
            }
        }, config);
        this.setPoolConfig$1(JdbcMetadata$Config$.MODULE$.FairnessKey(), (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String x$6) {
                return new StringOps(Predef$.MODULE$.augmentString(x$6)).toBoolean();
            }
        }, (Function1)new Serializable(poolConfig){
            public static final long serialVersionUID = 0L;
            private final GenericObjectPoolConfig poolConfig$1;

            public final void apply(boolean x$1) {
                this.poolConfig$1.setFairness(x$1);
            }
            {
                this.poolConfig$1 = poolConfig$1;
            }
        }, config);
        this.setPoolConfig$1(JdbcMetadata$Config$.MODULE$.TestOnBorrowKey(), (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String x$7) {
                return new StringOps(Predef$.MODULE$.augmentString(x$7)).toBoolean();
            }
        }, (Function1)new Serializable(poolConfig){
            public static final long serialVersionUID = 0L;
            private final GenericObjectPoolConfig poolConfig$1;

            public final void apply(boolean x$1) {
                this.poolConfig$1.setTestOnBorrow(x$1);
            }
            {
                this.poolConfig$1 = poolConfig$1;
            }
        }, config);
        this.setPoolConfig$1(JdbcMetadata$Config$.MODULE$.TestOnCreateKey(), (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String x$8) {
                return new StringOps(Predef$.MODULE$.augmentString(x$8)).toBoolean();
            }
        }, (Function1)new Serializable(poolConfig){
            public static final long serialVersionUID = 0L;
            private final GenericObjectPoolConfig poolConfig$1;

            public final void apply(boolean x$1) {
                this.poolConfig$1.setTestOnCreate(x$1);
            }
            {
                this.poolConfig$1 = poolConfig$1;
            }
        }, config);
        this.setPoolConfig$1(JdbcMetadata$Config$.MODULE$.TestWhileIdlKey(), (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String x$9) {
                return new StringOps(Predef$.MODULE$.augmentString(x$9)).toBoolean();
            }
        }, (Function1)new Serializable(poolConfig){
            public static final long serialVersionUID = 0L;
            private final GenericObjectPoolConfig poolConfig$1;

            public final void apply(boolean x$1) {
                this.poolConfig$1.setTestWhileIdle(x$1);
            }
            {
                this.poolConfig$1 = poolConfig$1;
            }
        }, config);
        PoolableConnectionFactory factory = new PoolableConnectionFactory((ConnectionFactory)driver, null);
        GenericObjectPool pool = new GenericObjectPool((PooledObjectFactory)factory, poolConfig);
        factory.setPool((ObjectPool)pool);
        return new PoolingDataSource((ObjectPool)pool);
    }

    private final void setPoolConfig$1(String key2, Function1 conversion, Function1 method, Map config$1) {
        config$1.get((Object)key2).foreach((Function1)new Serializable(key2, conversion, method){
            public static final long serialVersionUID = 0L;
            private final String key$1;
            private final Function1 conversion$1;
            private final Function1 method$1;

            public final void apply(String v) {
                try {
                    this.method$1.apply(this.conversion$1.apply((Object)v));
                }
                catch (Throwable throwable) {
                    BoxedUnit boxedUnit;
                    Throwable throwable2 = throwable;
                    Option option = NonFatal$.MODULE$.unapply(throwable2);
                    if (option.isEmpty()) {
                        throw throwable;
                    }
                    Throwable e = (Throwable)option.get();
                    if (JdbcMetadataFactory$.MODULE$.logger().underlying().isWarnEnabled()) {
                        JdbcMetadataFactory$.MODULE$.logger().underlying().warn("Invalid configuration value '{}' for key {}: {}", new Object[]{v, this.key$1, e});
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    BoxedUnit boxedUnit2 = boxedUnit;
                }
            }
            {
                this.key$1 = key$1;
                this.conversion$1 = conversion$1;
                this.method$1 = method$1;
            }
        });
    }

    private JdbcMetadataFactory$() {
        MODULE$ = this;
        LazyLogging.class.$init$((LazyLogging)this);
        MethodProfiling.class.$init$((MethodProfiling)this);
    }
}

