/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.fs.storage.common.metadata;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigParseOptions;
import com.typesafe.config.ConfigValue;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.EnumSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.Path;
import org.locationtech.geomesa.fs.storage.api.StorageMetadata;
import org.locationtech.geomesa.fs.storage.api.package;
import org.locationtech.geomesa.fs.storage.common.metadata.FileBasedMetadata$;
import org.locationtech.geomesa.fs.storage.common.metadata.FileBasedMetadataFactory;
import org.locationtech.geomesa.fs.storage.common.metadata.MetadataJson$;
import org.locationtech.geomesa.fs.storage.common.package$;
import org.locationtech.geomesa.fs.storage.common.utils.PathCache$;
import org.locationtech.geomesa.utils.geotools.SimpleFeatureTypes$;
import org.locationtech.geomesa.utils.io.WithClose$;
import org.locationtech.geomesa.utils.stats.MethodProfiling;
import org.opengis.feature.simple.SimpleFeatureType;
import pureconfig.ConfigReader;
import pureconfig.ConfigReader$;
import pureconfig.ConfigWriter;
import pureconfig.ConfigWriter$;
import pureconfig.Derivation;
import pureconfig.DerivedReaders1;
import pureconfig.DerivedWriters1;
import pureconfig.ProductHint$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Symbol;
import scala.Symbol$;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.SetLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Set$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.ObjectRef;
import scala.util.control.NonFatal$;
import shapeless.;
import shapeless.Default;
import shapeless.Default$;
import shapeless.DefaultSymbolicLabelling;
import shapeless.Generic;
import shapeless.HList;
import shapeless.HNil;
import shapeless.HNil$;
import shapeless.LabelledGeneric$;
import shapeless.Lazy$;
import shapeless.Witness$;
import shapeless.ops.hlist;

public final class MetadataJson$
implements MethodProfiling {
    public static final MetadataJson$ MODULE$;
    private final String MetadataPath;
    private final ConcurrentHashMap<String, package.NamedOptions> cache;
    private final Logger logger;
    private volatile boolean bitmap$0;

    static {
        new MetadataJson$();
    }

    public <R> R profile(Function1<Object, BoxedUnit> onComplete, Function0<R> code) {
        return (R)MethodProfiling.class.profile((MethodProfiling)this, onComplete, code);
    }

    public <R> R profile(Function2<R, Object, BoxedUnit> onComplete, Function0<R> code) {
        return (R)MethodProfiling.class.profile((MethodProfiling)this, onComplete, code);
    }

    public <R> R profile(String message, Function0<R> code) {
        return (R)MethodProfiling.class.profile((MethodProfiling)this, (String)message, code);
    }

    private Logger logger$lzycompute() {
        MetadataJson$ metadataJson$ = this;
        synchronized (metadataJson$) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    private String MetadataPath() {
        return this.MetadataPath;
    }

    private ConcurrentHashMap<String, package.NamedOptions> cache() {
        return this.cache;
    }

    public Option<package.NamedOptions> readMetadata(package.FileSystemContext context) {
        BoxedUnit boxedUnit;
        String key2 = context.root().toUri().toString();
        ObjectRef cached = ObjectRef.create((Object)this.cache().get(key2));
        if ((package.NamedOptions)cached.elem == null) {
            Path file = new Path(context.root(), this.MetadataPath());
            if (PathCache$.MODULE$.exists(context.fc(), file, PathCache$.MODULE$.exists$default$3())) {
                Config config = (Config)this.profile("Loaded metadata configuration", (Function0)new Serializable(context, file){
                    public static final long serialVersionUID = 0L;
                    private final package.FileSystemContext context$1;
                    private final Path file$1;

                    public final Config apply() {
                        return (Config)WithClose$.MODULE$.apply((Object)new InputStreamReader((InputStream)this.context$1.fc().open(this.file$1), StandardCharsets.UTF_8), (Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final Config apply(InputStreamReader in) {
                                return ConfigFactory.parseReader((Reader)in, (ConfigParseOptions)package$.MODULE$.ParseOptions());
                            }
                        });
                    }
                    {
                        this.context$1 = context$1;
                        this.file$1 = file$1;
                    }
                });
                if (config.hasPath("name")) {
                    cached.elem = (package.NamedOptions)this.profile("Parsed metadata configuration", (Function0)new Serializable(config){
                        public static final long serialVersionUID = 0L;
                        private final Config config$1;
                        private static Symbol symbol$1;
                        private static Symbol symbol$2;

                        static {
                            symbol$1 = Symbol$.MODULE$.apply("options");
                            symbol$2 = Symbol$.MODULE$.apply("name");
                        }

                        public final package.NamedOptions apply() {
                            public final class Org_locationtech_geomesa_fs_storage_common_metadata_MetadataJson$$anonfun$readMetadata$1$anon$deriveProductInstance$macro$285$1
                            implements Serializable {
                                private ConfigReader<String> inst$macro$281;
                                private Object inst$macro$283;
                                private DerivedReaders1.WrappedDefaultValue<package.NamedOptions, HNil, HNil> inst$macro$284;
                                private DerivedReaders1.WrappedDefaultValue<package.NamedOptions, .colon.colon<Map<String, String>, HNil>, .colon.colon<Option<Map<String, String>>, HNil>> inst$macro$282;
                                private DerivedReaders1.WrappedDefaultValue<package.NamedOptions, .colon.colon<String, .colon.colon<Map<String, String>, HNil>>, .colon.colon<Option<String>, .colon.colon<Option<Map<String, String>>, HNil>>> inst$macro$280;
                                private volatile byte bitmap$0;
                                private static Symbol symbol$5;
                                private static Symbol symbol$6;

                                static {
                                    symbol$5 = Symbol$.MODULE$.apply("options");
                                    symbol$6 = Symbol$.MODULE$.apply("name");
                                }

                                private ConfigReader inst$macro$281$lzycompute() {
                                    Org_locationtech_geomesa_fs_storage_common_metadata_MetadataJson$$anonfun$readMetadata$1$anon$deriveProductInstance$macro$285$1 var1_1 = this;
                                    synchronized (var1_1) {
                                        if ((byte)(this.bitmap$0 & 1) == 0) {
                                            this.inst$macro$281 = ConfigReader$.MODULE$.stringConfigReader();
                                            this.bitmap$0 = (byte)(this.bitmap$0 | 1);
                                        }
                                        return this.inst$macro$281;
                                    }
                                }

                                private ConfigReader inst$macro$283$lzycompute() {
                                    Org_locationtech_geomesa_fs_storage_common_metadata_MetadataJson$$anonfun$readMetadata$1$anon$deriveProductInstance$macro$285$1 var1_1 = this;
                                    synchronized (var1_1) {
                                        if ((byte)(this.bitmap$0 & 2) == 0) {
                                            this.inst$macro$283 = ConfigReader$.MODULE$.deriveMap((Derivation)new Derivation.Successful(Predef$.MODULE$.implicitly((Object)Lazy$.MODULE$.apply((Function0)new Serializable(this){
                                                public static final long serialVersionUID = 0L;
                                                private final /* synthetic */ Org_locationtech_geomesa_fs_storage_common_metadata_MetadataJson$$anonfun$readMetadata$1$anon$deriveProductInstance$macro$285$1 $outer;

                                                public final ConfigReader<String> apply() {
                                                    return this.$outer.inst$macro$281();
                                                }
                                                {
                                                    if ($outer == null) {
                                                        throw null;
                                                    }
                                                    this.$outer = $outer;
                                                }
                                            }))));
                                            this.bitmap$0 = (byte)(this.bitmap$0 | 2);
                                        }
                                        return this.inst$macro$283;
                                    }
                                }

                                private DerivedReaders1.WrappedDefaultValue inst$macro$284$lzycompute() {
                                    Org_locationtech_geomesa_fs_storage_common_metadata_MetadataJson$$anonfun$readMetadata$1$anon$deriveProductInstance$macro$285$1 var1_1 = this;
                                    synchronized (var1_1) {
                                        if ((byte)(this.bitmap$0 & 4) == 0) {
                                            this.inst$macro$284 = ConfigReader$.MODULE$.labelledHNilConfigReader(ProductHint$.MODULE$.default());
                                            this.bitmap$0 = (byte)(this.bitmap$0 | 4);
                                        }
                                        return this.inst$macro$284;
                                    }
                                }

                                private DerivedReaders1.WrappedDefaultValue inst$macro$282$lzycompute() {
                                    Org_locationtech_geomesa_fs_storage_common_metadata_MetadataJson$$anonfun$readMetadata$1$anon$deriveProductInstance$macro$285$1 var1_1 = this;
                                    synchronized (var1_1) {
                                        if ((byte)(this.bitmap$0 & 8) == 0) {
                                            this.inst$macro$282 = ConfigReader$.MODULE$.labelledHConsConfigReader(Witness$.MODULE$.mkWitness((Object)symbol$5), (Derivation)new Derivation.Successful(Predef$.MODULE$.implicitly((Object)Lazy$.MODULE$.apply((Function0)new Serializable(this){
                                                public static final long serialVersionUID = 0L;
                                                private final /* synthetic */ Org_locationtech_geomesa_fs_storage_common_metadata_MetadataJson$$anonfun$readMetadata$1$anon$deriveProductInstance$macro$285$1 $outer;

                                                public final Object apply() {
                                                    return this.$outer.inst$macro$283();
                                                }
                                                {
                                                    if ($outer == null) {
                                                        throw null;
                                                    }
                                                    this.$outer = $outer;
                                                }
                                            }))), Lazy$.MODULE$.apply((Function0)new Serializable(this){
                                                public static final long serialVersionUID = 0L;
                                                private final /* synthetic */ Org_locationtech_geomesa_fs_storage_common_metadata_MetadataJson$$anonfun$readMetadata$1$anon$deriveProductInstance$macro$285$1 $outer;

                                                public final DerivedReaders1.WrappedDefaultValue<package.NamedOptions, HNil, HNil> apply() {
                                                    return this.$outer.inst$macro$284();
                                                }
                                                {
                                                    if ($outer == null) {
                                                        throw null;
                                                    }
                                                    this.$outer = $outer;
                                                }
                                            }), ProductHint$.MODULE$.default());
                                            this.bitmap$0 = (byte)(this.bitmap$0 | 8);
                                        }
                                        return this.inst$macro$282;
                                    }
                                }

                                private DerivedReaders1.WrappedDefaultValue inst$macro$280$lzycompute() {
                                    Org_locationtech_geomesa_fs_storage_common_metadata_MetadataJson$$anonfun$readMetadata$1$anon$deriveProductInstance$macro$285$1 var1_1 = this;
                                    synchronized (var1_1) {
                                        if ((byte)(this.bitmap$0 & 0x10) == 0) {
                                            this.inst$macro$280 = ConfigReader$.MODULE$.labelledHConsConfigReader(Witness$.MODULE$.mkWitness((Object)symbol$6), (Derivation)new Derivation.Successful(Predef$.MODULE$.implicitly((Object)Lazy$.MODULE$.apply((Function0)new Serializable(this){
                                                public static final long serialVersionUID = 0L;
                                                private final /* synthetic */ Org_locationtech_geomesa_fs_storage_common_metadata_MetadataJson$$anonfun$readMetadata$1$anon$deriveProductInstance$macro$285$1 $outer;

                                                public final ConfigReader<String> apply() {
                                                    return this.$outer.inst$macro$281();
                                                }
                                                {
                                                    if ($outer == null) {
                                                        throw null;
                                                    }
                                                    this.$outer = $outer;
                                                }
                                            }))), Lazy$.MODULE$.apply((Function0)new Serializable(this){
                                                public static final long serialVersionUID = 0L;
                                                private final /* synthetic */ Org_locationtech_geomesa_fs_storage_common_metadata_MetadataJson$$anonfun$readMetadata$1$anon$deriveProductInstance$macro$285$1 $outer;

                                                public final DerivedReaders1.WrappedDefaultValue<package.NamedOptions, .colon.colon<Map<String, String>, HNil>, .colon.colon<Option<Map<String, String>>, HNil>> apply() {
                                                    return this.$outer.inst$macro$282();
                                                }
                                                {
                                                    if ($outer == null) {
                                                        throw null;
                                                    }
                                                    this.$outer = $outer;
                                                }
                                            }), ProductHint$.MODULE$.default());
                                            this.bitmap$0 = (byte)(this.bitmap$0 | 0x10);
                                        }
                                        return this.inst$macro$280;
                                    }
                                }

                                public ConfigReader<String> inst$macro$281() {
                                    return (byte)(this.bitmap$0 & 1) == 0 ? this.inst$macro$281$lzycompute() : this.inst$macro$281;
                                }

                                public Object inst$macro$283() {
                                    return (byte)(this.bitmap$0 & 2) == 0 ? this.inst$macro$283$lzycompute() : this.inst$macro$283;
                                }

                                public DerivedReaders1.WrappedDefaultValue<package.NamedOptions, HNil, HNil> inst$macro$284() {
                                    return (byte)(this.bitmap$0 & 4) == 0 ? this.inst$macro$284$lzycompute() : this.inst$macro$284;
                                }

                                public DerivedReaders1.WrappedDefaultValue<package.NamedOptions, .colon.colon<Map<String, String>, HNil>, .colon.colon<Option<Map<String, String>>, HNil>> inst$macro$282() {
                                    return (byte)(this.bitmap$0 & 8) == 0 ? this.inst$macro$282$lzycompute() : this.inst$macro$282;
                                }

                                public DerivedReaders1.WrappedDefaultValue<package.NamedOptions, .colon.colon<String, .colon.colon<Map<String, String>, HNil>>, .colon.colon<Option<String>, .colon.colon<Option<Map<String, String>>, HNil>>> inst$macro$280() {
                                    return (byte)(this.bitmap$0 & 0x10) == 0 ? this.inst$macro$280$lzycompute() : this.inst$macro$280;
                                }

                                public Org_locationtech_geomesa_fs_storage_common_metadata_MetadataJson$$anonfun$readMetadata$1$anon$deriveProductInstance$macro$285$1(anonfun.readMetadata.1 $outer) {
                                }
                            }
                            DerivedReaders1.WrappedDefaultValue<package.NamedOptions, .colon.colon<String, .colon.colon<Map<String, String>, HNil>>, .colon.colon<Option<String>, .colon.colon<Option<Map<String, String>>, HNil>>> inst$macro$286 = new Org_locationtech_geomesa_fs_storage_common_metadata_MetadataJson$$anonfun$readMetadata$1$anon$deriveProductInstance$macro$285$1(this).inst$macro$280();
                            public final class Org_locationtech_geomesa_fs_storage_common_metadata_MetadataJson$$anonfun$readMetadata$1$anon$macro$273$1
                            implements Generic<package.NamedOptions> {
                                public .colon.colon<String, .colon.colon<Map<String, String>, HNil>> to(package.NamedOptions p) {
                                    package.NamedOptions namedOptions = p;
                                    if (namedOptions != null) {
                                        String pat$macro$271 = namedOptions.name();
                                        Map pat$macro$272 = namedOptions.options();
                                        .colon.colon colon2 = new .colon.colon((Object)pat$macro$271, (HList)new .colon.colon((Object)pat$macro$272, (HList)HNil$.MODULE$));
                                        return colon2;
                                    }
                                    throw new MatchError((Object)namedOptions);
                                }

                                public package.NamedOptions from(.colon.colon<String, .colon.colon<Map<String, String>, HNil>> p) {
                                    .colon.colon<String, .colon.colon<Map<String, String>, HNil>> colon2 = p;
                                    if (colon2 != null) {
                                        String pat$macro$271 = (String)colon2.head();
                                        .colon.colon colon3 = (.colon.colon)colon2.tail();
                                        if (colon3 != null) {
                                            Map pat$macro$272 = (Map)colon3.head();
                                            HNil hNil = (HNil)colon3.tail();
                                            if (HNil$.MODULE$.equals(hNil)) {
                                                package.NamedOptions namedOptions = new package.NamedOptions(pat$macro$271, pat$macro$272);
                                                return namedOptions;
                                            }
                                        }
                                    }
                                    throw new MatchError(colon2);
                                }

                                public Org_locationtech_geomesa_fs_storage_common_metadata_MetadataJson$$anonfun$readMetadata$1$anon$macro$273$1(anonfun.readMetadata.1 $outer) {
                                }
                            }
                            public final class Org_locationtech_geomesa_fs_storage_common_metadata_MetadataJson$$anonfun$readMetadata$1$anon$macro$279$1
                            implements Generic<package.NamedOptions> {
                                public .colon.colon<String, .colon.colon<Map<String, String>, HNil>> to(package.NamedOptions p) {
                                    package.NamedOptions namedOptions = p;
                                    if (namedOptions != null) {
                                        String pat$macro$277 = namedOptions.name();
                                        Map pat$macro$278 = namedOptions.options();
                                        .colon.colon colon2 = new .colon.colon((Object)pat$macro$277, (HList)new .colon.colon((Object)pat$macro$278, (HList)HNil$.MODULE$));
                                        return colon2;
                                    }
                                    throw new MatchError((Object)namedOptions);
                                }

                                public package.NamedOptions from(.colon.colon<String, .colon.colon<Map<String, String>, HNil>> p) {
                                    .colon.colon<String, .colon.colon<Map<String, String>, HNil>> colon2 = p;
                                    if (colon2 != null) {
                                        String pat$macro$277 = (String)colon2.head();
                                        .colon.colon colon3 = (.colon.colon)colon2.tail();
                                        if (colon3 != null) {
                                            Map pat$macro$278 = (Map)colon3.head();
                                            HNil hNil = (HNil)colon3.tail();
                                            if (HNil$.MODULE$.equals(hNil)) {
                                                package.NamedOptions namedOptions = new package.NamedOptions(pat$macro$277, pat$macro$278);
                                                return namedOptions;
                                            }
                                        }
                                    }
                                    throw new MatchError(colon2);
                                }

                                public Org_locationtech_geomesa_fs_storage_common_metadata_MetadataJson$$anonfun$readMetadata$1$anon$macro$279$1(anonfun.readMetadata.1 $outer) {
                                }
                            }
                            return (package.NamedOptions)pureconfig.package$.MODULE$.loadConfigOrThrow(this.config$1, ClassTag$.MODULE$.apply(package.NamedOptions.class), (Derivation)new Derivation.Successful(Predef$.MODULE$.implicitly((Object)ConfigReader$.MODULE$.deriveProductInstance(LabelledGeneric$.MODULE$.materializeProduct((DefaultSymbolicLabelling)new DefaultSymbolicLabelling<package.NamedOptions>(this){
                                private static Symbol symbol$3;
                                private static Symbol symbol$4;

                                static {
                                    symbol$3 = Symbol$.MODULE$.apply("name");
                                    symbol$4 = Symbol$.MODULE$.apply("options");
                                }

                                public .colon.colon<Symbol, .colon.colon<Symbol, HNil>> apply() {
                                    return new .colon.colon((Object)symbol$3, (HList)new .colon.colon((Object)symbol$4, (HList)HNil$.MODULE$));
                                }
                            }, (Generic)new Org_locationtech_geomesa_fs_storage_common_metadata_MetadataJson$$anonfun$readMetadata$1$anon$macro$273$1(this), hlist.ZipWithKeys$.MODULE$.hconsZipWithKeys(hlist.ZipWithKeys$.MODULE$.hconsZipWithKeys(hlist.ZipWithKeys$.MODULE$.hnilZipWithKeys(), Witness$.MODULE$.mkWitness((Object)symbol$1)), Witness$.MODULE$.mkWitness((Object)symbol$2)), Predef$.MODULE$.$conforms()), Default.AsOptions$.MODULE$.asOption(Default$.MODULE$.mkDefault((HList)new .colon.colon((Object)None$.MODULE$, (HList)new .colon.colon((Object)new Some((Object)package.NamedOptions$.MODULE$.apply$default$2()), (HList)HNil$.MODULE$))), (Generic)new Org_locationtech_geomesa_fs_storage_common_metadata_MetadataJson$$anonfun$readMetadata$1$anon$macro$279$1(this), Default.AsOptions$.Helper$.MODULE$.hconsNoneHelper(Default.AsOptions$.Helper$.MODULE$.hconsSomeHelper(Default.AsOptions$.Helper$.MODULE$.hnilHelper()))), Lazy$.MODULE$.apply((Function0)new Serializable(this, inst$macro$286){
                                public static final long serialVersionUID = 0L;
                                private final DerivedReaders1.WrappedDefaultValue inst$macro$286$1;

                                public final DerivedReaders1.WrappedDefaultValue<package.NamedOptions, .colon.colon<String, .colon.colon<Map<String, String>, HNil>>, .colon.colon<Option<String>, .colon.colon<Option<Map<String, String>>, HNil>>> apply() {
                                    return this.inst$macro$286$1;
                                }
                                {
                                    this.inst$macro$286$1 = inst$macro$286$1;
                                }
                            })))));
                        }
                        {
                            this.config$1 = config$1;
                        }
                    });
                    boxedUnit = this.cache().put(key2, (package.NamedOptions)cached.elem);
                } else {
                    context.fc().rename(file, new Path(context.root(), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".bak"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.MetadataPath()}))), new Options.Rename[0]);
                    PathCache$.MODULE$.invalidate(context.fc(), file);
                    this.transitionMetadata(context, config).foreach((Function1)new Serializable(cached){
                        public static final long serialVersionUID = 0L;
                        private final ObjectRef cached$1;

                        public final void apply(package.NamedOptions meta) {
                            this.cached$1.elem = meta;
                        }
                        {
                            this.cached$1 = cached$1;
                        }
                    });
                    boxedUnit = BoxedUnit.UNIT;
                }
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return Option$.MODULE$.apply((Object)((package.NamedOptions)cached.elem));
    }

    public void writeMetadata(package.FileSystemContext context, package.NamedOptions metadata) {
        Path file = new Path(context.root(), this.MetadataPath());
        if (PathCache$.MODULE$.exists(context.fc(), file, true)) {
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Trying to create a new storage instance but metadata already exists at '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{file})));
        }
        String data = (String)this.profile("Serialized metadata configuration", (Function0)new Serializable(metadata){
            public static final long serialVersionUID = 0L;
            private final package.NamedOptions metadata$1;
            private static Symbol symbol$7;
            private static Symbol symbol$8;

            static {
                symbol$7 = Symbol$.MODULE$.apply("options");
                symbol$8 = Symbol$.MODULE$.apply("name");
            }

            public final String apply() {
                public final class Org_locationtech_geomesa_fs_storage_common_metadata_MetadataJson$$anonfun$2$anon$deriveLabelledGenericInstance$macro$304$1
                implements Serializable {
                    private ConfigWriter<String> inst$macro$300;
                    private Object inst$macro$302;
                    private DerivedWriters1.WrappedConfigWriter<package.NamedOptions, HNil> inst$macro$303;
                    private DerivedWriters1.WrappedConfigWriter<package.NamedOptions, .colon.colon<Map<String, String>, HNil>> inst$macro$301;
                    private DerivedWriters1.WrappedConfigWriter<package.NamedOptions, .colon.colon<String, .colon.colon<Map<String, String>, HNil>>> inst$macro$299;
                    private volatile byte bitmap$0;
                    private static Symbol symbol$11;
                    private static Symbol symbol$12;

                    static {
                        symbol$11 = Symbol$.MODULE$.apply("options");
                        symbol$12 = Symbol$.MODULE$.apply("name");
                    }

                    private ConfigWriter inst$macro$300$lzycompute() {
                        Org_locationtech_geomesa_fs_storage_common_metadata_MetadataJson$$anonfun$2$anon$deriveLabelledGenericInstance$macro$304$1 var1_1 = this;
                        synchronized (var1_1) {
                            if ((byte)(this.bitmap$0 & 1) == 0) {
                                this.inst$macro$300 = ConfigWriter$.MODULE$.stringConfigWriter();
                                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
                            }
                            return this.inst$macro$300;
                        }
                    }

                    private ConfigWriter inst$macro$302$lzycompute() {
                        Org_locationtech_geomesa_fs_storage_common_metadata_MetadataJson$$anonfun$2$anon$deriveLabelledGenericInstance$macro$304$1 var1_1 = this;
                        synchronized (var1_1) {
                            if ((byte)(this.bitmap$0 & 2) == 0) {
                                this.inst$macro$302 = ConfigWriter$.MODULE$.deriveMap((Derivation)new Derivation.Successful(Predef$.MODULE$.implicitly((Object)Lazy$.MODULE$.apply((Function0)new Serializable(this){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ Org_locationtech_geomesa_fs_storage_common_metadata_MetadataJson$$anonfun$2$anon$deriveLabelledGenericInstance$macro$304$1 $outer;

                                    public final ConfigWriter<String> apply() {
                                        return this.$outer.inst$macro$300();
                                    }
                                    {
                                        if ($outer == null) {
                                            throw null;
                                        }
                                        this.$outer = $outer;
                                    }
                                }))));
                                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
                            }
                            return this.inst$macro$302;
                        }
                    }

                    private DerivedWriters1.WrappedConfigWriter inst$macro$303$lzycompute() {
                        Org_locationtech_geomesa_fs_storage_common_metadata_MetadataJson$$anonfun$2$anon$deriveLabelledGenericInstance$macro$304$1 var1_1 = this;
                        synchronized (var1_1) {
                            if ((byte)(this.bitmap$0 & 4) == 0) {
                                this.inst$macro$303 = ConfigWriter$.MODULE$.labelledHNilConfigWriter();
                                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
                            }
                            return this.inst$macro$303;
                        }
                    }

                    private DerivedWriters1.WrappedConfigWriter inst$macro$301$lzycompute() {
                        Org_locationtech_geomesa_fs_storage_common_metadata_MetadataJson$$anonfun$2$anon$deriveLabelledGenericInstance$macro$304$1 var1_1 = this;
                        synchronized (var1_1) {
                            if ((byte)(this.bitmap$0 & 8) == 0) {
                                this.inst$macro$301 = ConfigWriter$.MODULE$.labelledHConsConfigWriter(Witness$.MODULE$.mkWitness((Object)symbol$11), (Derivation)new Derivation.Successful(Predef$.MODULE$.implicitly((Object)Lazy$.MODULE$.apply((Function0)new Serializable(this){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ Org_locationtech_geomesa_fs_storage_common_metadata_MetadataJson$$anonfun$2$anon$deriveLabelledGenericInstance$macro$304$1 $outer;

                                    public final Object apply() {
                                        return this.$outer.inst$macro$302();
                                    }
                                    {
                                        if ($outer == null) {
                                            throw null;
                                        }
                                        this.$outer = $outer;
                                    }
                                }))), Lazy$.MODULE$.apply((Function0)new Serializable(this){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ Org_locationtech_geomesa_fs_storage_common_metadata_MetadataJson$$anonfun$2$anon$deriveLabelledGenericInstance$macro$304$1 $outer;

                                    public final DerivedWriters1.WrappedConfigWriter<package.NamedOptions, HNil> apply() {
                                        return this.$outer.inst$macro$303();
                                    }
                                    {
                                        if ($outer == null) {
                                            throw null;
                                        }
                                        this.$outer = $outer;
                                    }
                                }), ProductHint$.MODULE$.default());
                                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
                            }
                            return this.inst$macro$301;
                        }
                    }

                    private DerivedWriters1.WrappedConfigWriter inst$macro$299$lzycompute() {
                        Org_locationtech_geomesa_fs_storage_common_metadata_MetadataJson$$anonfun$2$anon$deriveLabelledGenericInstance$macro$304$1 var1_1 = this;
                        synchronized (var1_1) {
                            if ((byte)(this.bitmap$0 & 0x10) == 0) {
                                this.inst$macro$299 = ConfigWriter$.MODULE$.labelledHConsConfigWriter(Witness$.MODULE$.mkWitness((Object)symbol$12), (Derivation)new Derivation.Successful(Predef$.MODULE$.implicitly((Object)Lazy$.MODULE$.apply((Function0)new Serializable(this){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ Org_locationtech_geomesa_fs_storage_common_metadata_MetadataJson$$anonfun$2$anon$deriveLabelledGenericInstance$macro$304$1 $outer;

                                    public final ConfigWriter<String> apply() {
                                        return this.$outer.inst$macro$300();
                                    }
                                    {
                                        if ($outer == null) {
                                            throw null;
                                        }
                                        this.$outer = $outer;
                                    }
                                }))), Lazy$.MODULE$.apply((Function0)new Serializable(this){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ Org_locationtech_geomesa_fs_storage_common_metadata_MetadataJson$$anonfun$2$anon$deriveLabelledGenericInstance$macro$304$1 $outer;

                                    public final DerivedWriters1.WrappedConfigWriter<package.NamedOptions, .colon.colon<Map<String, String>, HNil>> apply() {
                                        return this.$outer.inst$macro$301();
                                    }
                                    {
                                        if ($outer == null) {
                                            throw null;
                                        }
                                        this.$outer = $outer;
                                    }
                                }), ProductHint$.MODULE$.default());
                                this.bitmap$0 = (byte)(this.bitmap$0 | 0x10);
                            }
                            return this.inst$macro$299;
                        }
                    }

                    public ConfigWriter<String> inst$macro$300() {
                        return (byte)(this.bitmap$0 & 1) == 0 ? this.inst$macro$300$lzycompute() : this.inst$macro$300;
                    }

                    public Object inst$macro$302() {
                        return (byte)(this.bitmap$0 & 2) == 0 ? this.inst$macro$302$lzycompute() : this.inst$macro$302;
                    }

                    public DerivedWriters1.WrappedConfigWriter<package.NamedOptions, HNil> inst$macro$303() {
                        return (byte)(this.bitmap$0 & 4) == 0 ? this.inst$macro$303$lzycompute() : this.inst$macro$303;
                    }

                    public DerivedWriters1.WrappedConfigWriter<package.NamedOptions, .colon.colon<Map<String, String>, HNil>> inst$macro$301() {
                        return (byte)(this.bitmap$0 & 8) == 0 ? this.inst$macro$301$lzycompute() : this.inst$macro$301;
                    }

                    public DerivedWriters1.WrappedConfigWriter<package.NamedOptions, .colon.colon<String, .colon.colon<Map<String, String>, HNil>>> inst$macro$299() {
                        return (byte)(this.bitmap$0 & 0x10) == 0 ? this.inst$macro$299$lzycompute() : this.inst$macro$299;
                    }

                    public Org_locationtech_geomesa_fs_storage_common_metadata_MetadataJson$$anonfun$2$anon$deriveLabelledGenericInstance$macro$304$1(anonfun.2 $outer) {
                    }
                }
                DerivedWriters1.WrappedConfigWriter<package.NamedOptions, .colon.colon<String, .colon.colon<Map<String, String>, HNil>>> inst$macro$305 = new Org_locationtech_geomesa_fs_storage_common_metadata_MetadataJson$$anonfun$2$anon$deriveLabelledGenericInstance$macro$304$1(this).inst$macro$299();
                public final class Org_locationtech_geomesa_fs_storage_common_metadata_MetadataJson$$anonfun$2$anon$macro$298$1
                implements Generic<package.NamedOptions> {
                    public .colon.colon<String, .colon.colon<Map<String, String>, HNil>> to(package.NamedOptions p) {
                        package.NamedOptions namedOptions = p;
                        if (namedOptions != null) {
                            String pat$macro$296 = namedOptions.name();
                            Map pat$macro$297 = namedOptions.options();
                            .colon.colon colon2 = new .colon.colon((Object)pat$macro$296, (HList)new .colon.colon((Object)pat$macro$297, (HList)HNil$.MODULE$));
                            return colon2;
                        }
                        throw new MatchError((Object)namedOptions);
                    }

                    public package.NamedOptions from(.colon.colon<String, .colon.colon<Map<String, String>, HNil>> p) {
                        .colon.colon<String, .colon.colon<Map<String, String>, HNil>> colon2 = p;
                        if (colon2 != null) {
                            String pat$macro$296 = (String)colon2.head();
                            .colon.colon colon3 = (.colon.colon)colon2.tail();
                            if (colon3 != null) {
                                Map pat$macro$297 = (Map)colon3.head();
                                HNil hNil = (HNil)colon3.tail();
                                if (HNil$.MODULE$.equals(hNil)) {
                                    package.NamedOptions namedOptions = new package.NamedOptions(pat$macro$296, pat$macro$297);
                                    return namedOptions;
                                }
                            }
                        }
                        throw new MatchError(colon2);
                    }

                    public Org_locationtech_geomesa_fs_storage_common_metadata_MetadataJson$$anonfun$2$anon$macro$298$1(anonfun.2 $outer) {
                    }
                }
                return ConfigWriter$.MODULE$.apply(ConfigWriter$.MODULE$.deriveLabelledGenericInstance(LabelledGeneric$.MODULE$.materializeProduct((DefaultSymbolicLabelling)new DefaultSymbolicLabelling<package.NamedOptions>(this){
                    private static Symbol symbol$9;
                    private static Symbol symbol$10;

                    static {
                        symbol$9 = Symbol$.MODULE$.apply("name");
                        symbol$10 = Symbol$.MODULE$.apply("options");
                    }

                    public .colon.colon<Symbol, .colon.colon<Symbol, HNil>> apply() {
                        return new .colon.colon((Object)symbol$9, (HList)new .colon.colon((Object)symbol$10, (HList)HNil$.MODULE$));
                    }
                }, (Generic)new Org_locationtech_geomesa_fs_storage_common_metadata_MetadataJson$$anonfun$2$anon$macro$298$1(this), hlist.ZipWithKeys$.MODULE$.hconsZipWithKeys(hlist.ZipWithKeys$.MODULE$.hconsZipWithKeys(hlist.ZipWithKeys$.MODULE$.hnilZipWithKeys(), Witness$.MODULE$.mkWitness((Object)symbol$7)), Witness$.MODULE$.mkWitness((Object)symbol$8)), Predef$.MODULE$.$conforms()), Lazy$.MODULE$.apply((Function0)new Serializable(this, inst$macro$305){
                    public static final long serialVersionUID = 0L;
                    private final DerivedWriters1.WrappedConfigWriter inst$macro$305$1;

                    public final DerivedWriters1.WrappedConfigWriter<package.NamedOptions, .colon.colon<String, .colon.colon<Map<String, String>, HNil>>> apply() {
                        return this.inst$macro$305$1;
                    }
                    {
                        this.inst$macro$305$1 = inst$macro$305$1;
                    }
                }))).to((Object)this.metadata$1).render(package$.MODULE$.RenderOptions());
            }
            {
                this.metadata$1 = metadata$1;
            }
        });
        this.profile("Persisted metadata configuration", (Function0)new Serializable(context, file, data){
            public static final long serialVersionUID = 0L;
            private final package.FileSystemContext context$2;
            private final Path file$2;
            public final String data$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                WithClose$.MODULE$.apply((Object)this.context$2.fc().create(this.file$2, EnumSet.of(CreateFlag.CREATE), new Options.CreateOpts[]{Options.CreateOpts.createParent()}), (Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.writeMetadata.1 $outer;

                    public final void apply(FSDataOutputStream out) {
                        out.write(this.$outer.data$1.getBytes(StandardCharsets.UTF_8));
                        out.hflush();
                        out.hsync();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                this.context$2 = context$2;
                this.file$2 = file$2;
                this.data$1 = data$1;
            }
        });
        this.cache().put(context.root().toUri().toString(), metadata);
        PathCache$.MODULE$.register(context.fc(), file, PathCache$.MODULE$.register$default$3(), PathCache$.MODULE$.register$default$4());
    }

    private Option<package.NamedOptions> transitionMetadata(package.FileSystemContext context, Config config) {
        None$ none$;
        try {
            Config x$2 = config.getConfig("featureType");
            None$ x$3 = None$.MODULE$;
            Option x$4 = SimpleFeatureTypes$.MODULE$.createType$default$2();
            SimpleFeatureType sft = SimpleFeatureTypes$.MODULE$.createType(x$2, x$4, (Option)x$3);
            String encoding = config.getString("encoding");
            Config schemeConfig = config.getConfig("partitionScheme");
            Config schemeOpts = schemeConfig.getConfig("options");
            package.NamedOptions scheme = new package.NamedOptions(schemeConfig.getString("scheme"), ((TraversableOnce)((SetLike)JavaConverters$.MODULE$.asScalaSetConverter(schemeOpts.entrySet()).asScala()).map((Function1)new Serializable(schemeOpts){
                public static final long serialVersionUID = 0L;
                private final Config schemeOpts$1;

                public final Tuple2<String, String> apply(Map.Entry<String, ConfigValue> e) {
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)e.getKey()), (Object)this.schemeOpts$1.getString(e.getKey()));
                }
                {
                    this.schemeOpts$1 = schemeOpts$1;
                }
            }, Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()));
            boolean leafStorage = scheme.options().get((Object)"leaf-storage").forall((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final boolean apply(String x$1) {
                    return new StringOps(Predef$.MODULE$.augmentString(x$1)).toBoolean();
                }
            });
            package.Metadata meta = new package.Metadata(sft, encoding, scheme, leafStorage);
            Config partitionConfig = config.getConfig("partitions");
            WithClose$.MODULE$.apply((Object)new FileBasedMetadataFactory().create(context, (Map<String, String>)Predef$.MODULE$.Map().empty(), meta), (Function1)new Serializable(partitionConfig){
                public static final long serialVersionUID = 0L;
                public final Config partitionConfig$1;

                public final void apply(StorageMetadata metadata) {
                    ((IterableLike)JavaConverters$.MODULE$.asScalaSetConverter(this.partitionConfig$1.root().entrySet()).asScala()).foreach((Function1)new Serializable(this, metadata){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.transitionMetadata.1 $outer;
                        private final StorageMetadata metadata$2;

                        public final void apply(Map.Entry<String, ConfigValue> e) {
                            String name = e.getKey();
                            Buffer files = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(this.$outer.partitionConfig$1.getStringList(name)).asScala();
                            this.metadata$2.addPartition(new StorageMetadata.PartitionMetadata(name, (Seq)files, (Option)None$.MODULE$, 0L));
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.metadata$2 = metadata$2;
                        }
                    });
                }
                {
                    this.partitionConfig$1 = partitionConfig$1;
                }
            });
            none$ = new Some((Object)FileBasedMetadata$.MODULE$.DefaultOptions());
        }
        catch (Throwable throwable) {
            None$ none$2;
            BoxedUnit boxedUnit;
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            Throwable e = (Throwable)option.get();
            if (this.logger().underlying().isWarnEnabled()) {
                this.logger().underlying().warn("Error transitioning old metadata format: ", e);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            none$ = none$2 = None$.MODULE$;
        }
        return none$;
    }

    private MetadataJson$() {
        MODULE$ = this;
        LazyLogging.class.$init$((LazyLogging)this);
        MethodProfiling.class.$init$((MethodProfiling)this);
        this.MetadataPath = "metadata.json";
        this.cache = new ConcurrentHashMap();
    }
}

