/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.jobs.mapreduce;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Counter;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.geotools.data.DataStoreFinder;
import org.geotools.data.DataUtilities;
import org.geotools.data.simple.SimpleFeatureWriter;
import org.geotools.filter.identity.FeatureIdImpl;
import org.locationtech.geomesa.index.api.GeoMesaFeatureIndex;
import org.locationtech.geomesa.index.geotools.GeoMesaDataStore;
import org.locationtech.geomesa.jobs.mapreduce.GeoMesaOutputFormat$Counters$;
import org.locationtech.geomesa.jobs.mapreduce.GeoMesaRecordWriter$;
import org.locationtech.geomesa.utils.index.IndexMode$;
import org.locationtech.geomesa.utils.io.CloseQuietly$;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.Nothing$;

@ScalaSignature(bytes="\u0006\u0001\u0005]c\u0001B\u0001\u0003\u00015\u00111cR3p\u001b\u0016\u001c\u0018MU3d_J$wK]5uKJT!a\u0001\u0003\u0002\u00135\f\u0007O]3ek\u000e,'BA\u0003\u0007\u0003\u0011QwNY:\u000b\u0005\u001dA\u0011aB4f_6,7/\u0019\u0006\u0003\u0013)\tA\u0002\\8dCRLwN\u001c;fG\"T\u0011aC\u0001\u0004_J<7\u0001A\u000b\u0003\u001dy\u001b2\u0001A\b)!\u0011\u0001b\u0003\u0007\u0010\u000e\u0003EQ!a\u0001\n\u000b\u0005M!\u0012A\u00025bI>|\u0007O\u0003\u0002\u0016\u0015\u00051\u0011\r]1dQ\u0016L!aF\t\u0003\u0019I+7m\u001c:e/JLG/\u001a:\u0011\u0005eaR\"\u0001\u000e\u000b\u0005m\u0011\u0012AA5p\u0013\ti\"D\u0001\u0003UKb$\bCA\u0010'\u001b\u0005\u0001#BA\u0011#\u0003\u0019\u0019\u0018.\u001c9mK*\u00111\u0005J\u0001\bM\u0016\fG/\u001e:f\u0015\t)#\"A\u0004pa\u0016tw-[:\n\u0005\u001d\u0002#!D*j[BdWMR3biV\u0014X\r\u0005\u0002*a5\t!F\u0003\u0002,Y\u0005a1oY1mC2|wmZ5oO*\u0011QFL\u0001\tif\u0004Xm]1gK*\tq&A\u0002d_6L!!\r\u0016\u0003\u00171\u000b'0\u001f'pO\u001eLgn\u001a\u0005\tg\u0001\u0011\t\u0011)A\u0005i\u00051\u0001/\u0019:b[N\u0004B!N\u001e?}9\u0011a'O\u0007\u0002o)\t\u0001(A\u0003tG\u0006d\u0017-\u0003\u0002;o\u00051\u0001K]3eK\u001aL!\u0001P\u001f\u0003\u00075\u000b\u0007O\u0003\u0002;oA\u0011QgP\u0005\u0003\u0001v\u0012aa\u0015;sS:<\u0007\u0002\u0003\"\u0001\u0005\u0003\u0005\u000b\u0011B\"\u0002\u000f%tG-[2fgB\u0019a\u0007\u0012$\n\u0005\u0015;$AB(qi&|g\u000eE\u0002H\u001fzr!\u0001S'\u000f\u0005%cU\"\u0001&\u000b\u0005-c\u0011A\u0002\u001fs_>$h(C\u00019\u0013\tqu'A\u0004qC\u000e\\\u0017mZ3\n\u0005A\u000b&aA*fc*\u0011aj\u000e\u0005\t'\u0002\u0011\t\u0011)A\u0005)\u000691m\u001c8uKb$\bC\u0001\tV\u0013\t1\u0016C\u0001\nUCN\\\u0017\t\u001e;f[B$8i\u001c8uKb$\b\"\u0002-\u0001\t\u0003I\u0016A\u0002\u001fj]&$h\b\u0006\u0003[Y6t\u0007cA.\u000196\t!\u0001\u0005\u0002^=2\u0001A!B0\u0001\u0005\u0004\u0001'A\u0001#T#\t\tG\r\u0005\u00027E&\u00111m\u000e\u0002\b\u001d>$\b.\u001b8h!\r)'\u000eX\u0007\u0002M*\u0011q\r[\u0001\tO\u0016|Go\\8mg*\u0011\u0011NB\u0001\u0006S:$W\r_\u0005\u0003W\u001a\u0014\u0001cR3p\u001b\u0016\u001c\u0018\rR1uCN#xN]3\t\u000bM:\u0006\u0019\u0001\u001b\t\u000b\t;\u0006\u0019A\"\t\u000bM;\u0006\u0019\u0001+\t\u000fA\u0004!\u0019!C\u0001c\u0006\u0011Am]\u000b\u00029\"11\u000f\u0001Q\u0001\nq\u000b1\u0001Z:!\u0011\u001d)\bA1A\u0005\u0002Y\f\u0001b\u001d4u\u0007\u0006\u001c\u0007.Z\u000b\u0002oB!\u00010  \u007f\u001b\u0005I(B\u0001>|\u0003\u001diW\u000f^1cY\u0016T!\u0001`\u001c\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002=sB\u0011qd`\u0005\u0004\u0003\u0003\u0001#!E*j[BdWMR3biV\u0014X\rV=qK\"9\u0011Q\u0001\u0001!\u0002\u00139\u0018!C:gi\u000e\u000b7\r[3!\u0011%\tI\u0001\u0001b\u0001\n\u0003\tY!A\u0006xe&$XM]\"bG\",WCAA\u0007!\u0015AXPPA\b!\u0011\t\t\"a\u0007\u000e\u0005\u0005M!bA\u0011\u0002\u0016)!\u0011qCA\r\u0003\u0011!\u0017\r^1\u000b\u0005\u001dT\u0011\u0002BA\u000f\u0003'\u00111cU5na2,g)Z1ukJ,wK]5uKJD\u0001\"!\t\u0001A\u0003%\u0011QB\u0001\roJLG/\u001a:DC\u000eDW\r\t\u0005\n\u0003K\u0001!\u0019!C\u0001\u0003O\tqa\u001e:jiR,g.\u0006\u0002\u0002*A\u0019\u0001#a\u000b\n\u0007\u00055\u0012CA\u0004D_VtG/\u001a:\t\u0011\u0005E\u0002\u0001)A\u0005\u0003S\t\u0001b\u001e:jiR,g\u000e\t\u0005\n\u0003k\u0001!\u0019!C\u0001\u0003O\taAZ1jY\u0016$\u0007\u0002CA\u001d\u0001\u0001\u0006I!!\u000b\u0002\u000f\u0019\f\u0017\u000e\\3eA!9\u0011Q\b\u0001\u0005B\u0005}\u0012!B<sSR,GCBA!\u0003\u000f\nY\u0005E\u00027\u0003\u0007J1!!\u00128\u0005\u0011)f.\u001b;\t\u000f\u0005%\u00131\ba\u00011\u0005\u00191.Z=\t\u000f\u00055\u00131\ba\u0001=\u0005)a/\u00197vK\"9\u0011\u0011\u000b\u0001\u0005B\u0005M\u0013!B2m_N,G\u0003BA!\u0003+BaaUA(\u0001\u0004!\u0006")
public class GeoMesaRecordWriter<DS extends GeoMesaDataStore<DS>>
extends RecordWriter<Text, SimpleFeature>
implements LazyLogging {
    public final Option<Seq<String>> org$locationtech$geomesa$jobs$mapreduce$GeoMesaRecordWriter$$indices;
    private final DS ds;
    private final Map<String, SimpleFeatureType> sftCache;
    private final Map<String, SimpleFeatureWriter> writerCache;
    private final Counter written;
    private final Counter failed;
    private final Logger logger;
    private volatile boolean bitmap$0;

    private Logger logger$lzycompute() {
        GeoMesaRecordWriter geoMesaRecordWriter = this;
        synchronized (geoMesaRecordWriter) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public DS ds() {
        return this.ds;
    }

    public Map<String, SimpleFeatureType> sftCache() {
        return this.sftCache;
    }

    public Map<String, SimpleFeatureWriter> writerCache() {
        return this.writerCache;
    }

    public Counter written() {
        return this.written;
    }

    public Counter failed() {
        return this.failed;
    }

    public void write(Text key, SimpleFeature value) {
        String sftName = value.getFeatureType().getTypeName();
        SimpleFeatureType sft = (SimpleFeatureType)this.sftCache().getOrElseUpdate((Object)sftName, (Function0)new Serializable(this, value, sftName){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ GeoMesaRecordWriter $outer;
            private final SimpleFeature value$1;
            private final String sftName$1;

            public final SimpleFeatureType apply() {
                SimpleFeatureType simpleFeatureType;
                SimpleFeatureType existing = this.$outer.ds().getSchema(this.sftName$1);
                if (existing == null) {
                    this.$outer.ds().createSchema(this.value$1.getFeatureType());
                    simpleFeatureType = this.$outer.ds().getSchema(this.sftName$1);
                } else {
                    simpleFeatureType = existing;
                }
                return simpleFeatureType;
            }
            {
                void var3_3;
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.value$1 = value$1;
                this.sftName$1 = var3_3;
            }
        });
        SimpleFeatureWriter writer = (SimpleFeatureWriter)this.writerCache().getOrElseUpdate((Object)sftName, (Function0)new Serializable(this, sftName, sft){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ GeoMesaRecordWriter $outer;
            private final String sftName$1;
            public final SimpleFeatureType sft$1;

            public final SimpleFeatureWriter apply() {
                Option<Seq<String>> option;
                block4: {
                    Seq seq;
                    block3: {
                        block2: {
                            option = this.$outer.org$locationtech$geomesa$jobs$mapreduce$GeoMesaRecordWriter$$indices;
                            if (!(option instanceof Some)) break block2;
                            Some some = (Some)option;
                            Seq names = (Seq)some.x();
                            seq = (Seq)names.map((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ $anonfun$2 $outer;

                                public final GeoMesaFeatureIndex<Nothing$, Nothing$> apply(String x$2) {
                                    return this.$outer.org$locationtech$geomesa$jobs$mapreduce$GeoMesaRecordWriter$$anonfun$$$outer().ds().manager().index(this.$outer.sft$1, x$2, IndexMode$.MODULE$.Write());
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                }
                            }, Seq$.MODULE$.canBuildFrom());
                            break block3;
                        }
                        if (!None$.MODULE$.equals(option)) break block4;
                        seq = this.$outer.ds().manager().indices(this.sft$1, IndexMode$.MODULE$.Write());
                    }
                    Seq i = seq;
                    return this.$outer.ds().getIndexWriterAppend(this.sftName$1, i);
                }
                throw new MatchError(option);
            }

            public /* synthetic */ GeoMesaRecordWriter org$locationtech$geomesa$jobs$mapreduce$GeoMesaRecordWriter$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                void var3_3;
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.sftName$1 = sftName$1;
                this.sft$1 = var3_3;
            }
        });
        try {
            SimpleFeature next = (SimpleFeature)writer.next();
            ((FeatureIdImpl)next.getIdentifier()).setID(value.getID());
            next.setAttributes(value.getAttributes());
            next.getUserData().putAll(value.getUserData());
            writer.write();
            this.written().increment(1L);
        }
        catch (Exception exception) {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isErrorEnabled()) {
                this.logger().underlying().error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error writing feature '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{DataUtilities.encodeFeature((SimpleFeature)value)})), (Throwable)exception);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            this.failed().increment(1L);
        }
    }

    public void close(TaskAttemptContext context) {
        this.writerCache().values().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Option<Throwable> apply(SimpleFeatureWriter v) {
                return CloseQuietly$.MODULE$.apply((Object)v);
            }
        });
        this.ds().dispose();
    }

    public GeoMesaRecordWriter(scala.collection.immutable.Map<String, String> params, Option<Seq<String>> indices, TaskAttemptContext context) {
        this.org$locationtech$geomesa$jobs$mapreduce$GeoMesaRecordWriter$$indices = indices;
        LazyLogging.class.$init$((LazyLogging)this);
        this.ds = (GeoMesaDataStore)DataStoreFinder.getDataStore((java.util.Map)JavaConversions$.MODULE$.mapAsJavaMap(params));
        this.sftCache = Map$.MODULE$.empty();
        this.writerCache = Map$.MODULE$.empty();
        this.written = context.getCounter(GeoMesaOutputFormat$Counters$.MODULE$.Group(), GeoMesaOutputFormat$Counters$.MODULE$.Written());
        this.failed = context.getCounter(GeoMesaOutputFormat$Counters$.MODULE$.Group(), GeoMesaOutputFormat$Counters$.MODULE$.Failed());
    }
}

