/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.process.vector;

import org.geotools.filter.visitor.DuplicatingFilterVisitor;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.spatial.BBOX;

public class BBOXExpandingFilterVisitor
extends DuplicatingFilterVisitor {
    private double expandMinX;
    private double expandMaxX;
    private double expandMinY;
    private double expandMaxY;

    public BBOXExpandingFilterVisitor(double expandMinX, double expandMaxX, double expandMinY, double expandMaxY) {
        this.expandMinX = expandMinX;
        this.expandMaxX = expandMaxX;
        this.expandMinY = expandMinY;
        this.expandMaxY = expandMaxY;
    }

    public Object visit(BBOX filter, Object extraData) {
        Expression propertyName = filter.getExpression1();
        double minx = filter.getMinX();
        double miny = filter.getMinY();
        double maxx = filter.getMaxX();
        double maxy = filter.getMaxY();
        String srs = filter.getSRS();
        return this.getFactory(extraData).bbox(propertyName, minx - this.expandMinX, miny - this.expandMaxX, maxx + this.expandMinY, maxy + this.expandMaxY, srs);
    }
}

