/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.measure;

import javax.measure.IncommensurableException;
import javax.measure.Quantity;
import javax.measure.UnconvertibleException;
import javax.measure.Unit;
import javax.measure.UnitConverter;
import javax.measure.format.UnitFormat;
import javax.measure.quantity.Angle;
import javax.measure.quantity.Dimensionless;
import javax.measure.quantity.Length;
import javax.measure.quantity.Time;
import org.geotools.measure.SexagesimalConverter;
import org.geotools.referencing.wkt.DefaultUnitParser;
import si.uom.NonSI;
import si.uom.SI;
import systems.uom.common.USCustomary;
import tec.uom.se.AbstractUnit;
import tec.uom.se.format.SimpleUnitFormat;
import tec.uom.se.unit.TransformedUnit;

public final class Units {
    public static final Unit<Length> PIXEL = USCustomary.INCH.divide(72.0);
    public static final Unit<Time> MONTH = SI.YEAR.divide(12.0);
    public static final Unit<Angle> SEXAGESIMAL_DMS = NonSI.DEGREE_ANGLE.transform((UnitConverter)SexagesimalConverter.FRACTIONAL.inverse()).asType(Angle.class);
    public static final Unit<Angle> DEGREE_MINUTE_SECOND = NonSI.DEGREE_ANGLE.transform((UnitConverter)SexagesimalConverter.INTEGER.inverse()).asType(Angle.class);
    public static final Unit<Dimensionless> PPM = AbstractUnit.ONE.multiply(1.0E-6);
    static final UnitFormat format = SimpleUnitFormat.getInstance();

    private Units() {
    }

    public static UnitFormat getDefaultFormat() {
        return format;
    }

    static void registerCustomUnits(SimpleUnitFormat format) {
        format.label(DEGREE_MINUTE_SECOND, "DMS");
        format.alias(DEGREE_MINUTE_SECOND, "degree minute second");
        format.label(SEXAGESIMAL_DMS, "D.MS");
        format.alias(SEXAGESIMAL_DMS, "sexagesimal DMS");
        format.alias(SEXAGESIMAL_DMS, "DDD.MMSSsss");
        format.alias(SEXAGESIMAL_DMS, "sexagesimal degree DDD.MMSSsss");
        format.label(PPM, "ppm");
        format.label(NonSI.DEGREE_ANGLE, "\u00b0");
        format.label(PIXEL, "pixel");
        format.label(USCustomary.GRADE, "grad");
        format.alias(USCustomary.GRADE, "grade");
    }

    public static String toName(Unit<?> unit) {
        if (unit.getName() != null) {
            return unit.getName();
        }
        SimpleUnitFormat format = SimpleUnitFormat.getInstance();
        return format.format(unit);
    }

    public static String toSymbol(Unit<?> unit) {
        SimpleUnitFormat format = SimpleUnitFormat.getInstance();
        return format.format(unit);
    }

    public static <Q extends Quantity<Q>> Unit<Q> autoCorrect(Unit<Q> unit) {
        return DefaultUnitParser.getInstance().getEquivalentUnit(unit);
    }

    public static final boolean equals(Unit<?> unit1, Unit<?> unit2) {
        if (unit1 == unit2) {
            return true;
        }
        if (unit1 != null) {
            if (unit1 instanceof TransformedUnit && unit2 != null && unit2 instanceof TransformedUnit) {
                TransformedUnit tunit1 = (TransformedUnit)unit1;
                TransformedUnit tunit2 = (TransformedUnit)unit2;
                if (unit1.getSystemUnit().equals(unit2.getSystemUnit())) {
                    try {
                        float factor = (float)tunit1.getSystemConverter().concatenate(tunit2.getSystemConverter().inverse()).convert(1.0);
                        return factor == 1.0f;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            return unit1.equals(unit2);
        }
        return false;
    }

    public static UnitConverter getConverterToAny(Unit<?> fromUnit, Unit<?> toUnit) {
        try {
            return fromUnit.getConverterToAny(toUnit);
        }
        catch (IncommensurableException | UnconvertibleException e) {
            throw new IllegalArgumentException("Can't convert to the candidate unit", e);
        }
    }

    public static Unit<?> parseUnit(String name) {
        return Units.autoCorrect(DefaultUnitParser.getInstance().parse(name));
    }

    static {
        Units.registerCustomUnits((SimpleUnitFormat)format);
    }
}

