/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geojson.geom;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.geotools.geojson.DelegatingHandler;
import org.geotools.geojson.RecordingHandler;
import org.geotools.geojson.geom.GeometryHandlerBase;
import org.json.simple.parser.ParseException;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;

public class GeometryCollectionHandler
extends DelegatingHandler<GeometryCollection> {
    GeometryFactory factory;
    List<Geometry> geoms;
    GeometryCollection value;
    RecordingHandler proxy;
    Class delegateClass;

    public GeometryCollectionHandler(GeometryFactory factory) {
        this.factory = factory;
    }

    @Override
    public boolean startObject() throws ParseException, IOException {
        if (this.geoms != null) {
            this.delegate = UNINITIALIZED;
        }
        return true;
    }

    @Override
    public boolean endObject() throws ParseException, IOException {
        if (this.delegate instanceof GeometryHandlerBase) {
            ((GeometryHandlerBase)this.delegate).endObject();
            Object geomObject = ((GeometryHandlerBase)this.delegate).getValue();
            if (geomObject != null) {
                this.geoms.add((Geometry)geomObject);
            }
            this.delegate = NULL;
        } else {
            Geometry[] geometries = this.geoms.toArray(new Geometry[this.geoms.size()]);
            this.value = this.factory.createGeometryCollection(geometries);
            this.geoms = null;
        }
        return true;
    }

    @Override
    public boolean startObjectEntry(String key) throws ParseException, IOException {
        if ("coordinates".equals(key) && this.delegate == UNINITIALIZED) {
            this.proxy = new RecordingHandler();
            this.delegate = this.proxy;
            return super.startObjectEntry(key);
        }
        if ("type".equals(key) && this.delegate == this.proxy) {
            this.delegate = UNINITIALIZED;
        } else if ("geometries".equals(key)) {
            this.geoms = new ArrayList<Geometry>();
        } else if (this.geoms != null) {
            super.startObjectEntry(key);
        }
        return true;
    }

    @Override
    public boolean endObjectEntry() throws ParseException, IOException {
        if (this.delegateClass != null) {
            this.delegate = this.createDelegate(this.delegateClass, new Object[]{this.factory});
            this.delegateClass = null;
        }
        return true;
    }

    @Override
    public boolean primitive(Object value) throws ParseException, IOException {
        if (this.geoms != null && value instanceof String && this.delegate == UNINITIALIZED) {
            this.delegateClass = this.lookupDelegate(value.toString());
            if (this.proxy != null) {
                this.delegate = this.createDelegate(this.delegateClass, new Object[]{this.factory});
                this.delegateClass = null;
                this.proxy.replay(this.delegate);
                this.proxy = null;
            }
        } else {
            return super.primitive(value);
        }
        return true;
    }

    @Override
    public GeometryCollection getValue() {
        return this.value;
    }
}

