/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.ma.arrays;

import java.util.ArrayList;
import java.util.List;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.lib.ExtensionFunctionCall;
import net.sf.saxon.lib.ExtensionFunctionDefinition;
import net.sf.saxon.ma.arrays.ArrayItem;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.SequenceExtent;
import net.sf.saxon.value.SequenceType;

public class ArrayFlatten
extends ExtensionFunctionDefinition {
    private static final StructuredQName name = new StructuredQName("array", "http://www.w3.org/2005/xpath-functions/array", "flatten");
    private static final SequenceType[] ARG_TYPES = new SequenceType[]{SequenceType.ANY_SEQUENCE};

    public StructuredQName getFunctionQName() {
        return name;
    }

    public int getMinimumNumberOfArguments() {
        return 1;
    }

    public SequenceType[] getArgumentTypes() {
        return ARG_TYPES;
    }

    public SequenceType getResultType(SequenceType[] suppliedArgumentTypes) {
        return SequenceType.ANY_SEQUENCE;
    }

    public boolean trustResultType() {
        return true;
    }

    public ExtensionFunctionCall makeCallExpression() {
        return new ExtensionFunctionCall(){

            private void flatten(Sequence arg, List<Item> out) throws XPathException {
                Item item;
                SequenceIterator iter = arg.iterate();
                while ((item = iter.next()) != null) {
                    if (item instanceof ArrayItem) {
                        for (Sequence member : (ArrayItem)item) {
                            this.flatten(member, out);
                        }
                        continue;
                    }
                    out.add(item);
                }
            }

            @Override
            public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
                ArrayList<Item> out = new ArrayList<Item>();
                this.flatten(arguments[0], out);
                return SequenceExtent.makeSequenceExtent(out);
            }
        };
    }
}

