/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.parquet;

import java.nio.ByteBuffer;
import java.util.Date;
import java.util.UUID;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.io.api.RecordConsumer;
import org.locationtech.geomesa.parquet.AttributeWriter$;
import org.locationtech.jts.geom.Point;
import scala.Enumeration;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\tUcaB\u0001\u0003!\u0003\r\na\u0003\u0002\u0010\u0003R$(/\u001b2vi\u0016<&/\u001b;fe*\u00111\u0001B\u0001\ba\u0006\u0014\u0018/^3u\u0015\t)a!A\u0004hK>lWm]1\u000b\u0005\u001dA\u0011\u0001\u00047pG\u0006$\u0018n\u001c8uK\u000eD'\"A\u0005\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001a\u0001CA\u0007\u0011\u001b\u0005q!\"A\b\u0002\u000bM\u001c\u0017\r\\1\n\u0005Eq!AB!osJ+g\rC\u0003\u0014\u0001\u0019\u0005A#A\u0003baBd\u0017\u0010F\u0002\u00161\u0015\u0002\"!\u0004\f\n\u0005]q!\u0001B+oSRDQ!\u0007\nA\u0002i\taB]3d_J$7i\u001c8tk6,'\u000f\u0005\u0002\u001cG5\tAD\u0003\u0002\u001e=\u0005\u0019\u0011\r]5\u000b\u0005}\u0001\u0013AA5p\u0015\t\u0019\u0011E\u0003\u0002#\u0011\u00051\u0011\r]1dQ\u0016L!\u0001\n\u000f\u0003\u001dI+7m\u001c:e\u0007>t7/^7fe\")aE\u0005a\u0001\u0019\u0005)a/\u00197vK\u001e)\u0001F\u0001E\u0001S\u0005y\u0011\t\u001e;sS\n,H/Z,sSR,'\u000f\u0005\u0002+W5\t!AB\u0003\u0002\u0005!\u0005Af\u0005\u0002,\u0019!)af\u000bC\u0001_\u00051A(\u001b8jiz\"\u0012!\u000b\u0005\u0006'-\"\t!\r\u000b\u0004eMz\u0004C\u0001\u0016\u0001\u0011\u0015!\u0004\u00071\u00016\u0003)!Wm]2sSB$xN\u001d\t\u0003muj\u0011a\u000e\u0006\u0003qe\nA\u0001^=qK*\u0011!hO\u0001\bM\u0016\fG/\u001e:f\u0015\ta\u0004\"A\u0004pa\u0016tw-[:\n\u0005y:$aE!uiJL'-\u001e;f\t\u0016\u001c8M]5qi>\u0014\b\"\u0002!1\u0001\u0004\t\u0015!B5oI\u0016D\bCA\u0007C\u0013\t\u0019eBA\u0002J]RDQaE\u0016\u0005\u0002\u0015#BA\r$P!\")q\t\u0012a\u0001\u0011\u0006!a.Y7f!\tIEJ\u0004\u0002\u000e\u0015&\u00111JD\u0001\u0007!J,G-\u001a4\n\u00055s%AB*ue&twM\u0003\u0002L\u001d!)\u0001\t\u0012a\u0001\u0003\")\u0011\u000b\u0012a\u0001%\u0006A!-\u001b8eS:<7\u000fE\u0002T7zs!\u0001V-\u000f\u0005UCV\"\u0001,\u000b\u0005]S\u0011A\u0002\u001fs_>$h(C\u0001\u0010\u0013\tQf\"A\u0004qC\u000e\\\u0017mZ3\n\u0005qk&aA*fc*\u0011!L\u0004\t\u0003?Bt!\u0001Y7\u000f\u0005\u0005TgB\u00012i\u001d\t\u0019wM\u0004\u0002eM:\u0011Q+Z\u0005\u0002\u0013%\u0011q\u0001C\u0005\u0003\u000b\u0019I!!\u001b\u0003\u0002\u0011\u0019,\u0017\r^;sKNL!a\u001b7\u0002\u001bM,'/[1mSj\fG/[8o\u0015\tIG!\u0003\u0002o_\u0006QqJ\u00196fGR$\u0016\u0010]3\u000b\u0005-d\u0017BA9s\u0005)y%M[3diRK\b/\u001a\u0006\u0003]>4Q\u0001^\u0016\u0002\u0002U\u0014q#\u00112tiJ\f7\r^!uiJL'-\u001e;f/JLG/\u001a:\u0014\u0007Md!\u0007\u0003\u0005xg\n\u0005\t\u0015!\u0003I\u0003%1\u0017.\u001a7e\u001d\u0006lW\r\u0003\u0005zg\n\u0005\t\u0015!\u0003B\u0003)1\u0017.\u001a7e\u0013:$W\r\u001f\u0005\u0006]M$\ta\u001f\u000b\u0004yz|\bCA?t\u001b\u0005Y\u0003\"B<{\u0001\u0004A\u0005\"B={\u0001\u0004\t\u0005bBA\u0002g\u001a\u0005\u0011QA\u0001\u0006oJLG/\u001a\u000b\u0006+\u0005\u001d\u0011\u0011\u0002\u0005\u00073\u0005\u0005\u0001\u0019\u0001\u000e\t\r\u0019\n\t\u00011\u0001\r\u0011\u0019\u00192\u000f\"\u0011\u0002\u000eQ)Q#a\u0004\u0002\u0012!1\u0011$a\u0003A\u0002iAaAJA\u0006\u0001\u0004aaABA\u000bW\u0001\t9B\u0001\u000bQ_&tG/\u0011;ue&\u0014W\u000f^3Xe&$XM]\n\u0004\u0003'a\b\"C<\u0002\u0014\t\u0005\t\u0015!\u0003I\u0011%I\u00181\u0003B\u0001B\u0003%\u0011\tC\u0004/\u0003'!\t!a\b\u0015\r\u0005\u0005\u00121EA\u0013!\ri\u00181\u0003\u0005\u0007o\u0006u\u0001\u0019\u0001%\t\re\fi\u00021\u0001B\u0011!\t\u0019!a\u0005\u0005B\u0005%B#B\u000b\u0002,\u00055\u0002BB\r\u0002(\u0001\u0007!\u0004\u0003\u0004'\u0003O\u0001\r\u0001\u0004\u0004\u0007\u0003cY\u0003!a\r\u0003\u0015\u0011\u000bG/Z,sSR,'oE\u0002\u00020qD\u0011b^A\u0018\u0005\u0003\u0005\u000b\u0011\u0002%\t\u0013e\fyC!A!\u0002\u0013\t\u0005b\u0002\u0018\u00020\u0011\u0005\u00111\b\u000b\u0007\u0003{\ty$!\u0011\u0011\u0007u\fy\u0003\u0003\u0004x\u0003s\u0001\r\u0001\u0013\u0005\u0007s\u0006e\u0002\u0019A!\t\u0011\u0005\r\u0011q\u0006C!\u0003\u000b\"R!FA$\u0003\u0013Ba!GA\"\u0001\u0004Q\u0002B\u0002\u0014\u0002D\u0001\u0007AB\u0002\u0004\u0002N-\u0002\u0011q\n\u0002\r\t>,(\r\\3Xe&$XM]\n\u0004\u0003\u0017b\b\"C<\u0002L\t\u0005\t\u0015!\u0003I\u0011%I\u00181\nB\u0001B\u0003%\u0011\tC\u0004/\u0003\u0017\"\t!a\u0016\u0015\r\u0005e\u00131LA/!\ri\u00181\n\u0005\u0007o\u0006U\u0003\u0019\u0001%\t\re\f)\u00061\u0001B\u0011!\t\u0019!a\u0013\u0005B\u0005\u0005D#B\u000b\u0002d\u0005\u0015\u0004BB\r\u0002`\u0001\u0007!\u0004\u0003\u0004'\u0003?\u0002\r\u0001\u0004\u0004\u0007\u0003SZ\u0003!a\u001b\u0003\u0017\u0019cw.\u0019;Xe&$XM]\n\u0004\u0003Ob\b\"C<\u0002h\t\u0005\t\u0015!\u0003I\u0011%I\u0018q\rB\u0001B\u0003%\u0011\tC\u0004/\u0003O\"\t!a\u001d\u0015\r\u0005U\u0014qOA=!\ri\u0018q\r\u0005\u0007o\u0006E\u0004\u0019\u0001%\t\re\f\t\b1\u0001B\u0011!\t\u0019!a\u001a\u0005B\u0005uD#B\u000b\u0002\u0000\u0005\u0005\u0005BB\r\u0002|\u0001\u0007!\u0004\u0003\u0004'\u0003w\u0002\r\u0001\u0004\u0004\u0007\u0003\u000b[\u0003!a\"\u0003\u001b%sG/Z4fe^\u0013\u0018\u000e^3s'\r\t\u0019\t \u0005\no\u0006\r%\u0011!Q\u0001\n!C\u0011\"_AB\u0005\u0003\u0005\u000b\u0011B!\t\u000f9\n\u0019\t\"\u0001\u0002\u0010R1\u0011\u0011SAJ\u0003+\u00032!`AB\u0011\u00199\u0018Q\u0012a\u0001\u0011\"1\u00110!$A\u0002\u0005C\u0001\"a\u0001\u0002\u0004\u0012\u0005\u0013\u0011\u0014\u000b\u0006+\u0005m\u0015Q\u0014\u0005\u00073\u0005]\u0005\u0019\u0001\u000e\t\r\u0019\n9\n1\u0001\r\r\u0019\t\tk\u000b\u0001\u0002$\nQAj\u001c8h/JLG/\u001a:\u0014\u0007\u0005}E\u0010C\u0005x\u0003?\u0013\t\u0011)A\u0005\u0011\"I\u00110a(\u0003\u0002\u0003\u0006I!\u0011\u0005\b]\u0005}E\u0011AAV)\u0019\ti+a,\u00022B\u0019Q0a(\t\r]\fI\u000b1\u0001I\u0011\u0019I\u0018\u0011\u0016a\u0001\u0003\"A\u00111AAP\t\u0003\n)\fF\u0003\u0016\u0003o\u000bI\f\u0003\u0004\u001a\u0003g\u0003\rA\u0007\u0005\u0007M\u0005M\u0006\u0019\u0001\u0007\u0007\r\u0005u6\u0006AA`\u00051\u0019FO]5oO^\u0013\u0018\u000e^3s'\r\tY\f \u0005\no\u0006m&\u0011!Q\u0001\n!C\u0011\"_A^\u0005\u0003\u0005\u000b\u0011B!\t\u000f9\nY\f\"\u0001\u0002HR1\u0011\u0011ZAf\u0003\u001b\u00042!`A^\u0011\u00199\u0018Q\u0019a\u0001\u0011\"1\u00110!2A\u0002\u0005C\u0001\"a\u0001\u0002<\u0012\u0005\u0013\u0011\u001b\u000b\u0006+\u0005M\u0017Q\u001b\u0005\u00073\u0005=\u0007\u0019\u0001\u000e\t\r\u0019\ny\r1\u0001\r\r\u0019\tIn\u000b\u0001\u0002\\\nQA*[:u/JLG/\u001a:\u0014\u0007\u0005]G\u0010C\u0005x\u0003/\u0014\t\u0011)A\u0005\u0011\"I\u00110a6\u0003\u0002\u0003\u0006I!\u0011\u0005\u000b\u0003G\f9N!A!\u0002\u0013q\u0016!\u0003<bYV,G+\u001f9f\u0011\u001dq\u0013q\u001bC\u0001\u0003O$\u0002\"!;\u0002l\u00065\u0018q\u001e\t\u0004{\u0006]\u0007BB<\u0002f\u0002\u0007\u0001\n\u0003\u0004z\u0003K\u0004\r!\u0011\u0005\b\u0003G\f)\u000f1\u0001_\u0011)\t\u00190a6C\u0002\u0013\u0005\u0011Q_\u0001\u000eK2,W.\u001a8u/JLG/\u001a:\u0016\u0003IB\u0001\"!?\u0002X\u0002\u0006IAM\u0001\u000fK2,W.\u001a8u/JLG/\u001a:!\u0011!\t\u0019!a6\u0005B\u0005uH#B\u000b\u0002\u0000\n\u0005\u0001BB\r\u0002|\u0002\u0007!\u0004\u0003\u0004'\u0003w\u0004\r\u0001\u0004\u0004\u0007\u0005\u000bY\u0003Aa\u0002\u0003\u00135\u000b\u0007o\u0016:ji\u0016\u00148c\u0001B\u0002y\"IqOa\u0001\u0003\u0002\u0003\u0006I\u0001\u0013\u0005\ns\n\r!\u0011!Q\u0001\n\u0005C!Ba\u0004\u0003\u0004\t\u0005\t\u0015!\u0003_\u0003\u001dYW-\u001f+za\u0016D!\"a9\u0003\u0004\t\u0005\t\u0015!\u0003_\u0011\u001dq#1\u0001C\u0001\u0005+!\"Ba\u0006\u0003\u001a\tm!Q\u0004B\u0010!\ri(1\u0001\u0005\u0007o\nM\u0001\u0019\u0001%\t\re\u0014\u0019\u00021\u0001B\u0011\u001d\u0011yAa\u0005A\u0002yCq!a9\u0003\u0014\u0001\u0007a\f\u0003\u0006\u0003$\t\r!\u0019!C\u0001\u0003k\f\u0011b[3z/JLG/\u001a:\t\u0011\t\u001d\"1\u0001Q\u0001\nI\n!b[3z/JLG/\u001a:!\u0011)\u0011YCa\u0001C\u0002\u0013\u0005\u0011Q_\u0001\fm\u0006dW/Z,sSR,'\u000f\u0003\u0005\u00030\t\r\u0001\u0015!\u00033\u000311\u0018\r\\;f/JLG/\u001a:!\u0011!\t\u0019Aa\u0001\u0005B\tMB#B\u000b\u00036\t]\u0002BB\r\u00032\u0001\u0007!\u0004\u0003\u0004'\u0005c\u0001\r\u0001\u0004\u0004\u0007\u0005wY\u0003A!\u0010\u0003\u0015U+\u0016\nR,sSR,'oE\u0002\u0003:qD\u0011b\u001eB\u001d\u0005\u0003\u0005\u000b\u0011\u0002%\t\u0013e\u0014ID!A!\u0002\u0013\t\u0005b\u0002\u0018\u0003:\u0011\u0005!Q\t\u000b\u0007\u0005\u000f\u0012IEa\u0013\u0011\u0007u\u0014I\u0004\u0003\u0004x\u0005\u0007\u0002\r\u0001\u0013\u0005\u0007s\n\r\u0003\u0019A!\t\u0011\u0005\r!\u0011\bC!\u0005\u001f\"R!\u0006B)\u0005'Ba!\u0007B'\u0001\u0004Q\u0002B\u0002\u0014\u0003N\u0001\u0007A\u0002")
public interface AttributeWriter {
    public void apply(RecordConsumer var1, Object var2);

    public static class MapWriter
    extends AbstractAttributeWriter {
        private final String fieldName;
        private final AttributeWriter keyWriter;
        private final AttributeWriter valueWriter;

        public AttributeWriter keyWriter() {
            return this.keyWriter;
        }

        public AttributeWriter valueWriter() {
            return this.valueWriter;
        }

        @Override
        public void write(RecordConsumer recordConsumer, Object value) {
            recordConsumer.startGroup();
            Map themap = (Map)value;
            if (themap != null && themap.nonEmpty()) {
                recordConsumer.startField(this.fieldName, 0);
                themap.foreach((Function1)new Serializable(this, recordConsumer){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ MapWriter $outer;
                    private final RecordConsumer recordConsumer$2;

                    public final void apply(Tuple2<Object, Object> x0$1) {
                        Tuple2<Object, Object> tuple2 = x0$1;
                        if (tuple2 != null) {
                            Object k = tuple2._1();
                            Object v = tuple2._2();
                            this.recordConsumer$2.startGroup();
                            this.$outer.keyWriter().apply(this.recordConsumer$2, k);
                            if (v != null) {
                                this.$outer.valueWriter().apply(this.recordConsumer$2, v);
                            }
                            this.recordConsumer$2.endGroup();
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            return;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.recordConsumer$2 = recordConsumer$2;
                    }
                });
                recordConsumer.endField(this.fieldName, 0);
            }
            recordConsumer.endGroup();
        }

        public MapWriter(String fieldName, int fieldIndex, Enumeration.Value keyType, Enumeration.Value valueType) {
            this.fieldName = fieldName;
            super(fieldName, fieldIndex);
            this.keyWriter = AttributeWriter$.MODULE$.apply("key", 0, (Seq<Enumeration.Value>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Enumeration.Value[]{keyType}))));
            this.valueWriter = AttributeWriter$.MODULE$.apply("value", 1, (Seq<Enumeration.Value>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Enumeration.Value[]{valueType}))));
        }
    }

    public static class DateWriter
    extends AbstractAttributeWriter {
        @Override
        public void write(RecordConsumer recordConsumer, Object value) {
            recordConsumer.addLong(((Date)value).getTime());
        }

        public DateWriter(String fieldName, int fieldIndex) {
            super(fieldName, fieldIndex);
        }
    }

    public static class LongWriter
    extends AbstractAttributeWriter {
        @Override
        public void write(RecordConsumer recordConsumer, Object value) {
            recordConsumer.addLong(BoxesRunTime.unboxToLong((Object)value));
        }

        public LongWriter(String fieldName, int fieldIndex) {
            super(fieldName, fieldIndex);
        }
    }

    public static class ListWriter
    extends AbstractAttributeWriter {
        private final String fieldName;
        private final AttributeWriter elementWriter;

        public AttributeWriter elementWriter() {
            return this.elementWriter;
        }

        @Override
        public void write(RecordConsumer recordConsumer, Object value) {
            recordConsumer.startGroup();
            List thelist = (List)value;
            if (thelist != null && thelist.nonEmpty()) {
                recordConsumer.startField(this.fieldName, 0);
                thelist.foreach((Function1)new Serializable(this, recordConsumer){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ ListWriter $outer;
                    private final RecordConsumer recordConsumer$1;

                    public final void apply(Object e) {
                        this.recordConsumer$1.startGroup();
                        if (e != null) {
                            this.$outer.elementWriter().apply(this.recordConsumer$1, e);
                        }
                        this.recordConsumer$1.endGroup();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.recordConsumer$1 = recordConsumer$1;
                    }
                });
                recordConsumer.endField(this.fieldName, 0);
            }
            recordConsumer.endGroup();
        }

        public ListWriter(String fieldName, int fieldIndex, Enumeration.Value valueType) {
            this.fieldName = fieldName;
            super(fieldName, fieldIndex);
            this.elementWriter = AttributeWriter$.MODULE$.apply("element", 0, (Seq<Enumeration.Value>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Enumeration.Value[]{valueType}))));
        }
    }

    public static class UUIDWriter
    extends AbstractAttributeWriter {
        @Override
        public void write(RecordConsumer recordConsumer, Object value) {
            UUID uuid = (UUID)value;
            ByteBuffer bb = ByteBuffer.wrap(new byte[16]);
            bb.putLong(uuid.getMostSignificantBits());
            bb.putLong(uuid.getLeastSignificantBits());
            recordConsumer.addBinary(Binary.fromConstantByteArray((byte[])bb.array()));
        }

        public UUIDWriter(String fieldName, int fieldIndex) {
            super(fieldName, fieldIndex);
        }
    }

    public static class FloatWriter
    extends AbstractAttributeWriter {
        @Override
        public void write(RecordConsumer recordConsumer, Object value) {
            recordConsumer.addFloat(Predef$.MODULE$.Float2float((Float)value));
        }

        public FloatWriter(String fieldName, int fieldIndex) {
            super(fieldName, fieldIndex);
        }
    }

    public static class DoubleWriter
    extends AbstractAttributeWriter {
        @Override
        public void write(RecordConsumer recordConsumer, Object value) {
            recordConsumer.addDouble(Predef$.MODULE$.Double2double((Double)value));
        }

        public DoubleWriter(String fieldName, int fieldIndex) {
            super(fieldName, fieldIndex);
        }
    }

    public static class StringWriter
    extends AbstractAttributeWriter {
        @Override
        public void write(RecordConsumer recordConsumer, Object value) {
            recordConsumer.addBinary(Binary.fromString((String)((String)value)));
        }

        public StringWriter(String fieldName, int fieldIndex) {
            super(fieldName, fieldIndex);
        }
    }

    public static class IntegerWriter
    extends AbstractAttributeWriter {
        @Override
        public void write(RecordConsumer recordConsumer, Object value) {
            recordConsumer.addInteger(Predef$.MODULE$.Integer2int((Integer)value));
        }

        public IntegerWriter(String fieldName, int fieldIndex) {
            super(fieldName, fieldIndex);
        }
    }

    public static class PointAttributeWriter
    extends AbstractAttributeWriter {
        @Override
        public void write(RecordConsumer recordConsumer, Object value) {
            Point pt = (Point)value;
            recordConsumer.startGroup();
            recordConsumer.startField("x", 0);
            recordConsumer.addDouble(pt.getX());
            recordConsumer.endField("x", 0);
            recordConsumer.startField("y", 1);
            recordConsumer.addDouble(pt.getY());
            recordConsumer.endField("y", 1);
            recordConsumer.endGroup();
        }

        public PointAttributeWriter(String fieldName, int fieldIndex) {
            super(fieldName, fieldIndex);
        }
    }

    public static abstract class AbstractAttributeWriter
    implements AttributeWriter {
        private final String fieldName;
        private final int fieldIndex;

        public abstract void write(RecordConsumer var1, Object var2);

        @Override
        public void apply(RecordConsumer recordConsumer, Object value) {
            if (value != null) {
                recordConsumer.startField(this.fieldName, this.fieldIndex);
                this.write(recordConsumer, value);
                recordConsumer.endField(this.fieldName, this.fieldIndex);
            }
        }

        public AbstractAttributeWriter(String fieldName, int fieldIndex) {
            this.fieldName = fieldName;
            this.fieldIndex = fieldIndex;
        }
    }
}

