/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.utils.io.fs;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Locale;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.locationtech.geomesa.utils.collection.CloseableIterator;
import org.locationtech.geomesa.utils.collection.CloseableIterator$;
import org.locationtech.geomesa.utils.io.PathUtils$;
import org.locationtech.geomesa.utils.io.WithClose$;
import org.locationtech.geomesa.utils.io.fs.FileSystemDelegate;
import org.locationtech.geomesa.utils.io.fs.FileSystemDelegate$FileHandle$class;
import org.locationtech.geomesa.utils.io.fs.LocalDelegate$;
import org.locationtech.geomesa.utils.io.fs.package;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\u0005ed\u0001B\u0001\u0003\u0001=\u0011Q\u0002T8dC2$U\r\\3hCR,'BA\u0002\u0005\u0003\t17O\u0003\u0002\u0006\r\u0005\u0011\u0011n\u001c\u0006\u0003\u000f!\tQ!\u001e;jYNT!!\u0003\u0006\u0002\u000f\u001d,w.\\3tC*\u00111\u0002D\u0001\rY>\u001c\u0017\r^5p]R,7\r\u001b\u0006\u0002\u001b\u0005\u0019qN]4\u0004\u0001M\u0019\u0001\u0001\u0005\f\u0011\u0005E!R\"\u0001\n\u000b\u0003M\tQa]2bY\u0006L!!\u0006\n\u0003\r\u0005s\u0017PU3g!\t9\u0002$D\u0001\u0003\u0013\tI\"A\u0001\nGS2,7+_:uK6$U\r\\3hCR,\u0007\"B\u000e\u0001\t\u0003a\u0012A\u0002\u001fj]&$h\bF\u0001\u001e!\t9\u0002\u0001C\u0003 \u0001\u0011\u0005\u0003%A\u0007j]R,'\u000f\u001d:fiB\u000bG\u000f\u001b\u000b\u0003C\u0001\u00032A\t\u0016.\u001d\t\u0019\u0003F\u0004\u0002%O5\tQE\u0003\u0002'\u001d\u00051AH]8pizJ\u0011aE\u0005\u0003SI\tq\u0001]1dW\u0006<W-\u0003\u0002,Y\t\u00191+Z9\u000b\u0005%\u0012\u0002C\u0001\u0018>\u001d\ty3H\u0004\u00021u9\u0011\u0011'\u000f\b\u0003ear!aM\u001c\u000f\u0005Q2dB\u0001\u00136\u0013\u0005i\u0011BA\u0006\r\u0013\tI!\"\u0003\u0002\b\u0011%\u0011QAB\u0005\u0003\u0007\u0011I!\u0001\u0010\u0002\u0002%\u0019KG.Z*zgR,W\u000eR3mK\u001e\fG/Z\u0005\u0003}}\u0012!BR5mK\"\u000bg\u000e\u001a7f\u0015\ta$\u0001C\u0003B=\u0001\u0007!)\u0001\u0003qCRD\u0007CA\"G\u001d\t\tB)\u0003\u0002F%\u00051\u0001K]3eK\u001aL!a\u0012%\u0003\rM#(/\u001b8h\u0015\t)%\u0003C\u0003K\u0001\u0011%1*\u0001\u0007de\u0016\fG/\u001a%b]\u0012dW\r\u0006\u0002.\u0019\")Q*\u0013a\u0001\u001d\u0006!a-\u001b7f!\ty5+D\u0001Q\u0015\t)\u0011KC\u0001S\u0003\u0011Q\u0017M^1\n\u0005Q\u0003&\u0001\u0002$jY\u0016<QA\u0016\u0002\t\u0002]\u000bQ\u0002T8dC2$U\r\\3hCR,\u0007CA\fY\r\u0015\t!\u0001#\u0001Z'\tA\u0006\u0003C\u0003\u001c1\u0012\u00051\fF\u0001X\u0011\u001di\u0006L1A\u0005\ny\u000bqAZ1di>\u0014\u00180F\u0001`!\t\u0001\u0017.D\u0001b\u0015\t\u00117-A\u0005be\u000eD\u0017N^3sg*\u0011A-Z\u0001\tG>l\u0007O]3tg*\u0011amZ\u0001\bG>lWn\u001c8t\u0015\tAG\"\u0001\u0004ba\u0006\u001c\u0007.Z\u0005\u0003U\u0006\u0014A#\u0011:dQ&4Xm\u0015;sK\u0006lg)Y2u_JL\bB\u00027YA\u0003%q,\u0001\u0005gC\u000e$xN]=!\r\u0011q\u0007\fA8\u0003\u001f1{7-\u00197GS2,\u0007*\u00198eY\u0016\u001c2!\u001c\t.\u0011!iUN!A!\u0002\u0013q\u0005\"B\u000en\t\u0003\u0011HCA:v!\t!X.D\u0001Y\u0011\u0015i\u0015\u000f1\u0001O\u0011\u0015\tU\u000e\"\u0011x+\u0005\u0011\u0005\"B=n\t\u0003R\u0018A\u00027f]\u001e$\b.F\u0001|!\t\tB0\u0003\u0002~%\t!Aj\u001c8h\u0011\u0019yX\u000e\"\u0011\u0002\u0002\u0005!q\u000e]3o+\t\t\u0019\u0001\u0005\u0004\u0002\u0006\u0005-\u0011qB\u0007\u0003\u0003\u000fQ1!!\u0003\u0007\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003\u001b\t9AA\tDY>\u001cX-\u00192mK&#XM]1u_J\u0004r!EA\t\u0003+\tY\"C\u0002\u0002\u0014I\u0011a\u0001V;qY\u0016\u0014\u0004\u0003B\t\u0002\u0018\tK1!!\u0007\u0013\u0005\u0019y\u0005\u000f^5p]B\u0019q*!\b\n\u0007\u0005}\u0001KA\u0006J]B,Ho\u0015;sK\u0006lgABA\u00121\u0002\t)C\u0001\bM_\u000e\fGNW5q\u0011\u0006tG\r\\3\u0014\u0007\u0005\u00052\u000fC\u0005N\u0003C\u0011\t\u0011)A\u0005\u001d\"91$!\t\u0005\u0002\u0005-B\u0003BA\u0017\u0003_\u00012\u0001^A\u0011\u0011\u0019i\u0015\u0011\u0006a\u0001\u001d\"9q0!\t\u0005B\u0005\u0005aABA\u001b1\u0002\t9D\u0001\bM_\u000e\fG\u000eV1s\u0011\u0006tG\r\\3\u0014\u0007\u0005M2\u000fC\u0005N\u0003g\u0011\t\u0011)A\u0005\u001d\"91$a\r\u0005\u0002\u0005uB\u0003BA \u0003\u0003\u00022\u0001^A\u001a\u0011\u0019i\u00151\ba\u0001\u001d\"9q0a\r\u0005B\u0005\u0005aABA$1\u0002\tIEA\u0006Ti\u0012Le\u000eS1oI2,7\u0003BA#!5BqaGA#\t\u0003\ti\u0005\u0006\u0002\u0002PA\u0019A/!\u0012\t\r\u0005\u000b)\u0005\"\u0011x\u0011\u0019I\u0018Q\tC!u\"9q0!\u0012\u0005B\u0005\u0005qaBA-1\"\u0005\u00111L\u0001\f'R$\u0017J\u001c%b]\u0012dW\rE\u0002u\u0003;2q!a\u0012Y\u0011\u0003\tyfE\u0002\u0002^AAqaGA/\t\u0003\t\u0019\u0007\u0006\u0002\u0002\\!A\u0011qMA/\t\u0003\tI'A\u0005bm\u0006LG.\u00192mKR\u0011\u00111\u000e\t\u0005#\u0005]Q\u0006\u0003\u0005\u0002p\u0005uC\u0011AA9\u0003-I7/\u0011<bS2\f'\r\\3\u0016\u0005\u0005M\u0004cA\t\u0002v%\u0019\u0011q\u000f\n\u0003\u000f\t{w\u000e\\3b]\u0002")
public class LocalDelegate
implements FileSystemDelegate {
    @Override
    public Seq<FileSystemDelegate.FileHandle> interpretPath(String path) {
        Tuple2 tuple2;
        block8: {
            Seq seq;
            block7: {
                Tuple2 tuple22;
                int firstWildcard;
                block6: {
                    firstWildcard = path.indexOf(42);
                    if (firstWildcard != -1) break block6;
                    File file = new File(path);
                    if (file.isDirectory()) {
                        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Input file is a directory: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{file.getAbsolutePath()})));
                    }
                    seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new FileSystemDelegate.FileHandle[]{this.org$locationtech$geomesa$utils$io$fs$LocalDelegate$$createHandle(file)}));
                    break block7;
                }
                int lastSep = path.length() - 1 - ((String)new StringOps(Predef$.MODULE$.augmentString(path)).reverse()).indexOf(47, path.length() - firstWildcard - 1);
                Tuple2 tuple23 = tuple2 = lastSep == path.length() ? new Tuple2((Object)new File(".").toPath(), (Object)path) : new Tuple2((Object)new File(path.substring(0, lastSep)).toPath(), (Object)path.substring(lastSep + 1));
                if (tuple2 == null) break block8;
                Path basepath = (Path)tuple2._1();
                String glob = (String)tuple2._2();
                Tuple2 tuple24 = tuple22 = new Tuple2((Object)basepath, (Object)glob);
                Path basepath2 = (Path)tuple24._1();
                String glob2 = (String)tuple24._2();
                if (glob2.indexOf(47) == -1 && !glob2.contains("**")) {
                    seq = (Seq)WithClose$.MODULE$.apply(Files.newDirectoryStream(basepath2, glob2), new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ LocalDelegate $outer;

                        public final Seq<FileSystemDelegate.FileHandle> apply(DirectoryStream<Path> stream) {
                            return (Seq)((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(stream).asScala()).toList().flatMap((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ $anonfun$interpretPath$1 $outer;

                                public final List<FileSystemDelegate.FileHandle> apply(Path p) {
                                    File file = p.toFile();
                                    return file.isDirectory() ? Nil$.MODULE$ : List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new FileSystemDelegate.FileHandle[]{this.$outer.org$locationtech$geomesa$utils$io$fs$LocalDelegate$$anonfun$$$outer().org$locationtech$geomesa$utils$io$fs$LocalDelegate$$createHandle(file)}));
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                }
                            }, List$.MODULE$.canBuildFrom());
                        }

                        public /* synthetic */ LocalDelegate org$locationtech$geomesa$utils$io$fs$LocalDelegate$$anonfun$$$outer() {
                            return this.$outer;
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    });
                } else {
                    PathMatcher matcher = FileSystems.getDefault().getPathMatcher(new StringBuilder().append((Object)"glob:").append((Object)glob2).toString());
                    ArrayBuffer result = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
                    SimpleFileVisitor<Path> visitor = new SimpleFileVisitor<Path>(this, matcher, result){
                        private final /* synthetic */ LocalDelegate $outer;
                        private final PathMatcher matcher$1;
                        private final ArrayBuffer result$1;

                        public FileVisitResult visitFile(Path file, BasicFileAttributes attributes2) {
                            Object object = this.matcher$1.matches(file) && attributes2.isRegularFile() && !attributes2.isDirectory() ? this.result$1.$plus$eq((Object)this.$outer.org$locationtech$geomesa$utils$io$fs$LocalDelegate$$createHandle(file.toFile())) : BoxedUnit.UNIT;
                            return FileVisitResult.CONTINUE;
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.matcher$1 = matcher$1;
                            this.result$1 = result$1;
                        }
                    };
                    Files.walkFileTree(basepath2, (FileVisitor<? super Path>)visitor);
                    seq = result;
                }
            }
            return seq;
        }
        throw new MatchError((Object)tuple2);
    }

    public FileSystemDelegate.FileHandle org$locationtech$geomesa$utils$io$fs$LocalDelegate$$createHandle(File file) {
        LocalFileHandle localFileHandle;
        String string2 = PathUtils$.MODULE$.getUncompressedExtension(file.getName()).toLowerCase(Locale.US);
        if ("tar".equals(string2)) {
            localFileHandle = new LocalTarHandle(file);
        } else {
            boolean bl = "zip".equals(string2) ? true : "jar".equals(string2);
            localFileHandle = bl ? new LocalZipHandle(file) : new LocalFileHandle(file);
        }
        return localFileHandle;
    }

    public static class StdInHandle
    implements FileSystemDelegate.FileHandle {
        private final String format;
        private volatile boolean bitmap$0;

        private String format$lzycompute() {
            StdInHandle stdInHandle = this;
            synchronized (stdInHandle) {
                if (!this.bitmap$0) {
                    this.format = FileSystemDelegate$FileHandle$class.format(this);
                    this.bitmap$0 = true;
                }
                return this.format;
            }
        }

        @Override
        public String format() {
            return this.bitmap$0 ? this.format : this.format$lzycompute();
        }

        @Override
        public String path() {
            return "<stdin>";
        }

        @Override
        public long length() {
            return BoxesRunTime.unboxToLong((Object)Try$.MODULE$.apply((Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final long apply() {
                    return this.apply$mcJ$sp();
                }

                public long apply$mcJ$sp() {
                    return System.in.available();
                }
            }).getOrElse((Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final long apply() {
                    return this.apply$mcJ$sp();
                }

                public long apply$mcJ$sp() {
                    return 0L;
                }
            }));
        }

        @Override
        public CloseableIterator<Tuple2<Option<String>, InputStream>> open() {
            return CloseableIterator$.MODULE$.single(new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Tuple2<None$, InputStream> apply() {
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)None$.MODULE$), (Object)System.in);
                }
            }, (Function0<BoxedUnit>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final void apply() {
                    this.apply$mcV$sp();
                }

                public void apply$mcV$sp() {
                    CloseableIterator$.MODULE$.single$default$2();
                }
            });
        }

        public StdInHandle() {
            FileSystemDelegate$FileHandle$class.$init$(this);
        }
    }

    public static class LocalTarHandle
    extends LocalFileHandle {
        private final File file;

        @Override
        public CloseableIterator<Tuple2<Option<String>, InputStream>> open() {
            InputStream uncompressed = PathUtils$.MODULE$.handleCompression(new FileInputStream(this.file), this.file.getName());
            ArchiveInputStream archive = LocalDelegate$.MODULE$.org$locationtech$geomesa$utils$io$fs$LocalDelegate$$factory().createArchiveInputStream("tar", uncompressed);
            return new package.ArchiveFileIterator(archive, this.file.getAbsolutePath());
        }

        public LocalTarHandle(File file) {
            this.file = file;
            super(file);
        }
    }

    public static class LocalZipHandle
    extends LocalFileHandle {
        private final File file;

        @Override
        public CloseableIterator<Tuple2<Option<String>, InputStream>> open() {
            return new package.ZipFileIterator(new ZipFile(this.file), this.file.getAbsolutePath());
        }

        public LocalZipHandle(File file) {
            this.file = file;
            super(file);
        }
    }

    public static class LocalFileHandle
    implements FileSystemDelegate.FileHandle {
        private final File file;
        private final String format;
        private volatile boolean bitmap$0;

        private String format$lzycompute() {
            LocalFileHandle localFileHandle = this;
            synchronized (localFileHandle) {
                if (!this.bitmap$0) {
                    this.format = FileSystemDelegate$FileHandle$class.format(this);
                    this.bitmap$0 = true;
                }
                return this.format;
            }
        }

        @Override
        public String format() {
            return this.bitmap$0 ? this.format : this.format$lzycompute();
        }

        @Override
        public String path() {
            return this.file.getAbsolutePath();
        }

        @Override
        public long length() {
            return this.file.length();
        }

        @Override
        public CloseableIterator<Tuple2<Option<String>, InputStream>> open() {
            InputStream is = PathUtils$.MODULE$.handleCompression(new FileInputStream(this.file), this.file.getName());
            return CloseableIterator$.MODULE$.single(new Serializable(this, is){
                public static final long serialVersionUID = 0L;
                private final InputStream is$1;

                public final Tuple2<None$, InputStream> apply() {
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)None$.MODULE$), (Object)this.is$1);
                }
                {
                    this.is$1 = is$1;
                }
            }, (Function0<BoxedUnit>)new Serializable(this, is){
                public static final long serialVersionUID = 0L;
                private final InputStream is$1;

                public final void apply() {
                    this.apply$mcV$sp();
                }

                public void apply$mcV$sp() {
                    this.is$1.close();
                }
                {
                    this.is$1 = is$1;
                }
            });
        }

        public LocalFileHandle(File file) {
            this.file = file;
            FileSystemDelegate$FileHandle$class.$init$(this);
        }
    }
}

