/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.jobs.mapreduce;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Closeable;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.Seekable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.compress.CodecPool;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionCodecFactory;
import org.apache.hadoop.io.compress.Decompressor;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.opengis.feature.simple.SimpleFeature;
import scala.collection.Iterator;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u00055e!B\u0001\u0003\u0003\u0003i!A\u0006$jY\u0016\u001cFO]3b[J+7m\u001c:e%\u0016\fG-\u001a:\u000b\u0005\r!\u0011!C7baJ,G-^2f\u0015\t)a!\u0001\u0003k_\n\u001c(BA\u0004\t\u0003\u001d9Wm\\7fg\u0006T!!\u0003\u0006\u0002\u00191|7-\u0019;j_:$Xm\u00195\u000b\u0003-\t1a\u001c:h\u0007\u0001\u00192\u0001\u0001\b(!\u0011yQcF\u000f\u000e\u0003AQ!aA\t\u000b\u0005I\u0019\u0012A\u00025bI>|\u0007O\u0003\u0002\u0015\u0015\u00051\u0011\r]1dQ\u0016L!A\u0006\t\u0003\u0019I+7m\u001c:e%\u0016\fG-\u001a:\u0011\u0005aYR\"A\r\u000b\u0005i\t\u0012AA5p\u0013\ta\u0012D\u0001\u0007M_:<wK]5uC\ndW\r\u0005\u0002\u001fK5\tqD\u0003\u0002!C\u000511/[7qY\u0016T!AI\u0012\u0002\u000f\u0019,\u0017\r^;sK*\u0011AEC\u0001\b_B,gnZ5t\u0013\t1sDA\u0007TS6\u0004H.\u001a$fCR,(/\u001a\t\u0003Q=j\u0011!\u000b\u0006\u0003U-\nAb]2bY\u0006dwnZ4j]\u001eT!\u0001L\u0017\u0002\u0011QL\b/Z:bM\u0016T\u0011AL\u0001\u0004G>l\u0017B\u0001\u0019*\u0005-a\u0015M_=M_\u001e<\u0017N\\4\t\u000bI\u0002A\u0011A\u001a\u0002\rqJg.\u001b;?)\u0005!\u0004CA\u001b\u0001\u001b\u0005\u0011\u0001\"C\u001c\u0001\u0001\u0004\u0005\r\u0011\"\u00039\u0003\r!WmY\u000b\u0002sA\u0011!(P\u0007\u0002w)\u0011A(G\u0001\tG>l\u0007O]3tg&\u0011ah\u000f\u0002\r\t\u0016\u001cw.\u001c9sKN\u001cxN\u001d\u0005\n\u0001\u0002\u0001\r\u00111A\u0005\n\u0005\u000bq\u0001Z3d?\u0012*\u0017\u000f\u0006\u0002C\u0011B\u00111IR\u0007\u0002\t*\tQ)A\u0003tG\u0006d\u0017-\u0003\u0002H\t\n!QK\\5u\u0011\u001dIu(!AA\u0002e\n1\u0001\u001f\u00132\u0011\u0019Y\u0005\u0001)Q\u0005s\u0005!A-Z2!\u0011%i\u0005\u00011AA\u0002\u0013%a*\u0001\u0004tiJ,\u0017-\\\u000b\u0002\u001fJ\u0019\u0001KU-\u0007\tE\u0003\u0001a\u0014\u0002\ryI,g-\u001b8f[\u0016tGO\u0010\t\u0003'^k\u0011\u0001\u0016\u0006\u00035US\u0011AV\u0001\u0005U\u00064\u0018-\u0003\u0002Y)\nY\u0011J\u001c9viN#(/Z1n!\tQV,D\u0001\\\u0015\ta\u0016#\u0001\u0002gg&\u0011al\u0017\u0002\t'\u0016,7.\u00192mK\"I\u0001\r\u0001a\u0001\u0002\u0004%I!Y\u0001\u000bgR\u0014X-Y7`I\u0015\fHC\u0001\"c\u0011\u001dIu,!AA\u0002=Ca\u0001\u001a\u0001!B\u0013y\u0015aB:ue\u0016\fW\u000e\t\u0005\nM\u0002\u0001\r\u00111A\u0005\n\u001d\fA!\u001b;feV\t\u0001NE\u0002jUZ4A!\u0015\u0001\u0001QB\u00191n]\u000f\u000f\u00051\fhBA7q\u001b\u0005q'BA8\r\u0003\u0019a$o\\8u}%\tQ)\u0003\u0002s\t\u00069\u0001/Y2lC\u001e,\u0017B\u0001;v\u0005!IE/\u001a:bi>\u0014(B\u0001:E!\t\u0019v/\u0003\u0002y)\nI1\t\\8tK\u0006\u0014G.\u001a\u0005\nu\u0002\u0001\r\u00111A\u0005\nm\f\u0001\"\u001b;fe~#S-\u001d\u000b\u0003\u0005rDq!S=\u0002\u0002\u0003\u0007\u0001\u000e\u0003\u0004\u007f\u0001\u0001\u0006K\u0001[\u0001\u0006SR,'\u000f\t\u0005\n\u0003\u0003\u0001\u0001\u0019!C\u0005\u0003\u0007\ta\u0001\\3oORDWCAA\u0003!\r\u0019\u0015qA\u0005\u0004\u0003\u0013!%!\u0002$m_\u0006$\b\"CA\u0007\u0001\u0001\u0007I\u0011BA\b\u0003)aWM\\4uQ~#S-\u001d\u000b\u0004\u0005\u0006E\u0001\"C%\u0002\f\u0005\u0005\t\u0019AA\u0003\u0011!\t)\u0002\u0001Q!\n\u0005\u0015\u0011a\u00027f]\u001e$\b\u000e\t\u0005\n\u00033\u0001!\u0019!C\u0005\u00037\taaY;s\u0017\u0016LX#A\f\t\u000f\u0005}\u0001\u0001)A\u0005/\u000591-\u001e:LKf\u0004\u0003bCA\u0012\u0001\u0001\u0007\t\u0019!C\u0005\u0003K\t\u0001bY;s-\u0006dW/Z\u000b\u0002;!Y\u0011\u0011\u0006\u0001A\u0002\u0003\u0007I\u0011BA\u0016\u00031\u0019WO\u001d,bYV,w\fJ3r)\r\u0011\u0015Q\u0006\u0005\t\u0013\u0006\u001d\u0012\u0011!a\u0001;!9\u0011\u0011\u0007\u0001!B\u0013i\u0012!C2veZ\u000bG.^3!\u0011\u001d\t)\u0004\u0001D\u0001\u0003o\tab\u0019:fCR,\u0017\n^3sCR|'\u000f\u0006\u0005\u0002:\u0005u\u00121IA'%\u0011\tYD\u001b<\u0007\u000bE\u0003\u0001!!\u000f\t\u000f5\u000b\u0019\u00041\u0001\u0002@I!\u0011\u0011\t*Z\r\u0015\t\u0006\u0001AA \u0011!\t)%a\rA\u0002\u0005\u001d\u0013\u0001\u00034jY\u0016\u0004\u0016\r\u001e5\u0011\u0007i\u000bI%C\u0002\u0002Lm\u0013A\u0001U1uQ\"A\u0011qJA\u001a\u0001\u0004\t\t&A\u0004d_:$X\r\u001f;\u0011\u0007=\t\u0019&C\u0002\u0002VA\u0011!\u0003V1tW\u0006#H/Z7qi\u000e{g\u000e^3yi\"9\u0011\u0011\f\u0001\u0005B\u0005m\u0013aC4fiB\u0013xn\u001a:fgN$\"!!\u0002\t\u000f\u0005}\u0003\u0001\"\u0011\u0002b\u0005aa.\u001a=u\u0017\u0016Lh+\u00197vKR\u0011\u00111\r\t\u0004\u0007\u0006\u0015\u0014bAA4\t\n9!i\\8mK\u0006t\u0007bBA6\u0001\u0011\u0005\u0013QN\u0001\u0010O\u0016$8)\u001e:sK:$h+\u00197vKR\tQ\u0004C\u0004\u0002r\u0001!\t%a\u001d\u0002\u0015%t\u0017\u000e^5bY&TX\rF\u0003C\u0003k\ny\b\u0003\u0005\u0002x\u0005=\u0004\u0019AA=\u0003\u0015\u0019\b\u000f\\5u!\ry\u00111P\u0005\u0004\u0003{\u0002\"AC%oaV$8\u000b\u001d7ji\"A\u0011qJA8\u0001\u0004\t\t\u0006C\u0004\u0002\u0004\u0002!\t%!\"\u0002\u001b\u001d,GoQ;se\u0016tGoS3z)\u00059\u0002bBAE\u0001\u0011\u0005\u00131R\u0001\u0006G2|7/\u001a\u000b\u0002\u0005\u0002")
public abstract class FileStreamRecordReader
extends RecordReader<LongWritable, SimpleFeature>
implements LazyLogging {
    private Decompressor dec;
    private InputStream stream;
    private Iterator<SimpleFeature> iter;
    private float length;
    private final LongWritable curKey;
    private SimpleFeature curValue;
    private final Logger logger;
    private volatile boolean bitmap$0;

    private Logger logger$lzycompute() {
        FileStreamRecordReader fileStreamRecordReader = this;
        synchronized (fileStreamRecordReader) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    private Decompressor dec() {
        return this.dec;
    }

    private void dec_$eq(Decompressor x$1) {
        this.dec = x$1;
    }

    private InputStream stream() {
        return this.stream;
    }

    private void stream_$eq(InputStream x$1) {
        this.stream = x$1;
    }

    private Iterator<SimpleFeature> iter() {
        return this.iter;
    }

    private void iter_$eq(Iterator<SimpleFeature> x$1) {
        this.iter = x$1;
    }

    private float length() {
        return this.length;
    }

    private void length_$eq(float x$1) {
        this.length = x$1;
    }

    private LongWritable curKey() {
        return this.curKey;
    }

    private SimpleFeature curValue() {
        return this.curValue;
    }

    private void curValue_$eq(SimpleFeature x$1) {
        this.curValue = x$1;
    }

    public abstract Iterator<SimpleFeature> createIterator(InputStream var1, Path var2, TaskAttemptContext var3);

    public float getProgress() {
        return this.length() == 0.0f ? 0.0f : package$.MODULE$.min(1.0f, (float)((double)((Seekable)this.stream()).getPos() / (double)this.length()));
    }

    public boolean nextKeyValue() {
        boolean bl;
        if (this.iter().hasNext()) {
            this.curKey().set(this.curKey().get() + 1L);
            this.curValue_$eq((SimpleFeature)this.iter().next());
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    public SimpleFeature getCurrentValue() {
        return this.curValue();
    }

    public void initialize(InputSplit split, TaskAttemptContext context) {
        BoxedUnit boxedUnit;
        FSDataInputStream fSDataInputStream;
        Configuration job = context.getConfiguration();
        Path path = ((FileSplit)split).getPath();
        CompressionCodec codec = new CompressionCodecFactory(job).getCodec(path);
        FileSystem fs = path.getFileSystem(job);
        this.length_$eq(split.getLength());
        if (codec == null) {
            fSDataInputStream = fs.open(path);
        } else {
            this.dec_$eq(CodecPool.getDecompressor((CompressionCodec)codec));
            fSDataInputStream = codec.createInputStream((InputStream)fs.open(path), this.dec());
        }
        this.stream_$eq((InputStream)fSDataInputStream);
        this.iter_$eq(this.createIterator(this.stream(), path, context));
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Initialized record reader on split {}", new Object[]{path.toString()});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    public LongWritable getCurrentKey() {
        return this.curKey();
    }

    public void close() {
        IOUtils.closeQuietly((Closeable)((Closeable)this.iter()));
        IOUtils.closeQuietly((InputStream)this.stream());
        if (this.dec() != null) {
            CodecPool.returnDecompressor((Decompressor)this.dec());
        }
    }

    public FileStreamRecordReader() {
        LazyLogging.class.$init$((LazyLogging)this);
        this.length = 0.0f;
        this.curKey = new LongWritable(0L);
    }
}

