/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.utils.geotools;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.awt.geom.Point2D;
import org.geotools.geometry.jts.JTSFactoryFinder;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.GeodeticCalculator;
import org.locationtech.geomesa.utils.geohash.GeoHash;
import org.locationtech.geomesa.utils.geohash.GeohashUtils;
import org.locationtech.geomesa.utils.geohash.GeohashUtils$;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.math.Ordering;
import scala.math.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.control.NonFatal$;

public final class GeometryUtils$
implements LazyLogging {
    public static final GeometryUtils$ MODULE$;
    private final GeometryFactory geoFactory;
    private final Point zeroPoint;
    private final Logger logger;
    private volatile boolean bitmap$0;

    static {
        new GeometryUtils$();
    }

    private Logger logger$lzycompute() {
        GeometryUtils$ geometryUtils$ = this;
        synchronized (geometryUtils$) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public GeometryFactory geoFactory() {
        return this.geoFactory;
    }

    public Point zeroPoint() {
        return this.zeroPoint;
    }

    public Tuple2<Object, Object> distanceDegrees(Geometry geom, double meters) {
        Tuple2<Object, Object> tuple2;
        Geometry geometry = geom;
        if (geometry instanceof Point) {
            Point point = (Point)geometry;
            tuple2 = this.distanceDegrees(point, meters, new GeodeticCalculator());
        } else {
            tuple2 = this.distanceDegrees(geom.getEnvelopeInternal(), meters);
        }
        return tuple2;
    }

    public Tuple2<Object, Object> distanceDegrees(Point point, double meters, GeodeticCalculator calc) {
        Tuple2<Object, Object> tuple2 = this.directionalDegrees(point, meters, calc);
        if (tuple2 != null) {
            double north;
            double north2;
            double east = tuple2._1$mcD$sp();
            Tuple2.mcDD.sp sp2 = new Tuple2.mcDD.sp(east, north2 = tuple2._2$mcD$sp());
            Tuple2.mcDD.sp sp3 = sp2;
            double east2 = sp3._1$mcD$sp();
            return east2 > (north = sp3._2$mcD$sp()) ? new Tuple2.mcDD.sp(north, east2) : new Tuple2.mcDD.sp(east2, north);
        }
        throw new MatchError(tuple2);
    }

    public Tuple2<Object, Object> distanceDegrees(Envelope env, double meters) {
        Seq distances = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{this.distanceDegrees((Geometry)this.geoFactory().createPoint(new Coordinate(env.getMaxX(), env.getMaxY())), meters), this.distanceDegrees((Geometry)this.geoFactory().createPoint(new Coordinate(env.getMaxX(), env.getMinY())), meters), this.distanceDegrees((Geometry)this.geoFactory().createPoint(new Coordinate(env.getMinX(), env.getMinY())), meters), this.distanceDegrees((Geometry)this.geoFactory().createPoint(new Coordinate(env.getMinX(), env.getMaxY())), meters)}));
        return new Tuple2.mcDD.sp(((Tuple2)distances.minBy((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply(Tuple2<Object, Object> x$2) {
                return x$2._1$mcD$sp();
            }
        }, (Ordering)Ordering.Double$.MODULE$))._1$mcD$sp(), ((Tuple2)distances.maxBy((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply(Tuple2<Object, Object> x$3) {
                return x$3._2$mcD$sp();
            }
        }, (Ordering)Ordering.Double$.MODULE$))._2$mcD$sp());
    }

    public Tuple2<Object, Object> directionalDegrees(Point point, double meters, GeodeticCalculator calc) {
        calc.setStartingGeographicPoint(point.getX(), point.getY());
        return new Tuple2.mcDD.sp(package$.MODULE$.min(this.degrees$1(90.0, point, meters, calc), this.degrees$1(-90.0, point, meters, calc)), package$.MODULE$.min(this.degrees$1(0.0, point, meters, calc), this.degrees$1(180.0, point, meters, calc)));
    }

    public List<Coordinate> addWayPoints(Seq<Coordinate> coords) {
        return this.unfoldRight((Object)coords, (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Option<Tuple2<Coordinate, Seq<Coordinate>>> apply(Seq<Coordinate> x0$1) {
                Seq<Coordinate> seq;
                block10: {
                    None$ none$;
                    block8: {
                        Some some;
                        block9: {
                            block7: {
                                seq = x0$1;
                                Some some2 = Seq$.MODULE$.unapplySeq(seq);
                                if (some2.isEmpty() || some2.get() == null || ((SeqLike)some2.get()).lengthCompare(0) != 0) break block7;
                                none$ = None$.MODULE$;
                                break block8;
                            }
                            Some some3 = Seq$.MODULE$.unapplySeq(seq);
                            if (some3.isEmpty() || some3.get() == null || ((SeqLike)some3.get()).lengthCompare(1) != 0) break block9;
                            Coordinate pt = (Coordinate)((SeqLike)some3.get()).apply(0);
                            none$ = new Some((Object)new Tuple2((Object)pt, (Object)Seq$.MODULE$.apply((Seq)Nil$.MODULE$)));
                            break block8;
                        }
                        Some some4 = Seq$.MODULE$.unapplySeq(seq);
                        if (some4.isEmpty() || some4.get() == null || ((SeqLike)some4.get()).lengthCompare(2) < 0) break block10;
                        Coordinate first = (Coordinate)((SeqLike)some4.get()).apply(0);
                        Coordinate second = (Coordinate)((SeqLike)some4.get()).apply(1);
                        Seq rest = (Seq)((IterableLike)some4.get()).drop(2);
                        double d = second.x - first.x;
                        if (d > (double)120) {
                            Coordinate coordinate = new Coordinate(first.x + (double)120, first.y);
                            Coordinate coordinate2 = second;
                            some = new Some((Object)new Tuple2((Object)first, ((SeqLike)rest.$plus$colon((Object)coordinate2, Seq$.MODULE$.canBuildFrom())).$plus$colon((Object)coordinate, Seq$.MODULE$.canBuildFrom())));
                        } else if (d < (double)-120) {
                            Coordinate coordinate = new Coordinate(first.x - (double)120, first.y);
                            Coordinate coordinate3 = second;
                            some = new Some((Object)new Tuple2((Object)first, ((SeqLike)rest.$plus$colon((Object)coordinate3, Seq$.MODULE$.canBuildFrom())).$plus$colon((Object)coordinate, Seq$.MODULE$.canBuildFrom())));
                        } else {
                            Coordinate coordinate = second;
                            some = new Some((Object)new Tuple2((Object)first, rest.$plus$colon((Object)coordinate, Seq$.MODULE$.canBuildFrom())));
                        }
                        none$ = some;
                    }
                    return none$;
                }
                throw new MatchError(seq);
            }
        });
    }

    private <A, B> List<A> unfoldRight(B seed, Function1<B, Option<Tuple2<A, B>>> f) {
        Option option2;
        block4: {
            Nil$ nil$;
            block3: {
                Some some;
                Tuple2 tuple2;
                block2: {
                    option2 = (Option)f.apply(seed);
                    if (!None$.MODULE$.equals(option2)) break block2;
                    nil$ = Nil$.MODULE$;
                    break block3;
                }
                if (!(option2 instanceof Some) || (tuple2 = (Tuple2)(some = (Some)option2).x()) == null) break block4;
                Object a = tuple2._1();
                Object b = tuple2._2();
                Object object = a;
                nil$ = this.unfoldRight(b, f).$colon$colon(object);
            }
            return nil$;
        }
        throw new MatchError((Object)option2);
    }

    public Tuple4<Object, Object, Object, Object> bounds(Geometry geometry) {
        Envelope env = geometry.getEnvelopeInternal();
        return new Tuple4((Object)BoxesRunTime.boxToDouble((double)env.getMinX()), (Object)BoxesRunTime.boxToDouble((double)env.getMinY()), (Object)BoxesRunTime.boxToDouble((double)env.getMaxX()), (Object)BoxesRunTime.boxToDouble((double)env.getMaxY()));
    }

    public Seq<Tuple4<Object, Object, Object, Object>> bounds(Geometry geometry, int maxBounds, int maxBitResolution) {
        Seq seq;
        if (maxBounds < 2 || this.isRectangular(geometry)) {
            return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple4[]{this.bounds(geometry)}));
        }
        try {
            GeohashUtils.ResolutionRange resolution = new GeohashUtils.ResolutionRange(0, maxBitResolution | 1, 5);
            List<GeoHash> geohashes = GeohashUtils$.MODULE$.decomposeGeometry(geometry, maxBounds, resolution, true);
            seq = (Seq)geohashes.map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Tuple4<Object, Object, Object, Object> apply(GeoHash gh) {
                    return new Tuple4((Object)BoxesRunTime.boxToDouble((double)gh.bbox().ll().getX()), (Object)BoxesRunTime.boxToDouble((double)gh.bbox().ll().getY()), (Object)BoxesRunTime.boxToDouble((double)gh.bbox().ur().getX()), (Object)BoxesRunTime.boxToDouble((double)gh.bbox().ur().getY()));
                }
            }, List$.MODULE$.canBuildFrom());
        }
        catch (Throwable throwable) {
            Seq seq2;
            BoxedUnit boxedUnit;
            Throwable throwable2 = throwable;
            Option option2 = NonFatal$.MODULE$.unapply(throwable2);
            if (option2.isEmpty()) {
                throw throwable;
            }
            Throwable e = (Throwable)option2.get();
            if (this.logger().underlying().isErrorEnabled()) {
                this.logger().underlying().error("Error decomposing geometry, falling back to envelope bounds:", e);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            seq = seq2 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple4[]{this.bounds(geometry)}));
        }
        return seq;
    }

    public boolean isRectangular(Geometry geometry) {
        boolean bl;
        Geometry geometry2 = geometry;
        if (geometry2 instanceof Point) {
            bl = true;
        } else if (geometry2 instanceof Polygon) {
            Polygon polygon = (Polygon)geometry2;
            bl = this.isRectangular(polygon);
        } else {
            bl = false;
        }
        return bl;
    }

    public boolean isRectangular(Polygon p) {
        Tuple4 tuple4;
        block6: {
            boolean bl;
            block4: {
                Tuple4 tuple42;
                block5: {
                    block3: {
                        if (!p.isEmpty()) break block3;
                        bl = true;
                        break block4;
                    }
                    if (p.getNumInteriorRing() == 0) break block5;
                    bl = false;
                    break block4;
                }
                Envelope env = p.getEnvelopeInternal();
                tuple4 = new Tuple4((Object)BoxesRunTime.boxToDouble((double)env.getMinX()), (Object)BoxesRunTime.boxToDouble((double)env.getMinY()), (Object)BoxesRunTime.boxToDouble((double)env.getMaxX()), (Object)BoxesRunTime.boxToDouble((double)env.getMaxY()));
                if (tuple4 == null) break block6;
                double xmin = BoxesRunTime.unboxToDouble((Object)tuple4._1());
                double ymin = BoxesRunTime.unboxToDouble((Object)tuple4._2());
                double xmax = BoxesRunTime.unboxToDouble((Object)tuple4._3());
                double ymax = BoxesRunTime.unboxToDouble((Object)tuple4._4());
                Tuple4 tuple43 = tuple42 = new Tuple4((Object)BoxesRunTime.boxToDouble((double)xmin), (Object)BoxesRunTime.boxToDouble((double)ymin), (Object)BoxesRunTime.boxToDouble((double)xmax), (Object)BoxesRunTime.boxToDouble((double)ymax));
                double xmin2 = BoxesRunTime.unboxToDouble((Object)tuple43._1());
                double ymin2 = BoxesRunTime.unboxToDouble((Object)tuple43._2());
                double xmax2 = BoxesRunTime.unboxToDouble((Object)tuple43._3());
                double ymax2 = BoxesRunTime.unboxToDouble((Object)tuple43._4());
                Coordinate[] coords = p.getCoordinates();
                for (int i = 1; i < coords.length; ++i) {
                    Coordinate c = coords[i];
                    if (!this.cutout$1(c, xmin2, ymin2, xmax2, ymax2) && (c.x == coords[i - 1].x || c.y == coords[i - 1].y)) continue;
                    return false;
                }
                bl = !this.cutout$1(coords[0], xmin2, ymin2, xmax2, ymax2);
            }
            return bl;
        }
        throw new MatchError((Object)tuple4);
    }

    public boolean crossesIDL(Coordinate point1, Coordinate point2) {
        return Math.abs(point1.x - point2.x) >= (double)180;
    }

    public double calcIDLIntercept(Coordinate point1, Coordinate point2) {
        return point1.x < 0.0 ? this.calcCrossLat(point1, new Coordinate(point2.x - (double)360, point2.y), -180.0) : this.calcCrossLat(point1, new Coordinate(point2.x + (double)360, point2.y), 180.0);
    }

    public double calcCrossLat(Coordinate point1, Coordinate point2, double crossLon) {
        double slope = (point1.y - point2.y) / (point1.x - point2.x);
        double intercept = point1.y - slope * point1.x;
        return slope * crossLon + intercept;
    }

    public Seq<ReferencedEnvelope> splitBoundingBox(ReferencedEnvelope envelope) {
        Seq seq;
        try {
            ReferencedEnvelope translated;
            ReferencedEnvelope referencedEnvelope;
            CoordinateReferenceSystem crs = envelope.getCoordinateReferenceSystem();
            if (envelope.getMinX() >= 180.0) {
                double multiplier = package$.MODULE$.ceil((envelope.getMinX() - 180.0) / 360.0);
                double left = envelope.getMinX() - 360.0 * multiplier;
                double right = envelope.getMaxX() - 360.0 * multiplier;
                referencedEnvelope = new ReferencedEnvelope(left, right, envelope.getMinY(), envelope.getMaxY(), crs);
            } else if (envelope.getMaxX() <= -180.0) {
                double multiplier = package$.MODULE$.ceil((envelope.getMaxX() + 180.0) / -360.0);
                double left = envelope.getMinX() + 360.0 * multiplier;
                double right = envelope.getMaxX() + 360.0 * multiplier;
                referencedEnvelope = new ReferencedEnvelope(left, right, envelope.getMinY(), envelope.getMaxY(), crs);
            } else {
                referencedEnvelope = translated = envelope;
            }
            if (translated.getMinX() < -180.0 && translated.getMaxX() < 180.0) {
                ReferencedEnvelope trimmed = new ReferencedEnvelope(-180.0, translated.getMaxX(), envelope.getMinY(), envelope.getMaxY(), crs);
                ReferencedEnvelope wrapped = new ReferencedEnvelope(translated.getMinX() + 360.0, 180.0, envelope.getMinY(), envelope.getMaxY(), crs);
                seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReferencedEnvelope[]{trimmed, wrapped}));
            } else if (translated.getMaxX() > 180.0 && translated.getMinX() > -180.0) {
                ReferencedEnvelope trimmed = new ReferencedEnvelope(translated.getMinX(), 180.0, envelope.getMinY(), envelope.getMaxY(), crs);
                ReferencedEnvelope wrapped = new ReferencedEnvelope(-180.0, translated.getMaxX() - 360.0, envelope.getMinY(), envelope.getMaxY(), crs);
                seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReferencedEnvelope[]{trimmed, wrapped}));
            } else {
                seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReferencedEnvelope[]{translated}));
            }
        }
        catch (Throwable throwable) {
            Seq seq2;
            BoxedUnit boxedUnit;
            Throwable throwable2 = throwable;
            Option option2 = NonFatal$.MODULE$.unapply(throwable2);
            if (option2.isEmpty()) {
                throw throwable;
            }
            Throwable e = (Throwable)option2.get();
            if (this.logger().underlying().isWarnEnabled()) {
                this.logger().underlying().warn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error splitting bounding box envelope '", "':"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{envelope})), e);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            seq = seq2 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReferencedEnvelope[]{envelope}));
        }
        return seq;
    }

    private final double degrees$1(double azimuth, Point point$1, double meters$1, GeodeticCalculator calc$1) {
        calc$1.setDirection(azimuth, meters$1);
        Point2D dest = calc$1.getDestinationGeographicPoint();
        return point$1.distance((Geometry)this.geoFactory().createPoint(new Coordinate(dest.getX(), dest.getY())));
    }

    private final boolean cutout$1(Coordinate c, double xmin$1, double ymin$1, double xmax$1, double ymax$1) {
        return c.x != xmin$1 && c.x != xmax$1 && c.y != ymin$1 && c.y != ymax$1;
    }

    private GeometryUtils$() {
        MODULE$ = this;
        LazyLogging.class.$init$((LazyLogging)this);
        this.geoFactory = JTSFactoryFinder.getGeometryFactory();
        this.zeroPoint = this.geoFactory().createPoint(new Coordinate(0.0, 0.0));
    }
}

