/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry;

import java.util.Arrays;
import org.geotools.util.factory.FactoryCreator;
import org.geotools.util.factory.FactoryFinder;
import org.geotools.util.factory.FactoryRegistry;
import org.geotools.util.factory.FactoryRegistryException;
import org.geotools.util.factory.Hints;
import org.opengis.geometry.PositionFactory;
import org.opengis.geometry.Precision;
import org.opengis.geometry.aggregate.AggregateFactory;
import org.opengis.geometry.complex.ComplexFactory;
import org.opengis.geometry.coordinate.GeometryFactory;
import org.opengis.geometry.primitive.PrimitiveFactory;

public class GeometryFactoryFinder
extends FactoryFinder {
    private static FactoryRegistry registry;

    private GeometryFactoryFinder() {
    }

    private static FactoryRegistry getServiceRegistry() {
        assert (Thread.holdsLock(GeometryFactoryFinder.class));
        if (registry == null) {
            registry = new FactoryCreator(Arrays.asList(Precision.class, PositionFactory.class, GeometryFactory.class, ComplexFactory.class, AggregateFactory.class, PrimitiveFactory.class));
        }
        return registry;
    }

    public static synchronized Precision getPrecision(Hints hints) throws FactoryRegistryException {
        hints = GeometryFactoryFinder.mergeSystemHints((Hints)hints);
        return (Precision)GeometryFactoryFinder.getServiceRegistry().getFactory(Precision.class, null, hints, Hints.PRECISION);
    }

    public static synchronized PositionFactory getPositionFactory(Hints hints) throws FactoryRegistryException {
        hints = GeometryFactoryFinder.mergeSystemHints((Hints)hints);
        return (PositionFactory)GeometryFactoryFinder.getServiceRegistry().getFactory(PositionFactory.class, null, hints, Hints.POSITION_FACTORY);
    }

    public static synchronized GeometryFactory getGeometryFactory(Hints hints) throws FactoryRegistryException {
        hints = GeometryFactoryFinder.mergeSystemHints((Hints)hints);
        return (GeometryFactory)GeometryFactoryFinder.getServiceRegistry().getFactory(GeometryFactory.class, null, hints, Hints.GEOMETRY_FACTORY);
    }

    public static synchronized ComplexFactory getComplexFactory(Hints hints) throws FactoryRegistryException {
        hints = GeometryFactoryFinder.mergeSystemHints((Hints)hints);
        return (ComplexFactory)GeometryFactoryFinder.getServiceRegistry().getFactory(ComplexFactory.class, null, hints, Hints.COMPLEX_FACTORY);
    }

    public static synchronized AggregateFactory getAggregateFactory(Hints hints) throws FactoryRegistryException {
        hints = GeometryFactoryFinder.mergeSystemHints((Hints)hints);
        return (AggregateFactory)GeometryFactoryFinder.getServiceRegistry().getFactory(AggregateFactory.class, null, hints, Hints.AGGREGATE_FACTORY);
    }

    public static synchronized PrimitiveFactory getPrimitiveFactory(Hints hints) throws FactoryRegistryException {
        hints = GeometryFactoryFinder.mergeSystemHints((Hints)hints);
        return (PrimitiveFactory)GeometryFactoryFinder.getServiceRegistry().getFactory(PrimitiveFactory.class, null, hints, Hints.PRIMITIVE_FACTORY);
    }
}

