/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.index.iterators;

import java.util.concurrent.ConcurrentHashMap;
import org.locationtech.geomesa.features.kryo.KryoFeatureSerializer;
import org.locationtech.geomesa.features.kryo.KryoFeatureSerializer$;
import org.locationtech.geomesa.filter.factory.FastFilterFactory$;
import org.locationtech.geomesa.index.api.GeoMesaFeatureIndex;
import org.locationtech.geomesa.index.api.GeoMesaFeatureIndexFactory$;
import org.locationtech.geomesa.utils.cache.SoftThreadLocalCache;
import org.locationtech.geomesa.utils.conf.IndexId;
import org.locationtech.geomesa.utils.conf.IndexId$;
import org.locationtech.geomesa.utils.geotools.SimpleFeatureTypes$;
import org.locationtech.geomesa.utils.index.IndexMode$;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import scala.Enumeration;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Set;
import scala.runtime.Nothing$;

public final class IteratorCache$ {
    public static final IteratorCache$ MODULE$;
    private final ConcurrentHashMap<Tuple2<String, String>, KryoFeatureSerializer> serializerCache;
    private final ConcurrentHashMap<Tuple2<String, String>, GeoMesaFeatureIndex<?, ?>> indexCache;
    private final SoftThreadLocalCache<Tuple2<String, String>, Filter> filterCache;

    static {
        new IteratorCache$();
    }

    private ConcurrentHashMap<Tuple2<String, String>, KryoFeatureSerializer> serializerCache() {
        return this.serializerCache;
    }

    private ConcurrentHashMap<Tuple2<String, String>, GeoMesaFeatureIndex<?, ?>> indexCache() {
        return this.indexCache;
    }

    private SoftThreadLocalCache<Tuple2<String, String>, Filter> filterCache() {
        return this.filterCache;
    }

    public SimpleFeatureType sft(String spec) {
        return SimpleFeatureTypes$.MODULE$.createImmutableType("", spec);
    }

    public KryoFeatureSerializer serializer(String spec, Set<Enumeration.Value> options) {
        KryoFeatureSerializer kryoFeatureSerializer;
        KryoFeatureSerializer cached = this.serializerCache().get(new Tuple2((Object)spec, (Object)options.mkString()));
        if (cached == null) {
            KryoFeatureSerializer serializer = KryoFeatureSerializer$.MODULE$.apply(this.sft(spec), options);
            this.serializerCache().put((Tuple2<String, String>)new Tuple2((Object)spec, (Object)options.mkString()), serializer);
            kryoFeatureSerializer = serializer;
        } else {
            kryoFeatureSerializer = cached;
        }
        return kryoFeatureSerializer;
    }

    public Filter filter(SimpleFeatureType sft, String spec, String ecql) {
        return (Filter)this.filterCache().getOrElseUpdate((Object)new Tuple2((Object)spec, (Object)ecql), (Function0)new Serializable(sft, ecql){
            public static final long serialVersionUID = 0L;
            private final SimpleFeatureType sft$1;
            private final String ecql$1;

            public final Filter apply() {
                return FastFilterFactory$.MODULE$.toFilter(this.sft$1, this.ecql$1);
            }
            {
                this.sft$1 = sft$1;
                this.ecql$1 = ecql$1;
            }
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public GeoMesaFeatureIndex<?, ?> index(SimpleFeatureType sft, String spec, String identifier) {
        GeoMesaFeatureIndex geoMesaFeatureIndex;
        GeoMesaFeatureIndex cached = this.indexCache().get(new Tuple2((Object)spec, (Object)identifier));
        if (cached == null) {
            GeoMesaFeatureIndex index = (GeoMesaFeatureIndex)GeoMesaFeatureIndexFactory$.MODULE$.create(null, sft, (Seq<IndexId>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new IndexId[]{IndexId$.MODULE$.id(identifier)})))).headOption().getOrElse((Function0)new Serializable(identifier){
                public static final long serialVersionUID = 0L;
                private final String identifier$1;

                public final Nothing$ apply() {
                    throw new RuntimeException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Index option not configured correctly: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.identifier$1})));
                }
                {
                    this.identifier$1 = identifier$1;
                }
            });
            if (!index.mode().supports(IndexMode$.MODULE$.Read())) throw new RuntimeException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Index option configured for a non-readable index: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{identifier})));
            this.indexCache().put((Tuple2<String, String>)new Tuple2((Object)spec, (Object)identifier), index);
            geoMesaFeatureIndex = index;
            return geoMesaFeatureIndex;
        } else {
            geoMesaFeatureIndex = cached;
        }
        return geoMesaFeatureIndex;
    }

    private IteratorCache$() {
        MODULE$ = this;
        this.serializerCache = new ConcurrentHashMap();
        this.indexCache = new ConcurrentHashMap();
        this.filterCache = new SoftThreadLocalCache();
    }
}

