/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.index.utils;

import com.typesafe.scalalogging.Logger;
import java.io.Closeable;
import java.util.concurrent.ScheduledFuture;
import org.locationtech.geomesa.index.utils.ThreadManagement$;
import scala.Option;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005q!B\u0001\u0003\u0011\u0003i\u0011\u0001\u0005+ie\u0016\fG-T1oC\u001e,W.\u001a8u\u0015\t\u0019A!A\u0003vi&d7O\u0003\u0002\u0006\r\u0005)\u0011N\u001c3fq*\u0011q\u0001C\u0001\bO\u0016|W.Z:b\u0015\tI!\"\u0001\u0007m_\u000e\fG/[8oi\u0016\u001c\u0007NC\u0001\f\u0003\ry'oZ\u0002\u0001!\tqq\"D\u0001\u0003\r\u0015\u0001\"\u0001#\u0001\u0012\u0005A!\u0006N]3bI6\u000bg.Y4f[\u0016tGoE\u0002\u0010%a\u0001\"a\u0005\f\u000e\u0003QQ\u0011!F\u0001\u0006g\u000e\fG.Y\u0005\u0003/Q\u0011a!\u00118z%\u00164\u0007CA\r!\u001b\u0005Q\"BA\u000e\u001d\u00031\u00198-\u00197bY><w-\u001b8h\u0015\tib$\u0001\u0005usB,7/\u00194f\u0015\u0005y\u0012aA2p[&\u0011\u0011E\u0007\u0002\f\u0019\u0006T\u0018\u0010T8hO&tw\rC\u0003$\u001f\u0011\u0005A%\u0001\u0004=S:LGO\u0010\u000b\u0002\u001b!9ae\u0004b\u0001\n\u00139\u0013\u0001C3yK\u000e,Ho\u001c:\u0016\u0003!\u0002\"!\u000b\u0019\u000e\u0003)R!a\u000b\u0017\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0002.]\u0005!Q\u000f^5m\u0015\u0005y\u0013\u0001\u00026bm\u0006L!!\r\u0016\u00031M\u001b\u0007.\u001a3vY\u0016$W\t_3dkR|'oU3sm&\u001cW\r\u0003\u00044\u001f\u0001\u0006I\u0001K\u0001\nKb,7-\u001e;pe\u0002BQ!N\b\u0005\u0002Y\n\u0001B]3hSN$XM\u001d\u000b\u0003o\u0019\u0003$\u0001O\u001f\u0011\u0007%J4(\u0003\u0002;U\ty1k\u00195fIVdW\r\u001a$viV\u0014X\r\u0005\u0002={1\u0001A!\u0003 5\u0003\u0003\u0005\tQ!\u0001@\u0005\ryF%M\t\u0003\u0001\u000e\u0003\"aE!\n\u0005\t#\"a\u0002(pi\"Lgn\u001a\t\u0003'\u0011K!!\u0012\u000b\u0003\u0007\u0005s\u0017\u0010C\u0003Hi\u0001\u0007\u0001*A\u0003rk\u0016\u0014\u0018\u0010\u0005\u0002J\u00156\tqBB\u0004L\u001fA\u0005\u0019\u0013\u0001'\u0003\u00195\u000bg.Y4fIF+XM]=\u0014\u0007)k5\u000b\u0005\u0002O#6\tqJ\u0003\u0002Q]\u0005!A.\u00198h\u0013\t\u0011vJ\u0001\u0004PE*,7\r\u001e\t\u0003)^k\u0011!\u0016\u0006\u0003-:\n!![8\n\u0005a+&!C\"m_N,\u0017M\u00197f\u0011\u0015Q&J\"\u0001\\\u0003)9W\r\u001e+j[\u0016|W\u000f^\u000b\u00029B\u00111#X\u0005\u0003=R\u0011A\u0001T8oO\")\u0001M\u0013D\u0001C\u0006A\u0011n]\"m_N,G-F\u0001c!\t\u00192-\u0003\u0002e)\t9!i\\8mK\u0006t\u0007\"\u00024K\r\u00039\u0017!\u00023fEV<W#\u00015\u0011\u0005%dgBA\nk\u0013\tYG#\u0001\u0004Qe\u0016$WMZ\u0005\u0003[:\u0014aa\u0015;sS:<'BA6\u0015\r\u0011\u0001x\u0002B9\u0003\u0017E+XM]=LS2dWM]\n\u0004_6\u0013\bC\u0001(t\u0013\t!xJ\u0001\u0005Sk:t\u0017M\u00197f\u0011!9uN!A!\u0002\u0013A\u0005\"B\u0012p\t\u00039HC\u0001=z!\tIu\u000eC\u0003Hm\u0002\u0007\u0001\nC\u0003|_\u0012\u0005C0A\u0002sk:$\u0012! \t\u0003'yL!a \u000b\u0003\tUs\u0017\u000e\u001e")
public final class ThreadManagement {
    public static Logger logger() {
        return ThreadManagement$.MODULE$.logger();
    }

    public static ScheduledFuture<?> register(ManagedQuery managedQuery) {
        return ThreadManagement$.MODULE$.register(managedQuery);
    }

    public static class QueryKiller
    implements Runnable {
        private final ManagedQuery query;

        @Override
        public void run() {
            if (!this.query.isClosed()) {
                BoxedUnit boxedUnit;
                if (ThreadManagement$.MODULE$.logger().underlying().isWarnEnabled()) {
                    ThreadManagement$.MODULE$.logger().underlying().warn("Stopping {} based on timeout of {}ms", new Object[]{this.query.debug(), BoxesRunTime.boxToLong((long)this.query.getTimeout())});
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                try {
                    this.query.close();
                }
                catch (Throwable throwable) {
                    BoxedUnit boxedUnit2;
                    Throwable throwable2 = throwable;
                    Option option = NonFatal$.MODULE$.unapply(throwable2);
                    if (option.isEmpty()) {
                        throw throwable;
                    }
                    Throwable e = (Throwable)option.get();
                    if (ThreadManagement$.MODULE$.logger().underlying().isWarnEnabled()) {
                        ThreadManagement$.MODULE$.logger().underlying().warn("Error cancelling query:", e);
                        boxedUnit2 = BoxedUnit.UNIT;
                    } else {
                        boxedUnit2 = BoxedUnit.UNIT;
                    }
                    BoxedUnit boxedUnit3 = boxedUnit2;
                }
            }
        }

        public QueryKiller(ManagedQuery query2) {
            this.query = query2;
        }
    }

    public static interface ManagedQuery
    extends Closeable {
        public long getTimeout();

        public boolean isClosed();

        public String debug();
    }
}

