/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.sort;

import java.util.List;
import net.sf.saxon.expr.LastPositionFinder;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.sort.GroupIterator;
import net.sf.saxon.om.AtomicSequence;
import net.sf.saxon.om.FocusIterator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.ListIterator;
import net.sf.saxon.tree.iter.LookaheadIterator;
import net.sf.saxon.value.SequenceExtent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GroupMatchingIterator
implements LookaheadIterator,
LastPositionFinder<Item>,
GroupIterator {
    protected FocusIterator population;
    protected Pattern pattern;
    protected XPathContext baseContext;
    protected XPathContext runningContext;
    protected List currentMembers;
    protected Item next;
    protected Item current = null;
    protected int position = 0;
    private int groupSlot = -1;

    @Override
    public int getLength() throws XPathException {
        SequenceIterator another = this.getAnother();
        int n = 0;
        while (another.next() != null) {
            ++n;
        }
        return n;
    }

    protected abstract void advance() throws XPathException;

    @Override
    public AtomicSequence getCurrentGroupingKey() {
        return null;
    }

    @Override
    public SequenceIterator iterateCurrentGroup() {
        return new ListIterator(this.currentMembers);
    }

    @Override
    public boolean hasCurrentGroup() {
        return this.groupSlot < 0;
    }

    @Override
    public boolean hasCurrentGroupingKey() {
        return false;
    }

    @Override
    public boolean hasNext() {
        return this.next != null;
    }

    @Override
    public Item next() throws XPathException {
        if (this.next != null) {
            this.current = this.next;
            ++this.position;
            this.advance();
            if (this.groupSlot >= 0) {
                this.runningContext.setLocalVariable(this.groupSlot, new SequenceExtent(this.currentMembers));
            }
            return this.current;
        }
        this.current = null;
        this.position = -1;
        return null;
    }

    @Override
    public void close() {
        this.population.close();
    }

    @Override
    public int getProperties() {
        return 6;
    }
}

