/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.process.vector;

import java.util.List;
import java.util.UUID;
import org.geotools.data.DataUtilities;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.collection.BaseFeatureCollection;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.opengis.feature.Feature;
import org.opengis.feature.type.FeatureType;

public abstract class ProcessingCollection<T extends FeatureType, F extends Feature>
extends BaseFeatureCollection<T, F> {
    public ProcessingCollection() {
        this.id = this.getClass().getSimpleName() + "-" + UUID.randomUUID().toString();
    }

    @Override
    public abstract FeatureIterator<F> features();

    @Override
    public abstract ReferencedEnvelope getBounds();

    protected abstract T buildTargetFeatureType();

    @Override
    public abstract int size();

    protected int getFeatureCount() {
        return DataUtilities.count(this);
    }

    protected List<F> toList() {
        return DataUtilities.list(this);
    }

    protected ReferencedEnvelope getFeatureBounds() {
        return DataUtilities.bounds(this.features());
    }

    @Override
    public T getSchema() {
        if (this.schema == null) {
            this.schema = this.buildTargetFeatureType();
        }
        return (T)this.schema;
    }
}

