/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.process.analytic;

import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Date;
import org.geotools.data.collection.ListFeatureCollection;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.JTSFactoryFinder;
import org.geotools.process.factory.DescribeParameter;
import org.geotools.process.factory.DescribeProcess;
import org.geotools.process.factory.DescribeResult;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.locationtech.geomesa.process.GeoMesaProcess;
import org.locationtech.geomesa.process.analytic.Point2PointProcess$;
import org.locationtech.geomesa.process.analytic.Point2PointProcess$$anonfun$3$;
import org.locationtech.geomesa.utils.collection.SelfClosingIterator$;
import org.locationtech.geomesa.utils.date.DateUtils$;
import org.locationtech.geomesa.utils.geotools.Conversions;
import org.locationtech.geomesa.utils.geotools.Conversions$;
import org.locationtech.geomesa.utils.geotools.SchemaBuilder;
import org.locationtech.geomesa.utils.geotools.SchemaBuilder$;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.GeometryFactory;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@DescribeProcess(title="Point2PointProcess", description="Aggregates a collection of points into a collection of line segments")
@ScalaSignature(bytes="\u0006\u0001\u0005\u0015c\u0001B\u0001\u0003\u00015\u0011!\u0003U8j]R\u0014\u0004k\\5oiB\u0013xnY3tg*\u00111\u0001B\u0001\tC:\fG.\u001f;jG*\u0011QAB\u0001\baJ|7-Z:t\u0015\t9\u0001\"A\u0004hK>lWm]1\u000b\u0005%Q\u0011\u0001\u00047pG\u0006$\u0018n\u001c8uK\u000eD'\"A\u0006\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001qa\u0003\u0005\u0002\u0010)5\t\u0001C\u0003\u0002\u0012%\u0005!A.\u00198h\u0015\u0005\u0019\u0012\u0001\u00026bm\u0006L!!\u0006\t\u0003\r=\u0013'.Z2u!\t9\u0002$D\u0001\u0005\u0013\tIBA\u0001\bHK>lUm]1Qe>\u001cWm]:\t\u000bm\u0001A\u0011\u0001\u000f\u0002\rqJg.\u001b;?)\u0005i\u0002C\u0001\u0010\u0001\u001b\u0005\u0011\u0001b\u0002\u0011\u0001\u0005\u0004%I!I\u0001\tE\u0006\u001cX\rV=qKV\t!\u0005\u0005\u0002$U5\tAE\u0003\u0002&M\u000511/[7qY\u0016T!a\n\u0015\u0002\u000f\u0019,\u0017\r^;sK*\u0011\u0011FC\u0001\b_B,gnZ5t\u0013\tYCEA\tTS6\u0004H.\u001a$fCR,(/\u001a+za\u0016Da!\f\u0001!\u0002\u0013\u0011\u0013!\u00032bg\u0016$\u0016\u0010]3!\u0011\u001dy\u0003A1A\u0005\nA\n!a\u001a4\u0016\u0003E\u0002\"AM\u001c\u000e\u0003MR!\u0001N\u001b\u0002\t\u001d,w.\u001c\u0006\u0003m!\t1A\u001b;t\u0013\tA4GA\bHK>lW\r\u001e:z\r\u0006\u001cGo\u001c:z\u0011\u0019Q\u0004\u0001)A\u0005c\u0005\u0019qM\u001a\u0011\t\u000bq\u0002A\u0011A\u001f\u0002\u000f\u0015DXmY;uKR9ahR+fWVt\bCA F\u001b\u0005\u0001%BA\u0013B\u0015\t\u00115)\u0001\u0003eCR\f'B\u0001#\u000b\u0003!9Wm\u001c;p_2\u001c\u0018B\u0001$A\u0005]\u0019\u0016.\u001c9mK\u001a+\u0017\r^;sK\u000e{G\u000e\\3di&|g\u000eC\u0003Cw\u0001\u0007a\b\u000b\u0004H\u0013B\u000b&k\u0015\t\u0003\u0015:k\u0011a\u0013\u0006\u0003\u00196\u000bqAZ1di>\u0014\u0018P\u0003\u0002\u0006\u0007&\u0011qj\u0013\u0002\u0012\t\u0016\u001c8M]5cKB\u000b'/Y7fi\u0016\u0014\u0018\u0001\u00028b[\u0016\f\u0013AQ\u0001\fI\u0016\u001c8M]5qi&|g.I\u0001U\u0003aIe\u000e];uA\u0019,\u0017\r^;sK\u0002\u001aw\u000e\u001c7fGRLwN\u001c\u0005\u0006-n\u0002\raV\u0001\u000eOJ|W\u000f]5oO\u001aKW\r\u001c3\u0011\u0005asfBA-]\u001b\u0005Q&\"A.\u0002\u000bM\u001c\u0017\r\\1\n\u0005uS\u0016A\u0002)sK\u0012,g-\u0003\u0002`A\n11\u000b\u001e:j]\u001eT!!\u0018.)\rUK\u0005K\u0019*dC\u00051\u0016%\u00013\u0002/\u0019KW\r\u001c3!_:\u0004s\u000f[5dQ\u0002\"x\u000eI4s_V\u0004\b\"\u00024<\u0001\u00049\u0016!C:peR4\u0015.\u001a7eQ\u0019)\u0017\n\u00155SS\u0006\na-I\u0001k\u0003)2\u0015.\u001a7eA=t\u0007e\u001e5jG\"\u0004Co\u001c\u0011t_J$\b\u0005K7vgR\u0004#-\u001a\u0011ECR,\u0007\u0005^=qK&BQ\u0001\\\u001eA\u00025\f\u0011\"\\5o!>Lg\u000e^:\u0011\u0005es\u0017BA8[\u0005\rIe\u000e\u001e\u0015\u0007W&\u0003\u0016OU:\"\u0003I\fQ#\\5oS6,XNT;nE\u0016\u0014xJ\u001a)pS:$8/I\u0001u\u0003ai\u0015N\\5nk6\u0004c.^7cKJ\u0004sN\u001a\u0011q_&tGo\u001d\u0005\u0006mn\u0002\ra^\u0001\u000bEJ,\u0017m[(o\t\u0006L\bCA-y\u0013\tI(LA\u0004C_>dW-\u00198)\rUL\u0005k\u001f*}C\u00051\u0018%A?\u0002=\t\u0013X-Y6!G>tg.Z2uS>t7\u000fI8oA\u0011\f\u0017\u0010I7be.\u001c\b\"B@<\u0001\u00049\u0018\u0001\u00064jYR,'oU5oOVd\u0017M\u001d)pS:$8\u000f\u000b\u0007\u007f\u0013B\u000b\u0019AUA\u0003\u0003\u0013\tY!I\u0001\u0000C\t\t9!A\u0018GS2$XM\u001d\u0011pkR\u00043/Z4nK:$8\u000f\t;iCR\u0004c-\u00197mA=t\u0007\u0005\u001e5fAM\fW.\u001a\u0011q_&tG/\u0001\u0007eK\u001a\fW\u000f\u001c;WC2,X-\t\u0002\u0002\u000e\u0005!AO];fQ%Y\u0014\u0011\u0003)\u0002\u0018I\u000bY\u0002E\u0002K\u0003'I1!!\u0006L\u00059!Um]2sS\n,'+Z:vYR\f#!!\u0007\u0002\rI,7/\u001e7uC\t\ti\"A\u000fBO\u001e\u0014XmZ1uK\u0012\u0004c-Z1ukJ,\u0007eY8mY\u0016\u001cG/[8o\u0011\u001d\t\t\u0003\u0001C\u0001\u0003G\tAbZ3u\t\u0006LxJZ-fCJ$R!\\A\u0013\u0003SAq!a\n\u0002 \u0001\u0007Q.\u0001\bt_J$h)[3mI&sG-\u001a=\t\u0011\u0005-\u0012q\u0004a\u0001\u0003[\t\u0011A\u001a\t\u0004G\u0005=\u0012bAA\u0019I\ti1+[7qY\u00164U-\u0019;ve\u0016D#\u0002AA\u001b\u0003w\tiDUA!!\rQ\u0015qG\u0005\u0004\u0003sY%a\u0004#fg\u000e\u0014\u0018NY3Qe>\u001cWm]:\u0002\u000bQLG\u000f\\3\"\u0005\u0005}\u0012A\u0005)pS:$(\u0007U8j]R\u0004&o\\2fgN\f#!a\u0011\u0002\t\u0006;wM]3hCR,7\u000fI1!G>dG.Z2uS>t\u0007e\u001c4!a>Lg\u000e^:!S:$x\u000eI1!G>dG.Z2uS>t\u0007e\u001c4!Y&tW\rI:fO6,g\u000e^:")
public class Point2PointProcess
implements GeoMesaProcess {
    private final SimpleFeatureType baseType = SchemaBuilder$.MODULE$.toSchemaBuilder((SchemaBuilder.AttributeBuilder)SchemaBuilder$.MODULE$.builder().addLineString("geom", true)).build("point2point");
    private final GeometryFactory org$locationtech$geomesa$process$analytic$Point2PointProcess$$gf = JTSFactoryFinder.getGeometryFactory();

    private SimpleFeatureType baseType() {
        return this.baseType;
    }

    public GeometryFactory org$locationtech$geomesa$process$analytic$Point2PointProcess$$gf() {
        return this.org$locationtech$geomesa$process$analytic$Point2PointProcess$$gf;
    }

    @DescribeResult(name="result", description="Aggregated feature collection")
    public SimpleFeatureCollection execute(@DescribeParameter(name="data", description="Input feature collection") SimpleFeatureCollection data, @DescribeParameter(name="groupingField", description="Field on which to group") String groupingField, @DescribeParameter(name="sortField", description="Field on which to sort (must be Date type)") String sortField, @DescribeParameter(name="minimumNumberOfPoints", description="Minimum number of points") int minPoints, @DescribeParameter(name="breakOnDay", description="Break connections on day marks") boolean breakOnDay, @DescribeParameter(name="filterSingularPoints", description="Filter out segments that fall on the same point", defaultValue="true") boolean filterSingularPoints) {
        SimpleFeatureType queryType = (SimpleFeatureType)data.getSchema();
        SimpleFeatureTypeBuilder sftBuilder = new SimpleFeatureTypeBuilder();
        sftBuilder.init(this.baseType());
        int groupingFieldIndex = ((SimpleFeatureType)data.getSchema()).indexOf(groupingField);
        sftBuilder.add((AttributeDescriptor)queryType.getAttributeDescriptors().get(groupingFieldIndex));
        int sortFieldIndex = ((SimpleFeatureType)data.getSchema()).indexOf(sortField);
        AttributeDescriptor sortDesc = (AttributeDescriptor)queryType.getAttributeDescriptors().get(sortFieldIndex);
        String sortAttrName = sortDesc.getLocalName();
        Class sortType = sortDesc.getType().getBinding();
        sftBuilder.add(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "_start"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{sortAttrName})), sortType);
        sftBuilder.add(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "_end"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{sortAttrName})), sortType);
        SimpleFeatureType sft = sftBuilder.buildFeatureType();
        SimpleFeatureBuilder builder = new SimpleFeatureBuilder(sft);
        Iterable lineFeatures = (Iterable)((TraversableLike)SelfClosingIterator$.MODULE$.apply(data.features()).toList().groupBy((Function1)new Serializable(this, groupingFieldIndex){
            public static final long serialVersionUID = 0L;
            private final int groupingFieldIndex$1;

            public final String apply(SimpleFeature f) {
                return String.valueOf(f.getAttribute(this.groupingFieldIndex$1));
            }
            {
                this.groupingFieldIndex$1 = groupingFieldIndex$1;
            }
        }).filter((Function1)new Serializable(this, minPoints){
            public static final long serialVersionUID = 0L;
            private final int minPoints$1;

            public final boolean apply(Tuple2<String, List<SimpleFeature>> x0$1) {
                Tuple2<String, List<SimpleFeature>> tuple2 = x0$1;
                if (tuple2 != null) {
                    List coll = (List)tuple2._2();
                    boolean bl = coll.lengthCompare(this.minPoints$1) > 0;
                    return bl;
                }
                throw new MatchError(tuple2);
            }
            {
                this.minPoints$1 = minPoints$1;
            }
        })).flatMap((Function1)new Serializable(this, breakOnDay, filterSingularPoints, groupingFieldIndex, sortFieldIndex, sortAttrName, builder){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Point2PointProcess $outer;
            private final boolean breakOnDay$1;
            private final boolean filterSingularPoints$1;
            public final int groupingFieldIndex$1;
            public final int sortFieldIndex$1;
            public final String sortAttrName$1;
            public final SimpleFeatureBuilder builder$1;

            public final ArrayOps<SimpleFeature> apply(Tuple2<String, List<SimpleFeature>> x0$2) {
                Tuple2<String, List<SimpleFeature>> tuple2 = x0$2;
                if (tuple2 != null) {
                    List coll = (List)tuple2._2();
                    List globalSorted = (List)coll.sortBy((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$3 $outer;

                        public final Date apply(SimpleFeature x$1) {
                            return (Date)Conversions.RichSimpleFeature$.MODULE$.get$extension0(Conversions$.MODULE$.RichSimpleFeature(x$1), this.$outer.sortFieldIndex$1);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    }, Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms()));
                    List[] groups = this.breakOnDay$1 ? (List[])((TraversableOnce)((TraversableLike)globalSorted.groupBy((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$3 $outer;

                        public final int apply(SimpleFeature f) {
                            return this.$outer.org$locationtech$geomesa$process$analytic$Point2PointProcess$$anonfun$$$outer().getDayOfYear(this.$outer.sortFieldIndex$1, f);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    }).filter((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final boolean apply(Tuple2<Object, List<SimpleFeature>> x0$3) {
                            Tuple2<Object, List<SimpleFeature>> tuple2 = x0$3;
                            if (tuple2 != null) {
                                List g = (List)tuple2._2();
                                boolean bl = g.lengthCompare(2) >= 0;
                                return bl;
                            }
                            throw new MatchError(tuple2);
                        }
                    })).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final List<SimpleFeature> apply(Tuple2<Object, List<SimpleFeature>> x0$4) {
                            Tuple2<Object, List<SimpleFeature>> tuple2 = x0$4;
                            if (tuple2 != null) {
                                List g;
                                List list = g = (List)tuple2._2();
                                return list;
                            }
                            throw new MatchError(tuple2);
                        }
                    }, Iterable$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(List.class)) : (List[])((Object[])new List[]{globalSorted});
                    Tuple2[] results2 = (Tuple2[])Predef$.MODULE$.refArrayOps((Object[])groups).flatMap((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$3 $outer;

                        public final Iterator<Tuple2<Object, SimpleFeature>> apply(List<SimpleFeature> sorted) {
                            return sorted.sliding(2).zipWithIndex().map((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ $anonfun$3$$anonfun$8 $outer;

                                public final Tuple2<Object, SimpleFeature> apply(Tuple2<List<SimpleFeature>, Object> x0$5) {
                                    Tuple2<List<SimpleFeature>, Object> tuple2 = x0$5;
                                    if (tuple2 != null) {
                                        List ptLst = (List)tuple2._1();
                                        int idx = tuple2._2$mcI$sp();
                                        List pts = (List)ptLst.map((Function1)new Serializable(this){
                                            public static final long serialVersionUID = 0L;

                                            public final Coordinate apply(SimpleFeature x$2) {
                                                return Conversions.RichSimpleFeature$.MODULE$.point$extension(Conversions$.MODULE$.RichSimpleFeature(x$2)).getCoordinate();
                                            }
                                        }, List$.MODULE$.canBuildFrom());
                                        double length = JTS.orthodromicDistance((Coordinate)((Coordinate)pts.head()), (Coordinate)((Coordinate)pts.last()), (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
                                        Object group = ((SimpleFeature)ptLst.head()).getAttribute(this.$outer.org$locationtech$geomesa$process$analytic$Point2PointProcess$$anonfun$$anonfun$$$outer().groupingFieldIndex$1);
                                        Object startDtg = ((SimpleFeature)ptLst.head()).getAttribute(this.$outer.org$locationtech$geomesa$process$analytic$Point2PointProcess$$anonfun$$anonfun$$$outer().sortAttrName$1);
                                        Object endDtg = ((SimpleFeature)ptLst.last()).getAttribute(this.$outer.org$locationtech$geomesa$process$analytic$Point2PointProcess$$anonfun$$anonfun$$$outer().sortAttrName$1);
                                        Object[] attrs = new Object[]{this.$outer.org$locationtech$geomesa$process$analytic$Point2PointProcess$$anonfun$$anonfun$$$outer().org$locationtech$geomesa$process$analytic$Point2PointProcess$$anonfun$$$outer().org$locationtech$geomesa$process$analytic$Point2PointProcess$$gf().createLineString((Coordinate[])pts.toArray(ClassTag$.MODULE$.apply(Coordinate.class))), group, startDtg, endDtg};
                                        SimpleFeature sf = this.$outer.org$locationtech$geomesa$process$analytic$Point2PointProcess$$anonfun$$anonfun$$$outer().builder$1.buildFeature(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{group, BoxesRunTime.boxToInteger((int)idx)})), attrs);
                                        Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToDouble((double)length), (Object)sf);
                                        return tuple22;
                                    }
                                    throw new MatchError(tuple2);
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                }
                            });
                        }

                        public /* synthetic */ $anonfun$3 org$locationtech$geomesa$process$analytic$Point2PointProcess$$anonfun$$anonfun$$$outer() {
                            return this.$outer;
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)));
                    ArrayOps arrayOps = this.filterSingularPoints$1 ? Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])results2).collect((PartialFunction)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        /*
                         * Enabled aggressive block sorting
                         */
                        public final <A1 extends Tuple2<Object, SimpleFeature>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                            Object object;
                            A1 A1 = x1;
                            if (A1 != null) {
                                double length = A1._1$mcD$sp();
                                SimpleFeature sf = (SimpleFeature)A1._2();
                                if (length > 0.0) {
                                    object = sf;
                                    return (B1)object;
                                }
                            }
                            object = function1.apply(x1);
                            return (B1)object;
                        }

                        public final boolean isDefinedAt(Tuple2<Object, SimpleFeature> x1) {
                            double length;
                            Tuple2<Object, SimpleFeature> tuple2 = x1;
                            boolean bl = tuple2 != null && (length = tuple2._1$mcD$sp()) > 0.0;
                            return bl;
                        }
                    }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(SimpleFeature.class)))) : Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])results2).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final SimpleFeature apply(Tuple2<Object, SimpleFeature> x0$6) {
                            Tuple2<Object, SimpleFeature> tuple2 = x0$6;
                            if (tuple2 != null) {
                                SimpleFeature sf;
                                SimpleFeature simpleFeature = sf = (SimpleFeature)tuple2._2();
                                return simpleFeature;
                            }
                            throw new MatchError(tuple2);
                        }
                    }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(SimpleFeature.class))));
                    return arrayOps;
                }
                throw new MatchError(tuple2);
            }

            public /* synthetic */ Point2PointProcess org$locationtech$geomesa$process$analytic$Point2PointProcess$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.breakOnDay$1 = breakOnDay$1;
                this.filterSingularPoints$1 = filterSingularPoints$1;
                this.groupingFieldIndex$1 = groupingFieldIndex$1;
                this.sortFieldIndex$1 = sortFieldIndex$1;
                this.sortAttrName$1 = sortAttrName$1;
                this.builder$1 = builder$1;
            }
        }, Iterable$.MODULE$.canBuildFrom());
        return new ListFeatureCollection(sft, JavaConversions$.MODULE$.seqAsJavaList((Seq)lineFeatures.toList()));
    }

    public int getDayOfYear(int sortFieldIndex, SimpleFeature f) {
        return ZonedDateTime.ofInstant(DateUtils$.MODULE$.toInstant((Date)f.getAttribute(sortFieldIndex)), ZoneOffset.UTC).getDayOfYear();
    }
}

