/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.arrow.io;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.ByteArrayOutputStream;
import java.util.Collections;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.ValueVector;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.complex.StructVector;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.Schema;
import org.apache.arrow.vector.util.TransferPair;
import org.locationtech.geomesa.arrow.io.SimpleFeatureArrowFileWriter;
import org.locationtech.geomesa.arrow.io.SimpleFeatureArrowFileWriter$;
import org.locationtech.geomesa.arrow.io.SimpleFeatureArrowIO$Metadata$;
import org.locationtech.geomesa.arrow.io.records.RecordBatchLoader;
import org.locationtech.geomesa.arrow.io.records.RecordBatchLoader$;
import org.locationtech.geomesa.arrow.io.records.RecordBatchUnloader;
import org.locationtech.geomesa.arrow.vector.ArrowDictionary;
import org.locationtech.geomesa.arrow.vector.ArrowDictionary$;
import org.locationtech.geomesa.arrow.vector.ArrowDictionaryReader;
import org.locationtech.geomesa.arrow.vector.GeometryFields;
import org.locationtech.geomesa.arrow.vector.GeometryVector;
import org.locationtech.geomesa.arrow.vector.SimpleFeatureVector;
import org.locationtech.geomesa.arrow.vector.SimpleFeatureVector$;
import org.locationtech.geomesa.utils.collection.CloseableIterator;
import org.locationtech.geomesa.utils.collection.CloseableIterator$;
import org.locationtech.geomesa.utils.conversions.ScalaImplicits;
import org.locationtech.geomesa.utils.conversions.ScalaImplicits$;
import org.locationtech.geomesa.utils.geotools.SimpleFeatureOrdering$;
import org.locationtech.geomesa.utils.io.CloseWithLogging$;
import org.opengis.feature.simple.SimpleFeatureType;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.BufferedIterator;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.JavaConversions$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Traversable;
import scala.collection.TraversableOnce;
import scala.collection.generic.CanBuildFrom;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Set;
import scala.collection.immutable.Stream;
import scala.collection.immutable.Vector;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Builder;
import scala.collection.mutable.PriorityQueue;
import scala.collection.mutable.PriorityQueue$;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.math.PartialOrdering;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

public final class SimpleFeatureArrowIO$
implements LazyLogging {
    public static final SimpleFeatureArrowIO$ MODULE$;
    private final Object ordering;
    private final Logger logger;
    private volatile boolean bitmap$0;

    static {
        new SimpleFeatureArrowIO$();
    }

    private Logger logger$lzycompute() {
        SimpleFeatureArrowIO$ simpleFeatureArrowIO$ = this;
        synchronized (simpleFeatureArrowIO$) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    private Object ordering() {
        return this.ordering;
    }

    public CloseableIterator<byte[]> reduceFiles(SimpleFeatureType sft, Seq<String> dictionaryFields, SimpleFeatureVector.SimpleFeatureEncoding encoding, Option<Tuple2<String, Object>> sort, CloseableIterator<byte[]> files, BufferAllocator allocator) {
        return files.hasNext() ? files : this.createFile(sft, this.createEmptyDictionaries(dictionaryFields), encoding, sort, files, allocator);
    }

    public CloseableIterator<byte[]> reduceBatches(SimpleFeatureType sft, scala.collection.immutable.Map<String, ArrowDictionary> dictionaries2, SimpleFeatureVector.SimpleFeatureEncoding encoding, Option<Tuple2<String, Object>> sort, int batchSize, CloseableIterator<byte[]> batches, BufferAllocator allocator) {
        Option<Tuple2<String, Object>> option;
        block4: {
            CloseableIterator<byte[]> closeableIterator;
            block3: {
                Some some;
                Tuple2 tuple2;
                block2: {
                    option = sort;
                    if (!None$.MODULE$.equals(option)) break block2;
                    closeableIterator = batches;
                    break block3;
                }
                if (!(option instanceof Some) || (tuple2 = (Tuple2)(some = (Some)option).x()) == null) break block4;
                String field = (String)tuple2._1();
                boolean reverse = tuple2._2$mcZ$sp();
                closeableIterator = this.sortBatches(sft, dictionaries2, encoding, field, reverse, batchSize, batches, allocator);
            }
            CloseableIterator<byte[]> sorted = closeableIterator;
            return this.createFile(sft, dictionaries2, encoding, sort, sorted, allocator);
        }
        throw new MatchError(option);
    }

    public CloseableIterator<byte[]> sortBatches(SimpleFeatureType sft, scala.collection.immutable.Map<String, ArrowDictionary> dictionaries2, SimpleFeatureVector.SimpleFeatureEncoding encoding, String sortBy, boolean reverse, int batchSize, CloseableIterator<byte[]> iter, BufferAllocator allocator) {
        CloseableIterator closeableIterator;
        Seq batches = iter.toSeq();
        if (batches.lengthCompare(2) < 0) {
            closeableIterator = CloseableIterator$.MODULE$.apply(batches.iterator(), (Function0)new Serializable(iter){
                public static final long serialVersionUID = 0L;
                private final CloseableIterator iter$1;

                public final void apply() {
                    this.apply$mcV$sp();
                }

                public void apply$mcV$sp() {
                    this.iter$1.close();
                }
                {
                    this.iter$1 = iter$1;
                }
            });
        } else {
            int sortByIndex = sft.indexOf(sortBy);
            Object getSortAttribute = dictionaries2.contains((Object)sortBy) ? new Serializable(sortByIndex){
                public static final long serialVersionUID = 0L;
                private final int sortByIndex$1;

                public final Integer apply(SimpleFeatureVector vector, int i) {
                    return ((ArrowDictionaryReader)vector.reader().readers()[this.sortByIndex$1]).getEncoded(i);
                }
                {
                    this.sortByIndex$1 = sortByIndex$1;
                }
            } : new Serializable(sortByIndex){
                public static final long serialVersionUID = 0L;
                private final int sortByIndex$1;

                public final Object apply(SimpleFeatureVector vector, int i) {
                    return vector.reader().readers()[this.sortByIndex$1].apply(i);
                }
                {
                    this.sortByIndex$1 = sortByIndex$1;
                }
            };
            SimpleFeatureVector result = SimpleFeatureVector$.MODULE$.create(sft, dictionaries2, encoding, SimpleFeatureVector$.MODULE$.create$default$4(), allocator);
            Tuple2[] inputs = (Tuple2[])((TraversableOnce)batches.map((Function1)new Serializable(dictionaries2, allocator, result){
                public static final long serialVersionUID = 0L;
                private final scala.collection.immutable.Map dictionaries$1;
                private final BufferAllocator allocator$1;
                private final SimpleFeatureVector result$1;

                public final Tuple2<SimpleFeatureVector, Function2<Object, Object, BoxedUnit>> apply(byte[] bytes) {
                    Field field = this.result$1.underlying().getField();
                    RecordBatchLoader loader = RecordBatchLoader$.MODULE$.apply(field, this.allocator$1);
                    SimpleFeatureVector vector = SimpleFeatureVector$.MODULE$.wrap((StructVector)loader.vector(), (scala.collection.immutable.Map<String, ArrowDictionary>)this.dictionaries$1, this.allocator$1);
                    loader.load(bytes);
                    java.util.List fromVectors = vector.underlying().getChildrenFromFields();
                    java.util.List toVectors = this.result$1.underlying().getChildrenFromFields();
                    Builder builder = Seq$.MODULE$.newBuilder();
                    builder.sizeHint(fromVectors.size());
                    for (int i = 0; i < fromVectors.size(); ++i) {
                        Builder builder2;
                        FieldVector fromVector = (FieldVector)fromVectors.get(i);
                        FieldVector toVector = (FieldVector)toVectors.get(i);
                        if (SimpleFeatureVector$.MODULE$.isGeometryVector(fromVector)) {
                            GeometryVector from = GeometryFields.wrap((FieldVector)fromVector);
                            GeometryVector to = GeometryFields.wrap((FieldVector)toVector);
                            builder2 = builder.$plus$eq((Object)new Serializable(this, from, to){
                                public static final long serialVersionUID = 0L;
                                private final GeometryVector from$1;
                                private final GeometryVector to$1;

                                public final void apply(int fromIndex, int toIndex) {
                                    this.apply$mcVII$sp(fromIndex, toIndex);
                                }

                                public void apply$mcVII$sp(int fromIndex, int toIndex) {
                                    this.from$1.transfer(fromIndex, toIndex, this.to$1);
                                }
                                {
                                    this.from$1 = from$1;
                                    this.to$1 = to$1;
                                }
                            });
                            continue;
                        }
                        TransferPair transfer = fromVector.makeTransferPair((ValueVector)toVector);
                        builder2 = builder.$plus$eq((Object)new Serializable(this, transfer){
                            public static final long serialVersionUID = 0L;
                            private final TransferPair transfer$1;

                            public final void apply(int fromIndex, int toIndex) {
                                this.apply$mcVII$sp(fromIndex, toIndex);
                            }

                            public void apply$mcVII$sp(int fromIndex, int toIndex) {
                                this.transfer$1.copyValueSafe(fromIndex, toIndex);
                            }
                            {
                                this.transfer$1 = transfer$1;
                            }
                        });
                    }
                    Seq transfers = (Seq)builder.result();
                    Serializable transfer = new Serializable(this, transfers){
                        public static final long serialVersionUID = 0L;
                        private final Seq transfers$1;

                        public final void apply(int from, int to) {
                            this.apply$mcVII$sp(from, to);
                        }

                        public void apply$mcVII$sp(int from, int to) {
                            this.transfers$1.foreach((Function1)new Serializable(this, from, to){
                                public static final long serialVersionUID = 0L;
                                private final int from$2;
                                private final int to$2;

                                public final void apply(Function2<Object, Object, BoxedUnit> x$1) {
                                    x$1.apply$mcVII$sp(this.from$2, this.to$2);
                                }
                                {
                                    this.from$2 = from$2;
                                    this.to$2 = to$2;
                                }
                            });
                        }
                        {
                            this.transfers$1 = transfers$1;
                        }
                    };
                    return new Tuple2((Object)vector, (Object)transfer);
                }
                {
                    this.dictionaries$1 = dictionaries$1;
                    this.allocator$1 = allocator$1;
                    this.result$1 = result$1;
                }
            }, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Tuple2.class));
            Ordering order = reverse ? this.ordering() : this.ordering().reverse();
            PriorityQueue heads = (PriorityQueue)PriorityQueue$.MODULE$.empty(order);
            for (int i = 0; i < inputs.length; ++i) {
                BoxedUnit boxedUnit;
                SimpleFeatureVector vector = (SimpleFeatureVector)inputs[i]._1();
                if (vector.reader().getValueCount() > 0) {
                    boxedUnit = heads.$plus$eq((Object)new Tuple3(getSortAttribute.apply((Object)vector, (Object)BoxesRunTime.boxToInteger((int)0)), (Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToInteger((int)i)));
                    continue;
                }
                vector.close();
                boxedUnit = BoxedUnit.UNIT;
            }
            PriorityQueue queue = heads;
            RecordBatchUnloader unloader = new RecordBatchUnloader(result);
            Iterator<byte[]> output = new Iterator<byte[]>(batchSize, (Function2)getSortAttribute, result, inputs, queue, unloader){
                private byte[] batch;
                private final int batchSize$1;
                private final Function2 getSortAttribute$1;
                private final SimpleFeatureVector result$1;
                private final Tuple2[] inputs$1;
                private final PriorityQueue queue$1;
                private final RecordBatchUnloader unloader$1;

                public Iterator<byte[]> seq() {
                    return Iterator.class.seq((Iterator)this);
                }

                public boolean isEmpty() {
                    return Iterator.class.isEmpty((Iterator)this);
                }

                public boolean isTraversableAgain() {
                    return Iterator.class.isTraversableAgain((Iterator)this);
                }

                public boolean hasDefiniteSize() {
                    return Iterator.class.hasDefiniteSize((Iterator)this);
                }

                public Iterator<byte[]> take(int n) {
                    return Iterator.class.take((Iterator)this, (int)n);
                }

                public Iterator<byte[]> drop(int n) {
                    return Iterator.class.drop((Iterator)this, (int)n);
                }

                public Iterator<byte[]> slice(int from, int until) {
                    return Iterator.class.slice((Iterator)this, (int)from, (int)until);
                }

                public <B> Iterator<B> map(Function1<byte[], B> f) {
                    return Iterator.class.map((Iterator)this, f);
                }

                public <B> Iterator<B> $plus$plus(Function0<GenTraversableOnce<B>> that) {
                    return Iterator.class.$plus$plus((Iterator)this, that);
                }

                public <B> Iterator<B> flatMap(Function1<byte[], GenTraversableOnce<B>> f) {
                    return Iterator.class.flatMap((Iterator)this, f);
                }

                public Iterator<byte[]> filter(Function1<byte[], Object> p) {
                    return Iterator.class.filter((Iterator)this, p);
                }

                public <B> boolean corresponds(GenTraversableOnce<B> that, Function2<byte[], B, Object> p) {
                    return Iterator.class.corresponds((Iterator)this, that, p);
                }

                public Iterator<byte[]> withFilter(Function1<byte[], Object> p) {
                    return Iterator.class.withFilter((Iterator)this, p);
                }

                public Iterator<byte[]> filterNot(Function1<byte[], Object> p) {
                    return Iterator.class.filterNot((Iterator)this, p);
                }

                public <B> Iterator<B> collect(PartialFunction<byte[], B> pf) {
                    return Iterator.class.collect((Iterator)this, pf);
                }

                public <B> Iterator<B> scanLeft(B z, Function2<B, byte[], B> op) {
                    return Iterator.class.scanLeft((Iterator)this, z, op);
                }

                public <B> Iterator<B> scanRight(B z, Function2<byte[], B, B> op) {
                    return Iterator.class.scanRight((Iterator)this, z, op);
                }

                public Iterator<byte[]> takeWhile(Function1<byte[], Object> p) {
                    return Iterator.class.takeWhile((Iterator)this, p);
                }

                public Tuple2<Iterator<byte[]>, Iterator<byte[]>> partition(Function1<byte[], Object> p) {
                    return Iterator.class.partition((Iterator)this, p);
                }

                public Tuple2<Iterator<byte[]>, Iterator<byte[]>> span(Function1<byte[], Object> p) {
                    return Iterator.class.span((Iterator)this, p);
                }

                public Iterator<byte[]> dropWhile(Function1<byte[], Object> p) {
                    return Iterator.class.dropWhile((Iterator)this, p);
                }

                public <B> Iterator<Tuple2<byte[], B>> zip(Iterator<B> that) {
                    return Iterator.class.zip((Iterator)this, that);
                }

                public <A1> Iterator<A1> padTo(int len, A1 elem) {
                    return Iterator.class.padTo((Iterator)this, (int)len, elem);
                }

                public Iterator<Tuple2<byte[], Object>> zipWithIndex() {
                    return Iterator.class.zipWithIndex((Iterator)this);
                }

                public <B, A1, B1> Iterator<Tuple2<A1, B1>> zipAll(Iterator<B> that, A1 thisElem, B1 thatElem) {
                    return Iterator.class.zipAll((Iterator)this, that, thisElem, thatElem);
                }

                public <U> void foreach(Function1<byte[], U> f) {
                    Iterator.class.foreach((Iterator)this, f);
                }

                public boolean forall(Function1<byte[], Object> p) {
                    return Iterator.class.forall((Iterator)this, p);
                }

                public boolean exists(Function1<byte[], Object> p) {
                    return Iterator.class.exists((Iterator)this, p);
                }

                public boolean contains(Object elem) {
                    return Iterator.class.contains((Iterator)this, (Object)elem);
                }

                public Option<byte[]> find(Function1<byte[], Object> p) {
                    return Iterator.class.find((Iterator)this, p);
                }

                public int indexWhere(Function1<byte[], Object> p) {
                    return Iterator.class.indexWhere((Iterator)this, p);
                }

                public <B> int indexOf(B elem) {
                    return Iterator.class.indexOf((Iterator)this, elem);
                }

                public BufferedIterator<byte[]> buffered() {
                    return Iterator.class.buffered((Iterator)this);
                }

                public <B> Iterator.GroupedIterator<B> grouped(int size) {
                    return Iterator.class.grouped((Iterator)this, (int)size);
                }

                public <B> Iterator.GroupedIterator<B> sliding(int size, int step) {
                    return Iterator.class.sliding((Iterator)this, (int)size, (int)step);
                }

                public int length() {
                    return Iterator.class.length((Iterator)this);
                }

                public Tuple2<Iterator<byte[]>, Iterator<byte[]>> duplicate() {
                    return Iterator.class.duplicate((Iterator)this);
                }

                public <B> Iterator<B> patch(int from, Iterator<B> patchElems, int replaced) {
                    return Iterator.class.patch((Iterator)this, (int)from, patchElems, (int)replaced);
                }

                public <B> void copyToArray(Object xs, int start, int len) {
                    Iterator.class.copyToArray((Iterator)this, (Object)xs, (int)start, (int)len);
                }

                public boolean sameElements(Iterator<?> that) {
                    return Iterator.class.sameElements((Iterator)this, that);
                }

                public Traversable<byte[]> toTraversable() {
                    return Iterator.class.toTraversable((Iterator)this);
                }

                public Iterator<byte[]> toIterator() {
                    return Iterator.class.toIterator((Iterator)this);
                }

                public Stream<byte[]> toStream() {
                    return Iterator.class.toStream((Iterator)this);
                }

                public String toString() {
                    return Iterator.class.toString((Iterator)this);
                }

                public <B> int sliding$default$2() {
                    return Iterator.class.sliding$default$2((Iterator)this);
                }

                public List<byte[]> reversed() {
                    return TraversableOnce.class.reversed((TraversableOnce)this);
                }

                public int size() {
                    return TraversableOnce.class.size((TraversableOnce)this);
                }

                public boolean nonEmpty() {
                    return TraversableOnce.class.nonEmpty((TraversableOnce)this);
                }

                public int count(Function1<byte[], Object> p) {
                    return TraversableOnce.class.count((TraversableOnce)this, p);
                }

                public <B> Option<B> collectFirst(PartialFunction<byte[], B> pf) {
                    return TraversableOnce.class.collectFirst((TraversableOnce)this, pf);
                }

                public <B> B $div$colon(B z, Function2<B, byte[], B> op) {
                    return (B)TraversableOnce.class.$div$colon((TraversableOnce)this, z, op);
                }

                public <B> B $colon$bslash(B z, Function2<byte[], B, B> op) {
                    return (B)TraversableOnce.class.$colon$bslash((TraversableOnce)this, z, op);
                }

                public <B> B foldLeft(B z, Function2<B, byte[], B> op) {
                    return (B)TraversableOnce.class.foldLeft((TraversableOnce)this, z, op);
                }

                public <B> B foldRight(B z, Function2<byte[], B, B> op) {
                    return (B)TraversableOnce.class.foldRight((TraversableOnce)this, z, op);
                }

                public <B> B reduceLeft(Function2<B, byte[], B> op) {
                    return (B)TraversableOnce.class.reduceLeft((TraversableOnce)this, op);
                }

                public <B> B reduceRight(Function2<byte[], B, B> op) {
                    return (B)TraversableOnce.class.reduceRight((TraversableOnce)this, op);
                }

                public <B> Option<B> reduceLeftOption(Function2<B, byte[], B> op) {
                    return TraversableOnce.class.reduceLeftOption((TraversableOnce)this, op);
                }

                public <B> Option<B> reduceRightOption(Function2<byte[], B, B> op) {
                    return TraversableOnce.class.reduceRightOption((TraversableOnce)this, op);
                }

                public <A1> A1 reduce(Function2<A1, A1, A1> op) {
                    return (A1)TraversableOnce.class.reduce((TraversableOnce)this, op);
                }

                public <A1> Option<A1> reduceOption(Function2<A1, A1, A1> op) {
                    return TraversableOnce.class.reduceOption((TraversableOnce)this, op);
                }

                public <A1> A1 fold(A1 z, Function2<A1, A1, A1> op) {
                    return (A1)TraversableOnce.class.fold((TraversableOnce)this, z, op);
                }

                public <B> B aggregate(Function0<B> z, Function2<B, byte[], B> seqop, Function2<B, B, B> combop) {
                    return (B)TraversableOnce.class.aggregate((TraversableOnce)this, z, seqop, combop);
                }

                public <B> B sum(Numeric<B> num) {
                    return (B)TraversableOnce.class.sum((TraversableOnce)this, num);
                }

                public <B> B product(Numeric<B> num) {
                    return (B)TraversableOnce.class.product((TraversableOnce)this, num);
                }

                public Object min(Ordering cmp) {
                    return TraversableOnce.class.min((TraversableOnce)this, (Ordering)cmp);
                }

                public Object max(Ordering cmp) {
                    return TraversableOnce.class.max((TraversableOnce)this, (Ordering)cmp);
                }

                public Object maxBy(Function1 f, Ordering cmp) {
                    return TraversableOnce.class.maxBy((TraversableOnce)this, (Function1)f, (Ordering)cmp);
                }

                public Object minBy(Function1 f, Ordering cmp) {
                    return TraversableOnce.class.minBy((TraversableOnce)this, (Function1)f, (Ordering)cmp);
                }

                public <B> void copyToBuffer(Buffer<B> dest) {
                    TraversableOnce.class.copyToBuffer((TraversableOnce)this, dest);
                }

                public <B> void copyToArray(Object xs, int start) {
                    TraversableOnce.class.copyToArray((TraversableOnce)this, (Object)xs, (int)start);
                }

                public <B> void copyToArray(Object xs) {
                    TraversableOnce.class.copyToArray((TraversableOnce)this, (Object)xs);
                }

                public <B> Object toArray(ClassTag<B> evidence$1) {
                    return TraversableOnce.class.toArray((TraversableOnce)this, evidence$1);
                }

                public List<byte[]> toList() {
                    return TraversableOnce.class.toList((TraversableOnce)this);
                }

                public Iterable<byte[]> toIterable() {
                    return TraversableOnce.class.toIterable((TraversableOnce)this);
                }

                public Seq<byte[]> toSeq() {
                    return TraversableOnce.class.toSeq((TraversableOnce)this);
                }

                public IndexedSeq<byte[]> toIndexedSeq() {
                    return TraversableOnce.class.toIndexedSeq((TraversableOnce)this);
                }

                public <B> Buffer<B> toBuffer() {
                    return TraversableOnce.class.toBuffer((TraversableOnce)this);
                }

                public <B> Set<B> toSet() {
                    return TraversableOnce.class.toSet((TraversableOnce)this);
                }

                public Vector<byte[]> toVector() {
                    return TraversableOnce.class.toVector((TraversableOnce)this);
                }

                public <Col> Col to(CanBuildFrom<Nothing$, byte[], Col> cbf) {
                    return (Col)TraversableOnce.class.to((TraversableOnce)this, cbf);
                }

                public <T, U> scala.collection.immutable.Map<T, U> toMap(Predef$.less.colon.less<byte[], Tuple2<T, U>> ev) {
                    return TraversableOnce.class.toMap((TraversableOnce)this, ev);
                }

                public String mkString(String start, String sep, String end) {
                    return TraversableOnce.class.mkString((TraversableOnce)this, (String)start, (String)sep, (String)end);
                }

                public String mkString(String sep) {
                    return TraversableOnce.class.mkString((TraversableOnce)this, (String)sep);
                }

                public String mkString() {
                    return TraversableOnce.class.mkString((TraversableOnce)this);
                }

                public StringBuilder addString(StringBuilder b, String start, String sep, String end) {
                    return TraversableOnce.class.addString((TraversableOnce)this, (StringBuilder)b, (String)start, (String)sep, (String)end);
                }

                public StringBuilder addString(StringBuilder b, String sep) {
                    return TraversableOnce.class.addString((TraversableOnce)this, (StringBuilder)b, (String)sep);
                }

                public StringBuilder addString(StringBuilder b) {
                    return TraversableOnce.class.addString((TraversableOnce)this, (StringBuilder)b);
                }

                private byte[] batch() {
                    return this.batch;
                }

                private void batch_$eq(byte[] x$1) {
                    this.batch = x$1;
                }

                public boolean hasNext() {
                    if (this.batch() == null) {
                        this.batch_$eq(SimpleFeatureArrowIO$.MODULE$.org$locationtech$geomesa$arrow$io$SimpleFeatureArrowIO$$nextBatch$1(this.batchSize$1, this.getSortAttribute$1, this.result$1, this.inputs$1, this.queue$1, this.unloader$1));
                    }
                    return this.batch() != null;
                }

                /*
                 * WARNING - void declaration
                 */
                public byte[] next() {
                    void var1_1;
                    byte[] res = this.batch();
                    this.batch_$eq(null);
                    return var1_1;
                }
                {
                    this.batchSize$1 = batchSize$1;
                    this.getSortAttribute$1 = getSortAttribute$1;
                    this.result$1 = result$1;
                    this.inputs$1 = inputs$1;
                    this.queue$1 = queue$1;
                    this.unloader$1 = unloader$1;
                    TraversableOnce.class.$init$((TraversableOnce)this);
                    Iterator.class.$init$((Iterator)this);
                }
            };
            closeableIterator = CloseableIterator$.MODULE$.apply((Iterator)output, (Function0)new Serializable(iter, result, inputs){
                public static final long serialVersionUID = 0L;
                private final CloseableIterator iter$1;
                private final SimpleFeatureVector result$1;
                private final Tuple2[] inputs$1;

                public final void apply() {
                    this.apply$mcV$sp();
                }

                public void apply$mcV$sp() {
                    SimpleFeatureArrowIO$.MODULE$.org$locationtech$geomesa$arrow$io$SimpleFeatureArrowIO$$closeAll$1(this.iter$1, this.result$1, this.inputs$1);
                }
                {
                    this.iter$1 = iter$1;
                    this.result$1 = result$1;
                    this.inputs$1 = inputs$1;
                }
            });
        }
        return closeableIterator;
    }

    public CloseableIterator<byte[]> createFile(SimpleFeatureVector vector, Option<Tuple2<String, Object>> sort, CloseableIterator<byte[]> body, BufferAllocator allocator) {
        ByteArrayOutputStream headerBytes = new ByteArrayOutputStream();
        SimpleFeatureArrowFileWriter writer = SimpleFeatureArrowFileWriter$.MODULE$.apply(vector, headerBytes, sort, allocator);
        writer.start();
        Iterator header = package$.MODULE$.Iterator().single((Object)headerBytes.toByteArray());
        Iterator footer = package$.MODULE$.Iterator().single(Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{0, 0, 0, 0}), ClassTag$.MODULE$.Byte()));
        return CloseableIterator$.MODULE$.apply(header.$plus$plus((Function0)new Serializable(body){
            public static final long serialVersionUID = 0L;
            private final CloseableIterator body$1;

            public final CloseableIterator<byte[]> apply() {
                return this.body$1;
            }
            {
                this.body$1 = body$1;
            }
        }).$plus$plus((Function0)new Serializable(footer){
            public static final long serialVersionUID = 0L;
            private final Iterator footer$1;

            public final Iterator<byte[]> apply() {
                return this.footer$1;
            }
            {
                this.footer$1 = footer$1;
            }
        }), (Function0)new Serializable(body, writer){
            public static final long serialVersionUID = 0L;
            private final CloseableIterator body$1;
            private final SimpleFeatureArrowFileWriter writer$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                CloseWithLogging$.MODULE$.apply((Object)this.body$1);
                CloseWithLogging$.MODULE$.apply((Object)this.writer$1);
            }
            {
                this.body$1 = body$1;
                this.writer$1 = writer$1;
            }
        });
    }

    public CloseableIterator<byte[]> createFile(SimpleFeatureType sft, scala.collection.immutable.Map<String, ArrowDictionary> dictionaries2, SimpleFeatureVector.SimpleFeatureEncoding encoding, Option<Tuple2<String, Object>> sort, CloseableIterator<byte[]> body, BufferAllocator allocator) {
        return this.createFile(SimpleFeatureVector$.MODULE$.create(sft, dictionaries2, encoding, 0, allocator), sort, body, allocator);
    }

    public Option<Tuple2<String, Object>> getSortFromMetadata(java.util.Map<String, String> metadata) {
        return Option$.MODULE$.apply((Object)metadata.get(SimpleFeatureArrowIO$Metadata$.MODULE$.SortField())).map((Function1)new Serializable(metadata){
            public static final long serialVersionUID = 0L;
            private final java.util.Map metadata$1;

            public final Tuple2<String, Object> apply(String field) {
                boolean reverse = Option$.MODULE$.apply(this.metadata$1.get(SimpleFeatureArrowIO$Metadata$.MODULE$.SortOrder())).exists((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(String x0$1) {
                        String string = x0$1;
                        boolean bl = "descending".equals(string);
                        return bl;
                    }
                });
                return new Tuple2((Object)field, (Object)BoxesRunTime.boxToBoolean((boolean)reverse));
            }
            {
                this.metadata$1 = metadata$1;
            }
        });
    }

    public java.util.Map<String, String> getSortAsMetadata(String field, boolean reverse) {
        return JavaConversions$.MODULE$.mapAsJavaMap((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SimpleFeatureArrowIO$Metadata$.MODULE$.SortField()), (Object)field), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SimpleFeatureArrowIO$Metadata$.MODULE$.SortOrder()), (Object)(reverse ? "descending" : "ascending"))})));
    }

    public VectorSchemaRoot createRoot(FieldVector vector, java.util.Map<String, String> metadata) {
        Schema schema = new Schema(Collections.singletonList(vector.getField()), metadata);
        return new VectorSchemaRoot(schema, Collections.singletonList(vector), vector.getValueCount());
    }

    public java.util.Map<String, String> createRoot$default$2() {
        return null;
    }

    private scala.collection.immutable.Map<String, ArrowDictionary> createEmptyDictionaries(Seq<String> fields) {
        return ((TraversableOnce)ScalaImplicits.RichTraversableLike$.MODULE$.mapWithIndex$extension(ScalaImplicits$.MODULE$.RichTraversableLike(fields), (Function2)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, ArrowDictionary> apply(String x0$2, int x1$1) {
                Tuple2 tuple2 = new Tuple2((Object)x0$2, (Object)BoxesRunTime.boxToInteger((int)x1$1));
                if (tuple2 != null) {
                    String name = (String)tuple2._1();
                    int i = tuple2._2$mcI$sp();
                    Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)name), (Object)ArrowDictionary$.MODULE$.create(i, (Object[])Array$.MODULE$.empty(ClassTag$.MODULE$.AnyRef()), ClassTag$.MODULE$.AnyRef()));
                    return tuple22;
                }
                throw new MatchError((Object)tuple2);
            }
        }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public final byte[] org$locationtech$geomesa$arrow$io$SimpleFeatureArrowIO$$nextBatch$1(int batchSize$1, Function2 getSortAttribute$1, SimpleFeatureVector result$1, Tuple2[] inputs$1, PriorityQueue queue$1, RecordBatchUnloader unloader$1) {
        byte[] byArray;
        if (queue$1.isEmpty()) {
            byArray = null;
        } else {
            result$1.clear();
            int resultIndex = 0;
            while (queue$1.nonEmpty() && resultIndex < batchSize$1) {
                Tuple3 tuple3 = (Tuple3)queue$1.dequeue();
                if (tuple3 != null) {
                    Tuple2.mcII.sp sp2;
                    int i = BoxesRunTime.unboxToInt((Object)tuple3._2());
                    int batch = BoxesRunTime.unboxToInt((Object)tuple3._3());
                    Tuple2.mcII.sp sp3 = sp2 = new Tuple2.mcII.sp(i, batch);
                    int i2 = sp3._1$mcI$sp();
                    int batch2 = sp3._2$mcI$sp();
                    Tuple2 tuple2 = inputs$1[batch2];
                    if (tuple2 != null) {
                        BoxedUnit boxedUnit;
                        Tuple2 tuple22;
                        SimpleFeatureVector vector = (SimpleFeatureVector)tuple2._1();
                        Function2 transfer = (Function2)tuple2._2();
                        Tuple2 tuple23 = tuple22 = new Tuple2((Object)vector, (Object)transfer);
                        SimpleFeatureVector vector2 = (SimpleFeatureVector)tuple23._1();
                        Function2 transfer2 = (Function2)tuple23._2();
                        transfer2.apply$mcVII$sp(i2, resultIndex);
                        result$1.underlying().setIndexDefined(resultIndex);
                        ++resultIndex;
                        int nextBatchIndex = i2 + 1;
                        if (vector2.reader().getValueCount() > nextBatchIndex) {
                            Object value = getSortAttribute$1.apply((Object)vector2, (Object)BoxesRunTime.boxToInteger((int)nextBatchIndex));
                            boxedUnit = queue$1.$plus$eq((Object)new Tuple3(value, (Object)BoxesRunTime.boxToInteger((int)nextBatchIndex), (Object)BoxesRunTime.boxToInteger((int)batch2)));
                            continue;
                        }
                        vector2.close();
                        boxedUnit = BoxedUnit.UNIT;
                        continue;
                    }
                    throw new MatchError((Object)tuple2);
                }
                throw new MatchError((Object)tuple3);
            }
            byArray = unloader$1.unload(resultIndex);
        }
        return byArray;
    }

    public final void org$locationtech$geomesa$arrow$io$SimpleFeatureArrowIO$$closeAll$1(CloseableIterator iter$1, SimpleFeatureVector result$1, Tuple2[] inputs$1) {
        CloseWithLogging$.MODULE$.apply((Object)result$1);
        CloseWithLogging$.MODULE$.apply((Object)iter$1);
        Predef$.MODULE$.refArrayOps((Object[])inputs$1).foreach((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Option<Throwable> apply(Tuple2<SimpleFeatureVector, Function2<Object, Object, BoxedUnit>> i) {
                return CloseWithLogging$.MODULE$.apply(i._1());
            }
        });
    }

    private SimpleFeatureArrowIO$() {
        MODULE$ = this;
        LazyLogging.class.$init$((LazyLogging)this);
        this.ordering = new Ordering<Tuple3<Object, Object, Object>>(){

            public Some tryCompare(Object x, Object y) {
                return Ordering.class.tryCompare((Ordering)this, (Object)x, (Object)y);
            }

            public boolean lteq(Object x, Object y) {
                return Ordering.class.lteq((Ordering)this, (Object)x, (Object)y);
            }

            public boolean gteq(Object x, Object y) {
                return Ordering.class.gteq((Ordering)this, (Object)x, (Object)y);
            }

            public boolean lt(Object x, Object y) {
                return Ordering.class.lt((Ordering)this, (Object)x, (Object)y);
            }

            public boolean gt(Object x, Object y) {
                return Ordering.class.gt((Ordering)this, (Object)x, (Object)y);
            }

            public boolean equiv(Object x, Object y) {
                return Ordering.class.equiv((Ordering)this, (Object)x, (Object)y);
            }

            public Object max(Object x, Object y) {
                return Ordering.class.max((Ordering)this, (Object)x, (Object)y);
            }

            public Object min(Object x, Object y) {
                return Ordering.class.min((Ordering)this, (Object)x, (Object)y);
            }

            public Ordering<Tuple3<Object, Object, Object>> reverse() {
                return Ordering.class.reverse((Ordering)this);
            }

            public <U> Ordering<U> on(Function1<U, Tuple3<Object, Object, Object>> f) {
                return Ordering.class.on((Ordering)this, f);
            }

            public Ordering.Ops mkOrderingOps(Object lhs) {
                return Ordering.class.mkOrderingOps((Ordering)this, (Object)lhs);
            }

            public int compare(Tuple3<Object, Object, Object> x, Tuple3<Object, Object, Object> y) {
                return SimpleFeatureOrdering$.MODULE$.nullCompare((Comparable)x._1(), y._1());
            }
            {
                PartialOrdering.class.$init$((PartialOrdering)this);
                Ordering.class.$init$((Ordering)this);
            }
        };
    }
}

