/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.arrow.vector;

import java.util.Collections;
import java.util.Date;
import java.util.Map;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.vector.BigIntVector;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.complex.ListVector;
import org.apache.arrow.vector.complex.StructVector;
import org.apache.arrow.vector.types.FloatingPointPrecision;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.FieldType;
import org.locationtech.geomesa.arrow.vector.ArrowDictionary;
import org.locationtech.geomesa.arrow.vector.GeometryFields;
import org.locationtech.geomesa.arrow.vector.SimpleFeatureVector;
import org.locationtech.geomesa.arrow.vector.SimpleFeatureVector$SimpleFeatureEncoding$;
import org.locationtech.geomesa.arrow.vector.SimpleFeatureVector$SimpleFeatureEncoding$Encoding$;
import org.locationtech.geomesa.utils.geotools.RichAttributeDescriptors;
import org.locationtech.geomesa.utils.geotools.RichAttributeDescriptors$;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType$;
import org.locationtech.geomesa.utils.geotools.SimpleFeatureTypes$;
import org.locationtech.jts.geom.Geometry;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.JavaConversions$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.ObjectRef;

public final class SimpleFeatureVector$ {
    public static final SimpleFeatureVector$ MODULE$;
    private final int DefaultCapacity;
    private final String FeatureIdField;
    private final String DescriptorKey;
    private final String OptionsKey;

    static {
        new SimpleFeatureVector$();
    }

    public int DefaultCapacity() {
        return this.DefaultCapacity;
    }

    public String FeatureIdField() {
        return this.FeatureIdField;
    }

    public String DescriptorKey() {
        return this.DescriptorKey;
    }

    public String OptionsKey() {
        return this.OptionsKey;
    }

    public SimpleFeatureVector create(SimpleFeatureType sft, scala.collection.immutable.Map<String, ArrowDictionary> dictionaries2, SimpleFeatureVector.SimpleFeatureEncoding encoding, int capacity, BufferAllocator allocator) {
        Map<String, String> metadata = Collections.singletonMap(this.OptionsKey(), SimpleFeatureTypes$.MODULE$.encodeUserData(sft));
        FieldType fieldType = new FieldType(true, (ArrowType)ArrowType.Struct.INSTANCE, null, metadata);
        StructVector underlying = new StructVector(sft.getTypeName(), allocator, fieldType, null);
        SimpleFeatureVector vector = new SimpleFeatureVector(sft, underlying, dictionaries2, encoding, allocator);
        underlying.setInitialCapacity(capacity);
        underlying.allocateNew();
        return vector;
    }

    public SimpleFeatureVector.SimpleFeatureEncoding create$default$3() {
        return SimpleFeatureVector$SimpleFeatureEncoding$.MODULE$.Min();
    }

    public int create$default$4() {
        return this.DefaultCapacity();
    }

    public SimpleFeatureVector wrap(StructVector vector, scala.collection.immutable.Map<String, ArrowDictionary> dictionaries2, BufferAllocator allocator) {
        Tuple2<SimpleFeatureType, SimpleFeatureVector.SimpleFeatureEncoding> tuple2 = this.getFeatureType(vector);
        if (tuple2 != null) {
            Tuple2 tuple22;
            SimpleFeatureType sft = (SimpleFeatureType)tuple2._1();
            SimpleFeatureVector.SimpleFeatureEncoding encoding = (SimpleFeatureVector.SimpleFeatureEncoding)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)sft, (Object)encoding);
            SimpleFeatureType sft2 = (SimpleFeatureType)tuple23._1();
            SimpleFeatureVector.SimpleFeatureEncoding encoding2 = (SimpleFeatureVector.SimpleFeatureEncoding)tuple23._2();
            return new SimpleFeatureVector(sft2, vector, dictionaries2, encoding2, allocator);
        }
        throw new MatchError(tuple2);
    }

    public SimpleFeatureVector clone(SimpleFeatureVector vector, StructVector underlying, BufferAllocator allocator) {
        return new SimpleFeatureVector(vector.sft(), underlying, vector.dictionaries(), vector.encoding(), allocator);
    }

    public Tuple2<SimpleFeatureType, SimpleFeatureVector.SimpleFeatureEncoding> getFeatureType(StructVector vector) {
        ArrayBuffer attributes = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
        ObjectRef fidEncoding = ObjectRef.create((Object)None$.MODULE$);
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(vector.getField().getChildren()).asScala()).foreach((Function1)new Serializable(attributes, fidEncoding){
            public static final long serialVersionUID = 0L;
            private final ArrayBuffer attributes$1;
            private final ObjectRef fidEncoding$1;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final void apply(Field field) {
                String string = field.getName();
                String string2 = SimpleFeatureVector$.MODULE$.FeatureIdField();
                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                    ArrowType arrowType = field.getType();
                    if (arrowType instanceof ArrowType.Int) {
                        this.fidEncoding$1.elem = new Some((Object)SimpleFeatureVector$SimpleFeatureEncoding$Encoding$.MODULE$.Min());
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return;
                    } else if (arrowType instanceof ArrowType.FixedSizeList) {
                        this.fidEncoding$1.elem = new Some((Object)SimpleFeatureVector$SimpleFeatureEncoding$Encoding$.MODULE$.Max());
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return;
                    } else {
                        if (!(arrowType instanceof ArrowType.Utf8)) throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Found feature ID vector field of unexpected type: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{field})));
                        this.fidEncoding$1.elem = new Some((Object)SimpleFeatureVector$SimpleFeatureEncoding$Encoding$.MODULE$.Max());
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    }
                    return;
                } else {
                    this.attributes$1.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{(String)field.getMetadata().get(SimpleFeatureVector$.MODULE$.DescriptorKey())}));
                }
            }
            {
                this.attributes$1 = attributes$1;
                this.fidEncoding$1 = fidEncoding$1;
            }
        });
        String options = (String)Option$.MODULE$.apply(vector.getField().getMetadata().get(this.OptionsKey())).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "";
            }
        });
        SimpleFeatureType sft = SimpleFeatureTypes$.MODULE$.createImmutableType(vector.getField().getName(), new StringBuilder().append((Object)attributes.mkString(",")).append((Object)options).toString());
        Option geomVector = Option$.MODULE$.apply((Object)RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getGeomField$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft))).flatMap((Function1)new Serializable(vector){
            public static final long serialVersionUID = 0L;
            private final StructVector vector$1;

            public final Option<FieldVector> apply(String d) {
                return Option$.MODULE$.apply((Object)this.vector$1.getChild(d));
            }
            {
                this.vector$1 = vector$1;
            }
        }).orElse((Function0)new Serializable(vector, sft){
            public static final long serialVersionUID = 0L;
            private final StructVector vector$1;
            private final SimpleFeatureType sft$1;

            public final Option<FieldVector> apply() {
                return SimpleFeatureVector$.MODULE$.org$locationtech$geomesa$arrow$vector$SimpleFeatureVector$$getNestedVector(this.sft$1, this.vector$1, ClassTag$.MODULE$.apply(Geometry.class));
            }
            {
                this.vector$1 = vector$1;
                this.sft$1 = sft$1;
            }
        });
        boolean isDouble = geomVector.exists((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(FieldVector v) {
                FloatingPointPrecision floatingPointPrecision = GeometryFields.precisionFromField((Field)v.getField());
                FloatingPointPrecision floatingPointPrecision2 = FloatingPointPrecision.DOUBLE;
                return !(floatingPointPrecision != null ? !floatingPointPrecision.equals(floatingPointPrecision2) : floatingPointPrecision2 != null);
            }
        });
        Enumeration.Value geomPrecision = isDouble ? SimpleFeatureVector$SimpleFeatureEncoding$Encoding$.MODULE$.Max() : SimpleFeatureVector$SimpleFeatureEncoding$Encoding$.MODULE$.Min();
        Option dateVector = RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getDtgField$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft)).flatMap((Function1)new Serializable(vector){
            public static final long serialVersionUID = 0L;
            private final StructVector vector$1;

            public final Option<FieldVector> apply(String d) {
                return Option$.MODULE$.apply((Object)this.vector$1.getChild(d));
            }
            {
                this.vector$1 = vector$1;
            }
        }).orElse((Function0)new Serializable(vector, sft){
            public static final long serialVersionUID = 0L;
            private final StructVector vector$1;
            private final SimpleFeatureType sft$1;

            public final Option<FieldVector> apply() {
                return SimpleFeatureVector$.MODULE$.org$locationtech$geomesa$arrow$vector$SimpleFeatureVector$$getNestedVector(this.sft$1, this.vector$1, ClassTag$.MODULE$.apply(Date.class));
            }
            {
                this.vector$1 = vector$1;
                this.sft$1 = sft$1;
            }
        });
        boolean isLong = dateVector.exists((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(FieldVector x$3) {
                return x$3 instanceof BigIntVector;
            }
        });
        Enumeration.Value datePrecision = isLong ? SimpleFeatureVector$SimpleFeatureEncoding$Encoding$.MODULE$.Max() : SimpleFeatureVector$SimpleFeatureEncoding$Encoding$.MODULE$.Min();
        SimpleFeatureVector.SimpleFeatureEncoding encoding = new SimpleFeatureVector.SimpleFeatureEncoding((Option<Enumeration.Value>)((Option)fidEncoding.elem), geomPrecision, datePrecision);
        return new Tuple2((Object)sft, (Object)encoding);
    }

    public boolean isGeometryVector(FieldVector vector) {
        return Option$.MODULE$.apply(vector.getField().getMetadata().get(this.DescriptorKey())).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final AttributeDescriptor apply(String spec) {
                return SimpleFeatureTypes$.MODULE$.createDescriptor(spec);
            }
        }).exists((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(AttributeDescriptor d) {
                return Geometry.class.isAssignableFrom(d.getType().getBinding());
            }
        });
    }

    public <T> Option<FieldVector> org$locationtech$geomesa$arrow$vector$SimpleFeatureVector$$getNestedVector(SimpleFeatureType sft, StructVector vector, ClassTag<T> ct) {
        return ((TraversableLike)JavaConversions$.MODULE$.asScalaBuffer(sft.getAttributeDescriptors()).flatMap((Function1)new Serializable(vector, ct){
            public static final long serialVersionUID = 0L;
            private final StructVector vector$2;
            private final ClassTag ct$1;

            public final Iterable<FieldVector> apply(AttributeDescriptor x0$1) {
                AttributeDescriptor attributeDescriptor = x0$1;
                Iterable iterable = RichAttributeDescriptors.RichAttributeDescriptor$.MODULE$.isList$extension(RichAttributeDescriptors$.MODULE$.RichAttributeDescriptor(attributeDescriptor)) && this.ct$1.runtimeClass().isAssignableFrom(RichAttributeDescriptors.RichAttributeDescriptor$.MODULE$.getListType$extension(RichAttributeDescriptors$.MODULE$.RichAttributeDescriptor(attributeDescriptor))) ? Option$.MODULE$.option2Iterable(Option$.MODULE$.apply((Object)((ListVector)this.vector$2.getChild(attributeDescriptor.getLocalName()))).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final FieldVector apply(ListVector x$4) {
                        return x$4.getDataVector();
                    }
                })) : (RichAttributeDescriptors.RichAttributeDescriptor$.MODULE$.isMap$extension(RichAttributeDescriptors$.MODULE$.RichAttributeDescriptor(attributeDescriptor)) && this.ct$1.runtimeClass().isAssignableFrom((Class)RichAttributeDescriptors.RichAttributeDescriptor$.MODULE$.getMapTypes$extension(RichAttributeDescriptors$.MODULE$.RichAttributeDescriptor(attributeDescriptor))._1()) ? Option$.MODULE$.option2Iterable(Option$.MODULE$.apply((Object)((StructVector)this.vector$2.getChild(attributeDescriptor.getLocalName()))).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final FieldVector apply(StructVector x$5) {
                        return (FieldVector)x$5.getChildrenFromFields().get(0);
                    }
                })) : (RichAttributeDescriptors.RichAttributeDescriptor$.MODULE$.isMap$extension(RichAttributeDescriptors$.MODULE$.RichAttributeDescriptor(attributeDescriptor)) && this.ct$1.runtimeClass().isAssignableFrom((Class)RichAttributeDescriptors.RichAttributeDescriptor$.MODULE$.getMapTypes$extension(RichAttributeDescriptors$.MODULE$.RichAttributeDescriptor(attributeDescriptor))._2()) ? Option$.MODULE$.option2Iterable(Option$.MODULE$.apply((Object)((StructVector)this.vector$2.getChild(attributeDescriptor.getLocalName()))).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final FieldVector apply(StructVector x$6) {
                        return (FieldVector)x$6.getChildrenFromFields().get(1);
                    }
                })) : Option$.MODULE$.option2Iterable((Option)None$.MODULE$)));
                return iterable;
            }
            {
                this.vector$2 = vector$2;
                this.ct$1 = ct$1;
            }
        }, Buffer$.MODULE$.canBuildFrom())).headOption();
    }

    private SimpleFeatureVector$() {
        MODULE$ = this;
        this.DefaultCapacity = 8096;
        this.FeatureIdField = "id";
        this.DescriptorKey = "descriptor";
        this.OptionsKey = "options";
    }
}

