/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature.type;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import org.geotools.feature.NameImpl;
import org.geotools.feature.type.AttributeDescriptorImpl;
import org.geotools.util.logging.Logging;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.AttributeType;
import org.opengis.feature.type.ComplexType;
import org.opengis.feature.type.Name;

public class Descriptors {
    private static final Logger LOGGER = Logging.getLogger(Descriptors.class);

    public static final List wrapAttributeTypes(List typeList) {
        ArrayList<AttributeDescriptor> descriptors = new ArrayList<AttributeDescriptor>(typeList.size());
        for (AttributeType attributeType : typeList) {
            descriptors.add(Descriptors.wrapAttributeType(attributeType));
        }
        return descriptors;
    }

    public static final AttributeDescriptor wrapAttributeType(AttributeType type) {
        if (type == null) {
            return null;
        }
        return new AttributeDescriptorImpl(type, type.getName(), 1, 1, true, null);
    }

    public static final AttributeDescriptor find(List descriptors, Name name) {
        if (name == null) {
            return null;
        }
        for (AttributeDescriptor attributeType : descriptors) {
            if (!name.equals((Object)attributeType.getType().getName())) continue;
            return attributeType;
        }
        return null;
    }

    AttributeDescriptor restrict(AttributeDescriptor node, AttributeDescriptor restrict) {
        if (node.getType() == restrict.getType()) {
            return restrict;
        }
        for (AttributeType type = restrict.getType(); type != null; type = type.getSuper()) {
            if (!node.getType().equals(type)) continue;
            return restrict;
        }
        throw new IllegalArgumentException("Cannot restrict provided schema");
    }

    Collection restriction(Collection schema, Collection restrict, Collection restriction) {
        if (schema.size() != restrict.size()) {
            throw new IllegalArgumentException("You must provide an exact structure match in order to implement restriction");
        }
        Iterator i = schema.iterator();
        Iterator j = restrict.iterator();
        while (i.hasNext() && j.hasNext()) {
            restriction.add(this.restrict((AttributeDescriptor)i.next(), (AttributeDescriptor)j.next()));
        }
        return restriction;
    }

    public static AttributeType type(Collection schema, Name name) {
        AttributeDescriptor node = Descriptors.node(schema, name);
        if (node != null) {
            return node.getType();
        }
        return null;
    }

    public static AttributeType type(ComplexType schema, String name) {
        return Descriptors.type(schema, (Name)new NameImpl(name));
    }

    public static AttributeType type(ComplexType schema, Name name) {
        AttributeDescriptor node = Descriptors.node(schema, name);
        if (node != null) {
            return node.getType();
        }
        return null;
    }

    public static AttributeDescriptor node(ComplexType schema, String name) {
        for (AttributeDescriptor node : Descriptors.list((AttributeType)schema)) {
            if (node.getName() == null) {
                LOGGER.warning("node has no name set, try to fix! " + node);
                if (!node.getType().getName().getLocalPart().equals(name)) continue;
                return node;
            }
            if (!node.getName().getLocalPart().equals(name)) continue;
            return node;
        }
        AttributeType superType = schema.getSuper();
        if (superType instanceof ComplexType) {
            return Descriptors.node((ComplexType)superType, name);
        }
        return null;
    }

    public static AttributeDescriptor node(ComplexType schema, Name name) {
        return Descriptors.node(Descriptors.list((AttributeType)schema), name);
    }

    public static AttributeDescriptor node(Collection schema, Name name) {
        for (AttributeDescriptor node : schema) {
            Name nodeName = node.getName();
            if (nodeName == null) {
                LOGGER.warning("node has no name set, try to fix! " + node);
                Name name2 = node.getType().getName();
                if (!(null == name.getNamespaceURI() ? name.getLocalPart().equals(name2.getLocalPart()) : name2.getNamespaceURI().equals(name.getNamespaceURI()) && name2.getLocalPart().equals(name.getLocalPart()))) continue;
                return node;
            }
            if (!(name.getNamespaceURI() != null ? name.getLocalPart().equals(nodeName.getLocalPart()) : name.equals((Object)nodeName))) continue;
            return node;
        }
        return null;
    }

    public static AttributeDescriptor node(ComplexType schema, AttributeType type) {
        for (AttributeDescriptor node : Descriptors.list((AttributeType)schema)) {
            if (node.getType() != type) continue;
            return node;
        }
        return null;
    }

    public static List nodes(ComplexType schema, AttributeType type) {
        ArrayList<AttributeDescriptor> nodes = new ArrayList<AttributeDescriptor>();
        for (AttributeDescriptor node : Descriptors.list((AttributeType)schema)) {
            if (!node.getType().equals(type)) continue;
            nodes.add(node);
        }
        return nodes;
    }

    public static List types(AttributeType type) {
        ArrayList<AttributeType> types = new ArrayList<AttributeType>();
        for (AttributeDescriptor node : Descriptors.list(type)) {
            types.add(node.getType());
        }
        return types;
    }

    public static boolean multiple(ComplexType schema, AttributeType type) {
        return Descriptors.maxOccurs(schema, type) > 1;
    }

    public static int maxOccurs(ComplexType schema, AttributeType type) {
        List nodes = Descriptors.nodes(schema, type);
        if (nodes.isEmpty()) {
            return 0;
        }
        int max = 0;
        for (AttributeDescriptor node : nodes) {
            if (max == Integer.MAX_VALUE) {
                return Integer.MAX_VALUE;
            }
            max += node.getMaxOccurs();
        }
        return max;
    }

    public static List list(AttributeType type) {
        ArrayList list = new ArrayList();
        if (type instanceof ComplexType) {
            list = new ArrayList(((ComplexType)type).getDescriptors());
        }
        return list;
    }

    public static boolean isSimple(Collection schema) {
        for (AttributeDescriptor d : schema) {
            if (d.getMinOccurs() != 1 || d.getMaxOccurs() != 1) {
                return false;
            }
            if (!(d.getType() instanceof ComplexType)) continue;
            return false;
        }
        return true;
    }
}

