_geomesa-arrow(){
  local cur prev;
  COMPREPLY=();
  cur="${COMP_WORDS[COMP_CWORD]}";
  prev="${COMP_WORDS[COMP_CWORD-1]}";

  if [[ "${COMP_WORDS[1]}" == "help" ]]; then
    COMPREPLY=( $(compgen -W "describe-schema env export help ingest get-type-names version get-sft-config gen-avro-schema stats-bounds stats-count stats-top-k stats-histogram convert configure classpath scala-console" ${cur}));
    return 0;
  fi;

  case ${COMP_CWORD} in
    1)
      COMPREPLY=( $(compgen -W "describe-schema env export help ingest get-type-names version get-sft-config gen-avro-schema stats-bounds stats-count stats-top-k stats-histogram convert configure classpath scala-console" ${cur}));
      ;;
    [2-9] | [1-9][0-9])
      if [[ "${cur}" =~ ^-[a-zA-Z-]?+$ ]]; then
        case ${COMP_WORDS[1]} in
                    describe-schema)
              COMPREPLY=( $(compgen -W "--show-dictionaries --url" -- ${cur}));
              return 0;
              ;;
                  env)
              COMPREPLY=( $(compgen -W "--concise --converters --list-sfts --describe-sfts --exclude-user-data --format --sfts --list-converters --describe-converters" -- ${cur}));
              return 0;
              ;;
                  export)
              COMPREPLY=( $(compgen -W "--output --cql --no-header --attributes --max-features --attribute --hints --gzip --output-format --sort-descending --num-reducers --force --url --chunk-size --sort-by --run-mode" -- ${cur}));
              return 0;
              ;;
                  help)
              COMPREPLY=( $(compgen -W "" -- ${cur}));
              return 0;
              ;;
                  ingest)
              COMPREPLY=( $(compgen -W "--threads --spec --src-list --run-mode --feature-name --combine-inputs --converter-error-mode --split-max-size --input-format --force --no-tracking --url --converter" -- ${cur}));
              return 0;
              ;;
                  get-type-names)
              COMPREPLY=( $(compgen -W "--url" -- ${cur}));
              return 0;
              ;;
                  version)
              COMPREPLY=( $(compgen -W "" -- ${cur}));
              return 0;
              ;;
                  get-sft-config)
              COMPREPLY=( $(compgen -W "--concise --format --exclude-user-data --url --feature-name" -- ${cur}));
              return 0;
              ;;
                  gen-avro-schema)
              COMPREPLY=( $(compgen -W "--spec --feature-name" -- ${cur}));
              return 0;
              ;;
                  stats-bounds)
              COMPREPLY=( $(compgen -W "--url --feature-name --attributes --cql --no-cache" -- ${cur}));
              return 0;
              ;;
                  stats-count)
              COMPREPLY=( $(compgen -W "--url --no-cache --feature-name --cql" -- ${cur}));
              return 0;
              ;;
                  stats-top-k)
              COMPREPLY=( $(compgen -W "--feature-name --cql --attributes --no-cache --url" -- ${cur}));
              return 0;
              ;;
                  stats-histogram)
              COMPREPLY=( $(compgen -W "--no-cache --feature-name --attributes --cql --url --bins" -- ${cur}));
              return 0;
              ;;
                  convert)
              COMPREPLY=( $(compgen -W "--attributes --cql --output --num-reducers --run-mode --spec --feature-name --attribute --hints --converter --gzip --no-header --sort-by --output-format --max-features --chunk-size --input-format --sort-descending --converter-error-mode --force" -- ${cur}));
              return 0;
              ;;
                  configure)
              COMPREPLY=( $(compgen -W "" -- ${cur}));
              return 0;
              ;;
                  classpath)
              COMPREPLY=( $(compgen -W "" -- ${cur}));
              return 0;
              ;;
                  scala-console)
              COMPREPLY=( $(compgen -W "" -- ${cur}));
              return 0;
              ;;
              esac;
      else
        compopt -o filenames -o nospace;
        COMPREPLY=( $(compgen -f "$2") );
      fi;
      return 0;
      ;;
    *)
      COMPREPLY=();
      ;;
  esac;
};
complete -F _geomesa-arrow geomesa-arrow;
complete -F _geomesa-arrow bin/geomesa-arrow;


       