/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.process.query;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.util.List;
import org.geotools.data.Query;
import org.geotools.data.collection.ListFeatureCollection;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureSource;
import org.locationtech.geomesa.filter.factory.FastFilterFactory$;
import org.locationtech.geomesa.filter.package$;
import org.locationtech.geomesa.index.process.GeoMesaProcessVisitor;
import org.locationtech.geomesa.process.FeatureResult;
import org.locationtech.geomesa.process.GeoMesaProcessVisitor;
import org.locationtech.geomesa.utils.collection.CloseableIterator;
import org.locationtech.geomesa.utils.collection.SelfClosingIterator$;
import org.locationtech.geomesa.utils.geotools.Conversions;
import org.locationtech.geomesa.utils.geotools.Conversions$;
import org.opengis.feature.Feature;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.spatial.DWithin;
import scala.Function1;
import scala.Serializable;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005Ea\u0001B\u0001\u0003\u00015\u0011\u0001\u0003\u0015:pq&l\u0017\u000e^=WSNLGo\u001c:\u000b\u0005\r!\u0011!B9vKJL(BA\u0003\u0007\u0003\u001d\u0001(o\\2fgNT!a\u0002\u0005\u0002\u000f\u001d,w.\\3tC*\u0011\u0011BC\u0001\rY>\u001c\u0017\r^5p]R,7\r\u001b\u0006\u0002\u0017\u0005\u0019qN]4\u0004\u0001M!\u0001A\u0004\f\u001b!\tyA#D\u0001\u0011\u0015\t\t\"#\u0001\u0003mC:<'\"A\n\u0002\t)\fg/Y\u0005\u0003+A\u0011aa\u00142kK\u000e$\bCA\f\u0019\u001b\u0005!\u0011BA\r\u0005\u0005U9Um\\'fg\u0006\u0004&o\\2fgN4\u0016n]5u_J\u0004\"a\u0007\u0012\u000e\u0003qQ!!\b\u0010\u0002\u0019M\u001c\u0017\r\\1m_\u001e<\u0017N\\4\u000b\u0005}\u0001\u0013\u0001\u0003;za\u0016\u001c\u0018MZ3\u000b\u0003\u0005\n1aY8n\u0013\t\u0019CDA\u0006MCjLHj\\4hS:<\u0007\u0002C\u0013\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0014\u0002\u001b%t\u0007/\u001e;GK\u0006$XO]3t!\t9c&D\u0001)\u0015\tI#&\u0001\u0004tS6\u0004H.\u001a\u0006\u0003W1\nA\u0001Z1uC*\u0011QFC\u0001\tO\u0016|Go\\8mg&\u0011q\u0006\u000b\u0002\u0018'&l\u0007\u000f\\3GK\u0006$XO]3D_2dWm\u0019;j_:D\u0001\"\r\u0001\u0003\u0002\u0003\u0006IAJ\u0001\rI\u0006$\u0018MR3biV\u0014Xm\u001d\u0005\tg\u0001\u0011\t\u0011)A\u0005i\u0005q!-\u001e4gKJLe.T3uKJ\u001c\bCA\u001b9\u001b\u00051$\"A\u001c\u0002\u000bM\u001c\u0017\r\\1\n\u0005e2$A\u0002#pk\ndW\rC\u0003<\u0001\u0011\u0005A(\u0001\u0004=S:LGO\u0010\u000b\u0005{}\u0002\u0015\t\u0005\u0002?\u00015\t!\u0001C\u0003&u\u0001\u0007a\u0005C\u00032u\u0001\u0007a\u0005C\u00034u\u0001\u0007A\u0007C\u0004D\u0001\t\u0007I\u0011\u0002#\u0002\u000f\u0011<\u0018\u000e\u001e5j]V\tQ\t\u0005\u0002G\u00176\tqI\u0003\u0002I\u0013\u00061a-\u001b7uKJT!A\u0013\u0006\u0002\u000f=\u0004XM\\4jg&\u0011Aj\u0012\u0002\u0007\r&dG/\u001a:\t\r9\u0003\u0001\u0015!\u0003F\u0003!!w/\u001b;iS:\u0004\u0003\u0002\u0003)\u0001\u0011\u000b\u0007I\u0011\u0002#\u0002\u00195\fg.^1m\r&dG/\u001a:\t\u0011I\u0003\u0001\u0012!Q!\n\u0015\u000bQ\"\\1ok\u0006dg)\u001b7uKJ\u0004\u0003b\u0002+\u0001\u0005\u0004%I!V\u0001\u0013[\u0006tW/\u00197WSNLGOU3tk2$8/F\u0001W!\t9&,D\u0001Y\u0015\tI&&\u0001\u0006d_2dWm\u0019;j_:L!a\u0017-\u0003+1K7\u000f\u001e$fCR,(/Z\"pY2,7\r^5p]\"1Q\f\u0001Q\u0001\nY\u000b1#\\1ok\u0006dg+[:jiJ+7/\u001e7ug\u0002Bqa\u0018\u0001A\u0002\u0013%\u0001-\u0001\u0006sKN,H\u000e^\"bY\u000e,\u0012!\u0019\t\u0003/\tL!a\u0019\u0003\u0003\u001b\u0019+\u0017\r^;sKJ+7/\u001e7u\u0011\u001d)\u0007\u00011A\u0005\n\u0019\faB]3tk2$8)\u00197d?\u0012*\u0017\u000f\u0006\u0002hUB\u0011Q\u0007[\u0005\u0003SZ\u0012A!\u00168ji\"91\u000eZA\u0001\u0002\u0004\t\u0017a\u0001=%c!1Q\u000e\u0001Q!\n\u0005\f1B]3tk2$8)\u00197dA!)q\u000e\u0001C!a\u0006)a/[:jiR\u0011q-\u001d\u0005\u0006e:\u0004\ra]\u0001\bM\u0016\fG/\u001e:f!\t!h/D\u0001v\u0015\t\u0011\u0018*\u0003\u0002xk\n9a)Z1ukJ,\u0007\"B=\u0001\t\u0003R\u0018!C4fiJ+7/\u001e7u)\u0005\t\u0007\"\u0002?\u0001\t\u0003j\u0018aB3yK\u000e,H/\u001a\u000b\u0005Oz\f9\u0001\u0003\u0004\u0000w\u0002\u0007\u0011\u0011A\u0001\u0007g>,(oY3\u0011\u0007\u001d\n\u0019!C\u0002\u0002\u0006!\u00121cU5na2,g)Z1ukJ,7k\\;sG\u0016DaaA>A\u0002\u0005%\u0001\u0003BA\u0006\u0003\u001bi\u0011AK\u0005\u0004\u0003\u001fQ#!B)vKJL\b")
public class ProximityVisitor
implements GeoMesaProcessVisitor,
LazyLogging {
    private final SimpleFeatureCollection dataFeatures;
    public final double org$locationtech$geomesa$process$query$ProximityVisitor$$bufferInMeters;
    private final Filter dwithin;
    private Filter manualFilter;
    private final ListFeatureCollection manualVisitResults;
    private FeatureResult resultCalc;
    private final Logger logger;
    private volatile byte bitmap$0;

    private Filter manualFilter$lzycompute() {
        ProximityVisitor proximityVisitor = this;
        synchronized (proximityVisitor) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.manualFilter = FastFilterFactory$.MODULE$.optimize((SimpleFeatureType)this.dataFeatures.getSchema(), this.dwithin());
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl8 : MonitorExitStatement: MONITOREXIT : var1_1
            this.dataFeatures = null;
            return this.manualFilter;
        }
    }

    private Logger logger$lzycompute() {
        ProximityVisitor proximityVisitor = this;
        synchronized (proximityVisitor) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.logger$lzycompute() : this.logger;
    }

    public List<Expression> getExpressions() {
        return GeoMesaProcessVisitor.class.getExpressions((org.locationtech.geomesa.index.process.GeoMesaProcessVisitor)this);
    }

    private Filter dwithin() {
        return this.dwithin;
    }

    private Filter manualFilter() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.manualFilter$lzycompute() : this.manualFilter;
    }

    private ListFeatureCollection manualVisitResults() {
        return this.manualVisitResults;
    }

    private FeatureResult resultCalc() {
        return this.resultCalc;
    }

    private void resultCalc_$eq(FeatureResult x$1) {
        this.resultCalc = x$1;
    }

    public void visit(Feature feature) {
        SimpleFeature sf = (SimpleFeature)feature;
        if (this.manualFilter().evaluate((Object)sf)) {
            this.manualVisitResults().add(sf);
        }
    }

    public FeatureResult getResult() {
        return this.resultCalc();
    }

    public void execute(SimpleFeatureSource source, Query query2) {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Running Geomesa Proximity Search on source type {}", new Object[]{source.getClass().getName()});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        Filter combinedFilter = package$.MODULE$.mergeFilters(query2.getFilter(), this.dwithin());
        this.resultCalc_$eq(new FeatureResult(source.getFeatures(combinedFilter)));
    }

    public ProximityVisitor(SimpleFeatureCollection inputFeatures, SimpleFeatureCollection dataFeatures, double bufferInMeters) {
        this.dataFeatures = dataFeatures;
        this.org$locationtech$geomesa$process$query$ProximityVisitor$$bufferInMeters = bufferInMeters;
        GeoMesaProcessVisitor.class.$init$((org.locationtech.geomesa.index.process.GeoMesaProcessVisitor)this);
        LazyLogging.class.$init$((LazyLogging)this);
        PropertyName geomProperty = package$.MODULE$.ff().property(dataFeatures.getSchema().getGeometryDescriptor().getName());
        CloseableIterator geomFilters = SelfClosingIterator$.MODULE$.apply(inputFeatures.features()).map((Function1)new Serializable(this, geomProperty){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ProximityVisitor $outer;
            private final PropertyName geomProperty$1;

            public final DWithin apply(SimpleFeature sf) {
                return package$.MODULE$.ff().dwithin((Expression)this.geomProperty$1, (Expression)package$.MODULE$.ff().literal((Object)Conversions.RichSimpleFeature$.MODULE$.geometry$extension(Conversions$.MODULE$.RichSimpleFeature(sf))), this.$outer.org$locationtech$geomesa$process$query$ProximityVisitor$$bufferInMeters, "meters");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.geomProperty$1 = geomProperty$1;
            }
        });
        this.dwithin = package$.MODULE$.orFilters(geomFilters.toSeq(), (FilterFactory)package$.MODULE$.ff());
        this.manualVisitResults = new ListFeatureCollection((SimpleFeatureType)dataFeatures.getSchema());
        this.resultCalc = new FeatureResult((SimpleFeatureCollection)this.manualVisitResults());
    }
}

