/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.process.query;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.util.List;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.feature.FeatureCollection;
import org.geotools.process.factory.DescribeParameter;
import org.geotools.process.factory.DescribeProcess;
import org.geotools.process.factory.DescribeResult;
import org.locationtech.geomesa.index.geotools.GeoMesaFeatureCollection$;
import org.locationtech.geomesa.process.GeoMesaProcess;
import org.locationtech.geomesa.process.query.QueryVisitor;
import org.opengis.feature.FeatureVisitor;
import org.opengis.filter.Filter;
import org.opengis.filter.IncludeFilter;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@DescribeProcess(title="Geomesa Query", description="Performs a Geomesa optimized query using spatiotemporal indexes")
@ScalaSignature(bytes="\u0006\u0001\u0005Ua\u0001B\u0001\u0003\u00015\u0011A\"U;fef\u0004&o\\2fgNT!a\u0001\u0003\u0002\u000bE,XM]=\u000b\u0005\u00151\u0011a\u00029s_\u000e,7o\u001d\u0006\u0003\u000f!\tqaZ3p[\u0016\u001c\u0018M\u0003\u0002\n\u0015\u0005aAn\\2bi&|g\u000e^3dQ*\t1\"A\u0002pe\u001e\u001c\u0001a\u0005\u0003\u0001\u001dYQ\u0002CA\b\u0015\u001b\u0005\u0001\"BA\t\u0013\u0003\u0011a\u0017M\\4\u000b\u0003M\tAA[1wC&\u0011Q\u0003\u0005\u0002\u0007\u001f\nTWm\u0019;\u0011\u0005]AR\"\u0001\u0003\n\u0005e!!AD$f_6+7/\u0019)s_\u000e,7o\u001d\t\u00037\tj\u0011\u0001\b\u0006\u0003;y\tAb]2bY\u0006dwnZ4j]\u001eT!a\b\u0011\u0002\u0011QL\b/Z:bM\u0016T\u0011!I\u0001\u0004G>l\u0017BA\u0012\u001d\u0005-a\u0015M_=M_\u001e<\u0017N\\4\t\u000b\u0015\u0002A\u0011\u0001\u0014\u0002\rqJg.\u001b;?)\u00059\u0003C\u0001\u0015\u0001\u001b\u0005\u0011\u0001\"\u0002\u0016\u0001\t\u0003Y\u0013aB3yK\u000e,H/\u001a\u000b\u0005YY*E\u000b\u0005\u0002.i5\taF\u0003\u00020a\u000511/[7qY\u0016T!!\r\u001a\u0002\t\u0011\fG/\u0019\u0006\u0003g)\t\u0001bZ3pi>|Gn]\u0005\u0003k9\u0012qcU5na2,g)Z1ukJ,7i\u001c7mK\u000e$\u0018n\u001c8\t\u000b]J\u0003\u0019\u0001\u0017\u0002\u0011\u0019,\u0017\r^;sKNDcAN\u001dA\u0003\n\u001b\u0005C\u0001\u001e?\u001b\u0005Y$B\u0001\u001f>\u0003\u001d1\u0017m\u0019;pefT!!\u0002\u001a\n\u0005}Z$!\u0005#fg\u000e\u0014\u0018NY3QCJ\fW.\u001a;fe\u0006!a.Y7fC\u00059\u0014a\u00033fg\u000e\u0014\u0018\u000e\u001d;j_:\f\u0013\u0001R\u0001\")\",\u0007EZ3biV\u0014X\rI:fi\u0002zg\u000eI<iS\u000eD\u0007\u0005^8!cV,'/\u001f\u0005\u0006\r&\u0002\raR\u0001\u0007M&dG/\u001a:\u0011\u0005!cU\"A%\u000b\u0005\u0019S%BA&\u000b\u0003\u001dy\u0007/\u001a8hSNL!!T%\u0003\r\u0019KG\u000e^3sQ!)\u0015\bQ(Q#\n\u0013\u0016%\u0001$\u0002\u00075Lg.H\u0001\u0001C\u0005\u0019\u0016!\f+iK\u00022\u0017\u000e\u001c;fe\u0002\"x\u000eI1qa2L\b\u0005^8!i\",\u0007EZ3biV\u0014X\rI2pY2,7\r^5p]\"9Q+\u000bI\u0001\u0002\u00041\u0016A\u00039s_B,'\u000f^5fgB\u0019qK\u0017/\u000e\u0003aS!!\u0017\n\u0002\tU$\u0018\u000e\\\u0005\u00037b\u0013A\u0001T5tiB\u0011Ql\u0019\b\u0003=\u0006l\u0011a\u0018\u0006\u0002A\u0006)1oY1mC&\u0011!mX\u0001\u0007!J,G-\u001a4\n\u0005\u0011,'AB*ue&twM\u0003\u0002c?\"bA+\u000f!h!FC\u0017N[6CY\u0006\nQ+A\u0002nCbl\"\u0001\u0001A\u0002\u001d\r|G\u000e\\3di&|g\u000eV=qK\u000e\nA,I\u0001n\u0003q\"\u0006.\u001a\u0011qe>\u0004XM\u001d;jKN|CO]1og\u001a|'/\\:!i>\u0004\u0013\r\u001d9ms\u0002\"x\u000e\t;iK\u00022W-\u0019;ve\u0016\u00043m\u001c7mK\u000e$\u0018n\u001c8)\t%z'I\u001d\t\u0003uAL!!]\u001e\u0003\u001d\u0011+7o\u0019:jE\u0016\u0014Vm];mi\u0006\n1/A\rPkR\u0004X\u000f\u001e\u0011gK\u0006$XO]3!G>dG.Z2uS>t\u0007bB;\u0001#\u0003%\tA^\u0001\u0012Kb,7-\u001e;fI\u0011,g-Y;mi\u0012\u001aT#A<+\u0005YC8&A=\u0011\u0005i|X\"A>\u000b\u0005ql\u0018!C;oG\",7m[3e\u0015\tqx,\u0001\u0006b]:|G/\u0019;j_:L1!!\u0001|\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u0015\u000b\u0001\u0005\u0015\u00111BA\u0007\u0005\u0006E\u0001c\u0001\u001e\u0002\b%\u0019\u0011\u0011B\u001e\u0003\u001f\u0011+7o\u0019:jE\u0016\u0004&o\\2fgN\fQ\u0001^5uY\u0016\f#!a\u0004\u0002\u001b\u001d+w.\\3tC\u0002\nV/\u001a:zC\t\t\u0019\"A QKJ4wN]7tA\u0005\u0004s)Z8nKN\f\u0007e\u001c9uS6L'0\u001a3!cV,'/\u001f\u0011vg&tw\rI:qCRLw\u000e^3na>\u0014\u0018\r\u001c\u0011j]\u0012,\u00070Z:")
public class QueryProcess
implements GeoMesaProcess,
LazyLogging {
    private final Logger logger;
    private volatile boolean bitmap$0;

    private Logger logger$lzycompute() {
        QueryProcess queryProcess = this;
        synchronized (queryProcess) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @DescribeResult(description="Output feature collection")
    public SimpleFeatureCollection execute(@DescribeParameter(name="features", description="The feature set on which to query") SimpleFeatureCollection features, @DescribeParameter(name="filter", min=0, description="The filter to apply to the feature collection") Filter filter, @DescribeParameter(name="properties", min=0, max=128, collectionType=String.class, description="The properties/transforms to apply to the feature collection") List<String> properties) {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug(new StringBuilder().append((Object)"Attempting Geomesa query on type ").append((Object)features.getClass().getName()).toString());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        String[] propsArray = (String[])Option$.MODULE$.apply(properties).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String[] apply(List<String> x$1) {
                return (String[])x$1.toArray((Object[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class)));
            }
        }).filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String[] x$2) {
                return x$2.length > 0;
            }
        }).orNull(Predef$.MODULE$.$conforms());
        QueryVisitor visitor = new QueryVisitor(features, (Filter)Option$.MODULE$.apply((Object)filter).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final IncludeFilter apply() {
                return Filter.INCLUDE;
            }
        }), propsArray);
        GeoMesaFeatureCollection$.MODULE$.visit((FeatureCollection)features, (FeatureVisitor)visitor, GeoMesaFeatureCollection$.MODULE$.visit$default$3());
        return visitor.getResult().results();
    }

    public List<String> execute$default$3() {
        return null;
    }

    public QueryProcess() {
        LazyLogging.class.$init$((LazyLogging)this);
    }
}

