/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.process.transform;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.util.Iterator;
import java.util.Locale;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.feature.FeatureCollection;
import org.geotools.process.factory.DescribeParameter;
import org.geotools.process.factory.DescribeProcess;
import org.geotools.process.factory.DescribeResult;
import org.locationtech.geomesa.index.geotools.GeoMesaFeatureCollection$;
import org.locationtech.geomesa.process.GeoMesaProcess;
import org.locationtech.geomesa.process.transform.BinVisitor;
import org.locationtech.geomesa.utils.bin.AxisOrder$;
import org.locationtech.geomesa.utils.bin.BinaryOutputEncoder;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType$;
import org.locationtech.geomesa.utils.geotools.SimpleFeatureTypes$;
import org.opengis.feature.FeatureVisitor;
import org.opengis.feature.simple.SimpleFeatureType;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@DescribeProcess(title="Binary Conversion", description="Converts a feature collection to binary format")
@ScalaSignature(bytes="\u0006\u0001\u0005Ua\u0001B\u0001\u0003\u00015\u0011ACQ5o\u0007>tg/\u001a:tS>t\u0007K]8dKN\u001c(BA\u0002\u0005\u0003%!(/\u00198tM>\u0014XN\u0003\u0002\u0006\r\u00059\u0001O]8dKN\u001c(BA\u0004\t\u0003\u001d9Wm\\7fg\u0006T!!\u0003\u0006\u0002\u00191|7-\u0019;j_:$Xm\u00195\u000b\u0003-\t1a\u001c:h\u0007\u0001\u0019B\u0001\u0001\b\u00175A\u0011q\u0002F\u0007\u0002!)\u0011\u0011CE\u0001\u0005Y\u0006twMC\u0001\u0014\u0003\u0011Q\u0017M^1\n\u0005U\u0001\"AB(cU\u0016\u001cG\u000f\u0005\u0002\u001815\tA!\u0003\u0002\u001a\t\tqq)Z8NKN\f\u0007K]8dKN\u001c\bCA\u000e#\u001b\u0005a\"BA\u000f\u001f\u00031\u00198-\u00197bY><w-\u001b8h\u0015\ty\u0002%\u0001\u0005usB,7/\u00194f\u0015\u0005\t\u0013aA2p[&\u00111\u0005\b\u0002\f\u0019\u0006T\u0018\u0010T8hO&tw\rC\u0003&\u0001\u0011\u0005a%\u0001\u0004=S:LGO\u0010\u000b\u0002OA\u0011\u0001\u0006A\u0007\u0002\u0005!)!\u0006\u0001C\u0001W\u00059Q\r_3dkR,Gc\u0002\u0017<)\u000eLw.\u001e\t\u0004[A\u0012T\"\u0001\u0018\u000b\u0005=\u0012\u0012\u0001B;uS2L!!\r\u0018\u0003\u0011%#XM]1u_J\u00042a\r\u001c9\u001b\u0005!$\"A\u001b\u0002\u000bM\u001c\u0017\r\\1\n\u0005]\"$!B!se\u0006L\bCA\u001a:\u0013\tQDG\u0001\u0003CsR,\u0007\"\u0002\u001f*\u0001\u0004i\u0014\u0001\u00034fCR,(/Z:\u0011\u0005y*U\"A \u000b\u0005\u0001\u000b\u0015AB:j[BdWM\u0003\u0002C\u0007\u0006!A-\u0019;b\u0015\t!%\"\u0001\u0005hK>$xn\u001c7t\u0013\t1uHA\fTS6\u0004H.\u001a$fCR,(/Z\"pY2,7\r^5p]\"21\bS(Q#J\u0003\"!S'\u000e\u0003)S!a\u0013'\u0002\u000f\u0019\f7\r^8ss*\u0011QaQ\u0005\u0003\u001d*\u0013\u0011\u0003R3tGJL'-\u001a)be\u0006lW\r^3s\u0003\u0011q\u0017-\\3\"\u0003q\n1\u0002Z3tGJL\u0007\u000f^5p]\u0006\n1+\u0001\u0012J]B,H\u000f\t4fCR,(/\u001a\u0011d_2dWm\u0019;j_:\u0004Co\u001c\u0011rk\u0016\u0014\u0018\u0010\t\u0005\u0006+&\u0002\rAV\u0001\u0006iJ\f7m\u001b\t\u0003/js!a\r-\n\u0005e#\u0014A\u0002)sK\u0012,g-\u0003\u0002\\9\n11\u000b\u001e:j]\u001eT!!\u0017\u001b)\u0011QCuJX)`C\n\f\u0013!V\u0011\u0002A\u0006\u0011CK]1dW\u00022\u0017.\u001a7eAQ|\u0007%^:fA\u0019|'\u000f\t\"J\u001d\u0002\u0012XmY8sIN\f1!\\5o;\u0005\u0001\u0001\"\u00023*\u0001\u00041\u0016\u0001B4f_6D\u0003b\u0019%PMF;\u0017MY\u0011\u0002I\u0006\n\u0001.A\u0013HK>lW\r\u001e:zA\u0019LW\r\u001c3!i>\u0004So]3!M>\u0014\bEQ%OAI,7m\u001c:eg\")!.\u000ba\u0001-\u0006\u0019A\r^4)\u0011%Du\n\\)nC\n\f\u0013A[\u0011\u0002]\u0006\tC)\u0019;fA\u0019LW\r\u001c3!i>\u0004So]3!M>\u0014\bEQ%OAI,7m\u001c:eg\")\u0001/\u000ba\u0001-\u0006)A.\u00192fY\"Bq\u000eS(s#N\f'-I\u0001qC\u0005!\u0018A\t'bE\u0016d\u0007EZ5fY\u0012\u0004Co\u001c\u0011vg\u0016\u0004cm\u001c:!\u0005&s\u0005E]3d_J$7\u000fC\u0003wS\u0001\u0007a+A\u0005bq&\u001cxJ\u001d3fe\"BQ\u000fS(y#f\f'-I\u0001wC\u0005Q\u0018\u0001J!ySN\u0004sN\u001d3fe\u0002j\u0003%Z5uQ\u0016\u0014\b\u0005\\1uY>t\u0007e\u001c:!Y>tG.\u0019;)\t%b\u0018k \t\u0003\u0013vL!A &\u0003\u001d\u0011+7o\u0019:jE\u0016\u0014Vm];mi\u0006\u0012\u0011\u0011A\u0001\u001b\u000b:\u001cw\u000eZ3eA\u0019,\u0017\r^;sK\u0002\u001aw\u000e\u001c7fGRLwN\u001c\u0015\u000b\u0001\u0005\u0015\u00111BA\u0007#\u0006E\u0001cA%\u0002\b%\u0019\u0011\u0011\u0002&\u0003\u001f\u0011+7o\u0019:jE\u0016\u0004&o\\2fgN\fQ\u0001^5uY\u0016\f#!a\u0004\u0002#\tKg.\u0019:zA\r{gN^3sg&|g.\t\u0002\u0002\u0014\u0005q3i\u001c8wKJ$8\u000fI1!M\u0016\fG/\u001e:fA\r|G\u000e\\3di&|g\u000e\t;pA\tLg.\u0019:zA\u0019|'/\\1u\u0001")
public class BinConversionProcess
implements GeoMesaProcess,
LazyLogging {
    private final Logger logger;
    private volatile boolean bitmap$0;

    private Logger logger$lzycompute() {
        BinConversionProcess binConversionProcess = this;
        synchronized (binConversionProcess) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @DescribeResult(description="Encoded feature collection")
    public Iterator<byte[]> execute(@DescribeParameter(name="features", description="Input feature collection to query ") SimpleFeatureCollection features, @DescribeParameter(name="track", description="Track field to use for BIN records", min=0) String track, @DescribeParameter(name="geom", description="Geometry field to use for BIN records", min=0) String geom, @DescribeParameter(name="dtg", description="Date field to use for BIN records", min=0) String dtg, @DescribeParameter(name="label", description="Label field to use for BIN records", min=0) String label, @DescribeParameter(name="axisOrder", description="Axis order - either latlon or lonlat", min=0) String axisOrder) {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Running BIN encoding for {}", new Object[]{features.getClass().getName()});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        SimpleFeatureType sft = (SimpleFeatureType)features.getSchema();
        Option geomField = Option$.MODULE$.apply((Object)geom).map((Function1)new Serializable(this, sft){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BinConversionProcess $outer;
            private final SimpleFeatureType sft$1;

            public final int apply(String attribute) {
                return this.$outer.org$locationtech$geomesa$process$transform$BinConversionProcess$$indexOf$1(attribute, this.sft$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.sft$1 = sft$1;
            }
        });
        Option dtgField = Option$.MODULE$.apply((Object)dtg).map((Function1)new Serializable(this, sft){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BinConversionProcess $outer;
            private final SimpleFeatureType sft$1;

            public final int apply(String attribute) {
                return this.$outer.org$locationtech$geomesa$process$transform$BinConversionProcess$$indexOf$1(attribute, this.sft$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.sft$1 = sft$1;
            }
        }).orElse((Function0)new Serializable(this, sft){
            public static final long serialVersionUID = 0L;
            private final SimpleFeatureType sft$1;

            public final Option<Object> apply() {
                return RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getDtgIndex$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(this.sft$1));
            }
            {
                this.sft$1 = sft$1;
            }
        });
        Option trackField = Option$.MODULE$.apply((Object)track).filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String x$1) {
                String string = x$1;
                String string2 = "id";
                return string != null ? !string.equals(string2) : string2 != null;
            }
        }).map((Function1)new Serializable(this, sft){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BinConversionProcess $outer;
            private final SimpleFeatureType sft$1;

            public final int apply(String attribute) {
                return this.$outer.org$locationtech$geomesa$process$transform$BinConversionProcess$$indexOf$1(attribute, this.sft$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.sft$1 = sft$1;
            }
        });
        Option labelField = Option$.MODULE$.apply((Object)label).map((Function1)new Serializable(this, sft){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BinConversionProcess $outer;
            private final SimpleFeatureType sft$1;

            public final int apply(String attribute) {
                return this.$outer.org$locationtech$geomesa$process$transform$BinConversionProcess$$indexOf$1(attribute, this.sft$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.sft$1 = sft$1;
            }
        });
        Option axis = Option$.MODULE$.apply((Object)axisOrder).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Enumeration.Value apply(String x0$1) {
                String string;
                block4: {
                    Enumeration.Value value;
                    block3: {
                        block2: {
                            string = x0$1;
                            String string2 = string.toLowerCase(Locale.US);
                            String string3 = "latlon";
                            if (string2 != null ? !string2.equals(string3) : string3 != null) break block2;
                            value = AxisOrder$.MODULE$.LatLon();
                            break block3;
                        }
                        String string4 = string.toLowerCase(Locale.US);
                        String string5 = "lonlat";
                        if (string4 != null ? !string4.equals(string5) : string5 != null) break block4;
                        value = AxisOrder$.MODULE$.LonLat();
                    }
                    return value;
                }
                throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid axis order '", "'. Valid values are 'latlon' and 'lonlat'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{string})));
            }
        });
        BinVisitor visitor = new BinVisitor(sft, new BinaryOutputEncoder.EncodingOptions(geomField, dtgField, trackField, labelField, axis));
        GeoMesaFeatureCollection$.MODULE$.visit((FeatureCollection)features, (FeatureVisitor)visitor, GeoMesaFeatureCollection$.MODULE$.visit$default$3());
        return visitor.getResult().results();
    }

    /*
     * WARNING - void declaration
     */
    public final int org$locationtech$geomesa$process$transform$BinConversionProcess$$indexOf$1(String attribute, SimpleFeatureType sft$1) {
        void var3_3;
        int i = sft$1.indexOf(attribute);
        if (i == -1) {
            throw new IllegalArgumentException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Attribute ", " doesn't exist in ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{attribute, sft$1.getTypeName()}))).append((Object)SimpleFeatureTypes$.MODULE$.encodeType(sft$1)).toString());
        }
        return (int)var3_3;
    }

    public BinConversionProcess() {
        LazyLogging.class.$init$((LazyLogging)this);
    }
}

