/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.process.tube;

import java.awt.geom.Point2D;
import java.util.Date;
import java.util.concurrent.atomic.AtomicInteger;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.locationtech.geomesa.process.tube.InterpolatedGapFill$;
import org.locationtech.geomesa.process.tube.TubeBuilder;
import org.locationtech.geomesa.utils.date.DateUtils$;
import org.locationtech.geomesa.utils.geotools.Conversions;
import org.locationtech.geomesa.utils.geotools.Conversions$;
import org.locationtech.geomesa.utils.text.WKTUtils$;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Point;
import org.opengis.feature.simple.SimpleFeature;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.NumericRange;
import scala.collection.immutable.NumericRange$;
import scala.collection.mutable.StringBuilder;
import scala.math.Integral;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0001U4A!\u0001\u0002\u0001\u001b\t\u0019\u0012J\u001c;feB|G.\u0019;fI\u001e\u000b\u0007OR5mY*\u00111\u0001B\u0001\u0005iV\u0014WM\u0003\u0002\u0006\r\u00059\u0001O]8dKN\u001c(BA\u0004\t\u0003\u001d9Wm\\7fg\u0006T!!\u0003\u0006\u0002\u00191|7-\u0019;j_:$Xm\u00195\u000b\u0003-\t1a\u001c:h\u0007\u0001\u00192\u0001\u0001\b\u0013!\ty\u0001#D\u0001\u0003\u0013\t\t\"AA\u0006Uk\n,')^5mI\u0016\u0014\bCA\n\u001b\u001b\u0005!\"BA\u000b\u0017\u00031\u00198-\u00197bY><w-\u001b8h\u0015\t9\u0002$\u0001\u0005usB,7/\u00194f\u0015\u0005I\u0012aA2p[&\u00111\u0004\u0006\u0002\f\u0019\u0006T\u0018\u0010T8hO&tw\rC\u0005\u001e\u0001\t\u0005\t\u0015!\u0003\u001fQ\u0005aA/\u001e2f\r\u0016\fG/\u001e:fgB\u0011qDJ\u0007\u0002A)\u0011\u0011EI\u0001\u0007g&l\u0007\u000f\\3\u000b\u0005\r\"\u0013\u0001\u00023bi\u0006T!!\n\u0006\u0002\u0011\u001d,w\u000e^8pYNL!a\n\u0011\u0003/MKW\u000e\u001d7f\r\u0016\fG/\u001e:f\u0007>dG.Z2uS>t\u0017BA\u000f\u0011\u0011%Q\u0003A!A!\u0002\u0013Y\u0013'\u0001\bck\u001a4WM\u001d#jgR\fgnY3\u0011\u00051zS\"A\u0017\u000b\u00039\nQa]2bY\u0006L!\u0001M\u0017\u0003\r\u0011{WO\u00197f\u0013\tQ\u0003\u0003C\u00054\u0001\t\u0005\t\u0015!\u00035o\u00059Q.\u0019=CS:\u001c\bC\u0001\u00176\u0013\t1TFA\u0002J]RL!a\r\t\t\u000be\u0002A\u0011\u0001\u001e\u0002\rqJg.\u001b;?)\u0011YD(\u0010 \u0011\u0005=\u0001\u0001\"B\u000f9\u0001\u0004q\u0002\"\u0002\u00169\u0001\u0004Y\u0003\"B\u001a9\u0001\u0004!\u0004b\u0002!\u0001\u0005\u0004%\t!Q\u0001\u0003S\u0012,\u0012A\u0011\t\u0003\u00072k\u0011\u0001\u0012\u0006\u0003\u000b\u001a\u000ba!\u0019;p[&\u001c'BA$I\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0003\u0013*\u000bA!\u001e;jY*\t1*\u0001\u0003kCZ\f\u0017BA'E\u00055\tEo\\7jG&sG/Z4fe\"1q\n\u0001Q\u0001\n\t\u000b1!\u001b3!\u0011\u0015\t\u0006\u0001\"\u0001S\u0003\u0019qW\r\u001f;JIV\t1\u000b\u0005\u0002U/:\u0011A&V\u0005\u0003-6\na\u0001\u0015:fI\u00164\u0017B\u0001-Z\u0005\u0019\u0019FO]5oO*\u0011a+\f\u0005\u00067\u0002!\t\u0005X\u0001\u000bGJ,\u0017\r^3Uk\n,W#A/\u0011\u0007y3\u0017N\u0004\u0002`I:\u0011\u0001mY\u0007\u0002C*\u0011!\rD\u0001\u0007yI|w\u000e\u001e \n\u00039J!!Z\u0017\u0002\u000fA\f7m[1hK&\u0011q\r\u001b\u0002\t\u0013R,'/\u0019;pe*\u0011Q-\f\t\u0003UBl\u0011a\u001b\u0006\u0003C1T!!\u001c8\u0002\u000f\u0019,\u0017\r^;sK*\u0011qNC\u0001\b_B,gnZ5t\u0013\t\t8NA\u0007TS6\u0004H.\u001a$fCR,(/\u001a\u0005\fg\u0002\u0001\n1!A\u0001\n\u0013!\u0018'\u0001\u000btkB,'\u000f\n2vM\u001a,'\u000fR5ti\u0006t7-Z\u000b\u0002W\u0001")
public class InterpolatedGapFill
extends TubeBuilder {
    private final AtomicInteger id = new AtomicInteger(0);

    public /* synthetic */ double org$locationtech$geomesa$process$tube$InterpolatedGapFill$$super$bufferDistance() {
        return super.bufferDistance();
    }

    public AtomicInteger id() {
        return this.id;
    }

    public String nextId() {
        return ((Object)BoxesRunTime.boxToInteger((int)this.id().getAndIncrement())).toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Iterator<SimpleFeature> createTube() {
        Iterator iterator;
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Creating tube with line interpolated line gap fill");
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        Iterator<SimpleFeature> transformed = this.transform(super.tubeFeatures(), this.dtgField());
        Seq sortedTube = (Seq)transformed.toSeq().sortBy((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ InterpolatedGapFill $outer;

            public final long apply(SimpleFeature sf) {
                return this.$outer.getStartTime(sf).getTime();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, (Ordering)Ordering.Long$.MODULE$);
        Seq pointsAndTimes = (Seq)sortedTube.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ InterpolatedGapFill $outer;

            public final Tuple2<Point, Date> apply(SimpleFeature sf) {
                return new Tuple2((Object)Conversions.RichGeometry$.MODULE$.safeCentroid$extension(Conversions$.MODULE$.RichGeometry(this.$outer.getGeom(sf))), (Object)this.$outer.getStartTime(sf));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Seq$.MODULE$.canBuildFrom());
        if (pointsAndTimes.lengthCompare(1) == 0) {
            BoxedUnit boxedUnit2;
            Tuple2 tuple2;
            Tuple2 tuple22 = (Tuple2)pointsAndTimes.head();
            if (tuple22 == null) throw new MatchError((Object)tuple22);
            Point p1 = (Point)tuple22._1();
            Date t1 = (Date)tuple22._2();
            Tuple2 tuple23 = tuple2 = new Tuple2((Object)p1, (Object)t1);
            Point p12 = (Point)tuple23._1();
            Date t12 = (Date)tuple23._2();
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("Only a single result - can't create a line");
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            iterator = package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SimpleFeature[]{this.builder().buildFeature(this.nextId(), new Object[]{p12, t12, t12})}));
        } else {
            iterator = pointsAndTimes.sliding(2).flatMap((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ InterpolatedGapFill $outer;

                public final TraversableOnce<SimpleFeature> apply(Seq<Tuple2<Point, Date>> x0$3) {
                    Seq<Tuple2<Point, Date>> seq = x0$3;
                    Some some = Seq$.MODULE$.unapplySeq(seq);
                    if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(2) == 0) {
                        Tuple2 tuple2 = (Tuple2)((SeqLike)some.get()).apply(0);
                        Tuple2 tuple22 = (Tuple2)((SeqLike)some.get()).apply(1);
                        if (tuple2 != null) {
                            Point p1 = (Point)tuple2._1();
                            Date t1 = (Date)tuple2._2();
                            if (tuple22 != null) {
                                Iterator iterator;
                                Point p2 = (Point)tuple22._1();
                                Date t2 = (Date)tuple22._2();
                                this.$outer.calc().setStartingGeographicPoint(p1.getX(), p1.getY());
                                this.$outer.calc().setDestinationGeographicPoint(p2.getX(), p2.getY());
                                double dist = this.$outer.calc().getOrthodromicDistance();
                                long timeDiffMillis = DateUtils$.MODULE$.toInstant(t2).toEpochMilli() - DateUtils$.MODULE$.toInstant(t1).toEpochMilli();
                                int segCount = (int)(dist / this.$outer.org$locationtech$geomesa$process$tube$InterpolatedGapFill$$super$bufferDistance());
                                long segDuration = timeDiffMillis / (long)segCount;
                                NumericRange.Inclusive timeSteps = NumericRange$.MODULE$.inclusive((Object)BoxesRunTime.boxToLong((long)DateUtils$.MODULE$.toInstant(t1).toEpochMilli()), (Object)BoxesRunTime.boxToLong((long)DateUtils$.MODULE$.toInstant(t2).toEpochMilli()), (Object)BoxesRunTime.boxToLong((long)segDuration), (Integral)Numeric.LongIsIntegral$.MODULE$);
                                if (dist > this.$outer.org$locationtech$geomesa$process$tube$InterpolatedGapFill$$super$bufferDistance() && timeSteps.lengthCompare(1) > 0) {
                                    double heading = this.$outer.calc().getAzimuth();
                                    ObjectRef segStep = ObjectRef.create((Object)new Coordinate(p1.getX(), p1.getY(), 0.0));
                                    iterator = timeSteps.sliding(2).map((Function1)new Serializable(this, heading, segStep){
                                        public static final long serialVersionUID = 0L;
                                        private final /* synthetic */ $anonfun$9 $outer;
                                        private final double heading$1;
                                        private final ObjectRef segStep$1;

                                        public final SimpleFeature apply(IndexedSeq<Object> x0$4) {
                                            IndexedSeq<Object> indexedSeq = x0$4;
                                            Some some = Seq$.MODULE$.unapplySeq(indexedSeq);
                                            if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(2) == 0) {
                                                long time0 = BoxesRunTime.unboxToLong((Object)((SeqLike)some.get()).apply(0));
                                                long time1 = BoxesRunTime.unboxToLong((Object)((SeqLike)some.get()).apply(1));
                                                Coordinate segP1 = (Coordinate)this.segStep$1.elem;
                                                this.$outer.org$locationtech$geomesa$process$tube$InterpolatedGapFill$$anonfun$$$outer().calc().setStartingGeographicPoint(segP1.x, segP1.y);
                                                this.$outer.org$locationtech$geomesa$process$tube$InterpolatedGapFill$$anonfun$$$outer().calc().setDirection(this.heading$1, this.$outer.org$locationtech$geomesa$process$tube$InterpolatedGapFill$$anonfun$$$outer().org$locationtech$geomesa$process$tube$InterpolatedGapFill$$super$bufferDistance());
                                                Point2D destPoint = this.$outer.org$locationtech$geomesa$process$tube$InterpolatedGapFill$$anonfun$$$outer().calc().getDestinationGeographicPoint();
                                                this.segStep$1.elem = new Coordinate(destPoint.getX(), destPoint.getY(), 0.0);
                                                Geometry geo = this.$outer.org$locationtech$geomesa$process$tube$InterpolatedGapFill$$anonfun$$$outer().makeIDLSafeLineString(segP1, (Coordinate)this.segStep$1.elem);
                                                SimpleFeature simpleFeature = this.$outer.org$locationtech$geomesa$process$tube$InterpolatedGapFill$$anonfun$$$outer().builder().buildFeature(this.$outer.org$locationtech$geomesa$process$tube$InterpolatedGapFill$$anonfun$$$outer().nextId(), new Object[]{geo, new Date(time0), new Date(time1)});
                                                return simpleFeature;
                                            }
                                            throw new MatchError(indexedSeq);
                                        }
                                        {
                                            if ($outer == null) {
                                                throw null;
                                            }
                                            this.$outer = $outer;
                                            this.heading$1 = heading$1;
                                            this.segStep$1 = segStep$1;
                                        }
                                    });
                                } else {
                                    BoxedUnit boxedUnit;
                                    Point geo;
                                    Object object = geo = p1.equals((Geometry)p2) ? p1 : this.$outer.makeIDLSafeLineString(p1.getCoordinate(), p2.getCoordinate());
                                    if (this.$outer.logger().underlying().isDebugEnabled()) {
                                        this.$outer.logger().underlying().debug(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Created line-filled geometry: ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{WKTUtils$.MODULE$.write((Geometry)geo)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"from ", " and ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{WKTUtils$.MODULE$.write((Geometry)p1), WKTUtils$.MODULE$.write((Geometry)p2)}))).toString());
                                        boxedUnit = BoxedUnit.UNIT;
                                    } else {
                                        boxedUnit = BoxedUnit.UNIT;
                                    }
                                    iterator = Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SimpleFeature[]{this.$outer.builder().buildFeature(this.$outer.nextId(), new Object[]{geo, t1, t2})}));
                                }
                                Iterator iterator2 = iterator;
                                return iterator2;
                            }
                        }
                    }
                    throw new MatchError(seq);
                }

                public /* synthetic */ InterpolatedGapFill org$locationtech$geomesa$process$tube$InterpolatedGapFill$$anonfun$$$outer() {
                    return this.$outer;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
        }
        Iterator lineFeatures = iterator;
        return this.buffer((Iterator<SimpleFeature>)lineFeatures, super.bufferDistance());
    }

    public InterpolatedGapFill(SimpleFeatureCollection tubeFeatures, double bufferDistance, int maxBins) {
        super(tubeFeatures, bufferDistance, maxBins);
    }
}

