/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.fs.storage.common.jobs;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.geotools.filter.text.ecql.ECQL;
import org.locationtech.geomesa.filter.factory.FastFilterFactory$;
import org.locationtech.geomesa.fs.storage.api.StorageMetadata;
import org.locationtech.geomesa.fs.storage.common.utils.StorageUtils$FileType$;
import org.locationtech.geomesa.utils.geotools.SimpleFeatureTypes$;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import scala.Array$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class StorageConfiguration$ {
    public static final StorageConfiguration$ MODULE$;
    private final String PathKey;
    private final String PartitionsKey;
    private final String FileTypeKey;
    private final String SftNameKey;
    private final String SftSpecKey;
    private final String FilterKey;
    private final String TransformSpecKey;
    private final String TransformDefinitionKey;
    private final String PathActionKey;

    static {
        new StorageConfiguration$();
    }

    public String PathKey() {
        return this.PathKey;
    }

    public String PartitionsKey() {
        return this.PartitionsKey;
    }

    public String FileTypeKey() {
        return this.FileTypeKey;
    }

    public String SftNameKey() {
        return this.SftNameKey;
    }

    public String SftSpecKey() {
        return this.SftSpecKey;
    }

    public String FilterKey() {
        return this.FilterKey;
    }

    public String TransformSpecKey() {
        return this.TransformSpecKey;
    }

    public String TransformDefinitionKey() {
        return this.TransformDefinitionKey;
    }

    public String PathActionKey() {
        return this.PathActionKey;
    }

    public void setSft(Configuration conf, SimpleFeatureType sft) {
        String name = (String)Option$.MODULE$.apply((Object)sft.getName().getNamespaceURI()).map((Function1)new Serializable(sft){
            public static final long serialVersionUID = 0L;
            private final SimpleFeatureType sft$1;

            public final String apply(String ns) {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ":", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ns, this.sft$1.getTypeName()}));
            }
            {
                this.sft$1 = sft$1;
            }
        }).getOrElse((Function0)new Serializable(sft){
            public static final long serialVersionUID = 0L;
            private final SimpleFeatureType sft$1;

            public final String apply() {
                return this.sft$1.getTypeName();
            }
            {
                this.sft$1 = sft$1;
            }
        });
        conf.set(this.SftNameKey(), name);
        conf.set(this.SftSpecKey(), SimpleFeatureTypes$.MODULE$.encodeType(sft, true));
    }

    public SimpleFeatureType getSft(Configuration conf) {
        return SimpleFeatureTypes$.MODULE$.createType(conf.get(this.SftNameKey()), conf.get(this.SftSpecKey()));
    }

    public String getSftName(Configuration conf) {
        return conf.get(this.SftNameKey());
    }

    public String getSftSpec(Configuration conf) {
        return conf.get(this.SftSpecKey());
    }

    public void setRootPath(Configuration conf, Path path) {
        conf.set(this.PathKey(), path.toString());
    }

    public Path getRootPath(Configuration conf) {
        return new Path(conf.get(this.PathKey()));
    }

    public void setPartitions(Configuration conf, String[] partitions) {
        conf.setStrings(this.PartitionsKey(), partitions);
    }

    public String[] getPartitions(Configuration conf) {
        return conf.getStrings(this.PartitionsKey());
    }

    public void setFileType(Configuration conf, Enumeration.Value fileType) {
        conf.set(this.FileTypeKey(), fileType.toString());
    }

    public Enumeration.Value getFileType(Configuration conf) {
        return StorageUtils$FileType$.MODULE$.withName(conf.get(this.FileTypeKey()));
    }

    public void setFilter(Configuration conf, Filter filter) {
        conf.set(this.FilterKey(), ECQL.toCQL((Filter)filter));
    }

    public Option<Filter> getFilter(Configuration conf, SimpleFeatureType sft) {
        return Option$.MODULE$.apply((Object)conf.get(this.FilterKey())).map((Function1)new Serializable(sft){
            public static final long serialVersionUID = 0L;
            private final SimpleFeatureType sft$2;

            public final Filter apply(String x$1) {
                return FastFilterFactory$.MODULE$.toFilter(this.sft$2, x$1);
            }
            {
                this.sft$2 = sft$2;
            }
        });
    }

    public void setTransforms(Configuration conf, Tuple2<String, SimpleFeatureType> transforms) {
        Tuple2<String, SimpleFeatureType> tuple2 = transforms;
        if (tuple2 != null) {
            Tuple2 tuple22;
            String tdefs = (String)tuple2._1();
            SimpleFeatureType tsft = (SimpleFeatureType)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)tdefs, (Object)tsft);
            String tdefs2 = (String)tuple23._1();
            SimpleFeatureType tsft2 = (SimpleFeatureType)tuple23._2();
            conf.set(this.TransformDefinitionKey(), tdefs2);
            conf.set(this.TransformSpecKey(), SimpleFeatureTypes$.MODULE$.encodeType(tsft2, true));
            return;
        }
        throw new MatchError(tuple2);
    }

    public Option<Tuple2<String, SimpleFeatureType>> getTransforms(Configuration conf) {
        return Option$.MODULE$.apply((Object)conf.get(this.TransformDefinitionKey())).flatMap((Function1)new Serializable(conf){
            public static final long serialVersionUID = 0L;
            private final Configuration conf$1;

            public final Option<Tuple2<String, SimpleFeatureType>> apply(String defs) {
                return Option$.MODULE$.apply((Object)this.conf$1.get(StorageConfiguration$.MODULE$.TransformSpecKey())).map((Function1)new Serializable(this, defs){
                    public static final long serialVersionUID = 0L;
                    private final String defs$1;

                    public final Tuple2<String, SimpleFeatureType> apply(String spec) {
                        return new Tuple2((Object)this.defs$1, (Object)SimpleFeatureTypes$.MODULE$.createType("", spec));
                    }
                    {
                        this.defs$1 = defs$1;
                    }
                });
            }
            {
                this.conf$1 = conf$1;
            }
        });
    }

    public void setPathActions(Configuration conf, Seq<StorageMetadata.StorageFilePath> paths) {
        paths.foreach((Function1)new Serializable(conf){
            public static final long serialVersionUID = 0L;
            private final Configuration conf$2;

            public final void apply(StorageMetadata.StorageFilePath x0$1) {
                StorageMetadata.StorageFilePath storageFilePath = x0$1;
                if (storageFilePath != null) {
                    StorageMetadata.StorageFile f = storageFilePath.file();
                    Path path = storageFilePath.path();
                    this.conf$2.set(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{StorageConfiguration$.MODULE$.PathActionKey(), path.getName()})), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ":", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)f.timestamp()), f.action()})));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError((Object)storageFilePath);
            }
            {
                this.conf$2 = conf$2;
            }
        });
    }

    public Tuple2<Object, Enumeration.Value> getPathAction(Configuration conf, Path path) {
        String[] stringArray = conf.get(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.PathActionKey(), path.getName()}))).split(":");
        Option option = Array$.MODULE$.unapplySeq((Object)stringArray);
        if (!option.isEmpty() && option.get() != null && ((SeqLike)option.get()).lengthCompare(2) == 0) {
            Tuple2 tuple2;
            String ts = (String)((SeqLike)option.get()).apply(0);
            String action = (String)((SeqLike)option.get()).apply(1);
            Tuple2 tuple22 = tuple2 = new Tuple2((Object)ts, (Object)action);
            String ts2 = (String)tuple22._1();
            String action2 = (String)tuple22._2();
            return new Tuple2((Object)BoxesRunTime.boxToLong((long)new StringOps(Predef$.MODULE$.augmentString(ts2)).toLong()), (Object)StorageMetadata.StorageFileAction$.MODULE$.withName(action2));
        }
        throw new MatchError((Object)stringArray);
    }

    private StorageConfiguration$() {
        MODULE$ = this;
        this.PathKey = "geomesa.fs.path";
        this.PartitionsKey = "geomesa.fs.partitions";
        this.FileTypeKey = "geomesa.fs.output.file-type";
        this.SftNameKey = "geomesa.fs.sft.name";
        this.SftSpecKey = "geomesa.fs.sft.spec";
        this.FilterKey = "geomesa.fs.filter";
        this.TransformSpecKey = "geomesa.fs.transform.spec";
        this.TransformDefinitionKey = "geomesa.fs.transform.defs";
        this.PathActionKey = "geomesa.fs.path.action";
    }
}

