/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.fs.storage.common.metadata;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigParseOptions;
import com.typesafe.config.ConfigRenderOptions;
import com.typesafe.config.ConfigSyntax;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.EnumSet;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Phaser;
import java.util.function.BiFunction;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.Path;
import org.locationtech.geomesa.fs.storage.api.StorageMetadata;
import org.locationtech.geomesa.fs.storage.api.package;
import org.locationtech.geomesa.fs.storage.common.metadata.FileBasedMetadata;
import org.locationtech.geomesa.fs.storage.common.metadata.FileBasedMetadata$$anonfun$org$locationtech$geomesa$fs$storage$common$metadata$FileBasedMetadata$;
import org.locationtech.geomesa.fs.storage.common.metadata.package;
import org.locationtech.geomesa.fs.storage.common.metadata.package$;
import org.locationtech.geomesa.fs.storage.common.utils.PathCache$;
import org.locationtech.geomesa.utils.io.WithClose$;
import org.locationtech.geomesa.utils.stats.MethodProfiling;
import pureconfig.Derivation;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.util.control.NonFatal$;

public final class FileBasedMetadata$
implements MethodProfiling {
    public static final FileBasedMetadata$ MODULE$;
    private final String MetadataType;
    private final package.NamedOptions DefaultOptions;
    private final String org$locationtech$geomesa$fs$storage$common$metadata$FileBasedMetadata$$CompactedPath;
    private final String org$locationtech$geomesa$fs$storage$common$metadata$FileBasedMetadata$$UpdateFilePrefix;
    private final String org$locationtech$geomesa$fs$storage$common$metadata$FileBasedMetadata$$JsonPathSuffix;
    private final ConfigRenderOptions org$locationtech$geomesa$fs$storage$common$metadata$FileBasedMetadata$$options;
    private final Object org$locationtech$geomesa$fs$storage$common$metadata$FileBasedMetadata$$add;
    private final Object org$locationtech$geomesa$fs$storage$common$metadata$FileBasedMetadata$$remove;
    private final Logger logger;
    private volatile boolean bitmap$0;

    static {
        new FileBasedMetadata$();
    }

    public <R> R profile(Function1<Object, BoxedUnit> onComplete, Function0<R> code) {
        return (R)MethodProfiling.class.profile((MethodProfiling)this, onComplete, code);
    }

    public <R> R profile(Function2<R, Object, BoxedUnit> onComplete, Function0<R> code) {
        return (R)MethodProfiling.class.profile((MethodProfiling)this, onComplete, code);
    }

    public <R> R profile(String message, Function0<R> code) {
        return (R)MethodProfiling.class.profile((MethodProfiling)this, (String)message, code);
    }

    private Logger logger$lzycompute() {
        FileBasedMetadata$ fileBasedMetadata$ = this;
        synchronized (fileBasedMetadata$) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public String MetadataType() {
        return this.MetadataType;
    }

    public package.NamedOptions DefaultOptions() {
        return this.DefaultOptions;
    }

    public String org$locationtech$geomesa$fs$storage$common$metadata$FileBasedMetadata$$CompactedPath() {
        return this.org$locationtech$geomesa$fs$storage$common$metadata$FileBasedMetadata$$CompactedPath;
    }

    public String org$locationtech$geomesa$fs$storage$common$metadata$FileBasedMetadata$$UpdateFilePrefix() {
        return this.org$locationtech$geomesa$fs$storage$common$metadata$FileBasedMetadata$$UpdateFilePrefix;
    }

    public String org$locationtech$geomesa$fs$storage$common$metadata$FileBasedMetadata$$JsonPathSuffix() {
        return this.org$locationtech$geomesa$fs$storage$common$metadata$FileBasedMetadata$$JsonPathSuffix;
    }

    public ConfigRenderOptions org$locationtech$geomesa$fs$storage$common$metadata$FileBasedMetadata$$options() {
        return this.org$locationtech$geomesa$fs$storage$common$metadata$FileBasedMetadata$$options;
    }

    public Object org$locationtech$geomesa$fs$storage$common$metadata$FileBasedMetadata$$add() {
        return this.org$locationtech$geomesa$fs$storage$common$metadata$FileBasedMetadata$$add;
    }

    public Object org$locationtech$geomesa$fs$storage$common$metadata$FileBasedMetadata$$remove() {
        return this.org$locationtech$geomesa$fs$storage$common$metadata$FileBasedMetadata$$remove;
    }

    public void org$locationtech$geomesa$fs$storage$common$metadata$FileBasedMetadata$$writePartitionConfig(FileContext fc, Path directory, package.PartitionConfig config) {
        String name = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "", "-", "", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.org$locationtech$geomesa$fs$storage$common$metadata$FileBasedMetadata$$UpdateFilePrefix(), this.org$locationtech$geomesa$fs$storage$common$metadata$FileBasedMetadata$$sanitizePartitionName(config.name()), UUID.randomUUID(), this.org$locationtech$geomesa$fs$storage$common$metadata$FileBasedMetadata$$JsonPathSuffix()}));
        String data = (String)this.profile("Serialized partition configuration", (Function0)new Serializable(config){
            public static final long serialVersionUID = 0L;
            private final package.PartitionConfig config$1;

            public final String apply() {
                return package$.MODULE$.PartitionConfigConvert().to((Object)this.config$1).render(FileBasedMetadata$.MODULE$.org$locationtech$geomesa$fs$storage$common$metadata$FileBasedMetadata$$options());
            }
            {
                this.config$1 = config$1;
            }
        });
        this.profile("Persisted partition configuration", (Function0)new Serializable(fc, directory, name, data){
            public static final long serialVersionUID = 0L;
            private final FileContext fc$1;
            private final Path directory$1;
            private final String name$1;
            public final String data$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Path file = new Path(this.directory$1, this.name$1);
                WithClose$.MODULE$.apply((Object)this.fc$1.create(file, EnumSet.of(CreateFlag.CREATE), new Options.CreateOpts[]{Options.CreateOpts.createParent()}), (Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun$org$locationtech$geomesa$fs$storage$common$metadata$FileBasedMetadata$$writePartitionConfig$1 $outer;

                    public final void apply(FSDataOutputStream out) {
                        out.write(this.$outer.data$1.getBytes(StandardCharsets.UTF_8));
                        out.hflush();
                        out.hsync();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
                PathCache$.MODULE$.register(this.fc$1, file, PathCache$.MODULE$.register$default$3(), PathCache$.MODULE$.register$default$4());
            }
            {
                this.fc$1 = fc$1;
                this.directory$1 = directory$1;
                this.name$1 = name$1;
                this.data$1 = data$1;
            }
        });
    }

    public Option<package.PartitionConfig> org$locationtech$geomesa$fs$storage$common$metadata$FileBasedMetadata$$readPartitionConfig(FileContext fc, Path file) {
        Option option;
        try {
            Config config = (Config)this.profile("Loaded partition configuration", (Function0)new Serializable(fc, file){
                public static final long serialVersionUID = 0L;
                private final FileContext fc$4;
                private final Path file$1;

                public final Config apply() {
                    return (Config)WithClose$.MODULE$.apply((Object)new InputStreamReader((InputStream)this.fc$4.open(this.file$1), StandardCharsets.UTF_8), (Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final Config apply(InputStreamReader in) {
                            return ConfigFactory.parseReader((Reader)in, (ConfigParseOptions)ConfigParseOptions.defaults().setSyntax(ConfigSyntax.JSON));
                        }
                    });
                }
                {
                    this.fc$4 = fc$4;
                    this.file$1 = file$1;
                }
            });
            option = (Option)this.profile("Parsed partition configuration", (Function0)new Serializable(config){
                public static final long serialVersionUID = 0L;
                private final Config config$3;

                public final Some<package.PartitionConfig> apply() {
                    return new Some(pureconfig.package$.MODULE$.loadConfigOrThrow(this.config$3, ClassTag$.MODULE$.apply(package.PartitionConfig.class), (Derivation)new Derivation.Successful(package$.MODULE$.PartitionConfigConvert())));
                }
                {
                    this.config$3 = config$3;
                }
            });
        }
        catch (Throwable throwable) {
            BoxedUnit boxedUnit;
            Throwable throwable2 = throwable;
            Option option2 = NonFatal$.MODULE$.unapply(throwable2);
            if (option2.isEmpty()) {
                throw throwable;
            }
            Throwable e = (Throwable)option2.get();
            if (this.logger().underlying().isErrorEnabled()) {
                this.logger().underlying().error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error reading config at path ", ":"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{file})), e);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            None$ none$ = None$.MODULE$;
            option = none$;
        }
        return option;
    }

    public void org$locationtech$geomesa$fs$storage$common$metadata$FileBasedMetadata$$writeCompactedConfig(FileContext fc, Path directory, Seq<package.PartitionConfig> config) {
        String data = (String)this.profile("Serialized compacted partition configuration", (Function0)new Serializable(config){
            public static final long serialVersionUID = 0L;
            private final Seq config$2;

            public final String apply() {
                return package$.MODULE$.CompactedConfigConvert().to((Object)new package.CompactedConfig((Seq<package.PartitionConfig>)this.config$2)).render(FileBasedMetadata$.MODULE$.org$locationtech$geomesa$fs$storage$common$metadata$FileBasedMetadata$$options());
            }
            {
                this.config$2 = config$2;
            }
        });
        this.profile("Persisted compacted partition configuration", (Function0)new Serializable(fc, directory, data){
            public static final long serialVersionUID = 0L;
            private final FileContext fc$5;
            private final Path directory$3;
            public final String data$2;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Path file = new Path(this.directory$3, FileBasedMetadata$.MODULE$.org$locationtech$geomesa$fs$storage$common$metadata$FileBasedMetadata$$CompactedPath());
                EnumSet<CreateFlag> flags = EnumSet.of(CreateFlag.CREATE, CreateFlag.OVERWRITE);
                WithClose$.MODULE$.apply((Object)this.fc$5.create(file, flags, new Options.CreateOpts[]{Options.CreateOpts.createParent()}), (Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun$org$locationtech$geomesa$fs$storage$common$metadata$FileBasedMetadata$$writeCompactedConfig$1 $outer;

                    public final void apply(FSDataOutputStream out) {
                        out.write(this.$outer.data$2.getBytes(StandardCharsets.UTF_8));
                        out.hflush();
                        out.hsync();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
                PathCache$.MODULE$.register(this.fc$5, file, PathCache$.MODULE$.register$default$3(), PathCache$.MODULE$.register$default$4());
            }
            {
                this.fc$5 = fc$5;
                this.directory$3 = directory$3;
                this.data$2 = data$2;
            }
        });
    }

    public Seq<package.PartitionConfig> org$locationtech$geomesa$fs$storage$common$metadata$FileBasedMetadata$$readCompactedConfig(FileContext fc, Path directory) {
        Seq seq;
        Path file = new Path(directory, this.org$locationtech$geomesa$fs$storage$common$metadata$FileBasedMetadata$$CompactedPath());
        try {
            if (PathCache$.MODULE$.exists(fc, file, true)) {
                Config config = (Config)this.profile("Loaded compacted partition configuration", (Function0)new Serializable(fc, file){
                    public static final long serialVersionUID = 0L;
                    private final FileContext fc$2;
                    private final Path file$2;

                    public final Config apply() {
                        return (Config)WithClose$.MODULE$.apply((Object)new InputStreamReader((InputStream)this.fc$2.open(this.file$2), StandardCharsets.UTF_8), (Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final Config apply(InputStreamReader in) {
                                return ConfigFactory.parseReader((Reader)in, (ConfigParseOptions)ConfigParseOptions.defaults().setSyntax(ConfigSyntax.JSON));
                            }
                        });
                    }
                    {
                        this.fc$2 = fc$2;
                        this.file$2 = file$2;
                    }
                });
                seq = (Seq)this.profile("Parsed compacted partition configuration", (Function0)new Serializable(config){
                    public static final long serialVersionUID = 0L;
                    private final Config config$4;

                    public final Seq<package.PartitionConfig> apply() {
                        return ((package.CompactedConfig)pureconfig.package$.MODULE$.loadConfigOrThrow(this.config$4, ClassTag$.MODULE$.apply(package.CompactedConfig.class), (Derivation)new Derivation.Successful(package$.MODULE$.CompactedConfigConvert()))).partitions();
                    }
                    {
                        this.config$4 = config$4;
                    }
                });
            } else {
                seq = (Seq)Seq$.MODULE$.empty();
            }
        }
        catch (Throwable throwable) {
            Seq seq2;
            BoxedUnit boxedUnit;
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            Throwable e = (Throwable)option.get();
            if (this.logger().underlying().isErrorEnabled()) {
                this.logger().underlying().error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error reading config at path ", ":"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{file})), e);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            seq = seq2 = (Seq)Seq$.MODULE$.empty();
        }
        return seq;
    }

    public Seq<Path> org$locationtech$geomesa$fs$storage$common$metadata$FileBasedMetadata$$listPartitionConfigs(ExecutorService es, FileContext fc, Path directory, Option<String> partition) {
        return (Seq)this.profile("Listed metadata files", (Function0)new Serializable(es, fc, directory, partition){
            public static final long serialVersionUID = 0L;
            private final ExecutorService es$1;
            private final FileContext fc$3;
            private final Path directory$2;
            private final Option partition$1;

            public final Seq<Path> apply() {
                Seq seq;
                if (PathCache$.MODULE$.exists(this.fc$3, this.directory$2, true)) {
                    String prefix = (String)this.partition$1.map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply(String p) {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{FileBasedMetadata$.MODULE$.org$locationtech$geomesa$fs$storage$common$metadata$FileBasedMetadata$$UpdateFilePrefix(), FileBasedMetadata$.MODULE$.org$locationtech$geomesa$fs$storage$common$metadata$FileBasedMetadata$$sanitizePartitionName(p)}));
                        }
                    }).getOrElse((Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return FileBasedMetadata$.MODULE$.org$locationtech$geomesa$fs$storage$common$metadata$FileBasedMetadata$$UpdateFilePrefix();
                        }
                    });
                    ConcurrentLinkedQueue<Path> result = new ConcurrentLinkedQueue<Path>();
                    Phaser phaser = new Phaser(2);
                    this.es$1.submit(new FileBasedMetadata.DirectoryWorker(this.es$1, phaser, this.fc$3, this.directory$2, result, prefix));
                    phaser.awaitAdvanceInterruptibly(phaser.arrive());
                    seq = ((TraversableOnce)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(result).asScala()).toSeq();
                } else {
                    seq = (Seq)Seq$.MODULE$.empty();
                }
                return seq;
            }
            {
                this.es$1 = es$1;
                this.fc$3 = fc$3;
                this.directory$2 = directory$2;
                this.partition$1 = partition$1;
            }
        });
    }

    public String org$locationtech$geomesa$fs$storage$common$metadata$FileBasedMetadata$$sanitizePartitionName(String name) {
        return name.replaceAll("[^a-zA-Z0-9]", "-");
    }

    private FileBasedMetadata$() {
        MODULE$ = this;
        LazyLogging.class.$init$((LazyLogging)this);
        MethodProfiling.class.$init$((MethodProfiling)this);
        this.MetadataType = "file";
        this.DefaultOptions = new package.NamedOptions(this.MetadataType(), package.NamedOptions$.MODULE$.apply$default$2());
        this.org$locationtech$geomesa$fs$storage$common$metadata$FileBasedMetadata$$CompactedPath = "compacted.json";
        this.org$locationtech$geomesa$fs$storage$common$metadata$FileBasedMetadata$$UpdateFilePrefix = "update-";
        this.org$locationtech$geomesa$fs$storage$common$metadata$FileBasedMetadata$$JsonPathSuffix = ".json";
        this.org$locationtech$geomesa$fs$storage$common$metadata$FileBasedMetadata$$options = ConfigRenderOptions.concise().setFormatted(true);
        this.org$locationtech$geomesa$fs$storage$common$metadata$FileBasedMetadata$$add = new BiFunction<StorageMetadata.PartitionMetadata, StorageMetadata.PartitionMetadata, StorageMetadata.PartitionMetadata>(){

            public StorageMetadata.PartitionMetadata apply(StorageMetadata.PartitionMetadata existing, StorageMetadata.PartitionMetadata update) {
                return existing.$plus(update);
            }
        };
        this.org$locationtech$geomesa$fs$storage$common$metadata$FileBasedMetadata$$remove = new BiFunction<StorageMetadata.PartitionMetadata, StorageMetadata.PartitionMetadata, StorageMetadata.PartitionMetadata>(){

            public StorageMetadata.PartitionMetadata apply(StorageMetadata.PartitionMetadata existing, StorageMetadata.PartitionMetadata update) {
                StorageMetadata.PartitionMetadata result = existing.$minus(update);
                return result.files().isEmpty() ? null : result;
            }
        };
    }
}

