/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.fs.storage.common.metadata;

import com.typesafe.scalalogging.Logger;
import org.apache.commons.dbcp2.PoolableConnection;
import org.apache.commons.dbcp2.PoolingDataSource;
import org.locationtech.geomesa.fs.storage.api.PartitionScheme;
import org.locationtech.geomesa.fs.storage.api.PartitionSchemeFactory$;
import org.locationtech.geomesa.fs.storage.api.StorageMetadataFactory;
import org.locationtech.geomesa.fs.storage.api.package;
import org.locationtech.geomesa.fs.storage.common.metadata.JdbcMetadata;
import org.locationtech.geomesa.fs.storage.common.metadata.JdbcMetadata$;
import org.locationtech.geomesa.fs.storage.common.metadata.JdbcMetadataFactory$;
import org.locationtech.geomesa.fs.storage.common.metadata.MetadataJson$;
import org.locationtech.geomesa.fs.storage.common.metadata.package$;
import org.locationtech.geomesa.utils.io.CloseQuietly$;
import org.opengis.feature.simple.SimpleFeatureType;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.Nothing$;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\u00055a\u0001B\u0001\u0003\u0001E\u00111C\u00133cG6+G/\u00193bi\u00064\u0015m\u0019;pefT!a\u0001\u0003\u0002\u00115,G/\u00193bi\u0006T!!\u0002\u0004\u0002\r\r|W.\\8o\u0015\t9\u0001\"A\u0004ti>\u0014\u0018mZ3\u000b\u0005%Q\u0011A\u00014t\u0015\tYA\"A\u0004hK>lWm]1\u000b\u00055q\u0011\u0001\u00047pG\u0006$\u0018n\u001c8uK\u000eD'\"A\b\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001\u0011\u0002\u0004\u0005\u0002\u0014-5\tACC\u0001\u0016\u0003\u0015\u00198-\u00197b\u0013\t9BC\u0001\u0004B]f\u0014VM\u001a\t\u00033qi\u0011A\u0007\u0006\u00037\u0019\t1!\u00199j\u0013\ti\"D\u0001\fTi>\u0014\u0018mZ3NKR\fG-\u0019;b\r\u0006\u001cGo\u001c:z\u0011\u0015y\u0002\u0001\"\u0001!\u0003\u0019a\u0014N\\5u}Q\t\u0011\u0005\u0005\u0002#\u00015\t!\u0001C\u0003%\u0001\u0011\u0005S%\u0001\u0003oC6,W#\u0001\u0014\u0011\u0005\u001dRcBA\n)\u0013\tIC#\u0001\u0004Qe\u0016$WMZ\u0005\u0003W1\u0012aa\u0015;sS:<'BA\u0015\u0015\u0011\u0015q\u0003\u0001\"\u00110\u0003\u0011aw.\u00193\u0015\u0005A2\u0004cA\n2g%\u0011!\u0007\u0006\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005\t\"\u0014BA\u001b\u0003\u00051QEMY2NKR\fG-\u0019;b\u0011\u00159T\u00061\u00019\u0003\u001d\u0019wN\u001c;fqR\u0004\"!O&\u000f\u0005iJeBA\u001eI\u001d\tatI\u0004\u0002>\r:\u0011a(\u0012\b\u0003\u007f\u0011s!\u0001Q\"\u000e\u0003\u0005S!A\u0011\t\u0002\rq\u0012xn\u001c;?\u0013\u0005y\u0011BA\u0007\u000f\u0013\tYA\"\u0003\u0002\n\u0015%\u0011q\u0001C\u0005\u00037\u0019I!A\u0013\u000e\u0002\u000fA\f7m[1hK&\u0011A*\u0014\u0002\u0012\r&dWmU=ti\u0016l7i\u001c8uKb$(B\u0001&\u001b\u0011\u0015y\u0005\u0001\"\u0011Q\u0003\u0019\u0019'/Z1uKR!1'\u0015*X\u0011\u00159d\n1\u00019\u0011\u0015\u0019f\n1\u0001U\u0003\u0019\u0019wN\u001c4jOB!q%\u0016\u0014'\u0013\t1FFA\u0002NCBDQ\u0001\u0017(A\u0002e\u000bA!\\3uCB\u0011\u0011HW\u0005\u000376\u0013\u0001\"T3uC\u0012\fG/Y\u0004\u0006;\nA\tAX\u0001\u0014\u0015\u0012\u00147-T3uC\u0012\fG/\u0019$bGR|'/\u001f\t\u0003E}3Q!\u0001\u0002\t\u0002\u0001\u001cBa\u0018\nbSB\u0011!mZ\u0007\u0002G*\u0011A-Z\u0001\u0006gR\fGo\u001d\u0006\u0003M*\tQ!\u001e;jYNL!\u0001[2\u0003\u001f5+G\u000f[8e!J|g-\u001b7j]\u001e\u0004\"A[9\u000e\u0003-T!\u0001\\7\u0002\u0019M\u001c\u0017\r\\1m_\u001e<\u0017N\\4\u000b\u00059|\u0017\u0001\u0003;za\u0016\u001c\u0018MZ3\u000b\u0003A\f1aY8n\u0013\t\u00118NA\u0006MCjLHj\\4hS:<\u0007\"B\u0010`\t\u0003!H#\u00010\t\u000bY|F\u0011A<\u0002!\r\u0014X-\u0019;f\t\u0006$\u0018mU8ve\u000e,Gc\u0001=\u0002\fA)\u00110!\u0001\u0002\u00065\t!P\u0003\u0002|y\u0006)AMY2qe)\u0011QP`\u0001\bG>lWn\u001c8t\u0015\tyh\"\u0001\u0004ba\u0006\u001c\u0007.Z\u0005\u0004\u0003\u0007Q(!\u0005)p_2Lgn\u001a#bi\u0006\u001cv.\u001e:dKB\u0019\u00110a\u0002\n\u0007\u0005%!P\u0001\nQ_>d\u0017M\u00197f\u0007>tg.Z2uS>t\u0007\"B*v\u0001\u0004!\u0006")
public class JdbcMetadataFactory
implements StorageMetadataFactory {
    public static Logger logger() {
        return JdbcMetadataFactory$.MODULE$.logger();
    }

    public static <R> R profile(String string, Function0<R> function0) {
        return JdbcMetadataFactory$.MODULE$.profile(string, function0);
    }

    public static <R> R profile(Function2<R, Object, BoxedUnit> function2, Function0<R> function0) {
        return JdbcMetadataFactory$.MODULE$.profile(function2, function0);
    }

    public static <R> R profile(Function1<Object, BoxedUnit> function1, Function0<R> function0) {
        return JdbcMetadataFactory$.MODULE$.profile(function1, function0);
    }

    public static PoolingDataSource<PoolableConnection> createDataSource(Map<String, String> map) {
        return JdbcMetadataFactory$.MODULE$.createDataSource(map);
    }

    public String name() {
        return JdbcMetadata$.MODULE$.MetadataType();
    }

    public Option<JdbcMetadata> load(package.FileSystemContext context) {
        return MetadataJson$.MODULE$.readMetadata(context).collect((PartialFunction)new Serializable(this, context){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ JdbcMetadataFactory $outer;
            private final package.FileSystemContext context$1;

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public final <A1 extends package.NamedOptions, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 != null) {
                    String name = A1.name();
                    Map opts = A1.options();
                    if (name.equalsIgnoreCase(this.$outer.name())) {
                        String root = this.context$1.root().toUri().toString();
                        PoolingDataSource<PoolableConnection> source = JdbcMetadataFactory$.MODULE$.createDataSource((Map<String, String>)opts);
                        try {
                            package.Metadata metadata = (package.Metadata)JdbcMetadata$.MODULE$.load(source, root).getOrElse((Function0)new Serializable(this, root){
                                public static final long serialVersionUID = 0L;
                                private final String root$1;

                                public final Nothing$ apply() {
                                    throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not load metadata at root '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.root$1})));
                                }
                                {
                                    this.root$1 = root$1;
                                }
                            });
                            SimpleFeatureType sft = package$.MODULE$.namespaced(metadata.sft(), (Option<String>)this.context$1.namespace());
                            PartitionScheme scheme = PartitionSchemeFactory$.MODULE$.load(sft, metadata.scheme());
                            object = new JdbcMetadata(source, root, sft, metadata.encoding(), scheme, metadata.leafStorage());
                            return (B1)object;
                        }
                        catch (Throwable throwable) {
                            Throwable throwable2 = throwable;
                            Option option = NonFatal$.MODULE$.unapply(throwable2);
                            if (option.isEmpty()) {
                                throw throwable;
                            }
                            Throwable e = (Throwable)option.get();
                            CloseQuietly$.MODULE$.apply(source).foreach((Function1)new Serializable(this, e){
                                public static final long serialVersionUID = 0L;
                                private final Throwable e$1;

                                public final void apply(Throwable x$1) {
                                    this.e$1.addSuppressed(x$1);
                                }
                                {
                                    this.e$1 = e$1;
                                }
                            });
                            throw e;
                        }
                    }
                }
                object = function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(package.NamedOptions x1) {
                String name;
                package.NamedOptions namedOptions = x1;
                boolean bl = namedOptions != null && (name = namedOptions.name()).equalsIgnoreCase(this.$outer.name());
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.context$1 = context$1;
            }
        });
    }

    public JdbcMetadata create(package.FileSystemContext context, Map<String, String> config, package.Metadata meta) {
        PartitionScheme scheme = PartitionSchemeFactory$.MODULE$.load(meta.sft(), meta.scheme());
        MetadataJson$.MODULE$.writeMetadata(context, new package.NamedOptions(this.name(), config));
        String root = context.root().toUri().toString();
        SimpleFeatureType sft = package$.MODULE$.namespaced(meta.sft(), (Option<String>)context.namespace());
        PoolingDataSource<PoolableConnection> source = JdbcMetadataFactory$.MODULE$.createDataSource(config);
        try {
            JdbcMetadata$.MODULE$.create(source, root, meta);
            return new JdbcMetadata(source, root, sft, meta.encoding(), scheme, meta.leafStorage());
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            Throwable e = (Throwable)option.get();
            CloseQuietly$.MODULE$.apply(source).foreach((Function1)new Serializable(this, e){
                public static final long serialVersionUID = 0L;
                private final Throwable e$2;

                public final void apply(Throwable x$1) {
                    this.e$2.addSuppressed(x$1);
                }
                {
                    this.e$2 = e$2;
                }
            });
            throw e;
        }
    }
}

