/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.index.iterators;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.locationtech.geomesa.features.ScalaSimpleFeature;
import org.locationtech.geomesa.features.ScalaSimpleFeature$;
import org.locationtech.geomesa.index.api.QueryPlan;
import org.locationtech.geomesa.index.iterators.AggregatingScan;
import org.locationtech.geomesa.index.utils.bin.BinSorter$;
import org.locationtech.geomesa.utils.bin.BinaryOutputCallback;
import org.locationtech.geomesa.utils.bin.BinaryOutputEncoder;
import org.locationtech.geomesa.utils.bin.BinaryOutputEncoder$;
import org.locationtech.geomesa.utils.geotools.GeometryUtils$;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import scala.Array$;
import scala.Option;
import scala.Predef$;
import scala.collection.immutable.Map;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\tugaB\u0001\u0003!\u0003\r\t!\u0004\u0002\u0013\u0005&t\u0017iZ4sK\u001e\fG/\u001b8h'\u000e\fgN\u0003\u0002\u0004\t\u0005I\u0011\u000e^3sCR|'o\u001d\u0006\u0003\u000b\u0019\tQ!\u001b8eKbT!a\u0002\u0005\u0002\u000f\u001d,w.\\3tC*\u0011\u0011BC\u0001\rY>\u001c\u0017\r^5p]R,7\r\u001b\u0006\u0002\u0017\u0005\u0019qN]4\u0004\u0001M\u0019\u0001A\u0004\u000b\u0011\u0005=\u0011R\"\u0001\t\u000b\u0003E\tQa]2bY\u0006L!a\u0005\t\u0003\r\u0005s\u0017PU3g!\r)b\u0003G\u0007\u0002\u0005%\u0011qC\u0001\u0002\u0010\u0003\u001e<'/Z4bi&twmU2b]B\u0019\u0011$!&\u000f\u0005i9cBA\u000e'\u001d\taRE\u0004\u0002\u001eI9\u0011ad\t\b\u0003?\tj\u0011\u0001\t\u0006\u0003C1\ta\u0001\u0010:p_Rt\u0014\"A\u0006\n\u0005%Q\u0011BA\u0004\t\u0013\t)a!\u0003\u0002\u0004\t\u001d)\u0001F\u0001E\u0001S\u0005\u0011\")\u001b8BO\u001e\u0014XmZ1uS:<7kY1o!\t)\"FB\u0003\u0002\u0005!\u00051f\u0005\u0002+\u001d!)QF\u000bC\u0001]\u00051A(\u001b8jiz\"\u0012!K\u0004\u0006a)B\t!M\u0001\u000e\u0007>tg-[4ve\u0006$\u0018n\u001c8\u0011\u0005I\u001aT\"\u0001\u0016\u0007\u000bQR\u0003\u0012A\u001b\u0003\u001b\r{gNZ5hkJ\fG/[8o'\t\u0019d\u0002C\u0003.g\u0011\u0005q\u0007F\u00012\u0011\u001dI4G1A\u0005\u0002i\nABQ1uG\"\u001c\u0016N_3PaR,\u0012a\u000f\t\u0003y\u0005k\u0011!\u0010\u0006\u0003}}\nA\u0001\\1oO*\t\u0001)\u0001\u0003kCZ\f\u0017B\u0001\">\u0005\u0019\u0019FO]5oO\"1Ai\rQ\u0001\nm\nQBQ1uG\"\u001c\u0016N_3PaR\u0004\u0003b\u0002$4\u0005\u0004%\tAO\u0001\b'>\u0014Ho\u00149u\u0011\u0019A5\u0007)A\u0005w\u0005A1k\u001c:u\u001fB$\b\u0005C\u0004Kg\t\u0007I\u0011\u0001\u001e\u0002\u0011Q\u0013\u0018mY6PaRDa\u0001T\u001a!\u0002\u0013Y\u0014!\u0003+sC\u000e\\w\n\u001d;!\u0011\u001dq5G1A\u0005\u0002i\nqaR3p[>\u0003H\u000f\u0003\u0004Qg\u0001\u0006IaO\u0001\t\u000f\u0016|Wn\u00149uA!9!k\rb\u0001\n\u0003Q\u0014a\u0002#bi\u0016|\u0005\u000f\u001e\u0005\u0007)N\u0002\u000b\u0011B\u001e\u0002\u0011\u0011\u000bG/Z(qi\u0002BqAV\u001aC\u0002\u0013\u0005!(\u0001\u0005MC\n,Gn\u00149u\u0011\u0019A6\u0007)A\u0005w\u0005IA*\u00192fY>\u0003H\u000f\t\u0005\b5N\u0012\r\u0011\"\u0001;\u00031!\u0015\r^3BeJ\f\u0017p\u00149u\u0011\u0019a6\u0007)A\u0005w\u0005iA)\u0019;f\u0003J\u0014\u0018-_(qi\u0002BQA\u0018\u0016\u0005\u0002}\u000b\u0011bY8oM&<WO]3\u0015'\u0001LW/a\u0006\u0002,\u0005=\u00121GA\u001d\u0003{\t9%!\u0015\u0011\t\u0005$wm\u001a\b\u0003\u001f\tL!a\u0019\t\u0002\rA\u0013X\rZ3g\u0013\t)gMA\u0002NCBT!a\u0019\t\u0011\u0005\u0005D\u0017B\u0001\"g\u0011\u0015QW\f1\u0001l\u0003\r\u0019h\r\u001e\t\u0003YNl\u0011!\u001c\u0006\u0003]>\faa]5na2,'B\u00019r\u0003\u001d1W-\u0019;ve\u0016T!A\u001d\u0006\u0002\u000f=\u0004XM\\4jg&\u0011A/\u001c\u0002\u0012'&l\u0007\u000f\\3GK\u0006$XO]3UsB,\u0007\"B\u0003^\u0001\u00041\b\u0007B<\u0000\u0003'\u0001R\u0001_>~\u0003#i\u0011!\u001f\u0006\u0003u\u0012\t1!\u00199j\u0013\ta\u0018PA\nHK>lUm]1GK\u0006$XO]3J]\u0012,\u0007\u0010\u0005\u0002\u007f\u007f2\u0001AaCA\u0001k\u0006\u0005\t\u0011!B\u0001\u0003\u0007\u00111a\u0018\u00132#\u0011\t)!a\u0003\u0011\u0007=\t9!C\u0002\u0002\nA\u0011qAT8uQ&tw\rE\u0002\u0010\u0003\u001bI1!a\u0004\u0011\u0005\r\te.\u001f\t\u0004}\u0006MAaCA\u000bk\u0006\u0005\t\u0011!B\u0001\u0003\u0007\u00111a\u0018\u00133\u0011\u001d\tI\"\u0018a\u0001\u00037\taAZ5mi\u0016\u0014\b#B\b\u0002\u001e\u0005\u0005\u0012bAA\u0010!\t1q\n\u001d;j_:\u0004B!a\t\u0002(5\u0011\u0011Q\u0005\u0006\u0004\u00033\t\u0018\u0002BA\u0015\u0003K\u0011aAR5mi\u0016\u0014\bBBA\u0017;\u0002\u0007q-A\u0004ue\u0006\u001c7.\u00133\t\r\u0005ER\f1\u0001h\u0003\u00119Wm\\7\t\u000f\u0005UR\f1\u0001\u00028\u0005\u0019A\r^4\u0011\t=\tib\u001a\u0005\b\u0003wi\u0006\u0019AA\u001c\u0003\u0015a\u0017MY3m\u0011\u001d\ty$\u0018a\u0001\u0003\u0003\n\u0011BY1uG\"\u001c\u0016N_3\u0011\u0007=\t\u0019%C\u0002\u0002FA\u00111!\u00138u\u0011\u001d\tI%\u0018a\u0001\u0003\u0017\nAa]8siB\u0019q\"!\u0014\n\u0007\u0005=\u0003CA\u0004C_>dW-\u00198\t\u000f\u0005MS\f1\u0001\u0002V\u0005A1/Y7qY&tw\rE\u0003\u0010\u0003;\t9\u0006E\u0004\u0010\u00033\ni&a\u000e\n\u0007\u0005m\u0003C\u0001\u0004UkBdWM\r\t\u0004\u001f\u0005}\u0013bAA1!\t)a\t\\8bi\"9\u0011Q\r\u0016\u0005\u0002\u0005\u001d\u0014!\u00049s_B,'\u000f^=OC6,7\u000f\u0006\u0004\u0002j\u0005m\u00141\u0013\t\u0006\u0003W\n)h\u001a\b\u0005\u0003[\n\tHD\u0002 \u0003_J\u0011!E\u0005\u0004\u0003g\u0002\u0012a\u00029bG.\fw-Z\u0005\u0005\u0003o\nIHA\u0002TKFT1!a\u001d\u0011\u0011!\ti(a\u0019A\u0002\u0005}\u0014!\u00025j]R\u001c\b\u0003BAA\u0003\u001fk!!a!\u000b\t\u0005\u0015\u0015qQ\u0001\bM\u0006\u001cGo\u001c:z\u0015\u0011\tI)a#\u0002\tU$\u0018\u000e\u001c\u0006\u0004\u0003\u001bS\u0011\u0001C4f_R|w\u000e\\:\n\t\u0005E\u00151\u0011\u0002\u0006\u0011&tGo\u001d\u0005\u0007U\u0006\r\u0004\u0019A6\u0007\r\u0005]%\u0006AAM\u00059\u0011Vm];mi\u000e\u000bG\u000e\u001c2bG.\u001cr!!&\u000f\u00037\u000bI\u000b\u0005\u0003\u0002\u001e\u0006\rfbA\u000b\u0002 &\u0019\u0011\u0011\u0015\u0002\u0002\u001f\u0005;wM]3hCRLgnZ*dC:LA!!*\u0002(\n1!+Z:vYRT1!!)\u0003!\u0011\tY+!.\u000e\u0005\u00055&\u0002BAX\u0003c\u000b1AY5o\u0015\r\t\u0019LB\u0001\u0006kRLGn]\u0005\u0005\u0003o\u000biK\u0001\u000bCS:\f'/_(viB,HoQ1mY\n\f7m\u001b\u0005\f\u0003w\u000b)J!A!\u0002\u0013\ti,\u0001\u0004ck\u001a4WM\u001d\t\u0005\u0003\u007f\u000b)-\u0004\u0002\u0002B*\u0019\u00111Y \u0002\u00079Lw.\u0003\u0003\u0002H\u0006\u0005'A\u0003\"zi\u0016\u0014UO\u001a4fe\"Y\u00111ZAK\u0005\u0003\u0007I\u0011BAg\u0003!yg/\u001a:gY><XCAA_\u0011-\t\t.!&\u0003\u0002\u0004%I!a5\u0002\u0019=4XM\u001d4m_^|F%Z9\u0015\t\u0005U\u00171\u001c\t\u0004\u001f\u0005]\u0017bAAm!\t!QK\\5u\u0011)\ti.a4\u0002\u0002\u0003\u0007\u0011QX\u0001\u0004q\u0012\n\u0004bCAq\u0003+\u0013\t\u0011)Q\u0005\u0003{\u000b\u0011b\u001c<fe\u001adwn\u001e\u0011\t\u0017\u0005\u0015\u0018Q\u0013B\u0001B\u0003%\u0011q]\u0001\bK:\u001cw\u000eZ3s!\u0011\tY+!;\n\t\u0005-\u0018Q\u0016\u0002\u0014\u0005&t\u0017M]=PkR\u0004X\u000f^#oG>$WM\u001d\u0005\f\u0003_\f)J!A!\u0002\u0013\t\t%A\u0004cS:\u001c\u0016N_3\t\u0017\u0005%\u0013Q\u0013B\u0001B\u0003%\u00111\n\u0005\b[\u0005UE\u0011AA{)1\t90!?\u0002|\u0006u\u0018q B\u0001!\r\u0011\u0014Q\u0013\u0005\t\u0003w\u000b\u0019\u00101\u0001\u0002>\"A\u00111ZAz\u0001\u0004\ti\f\u0003\u0005\u0002f\u0006M\b\u0019AAt\u0011!\ty/a=A\u0002\u0005\u0005\u0003\u0002CA%\u0003g\u0004\r!a\u0013\t\u0011\t\u0015\u0011Q\u0013C!\u0005\u000f\tQ!\u00199qYf$\"\"!6\u0003\n\t-!q\u0002B\n\u0011!\tiCa\u0001A\u0002\u0005\u0005\u0003\u0002\u0003B\u0007\u0005\u0007\u0001\r!!\u0018\u0002\u00071\fG\u000f\u0003\u0005\u0003\u0012\t\r\u0001\u0019AA/\u0003\rawN\u001c\u0005\t\u0003k\u0011\u0019\u00011\u0001\u0003\u0016A\u0019qBa\u0006\n\u0007\te\u0001C\u0001\u0003M_:<\u0007\u0002\u0003B\u0003\u0003+#\tE!\b\u0015\u0019\u0005U'q\u0004B\u0011\u0005G\u0011)Ca\n\t\u0011\u00055\"1\u0004a\u0001\u0003\u0003B\u0001B!\u0004\u0003\u001c\u0001\u0007\u0011Q\f\u0005\t\u0005#\u0011Y\u00021\u0001\u0002^!A\u0011Q\u0007B\u000e\u0001\u0004\u0011)\u0002\u0003\u0005\u0002<\tm\u0001\u0019\u0001B\u000b\u0011!\u0011Y#!&\u0005B\t5\u0012\u0001B5oSR$\"!!6\t\u0011\tE\u0012Q\u0013C!\u0005g\t\u0011\"Y4he\u0016<\u0017\r^3\u0015\t\u0005\u0005#Q\u0007\u0005\t\u0005o\u0011y\u00031\u0001\u0003:\u0005\u00111O\u001a\t\u0004Y\nm\u0012b\u0001B\u001f[\ni1+[7qY\u00164U-\u0019;ve\u0016D\u0001B!\u0011\u0002\u0016\u0012\u0005#1I\u0001\u0007K:\u001cw\u000eZ3\u0015\u0005\t\u0015\u0003#B\b\u0003H\t-\u0013b\u0001B%!\t)\u0011I\u001d:bsB\u0019qB!\u0014\n\u0007\t=\u0003C\u0001\u0003CsR,\u0007\u0002\u0003B*\u0003+#\tE!\f\u0002\u000f\rdW-\u00198va\"A!qKAK\t\u0013\u0011I&\u0001\bf]N,(/Z\"ba\u0006\u001c\u0017\u000e^=\u0015\t\u0005u&1\f\u0005\t\u0005;\u0012)\u00061\u0001\u0002B\u0005!1/\u001b>f\r\u001d\u0011\tGKA\u0001\u0005G\u0012ACQ5o%\u0016\u001cX\u000f\u001c;t)>4U-\u0019;ve\u0016\u001cX\u0003\u0002B3\u0005w\u001aRAa\u0018\u000f\u0005O\u0002bA!\u001b\u0003t\ted\u0002\u0002B6\u0005_r1a\u0007B7\u0013\tQH!C\u0002\u0003re\f\u0011\"U;fef\u0004F.\u00198\n\t\tU$q\u000f\u0002\u0012%\u0016\u001cX\u000f\u001c;t)>4U-\u0019;ve\u0016\u001c(b\u0001B9sB\u0019aPa\u001f\u0005\u0011\tu$q\fb\u0001\u0003\u0007\u0011\u0011\u0001\u0016\u0005\b[\t}C\u0011\u0001BA)\t\u0011\u0019\tE\u00033\u0005?\u0012I\b\u0003\u0005\u0003,\t}C\u0011\tBD)\u0011\t)N!#\t\u000f\t-%Q\u0011a\u0001A\u0006)1\u000f^1uK\"A!1\u0012B0\t\u0003\u0012y)F\u0001a\u0011!\u0011\u0019Ja\u0018\u0005B\tU\u0015AB:dQ\u0016l\u0017-F\u0001l\u0011!\u0011)Aa\u0018\u0005B\teE\u0003\u0002B\u001d\u00057C\u0001B!(\u0003\u0018\u0002\u0007!\u0011P\u0001\u0007e\u0016\u001cX\u000f\u001c;\t\u0011\t\u0005&q\fD\t\u0005G\u000bQAY=uKN$BA!\u0012\u0003&\"A!Q\u0014BP\u0001\u0004\u0011I\b\u0003\u0005\u0003*\n}C\u0011\u0001BV\u0003!\u0019\u0017M\\#rk\u0006dG\u0003BA&\u0005[C\u0001Ba,\u0003(\u0002\u0007\u00111B\u0001\u0006_RDWM\u001d\u0005\t\u0005g\u0013y\u0006\"\u0011\u00036\u00061Q-];bYN$B!a\u0013\u00038\"A!q\u0016BY\u0001\u0004\tY\u0001\u0003\u0005\u0003<\n}C\u0011\tB_\u0003!A\u0017m\u001d5D_\u0012,GCAA!\u0011\u001d\u0011\t\r\u0001C\u0001\u0005[\ta\u0001J5oSR$\u0003b\u0002Bc\u0001\u0011E#qY\u0001\rGJ,\u0017\r^3SKN,H\u000e\u001e\u000b\n1\t%'1\u001aBi\u0005'DaA\u001bBb\u0001\u0004Y\u0007\u0002\u0003Bg\u0005\u0007\u0004\rAa4\u0002\u0013Q\u0014\u0018M\\:g_Jl\u0007\u0003B\b\u0002\u001e-D\u0001\"a\u0010\u0003D\u0002\u0007\u0011\u0011\t\u0005\b\u0005+\u0014\u0019\r1\u0001a\u0003\u001dy\u0007\u000f^5p]NDqA!7\u0001\t#\u0012Y.\u0001\teK\u001a\fW\u000f\u001c;CCR\u001c\u0007nU5{KV\u0011\u0011\u0011\t")
public interface BinAggregatingScan
extends AggregatingScan<ResultCallback> {
    @Override
    public ResultCallback createResult(SimpleFeatureType var1, Option<SimpleFeatureType> var2, int var3, Map<String, String> var4);

    @Override
    public int defaultBatchSize();

    public static class ResultCallback
    implements AggregatingScan.Result,
    BinaryOutputCallback {
        private final ByteBuffer buffer;
        private ByteBuffer overflow;
        private final BinaryOutputEncoder encoder;
        private final int binSize;
        private final boolean sort;

        public void put(ByteBuffer buffer, int trackId, float lat, float lon, long dtg) {
            BinaryOutputCallback.class.put((BinaryOutputCallback)this, (ByteBuffer)buffer, (int)trackId, (float)lat, (float)lon, (long)dtg);
        }

        public void put(ByteBuffer buffer, int trackId, float lat, float lon, long dtg, long label) {
            BinaryOutputCallback.class.put((BinaryOutputCallback)this, (ByteBuffer)buffer, (int)trackId, (float)lat, (float)lon, (long)dtg, (long)label);
        }

        private ByteBuffer overflow() {
            return this.overflow;
        }

        private void overflow_$eq(ByteBuffer x$1) {
            this.overflow = x$1;
        }

        public void apply(int trackId, float lat, float lon, long dtg) {
            this.put(this.ensureCapacity(16), trackId, lat, lon, dtg);
        }

        public void apply(int trackId, float lat, float lon, long dtg, long label) {
            this.put(this.ensureCapacity(24), trackId, lat, lon, dtg, label);
        }

        @Override
        public void init() {
        }

        @Override
        public int aggregate(SimpleFeature sf) {
            int pos = this.buffer.position() + this.overflow().position();
            this.encoder.encode(sf, (BinaryOutputCallback)this);
            return (this.buffer.position() + this.overflow().position() - pos) / this.binSize;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public byte[] encode() {
            try {
                void var1_3;
                byte[] byArray;
                if (this.overflow().position() > 0) {
                    void var3_1;
                    byte[] copy = (byte[])Array$.MODULE$.ofDim(this.buffer.position() + this.overflow().position(), ClassTag$.MODULE$.Byte());
                    System.arraycopy(this.buffer.array(), 0, copy, 0, this.buffer.position());
                    System.arraycopy(this.overflow().array(), 0, copy, this.buffer.position(), this.overflow().position());
                    byArray = var3_1;
                } else if (this.buffer.position() == this.buffer.limit()) {
                    byArray = this.buffer.array();
                } else {
                    byte[] copy = (byte[])Array$.MODULE$.ofDim(this.buffer.position(), ClassTag$.MODULE$.Byte());
                    System.arraycopy(this.buffer.array(), 0, copy, 0, this.buffer.position());
                    byArray = copy;
                }
                byte[] bytes = byArray;
                if (this.sort) {
                    BinSorter$.MODULE$.quickSort(bytes, 0, bytes.length - this.binSize, this.binSize);
                }
                return var1_3;
            }
            finally {
                this.buffer.clear();
                this.overflow().clear();
            }
        }

        @Override
        public void cleanup() {
        }

        private ByteBuffer ensureCapacity(int size) {
            ByteBuffer byteBuffer;
            if (this.buffer.position() < this.buffer.limit() - size) {
                byteBuffer = this.buffer;
            } else if (this.overflow().position() < this.overflow().limit() - size) {
                byteBuffer = this.overflow();
            } else {
                byte[] expanded = (byte[])Array$.MODULE$.ofDim(this.overflow().limit() * 2, ClassTag$.MODULE$.Byte());
                System.arraycopy(this.overflow().array(), 0, expanded, 0, this.overflow().limit());
                ByteOrder order = this.overflow().order();
                int position = this.overflow().position();
                this.overflow_$eq((ByteBuffer)ByteBuffer.wrap(expanded).order(order).position(position));
                byteBuffer = this.overflow();
            }
            return byteBuffer;
        }

        public ResultCallback(ByteBuffer buffer, ByteBuffer overflow, BinaryOutputEncoder encoder, int binSize, boolean sort2) {
            this.buffer = buffer;
            this.overflow = overflow;
            this.encoder = encoder;
            this.binSize = binSize;
            this.sort = sort2;
            BinaryOutputCallback.class.$init$((BinaryOutputCallback)this);
        }
    }

    public static abstract class BinResultsToFeatures<T>
    implements QueryPlan.ResultsToFeatures<T> {
        @Override
        public void init(Map<String, String> state2) {
        }

        @Override
        public Map<String, String> state() {
            return Predef$.MODULE$.Map().empty();
        }

        @Override
        public SimpleFeatureType schema() {
            return BinaryOutputEncoder$.MODULE$.BinEncodedSft();
        }

        @Override
        public SimpleFeature apply(T result) {
            return new ScalaSimpleFeature(BinaryOutputEncoder$.MODULE$.BinEncodedSft(), "", new Object[]{this.bytes(result), GeometryUtils$.MODULE$.zeroPoint()}, ScalaSimpleFeature$.MODULE$.$lessinit$greater$default$4());
        }

        public abstract byte[] bytes(T var1);

        public boolean canEqual(Object other) {
            return other instanceof BinResultsToFeatures;
        }

        public boolean equals(Object other) {
            BinResultsToFeatures binResultsToFeatures;
            Object object = other;
            boolean bl = object instanceof BinResultsToFeatures && (binResultsToFeatures = (BinResultsToFeatures)object).canEqual(this);
            return bl;
        }

        public int hashCode() {
            return this.schema().hashCode();
        }
    }
}

